/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.htmlexporter.xlsx;

import com.iscobol.htmlexporter.RptComponent;
import com.iscobol.htmlexporter.RptStyle;
import com.iscobol.htmlexporter.ss.SSExporter;
import com.iscobol.misc.export.ss.SSExportHelper;
import com.iscobol.misc.export.xlsx.XLSXExportHelper;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;

public class XLSXExporter
extends SSExporter {
    public XLSXExporter(String reportName, String inputFile, String outFile) {
        super(reportName, inputFile, outFile);
    }

    @Override
    protected void setCellStyleAttrs(CellStyle cs, RptComponent cmp, RptStyle style, String numericFormat) {
        VerticalAlignment verticalAlign = VerticalAlignment.TOP;
        HorizontalAlignment horizontalAlign = HorizontalAlignment.LEFT;
        XSSFCellStyle cellStyle = (XSSFCellStyle)cs;
        Font font = this.getFont(cmp.font, cmp.foreground);
        cellStyle.setFont(font);
        XLSXExportHelper ee = (XLSXExportHelper)this.exportHelper;
        if (!this.ignoreCellBackground) {
            cellStyle.setFillForegroundColor(ee.getColor(cmp.background.getRGB()));
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        if (cmp.inputType != null) {
            cellStyle.setIndention((short)2);
            verticalAlign = VerticalAlignment.CENTER;
        }
        if (cmp.align != null) {
            if (cmp.align.equals("left")) {
                horizontalAlign = HorizontalAlignment.LEFT;
            } else if (cmp.align.equals("right")) {
                horizontalAlign = HorizontalAlignment.RIGHT;
            } else if (cmp.align.equals("center")) {
                horizontalAlign = HorizontalAlignment.CENTER;
            }
        }
        cellStyle.setAlignment(horizontalAlign);
        cellStyle.setVerticalAlignment(verticalAlign);
        if (style.border != null && !this.ignoreCellBorder) {
            BorderStyle border = ee.getBorder(style.border.width);
            if (style.border.color == null) {
                style.border.color = cmp.foreground;
            }
            XSSFColor col = ee.getColor(style.border.color.getRGB());
            if (style.border.top) {
                cellStyle.setBorderTop(border);
                cellStyle.setTopBorderColor(col);
            }
            if (style.border.left) {
                cellStyle.setBorderLeft(border);
                cellStyle.setLeftBorderColor(col);
            }
            if (style.border.right) {
                cellStyle.setRightBorderColor(col);
                cellStyle.setBorderRight(border);
            }
            if (style.border.bottom) {
                cellStyle.setBottomBorderColor(col);
                cellStyle.setBorderBottom(border);
            }
        }
        cellStyle.setWrapText(true);
        if (numericFormat != null) {
            cellStyle.setDataFormat(this.exportHelper.getFormat(numericFormat));
        }
        cellStyle.setWrapText(this.cellWrap);
        cellStyle.setLocked(this.cellLock);
    }

    @Override
    protected void flushRows() {
        SXSSFSheet sheet = (SXSSFSheet)this.getSheet(this.currentRowIndex);
        this.exportHelper.flushRows((Sheet)sheet);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.err.println("Usage: java com.iscobol.htmlexporter.xlsx.XLSXExporter reportName inputFile outputFile [options]");
            System.exit(1);
        }
        XLSXExporter exporter = new XLSXExporter(args[0], args[1], args[2]);
        exporter.setupPage(args);
        exporter.export();
        exporter.log();
        exporter.dispose();
        System.out.println("Created file '" + exporter.getOutputFile() + "'");
        System.exit(0);
    }

    @Override
    protected SSExportHelper createExportHelper() {
        return new XLSXExportHelper();
    }
}

