/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.htmlrenderer;

import com.iscobol.htmlrenderer.Source;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAHParser {
    private static final char[][] escapeAmpSequences = new char[][]{{'e', 'u', 'r', 'o', '\u20ac'}, {'g', 't', '>'}, {'l', 't', '<'}, {'a', 'm', 'p', '&'}, {'q', 'u', 'o', 't', '\"'}, {'n', 'b', 's', 'p', '\u00a0'}, {'?'}};
    private final Source input;

    private static char getEscapedChar(char[] c, int len) {
        for (int i = 0; i < escapeAmpSequences.length; ++i) {
            int j;
            if (len != escapeAmpSequences[i].length - 1) continue;
            for (j = 0; j < len && escapeAmpSequences[i][j] == c[j]; ++j) {
            }
            if (j != len) continue;
            return escapeAmpSequences[i][j];
        }
        return escapeAmpSequences[escapeAmpSequences.length - 1][0];
    }

    public SAHParser(InputStream is, String encoding) {
        this.input = new Source(is);
    }

    void skipSpaces() throws IOException {
        int c;
        while ((c = this.input.getChar()) <= 32 && c >= 0) {
        }
        this.input.ungetChar((char)c);
    }

    private int flushBuffer(DefaultHandler dh, char[] buffer, int idx) throws SAXException {
        int Return2;
        if (idx > 0) {
            if (buffer[idx - 1] <= ' ') {
                if (idx > 1) {
                    dh.characters(buffer, 0, idx - 1);
                }
                buffer[0] = 32;
                Return2 = 1;
            } else {
                if (idx > 1 || idx == 1 && buffer[0] > ' ') {
                    dh.characters(buffer, 0, idx);
                }
                Return2 = 0;
            }
        } else {
            Return2 = 0;
        }
        return Return2;
    }

    public void parse(DefaultHandler dh) throws SAXException, IOException {
        int c;
        char[] amp = new char[10];
        char[] buffer = new char[1024];
        int bufidx = 0;
        this.skipSpaces();
        block4: while ((c = this.input.getChar()) >= 0) {
            if (bufidx == buffer.length) {
                bufidx = this.flushBuffer(dh, buffer, bufidx);
            }
            switch (c) {
                case 60: {
                    Tag tag = new Tag();
                    if (!tag.isValid() || dh == null) continue block4;
                    if (tag.isOpen()) {
                        dh.startElement("", tag.name.toString(), tag.name.toString(), tag.attrs);
                    }
                    if (bufidx > 0) {
                        bufidx = this.flushBuffer(dh, buffer, bufidx);
                    }
                    if (tag.isClosed()) {
                        dh.endElement("", tag.name.toString(), tag.name.toString());
                    }
                    if (!tag.isOpen()) continue block4;
                    bufidx = 0;
                    continue block4;
                }
                case 38: {
                    c = this.input.getChar();
                    if (c > 32) {
                        int i;
                        amp[0] = (char)c;
                        for (i = 1; (c = this.input.getChar()) != 59 && c > 32 && i < amp.length; ++i) {
                            amp[i] = (char)c;
                        }
                        buffer[bufidx++] = SAHParser.getEscapedChar(amp, i);
                        continue block4;
                    }
                    this.input.ungetChar(c);
                    c = 38;
                }
            }
            if (c <= 32) {
                if (bufidx == 0 || buffer[bufidx - 1] > ' ') {
                    buffer[bufidx++] = 32;
                }
                this.skipSpaces();
                continue;
            }
            buffer[bufidx++] = (char)c;
        }
    }

    public static void main(String[] args) throws Exception {
        InputStream in = args.length > 0 ? new FileInputStream(args[0]) : System.in;
        new SAHParser(in, null).parse(new DefaultHandler(){

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                System.out.println("Tag=" + localName);
                int len = attributes.getLength();
                for (int i = 0; i < len; ++i) {
                    System.out.println("localName=" + attributes.getLocalName(i) + ", value=\"" + attributes.getValue(i) + '\"');
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                System.out.println("[" + new String(ch, start, length) + "]");
            }

            @Override
            public void endElement(String uri, String localName, String qName) {
                System.out.println("/" + localName);
            }
        });
    }

    class Tag {
        private StringBuffer name = new StringBuffer();
        AttributesImpl attrs = new AttributesImpl();
        private boolean valid;
        private boolean open;
        private boolean closed;

        Tag() throws IOException {
            int c = SAHParser.this.input.getChar();
            if (c == 33) {
                this.name.append((char)c);
                c = SAHParser.this.input.getChar();
                if (c == 45) {
                    this.name.append((char)c);
                    c = SAHParser.this.input.getChar();
                    if (c == 45) {
                        this.name.append((char)c);
                        while ((c = SAHParser.this.input.getChar()) >= 0) {
                            if (c == 45) {
                                this.name.append((char)c);
                                int dashCnt = 1;
                                while ((c = SAHParser.this.input.getChar()) == 45) {
                                    this.name.append((char)c);
                                    ++dashCnt;
                                }
                                if (dashCnt > 1 && c == 62) {
                                    this.name.append((char)c);
                                    break;
                                }
                                SAHParser.this.input.ungetChar(c);
                                continue;
                            }
                            this.name.append((char)c);
                        }
                    } else {
                        SAHParser.this.input.ungetChar(c);
                        this.skipToAngular(this.name);
                    }
                } else {
                    SAHParser.this.input.ungetChar(c);
                    this.skipToAngular(this.name);
                }
            } else {
                this.valid = true;
                if (c == 47) {
                    this.open = false;
                    this.closed = true;
                } else {
                    this.open = true;
                    this.closed = false;
                    SAHParser.this.input.ungetChar(c);
                }
                this.fillTag();
            }
        }

        private void skipToAngular(StringBuffer n) throws IOException {
            int c;
            while ((c = SAHParser.this.input.getChar()) >= 0 && c != 62) {
                n.append((char)c);
            }
        }

        private void getKey(StringBuffer sb) throws IOException {
            int c = SAHParser.this.input.getChar();
            if (c > 32 && c != 61 && c != 62) {
                sb.append(Character.toLowerCase((char)c));
                while ((c = SAHParser.this.input.getChar()) > 32 && c != 61 && c != 62) {
                    sb.append(Character.toLowerCase((char)c));
                }
                SAHParser.this.input.ungetChar(c);
            }
        }

        private void getValue(StringBuffer sb) throws IOException {
            int c = SAHParser.this.input.getChar();
            if (c > 32 && c != 62) {
                if (c == 39 || c == 34) {
                    int quote = c;
                    while ((c = SAHParser.this.input.getChar()) >= 0 && c != quote) {
                        sb.append((char)c);
                    }
                } else {
                    sb.append(Character.toLowerCase((char)c));
                    while ((c = SAHParser.this.input.getChar()) > 32 && c != 62) {
                        sb.append(Character.toLowerCase((char)c));
                    }
                    SAHParser.this.input.ungetChar(c);
                }
            }
        }

        private void fillTag() throws IOException {
            this.getKey(this.name);
            if (this.closed) {
                int c;
                while ((c = SAHParser.this.input.getChar()) >= 0 && c != 62) {
                }
            } else {
                SAHParser.this.skipSpaces();
                int c = SAHParser.this.input.getChar();
                while (c >= 0 && c != 62) {
                    this.closed = false;
                    SAHParser.this.input.ungetChar(c);
                    StringBuffer key = new StringBuffer();
                    this.getKey(key);
                    c = SAHParser.this.input.getChar();
                    if (c == 61) {
                        StringBuffer value = new StringBuffer();
                        this.getValue(value);
                        if (value.length() > 0) {
                            this.attrs.add("", key.toString(), null, "CDATA", value.toString());
                        } else {
                            this.attrs.add("", key.toString(), null, "CDATA", null);
                        }
                    } else if (c == 62) {
                        if ("/".equals(key.toString())) {
                            this.closed = true;
                        } else {
                            this.attrs.add("", key.toString(), null, "CDATA", null);
                        }
                        SAHParser.this.input.ungetChar(c);
                    } else {
                        this.attrs.add("", key.toString(), null, "CDATA", null);
                        SAHParser.this.input.ungetChar(c);
                    }
                    SAHParser.this.skipSpaces();
                    c = SAHParser.this.input.getChar();
                }
            }
        }

        boolean isValid() {
            return this.valid;
        }

        boolean isOpen() {
            return this.open;
        }

        boolean isClosed() {
            return this.closed;
        }

        public String toString() {
            if (this.closed) {
                if (this.open) {
                    return "<" + this.name + "/>";
                }
                return "</" + this.name + ">";
            }
            return "<" + this.name + ">";
        }
    }

    private static class AttributesImpl
    implements Attributes {
        ArrayList content = new ArrayList();

        private AttributesImpl() {
        }

        void add(String u, String ln, String qn, String t, String v) {
            if (qn == null) {
                qn = ln;
            }
            if (v == null) {
                v = ln;
            }
            this.content.add(new Attrs(u, ln, qn, t, v));
        }

        @Override
        public int getLength() {
            return this.content.size();
        }

        @Override
        public String getURI(int index) {
            return "";
        }

        @Override
        public String getLocalName(int index) {
            return ((Attrs)this.content.get((int)index)).localName;
        }

        @Override
        public String getQName(int index) {
            return ((Attrs)this.content.get((int)index)).qName;
        }

        @Override
        public String getType(int index) {
            return ((Attrs)this.content.get((int)index)).type;
        }

        @Override
        public String getValue(int index) {
            return ((Attrs)this.content.get((int)index)).value;
        }

        @Override
        public int getIndex(String uri, String localName) {
            int len = this.getLength();
            for (int i = 0; i < len; ++i) {
                Attrs a = (Attrs)this.content.get(i);
                if (!uri.equals(a.uri) || !localName.equals(a.localName)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int getIndex(String qName) {
            int len = this.getLength();
            for (int i = 0; i < len; ++i) {
                Attrs a = (Attrs)this.content.get(i);
                if (!qName.equals(a.qName)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public String getType(String uri, String localName) {
            int idx = this.getIndex(uri, localName);
            if (idx >= 0) {
                return this.getType(idx);
            }
            return null;
        }

        @Override
        public String getType(String qName) {
            int idx = this.getIndex(qName);
            if (idx >= 0) {
                return this.getType(idx);
            }
            return null;
        }

        @Override
        public String getValue(String uri, String localName) {
            int idx = this.getIndex(uri, localName);
            if (idx >= 0) {
                return this.getValue(idx);
            }
            return null;
        }

        @Override
        public String getValue(String qName) {
            int idx = this.getIndex(qName);
            if (idx >= 0) {
                return this.getValue(idx);
            }
            return null;
        }

        private static class Attrs {
            final String uri;
            final String localName;
            final String qName;
            final String type;
            final String value;

            Attrs(String u, String ln, String qn, String t, String v) {
                this.uri = u;
                this.localName = ln;
                this.qName = qn;
                this.type = t;
                this.value = v;
            }
        }
    }
}

