/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.AtEndException;
import com.iscobol.io.CobolFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.io.DataPickPut;
import com.iscobol.io.DynamicVConnector;
import com.iscobol.io.DynamicVision;
import com.iscobol.io.FileTypeManager;
import com.iscobol.io.IndexFile;
import com.iscobol.io.InvalidKeyException;
import com.iscobol.io.LineSequentialDFile;
import com.iscobol.io.PathTokenizer;
import com.iscobol.io.RelativeDFile;
import com.iscobol.io.SequentialDFile;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.ContextEnv;
import com.iscobol.rts.Factory;
import com.iscobol.rts.FactoryData;
import com.iscobol.rts.FuzzyRegexp;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.print.LocalSpoolPrinter;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class BaseFile
implements CobolFile,
RuntimeErrorsNumbers {
    public static final boolean acu_compat = Config.getProperty(".properties.acu_compat", false);
    public static final boolean input_nolock = Config.getProperty(".file.input_nolock", true);
    protected int accessMode;
    protected final InvalidKeyException invNoRec;
    protected final InvalidKeyException invDupl;
    protected final AtEndException atEnd;
    protected final String name;
    private ICobolVar buffer;
    private int maxRecordLen;
    private int minRecordLen;
    private String intFileStatus;
    private String extendedStatus;
    private String statusMessage;
    private boolean optional;
    private int openMode = 0;
    private CobolIOException lastException;
    private int lastOp;
    private String osPath;
    private boolean closeLock;
    private int fileType;
    private int openLock;
    private Logger log;
    private int compressionFactor = 0;
    protected boolean lockAutomatic;
    protected boolean assignExt;
    protected int lockMask;
    protected WhileLike whileLike;
    private DataPickPut pickPut = DataPickPut.get();
    protected int numPath = 0;
    protected boolean isfSet = false;
    protected LocalSpoolPrinter.QPrinterAttrs printerAttrs;

    private static MyProperties get() {
        MyProperties Return2 = (MyProperties)IscobolSystem.get(MyProperties.class);
        if (Return2 == null) {
            Return2 = new MyProperties();
            IscobolSystem.set(MyProperties.class, Return2);
        }
        return Return2;
    }

    private static String getVar(String v, Set founds) {
        if (v.equals(".")) {
            return v;
        }
        String env = Config.getProperty(("." + v).toLowerCase(), null);
        if (env == null || founds.contains(env)) {
            return v;
        }
        founds.add(env);
        return BaseFile.getVar(env, founds);
    }

    private static String getVar(String v) {
        if (v.equals(".")) {
            return v;
        }
        String env = Config.getProperty(("." + v).toLowerCase().replace('-', '_'), null);
        if (acu_compat && env != null) {
            HashSet<String> founds = new HashSet<String>();
            founds.add(v);
            founds.add(env);
            return BaseFile.getVar(env, founds);
        }
        return env;
    }

    private static String getItemN(String tk, boolean check) throws VarNotFoundException {
        if (tk.charAt(0) == '$') {
            String Return2 = "";
            tk = tk.substring(1);
            Return2 = !Config.getProperty(".file.env_toupper", true) ? System.getenv(tk.substring(1)) : Config.getProperty("." + tk.toLowerCase(), null);
            if (Return2 != null) {
                return Return2;
            }
            if (check) {
                throw new VarNotFoundException();
            }
            return tk;
        }
        return tk;
    }

    private static String getItem1(String tk, String prfx, boolean check) throws VarNotFoundException {
        String Return2;
        if (tk.length() > 0 && tk.charAt(0) == '$') {
            if (!Config.getProperty(".file.env_toupper", true)) {
                Return2 = System.getenv(prfx + tk.substring(1));
            } else {
                Return2 = BaseFile.getVar(prfx + tk.substring(1));
                if (Return2 == null) {
                    Return2 = BaseFile.getVar(tk.substring(1));
                }
            }
        } else {
            Return2 = !Config.getProperty(".file.env_toupper", true) ? System.getenv(prfx + tk) : BaseFile.getVar(prfx + tk);
        }
        if (Return2 != null) {
            return Return2;
        }
        if (check) {
            throw new VarNotFoundException();
        }
        return tk;
    }

    public static String expandFileName(String name) {
        try {
            return BaseFile.expandFileName(name, false);
        }
        catch (VarNotFoundException ex) {
            return name;
        }
    }

    private static String expandFileName(String name, boolean check) throws VarNotFoundException {
        char sep = File.separatorChar;
        String prfx = Config.getProperty(".file.env_naming_prefix", ".file.env_naming.prefix", "");
        if (Config.getProperty(".file.env_naming", false) && (Config.getProperty(".file.acu_compat", false) || name.indexOf(sep) >= 0) && Config.getProperty("." + name.toLowerCase(), "").length() != 0) {
            return Config.getProperty("." + name.toLowerCase(), name);
        }
        if (name.indexOf(sep) >= 0) {
            StringBuffer Return2 = new StringBuffer();
            StringTokenizer st = new StringTokenizer(name, File.separator, true);
            int i = 0;
            while (st.hasMoreTokens()) {
                String tk = st.nextToken();
                if (File.separator.equals(tk)) {
                    Return2.append(tk);
                } else if (i == 0) {
                    Return2.append(BaseFile.getItem1(tk, prfx, check));
                } else {
                    Return2.append(BaseFile.getItemN(tk, check));
                }
                ++i;
            }
            return Return2.toString();
        }
        String str = BaseFile.getItem1(name, prfx, check);
        return str;
    }

    public static boolean isIndexFile(BaseFile file) {
        return file != null && file.getClass().getName().equals("com.iscobol.io.IndexFile");
    }

    public static String[] getFilePrefix(int fileType) {
        String fp = "";
        MyProperties myProp = BaseFile.get();
        BaseFile lastUsedFile = myProp.getFd().getTdd().lastUsedFile;
        fp = lastUsedFile instanceof IndexFile ? (lastUsedFile instanceof RelativeDFile ? Config.getProperty(".file.relative_file_prefix", ".relative_file_prefix", "").trim() : (lastUsedFile instanceof SequentialDFile || lastUsedFile instanceof LineSequentialDFile ? Config.getProperty(".file.sequential_file_prefix", ".sequential_file_prefix", "").trim() : Config.getProperty(".file.indexed_file_prefix", ".indexed_file_prefix", "").trim())) : (fileType == 32 ? Config.getProperty(".file.binary_file_prefix", ".binary_file_prefix", "").trim() : Config.getProperty(".file.sequential_file_prefix", ".sequential_file_prefix", "").trim());
        if (fp.equals("")) {
            fp = Config.getProperty(".file.prefix", ".file_prefix", "").trim();
        }
        if (!fp.equals(myProp.filePrefixDesc)) {
            myProp.filePrefixDesc = fp;
            char lf = '\n';
            if (fp.length() > 0) {
                if (fp.toLowerCase().startsWith("isf://") || fp.toLowerCase().startsWith("@") || fp.toLowerCase().contains(" @") || fp.toLowerCase().contains(" isf://") || fp.contains(lf + "isf://") || fp.contains(lf + "@")) {
                    MyProperties.access$102(myProp, fp.split("" + lf));
                } else {
                    PathTokenizer st = new PathTokenizer(fp);
                    int nt = st.countTokens();
                    if (nt > 0) {
                        MyProperties.access$102(myProp, new String[nt]);
                        for (int i = 0; i < nt; ++i) {
                            ((MyProperties)myProp).filePrefixArray[i] = st.nextToken();
                        }
                    }
                }
            } else {
                MyProperties.access$102(myProp, null);
            }
        }
        return myProp.filePrefixArray;
    }

    public static String[] getFullPaths(String path, int[] fileType) {
        return BaseFile.getFullPaths(path, fileType, null);
    }

    public static String[] getFullPaths(String path, int[] fileType, BaseFile file) {
        String[] Return2;
        String fileSuffix;
        char dash;
        String name = path.toString().trim();
        if (name.length() > 0 && name.charAt(0) == '\"' && name.charAt(name.length() - 1) == '\"') {
            name = name.substring(1, name.length() - 1);
        }
        String file_case = "";
        if (name.length() > 0 && name.replace('\\', '/').charAt(0) != '/' && name.replace('\\', '/').contains("/")) {
            String str = name.replace('\\', '/').substring(0, name.replace('\\', '/').indexOf("/"));
            if (ContextEnv.get().getProperty("dd_" + str) != null) {
                name = name.replace(str, ContextEnv.get().getProperty("dd_" + str));
                return new String[]{name};
            }
        }
        if (Config.getProperty(".file.env_naming", false)) {
            name = BaseFile.expandFileName(name);
        } else if (name.length() > 3 && name.charAt(0) == '-' && name.charAt(2) == ' ') {
            switch (name.charAt(1)) {
                case 'E': 
                case 'e': {
                    name = Config.getProperty("." + name.substring(3).trim().toLowerCase(), "");
                }
            }
        }
        String separator = Config.getProperty(".file.prefix_separator", ".file_prefix.separator", File.separator).trim();
        String cwd = com.iscobol.rts.File.getcwd(separator);
        if ("PRINTER?".equalsIgnoreCase(name)) {
            fileType[0] = 17;
            return new String[]{name};
        }
        if (name.length() > 3 && name.charAt(2) == ' ' && ((dash = name.charAt(0)) == '-' || dash == '+')) {
            fileType[0] = dash == '+' ? 32 : 16;
            switch (name.charAt(1)) {
                case 'F': 
                case 'f': {
                    fileType[0] = fileType[0] | 0;
                    name = name.substring(3).trim();
                    if (BaseFile.isAbsolutePath(name)) {
                        return new String[]{name};
                    }
                    return new String[]{cwd + name};
                }
                case 'Q': 
                case 'q': {
                    LocalSpoolPrinter.QPrinterAttrs attrs = LocalSpoolPrinter.handleDashQPrinter(name.substring(3).trim());
                    name = attrs.direct ? "-p spooler-direct" : "-p spooler";
                    if (file != null) {
                        file.printerAttrs = attrs;
                    }
                }
                case 'P': 
                case 'p': {
                    fileType[0] = fileType[0] | 1;
                    return new String[]{name};
                }
                case 'S': 
                case 's': {
                    String ame = name.substring(1);
                    if (ame.equalsIgnoreCase("s in")) {
                        fileType[0] = fileType[0] | 2;
                        return new String[]{name};
                    }
                    if (ame.equalsIgnoreCase("s out")) {
                        fileType[0] = fileType[0] | 3;
                        return new String[]{name};
                    }
                    if (!ame.equalsIgnoreCase("s err")) break;
                    fileType[0] = fileType[0] | 4;
                    return new String[]{name};
                }
            }
        }
        if ((file_case = Config.getProperty(".file.case", file_case)).length() > 0) {
            if (file_case.charAt(0) == 'L' || file_case.charAt(0) == 'l') {
                name = name.toLowerCase();
            } else if (file_case.charAt(0) == 'U' || file_case.charAt(0) == 'u') {
                name = name.toUpperCase();
            }
        }
        String[] filePrefix = BaseFile.getFilePrefix(fileType[0]);
        fileType[0] = 0;
        String string = fileSuffix = name.indexOf(46) == -1 ? BaseFile.getFileSuffix() : "";
        if (filePrefix != null && filePrefix.length > 0 && (BaseFile.getApplyFilePath() || !BaseFile.isAbsolutePath(name))) {
            Return2 = new String[filePrefix.length];
            for (int i = 0; i < filePrefix.length; ++i) {
                if (BaseFile.isAbsolutePath(filePrefix[i])) {
                    if (filePrefix[i].endsWith(separator)) {
                        Return2[i] = filePrefix[i] + name + fileSuffix;
                        continue;
                    }
                    Return2[i] = filePrefix[i] + separator + name + fileSuffix;
                    continue;
                }
                Return2[i] = cwd + filePrefix[i] + separator + name + fileSuffix;
            }
        } else {
            Return2 = BaseFile.isAbsolutePath(name) ? new String[]{name + fileSuffix} : new String[]{cwd + name + fileSuffix};
        }
        return Return2;
    }

    private static boolean getApplyFilePath() {
        return Config.getProperty(".file.apply_file_path", ".apply_file_path", false);
    }

    private static boolean getIoCreates() {
        return Config.getProperty(".file.io_creates", ".io_creates", false);
    }

    private static boolean getExtendCreates() {
        return Config.getProperty(".file.extend_creates", ".extend_creates", false);
    }

    private static String getFileSuffix() {
        String fs = Config.getProperty(".file.suffix", ".file_suffix", null);
        if (fs == null || fs.length() == 0) {
            return "";
        }
        return "." + fs;
    }

    public BaseFile(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt, int am) {
        this.name = nam;
        this.invNoRec = new InvalidKeyException(111, "", this, 8);
        this.invDupl = new InvalidKeyException(100, "", this, 3);
        this.atEnd = new AtEndException(this, 6);
        this.init(nam, maxLen, memBuf, minLen, opt, am);
    }

    private void init(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt, int am) {
        this.buffer = memBuf.getIParent() != null ? memBuf.getIParent() : memBuf;
        this.maxRecordLen = maxLen > 0 ? maxLen : this.buffer.getMemoryLength();
        this.minRecordLen = minLen > 0 ? minLen : this.maxRecordLen;
        this.intFileStatus = "00";
        this.extendedStatus = "00";
        this.statusMessage = "";
        this.optional = opt;
        this.closeLock = false;
        this.accessMode = am;
    }

    private void initOperation(int op) {
        this.intFileStatus = "00";
        this.extendedStatus = "00";
        this.statusMessage = "";
        ((MyProperties)BaseFile.get()).fd.getTdd().lastUsedFile = this;
        this.lastException = null;
        this.lastOp = op;
    }

    private void initOperation(int op, boolean lock) {
        this.initOperation(op);
        if (lock) {
            this.lastOp |= 0x100;
        }
    }

    protected static boolean isAbsolutePath(String path) {
        return path.indexOf(":/") >= 0 || com.iscobol.rts.File.isAbsolute(path, new File(path));
    }

    @Override
    public String getOsPath() {
        return this.osPath;
    }

    @Override
    public Logger getLogger() {
        return this.log;
    }

    protected abstract void peerOpen(String var1, int var2, int var3);

    protected abstract void peerClose(int var1);

    private void myPeerOpen(String path, int openType, int lockType) {
        this.osPath = path;
        this.openLock = lockType;
        this.peerOpen(path, openType, lockType);
    }

    @Override
    public boolean isMultilock() {
        return (this.openLock & 0x100) != 0;
    }

    @Override
    public Object getResourceUniqueId() {
        return this.osPath;
    }

    protected final int getFileType() {
        return this.fileType & 0xF;
    }

    protected final boolean isBinary() {
        return (this.fileType & 0x20) > 0;
    }

    @Override
    public final void open(CobolVar path, int openType, int lockType) {
        this.open((ICobolVar)path, openType, lockType);
    }

    @Override
    public final void open(ICobolVar path, int openType, int lockType) {
        int i;
        int idx;
        this.log = LoggerFactory.get(8);
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("OPEN:");
            msg.append(this.name);
            msg.append(", ");
            msg.append(OPEN[openType]);
            msg.append(", lock=");
            msg.append(LOCK[lockType & 7]);
            if ((lockType & 0x80) != 0) {
                msg.append(", AUTOMATIC");
            }
            if ((lockType & 0x100) != 0) {
                msg.append(", MULTI");
            }
            if ((lockType & 0x200) != 0) {
                msg.append(", MASS_UPDATE");
            }
            if ((lockType & 0x400) != 0) {
                msg.append(", BULK");
            }
            if ((lockType & 0x800) != 0) {
                msg.append(", TRANSACTION");
            }
            this.log.info(msg.toString());
        }
        this.lockMask = openType == 1 && input_nolock ? 0 : -1;
        this.lockAutomatic = (lockType & 0x80) != 0;
        this.initOperation(1);
        if (this.openMode != 0) {
            CobolIOException.get(135, "", this, 1);
            return;
        }
        if (this.closeLock) {
            CobolIOException.get(141, "", this, 1);
            return;
        }
        String strPath = path.toString().trim();
        if (BaseFile.isRemoveNameSpaces(strPath)) {
            strPath = path.toString().trim().replaceAll(" ", "");
        }
        if (strPath.length() == 0) {
            CobolIOException.get(130, "", this, 1);
            return;
        }
        if (BaseFile.isIndexFile(this) && Config.getProperty(".file.index.strip_extension", 0) == 1 && (idx = strPath.lastIndexOf(46)) > 0) {
            strPath = strPath.substring(0, idx);
        }
        int[] type = new int[]{0};
        if (this.assignExt) {
            try {
                BaseFile.expandFileName(strPath, true);
                this.myPeerOpen(strPath, openType, lockType);
                return;
            }
            catch (VarNotFoundException varNotFoundException) {
                // empty catch block
            }
        }
        String[] fullPath = BaseFile.getFullPaths(strPath, type, this);
        this.fileType = type[0];
        String[] intFullPath = new String[]{fullPath[0]};
        if (fullPath.length > 1 && this.canCreate(openType)) {
            for (i = 0; i < fullPath.length; ++i) {
                intFullPath[0] = fullPath[i];
                this.checkISF(intFullPath, this.name);
                if (this.exists(intFullPath[0])) break;
            }
            if (i == fullPath.length) {
                i = 0;
            }
            this.initOperation(1);
        } else {
            for (i = 0; i < fullPath.length - 1; ++i) {
                try {
                    this.numPath = i;
                    intFullPath[0] = fullPath[i];
                    this.checkISF(intFullPath, this.name);
                    this.myPeerOpen(intFullPath[0], openType, lockType);
                    return;
                }
                catch (CobolIOException e) {
                    if (e.getErrNum() != 130) {
                        throw e;
                    }
                    this.initOperation(1);
                    continue;
                }
            }
        }
        intFullPath[0] = fullPath[i];
        this.checkISF(intFullPath, this.name);
        this.myPeerOpen(intFullPath[0], openType, lockType);
    }

    @Override
    public final void close() {
        this.close(0);
    }

    @Override
    public final void close(int opts) {
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("CLOSE opts=" + opts + ":");
            msg.append(this.name);
            this.log.info(msg.toString());
        }
        this.initOperation(2);
        if (this.openMode == 0) {
            CobolIOException.get(101, "", this, 2);
        }
        this.peerClose(opts);
        this.openMode = 0;
    }

    @Override
    public final void closeReel() {
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("CLOSE REEL:");
            msg.append(this.name);
            this.log.info(msg.toString());
        }
        this.initOperation(2);
        if (this.openMode == 0) {
            CobolIOException.get(101, "", this, 2);
        }
        CobolIOException.get(206, "", this, 2);
    }

    @Override
    public CobolFile key(CobolVar[] key, boolean dup) {
        return this.key((ICobolVar[])key, dup);
    }

    @Override
    public CobolFile key(ICobolVar[] key, boolean dup) {
        throw new IscobolRuntimeException(3, new IllegalArgumentException("KEY").toString());
    }

    @Override
    public void keyReset() {
        throw new IscobolRuntimeException(3, new IllegalArgumentException("KEYRESET").toString());
    }

    @Override
    public CobolFile relativeKey(NumericVar key) {
        return this.relativeKey((INumericVar)key);
    }

    @Override
    public CobolFile relativeKey(INumericVar key) {
        throw new IscobolRuntimeException(3, new IllegalArgumentException("KEY").toString());
    }

    @Override
    public CobolFile collatingSequence(byte[] cs) {
        throw new IscobolRuntimeException(3, new IllegalArgumentException("COLLATING SEQUENCE").toString());
    }

    @Override
    public boolean write(boolean lock, int len, int opts) {
        if (opts == 0) {
            return this.write(lock, len);
        }
        throw new IscobolRuntimeException(3, new IllegalArgumentException("CONTROL/CONVERSION").toString());
    }

    @Override
    public boolean write(boolean lock, int len) {
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("WRITE:");
            msg.append(this.name);
            msg.append(", lock=");
            msg.append(lock);
            msg.append(", len=");
            msg.append(len);
            this.log.info(msg.toString());
            if (LoggerFactory.get(32) != null) {
                msg.delete(0, msg.capacity());
                msg.append("record-data=");
                if ((this.openLock & 0x1000) != 0) {
                    msg.append("********Encrypted Value******");
                } else {
                    msg.append(this.buffer.toString());
                }
                this.log.info(msg.toString());
            }
        }
        this.initOperation(3);
        if ((this.openMode & 2) == 0) {
            if (this.openMode == 0) {
                CobolIOException.get(101, "", this, 3);
            } else {
                CobolIOException.get(137, "", this, 3);
            }
        }
        return false;
    }

    @Override
    public boolean advance(int nLines, int opts) {
        throw new IscobolRuntimeException(3, new IllegalArgumentException("ADVANCE").toString());
    }

    @Override
    public boolean page(int opts) {
        throw new IscobolRuntimeException(3, new IllegalArgumentException("PAGE").toString());
    }

    @Override
    public CobolFile setLinage(CobolVar linage) {
        return this.setLinage((ICobolVar)linage);
    }

    @Override
    public CobolFile setLinage(ICobolVar linage) {
        throw new IscobolRuntimeException(3, new IllegalArgumentException("LINAGE").toString());
    }

    @Override
    public CobolFile setLinage(CobolVar linage, CobolVar footing, CobolVar top, CobolVar bottom) {
        return this.setLinage((ICobolVar)linage, (ICobolVar)footing, (ICobolVar)top, (ICobolVar)bottom);
    }

    @Override
    public CobolFile setLinage(ICobolVar linage, ICobolVar footing, ICobolVar top, ICobolVar bottom) {
        throw new IscobolRuntimeException(3, new IllegalArgumentException("LINAGE").toString());
    }

    @Override
    public NumericVar getLinageCounter() {
        throw new IscobolRuntimeException(3, new IllegalArgumentException("LINAGE-COUNTER").toString());
    }

    @Override
    public int linageCounter() {
        throw new IscobolRuntimeException(3, new IllegalArgumentException("LINAGE-COUNTER").toString());
    }

    @Override
    public void rewrite(boolean lock, int len) {
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("REWRITE:");
            msg.append(this.name);
            msg.append(", lock=");
            msg.append(lock);
            msg.append(", len=");
            msg.append(len);
            this.log.info(msg.toString());
            if (LoggerFactory.get(32) != null) {
                msg.delete(0, msg.capacity());
                msg.append("record-data=");
                if ((this.openLock & 0x1000) != 0) {
                    msg.append("********Encrypted Value******");
                } else {
                    msg.append(this.buffer.toString());
                }
                this.log.info(msg.toString());
            }
        }
        this.initOperation(4);
        if (this.openMode != 3) {
            if (this.openMode == 0) {
                CobolIOException.get(101, "", this, 4);
            } else {
                CobolIOException.get(138, "", this, 4);
            }
        }
    }

    @Override
    public void delete() {
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("DELETE:");
            msg.append(this.name);
            this.log.info(msg.toString());
        }
        this.initOperation(5);
        if (this.openMode != 3) {
            if (this.openMode == 0) {
                CobolIOException.get(101, "", this, 5);
            } else {
                CobolIOException.get(138, "", this, 5);
            }
        }
    }

    @Override
    public int readNext(boolean lock, CobolVar into) {
        return this.readNext(lock, (ICobolVar)into);
    }

    @Override
    public int readNext(boolean lock, ICobolVar into) {
        return this.readNext(lock ? 1 : 0, into);
    }

    @Override
    public int readNext(int lock, ICobolVar into) {
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("READ NEXT:");
            msg.append(this.name);
            msg.append(", lock=");
            msg.append(lock);
            this.log.info(msg.toString());
        }
        this.initOperation(6, lock > 0);
        if ((this.openMode & 1) == 0) {
            if (this.openMode == 0) {
                CobolIOException.get(101, "", this, 6);
            } else {
                CobolIOException.get(136, "", this, 6);
            }
        }
        return 0;
    }

    @Override
    public int readPrev(boolean lock, CobolVar into) {
        return this.readPrev(lock, (ICobolVar)into);
    }

    @Override
    public int readPrev(boolean lock, ICobolVar into) {
        return this.readPrev(lock ? 1 : 0, into);
    }

    @Override
    public int readPrev(int lock, ICobolVar into) {
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("READ PREV:");
            msg.append(this.name);
            msg.append(", lock=");
            msg.append(lock);
            this.log.info(msg.toString());
        }
        this.initOperation(7, lock > 0);
        if ((this.openMode & 1) == 0) {
            if (this.openMode == 0) {
                CobolIOException.get(101, "", this, 7);
            } else {
                CobolIOException.get(136, "", this, 7);
            }
        }
        return 0;
    }

    @Override
    public int readKey(CobolVar[] key, boolean lock, CobolVar into) {
        return this.readKey((ICobolVar[])key, lock, (ICobolVar)into);
    }

    @Override
    public int readKey(ICobolVar[] key, boolean lock, ICobolVar into) {
        return this.readKey(key, lock ? 1 : 0, into);
    }

    @Override
    public int readKey(ICobolVar[] key, int lock, ICobolVar into) {
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("READ KEY:");
            msg.append(this.name);
            msg.append(", lock=");
            msg.append(lock);
            this.log.info(msg.toString());
        }
        this.initOperation(8, lock > 0);
        if ((this.openMode & 1) == 0) {
            if (this.openMode == 0) {
                CobolIOException.get(101, "", this, 8);
            } else {
                CobolIOException.get(136, "", this, 8);
            }
        }
        return 0;
    }

    @Override
    public void start(CobolVar[] key, int type, int keyLen) {
        this.start((ICobolVar[])key, type, keyLen);
    }

    @Override
    public void start(ICobolVar[] key, int type, int keyLen) {
        this.whileLike = null;
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("START:");
            msg.append(this.name);
            msg.append(", type=");
            msg.append(START[type]);
            if (this instanceof IndexFile) {
                msg.append(", keyNum=");
                msg.append(((IndexFile)this).findKeyNum(key));
            }
            msg.append(", keyLen=");
            msg.append(keyLen);
            this.log.info(msg.toString());
        }
        this.initOperation(9);
        if ((this.openMode & 1) == 0) {
            if (this.openMode == 0) {
                CobolIOException.get(101, "", this, 9);
            } else {
                CobolIOException.get(136, "", this, 9);
            }
        }
    }

    @Override
    public void unlock() {
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("UNLOCK:");
            msg.append(this.name);
            this.log.info(msg.toString());
        }
        this.initOperation(10);
        if (this.openMode == 0) {
            CobolIOException.get(101, "", this, 10);
        }
    }

    @Override
    public void deleteFile(CobolVar path) {
        this.deleteFile((ICobolVar)path);
    }

    @Override
    public void deleteFile(ICobolVar path) {
        int i;
        this.log = LoggerFactory.get(8);
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("DELETE FILE:");
            msg.append(this.name);
            this.log.info(msg.toString());
        }
        this.initOperation(11);
        if (this.openMode != 0) {
            CobolIOException.get(135, "", this, 11);
        }
        String[] fullPath = BaseFile.isRemoveNameSpaces(path.toString()) ? BaseFile.getFullPaths(path.toString().replace(" ", ""), new int[]{0}) : BaseFile.getFullPaths(path.toString(), new int[]{0});
        for (i = 0; i < fullPath.length; ++i) {
            int idx;
            if (!BaseFile.isIndexFile(this) || Config.getProperty(".file.index.strip_extension", 0) != 1 || (idx = fullPath[i].lastIndexOf(46)) <= 0) continue;
            fullPath[i] = fullPath[i].substring(0, idx);
        }
        for (i = 0; i < fullPath.length; ++i) {
            String[] intFullPath = new String[]{fullPath[i]};
            this.checkISF(intFullPath, this.name);
            if (this.exists(intFullPath[0])) break;
        }
        if (i == fullPath.length) {
            CobolIOException.get(203, "", this, 11);
        }
    }

    @Override
    public void like(ICobolVar[] key, ICobolVar rgx, int flg) {
        if (key != null) {
            String regex = Factory.rightTrim(rgx.toString());
            if (this.log != null) {
                StringBuffer msg = new StringBuffer("WHILE LIKE:");
                msg.append(regex);
                this.log.info(msg.toString());
            }
            try {
                this.whileLike = new WhileLikeRE(key, flg, regex);
            }
            catch (PatternSyntaxException _ex) {
                this.whileLike = null;
                CobolIOException.get(111, "28 " + _ex.getMessage(), this, 9);
            }
        } else {
            this.whileLike = null;
        }
    }

    @Override
    public void like(ICobolVar[] key, ICobolVar rgx, int flg, int approx) {
        if (key != null) {
            String regex = Factory.rightTrim(rgx.toString());
            if (this.log != null) {
                StringBuffer msg = new StringBuffer("WHILE LIKE:");
                msg.append(regex);
                this.log.info(msg.toString());
            }
            this.whileLike = new WhileLikeApprox(key, flg, regex, approx);
        } else {
            this.whileLike = null;
        }
    }

    protected boolean isLike() {
        if (this.whileLike != null) {
            return this.whileLike.isLike();
        }
        return false;
    }

    protected void setOpenMode(int om) {
        this.openMode = om;
    }

    @Override
    public boolean isOpen() {
        return this.openMode != 0;
    }

    @Override
    public int getOpenMode() {
        return this.openMode;
    }

    public boolean isWritable() {
        return (this.openMode & 2) != 0;
    }

    @Override
    public String getLogicName() {
        return this.name;
    }

    @Override
    public void setFileStatus(String fs) {
        this.intFileStatus = fs;
    }

    @Override
    public String getFileStatus() {
        return this.intFileStatus;
    }

    public static void setLockId(long lId) {
        ((MyProperties)BaseFile.get()).fd.getTdd().pidLock = lId;
    }

    public static long getLockId() {
        return ((MyProperties)BaseFile.get()).fd.getTdd().pidLock;
    }

    @Override
    public void setExtendedStatus(String fs) {
        int len = fs == null ? 0 : fs.length();
        switch (len) {
            case 0: {
                this.extendedStatus = "00";
                break;
            }
            case 1: {
                this.extendedStatus = "0" + fs;
                break;
            }
            default: {
                this.extendedStatus = fs;
            }
        }
    }

    @Override
    public String getExtendedStatus() {
        return this.extendedStatus;
    }

    @Override
    public void setStatusMessage(String fs) {
        this.statusMessage = fs;
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    public boolean isOptional(int mode) {
        switch (mode) {
            case 3: {
                return this.optional || BaseFile.getIoCreates();
            }
            case 6: {
                return this.optional || BaseFile.getExtendCreates();
            }
        }
        return this.optional;
    }

    private boolean canCreate(int mode) {
        switch (mode) {
            case 2: {
                return true;
            }
            case 1: 
            case 3: 
            case 6: {
                return this.isOptional(mode);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exists(String path) {
        boolean opt = this.optional;
        boolean cl = this.closeLock;
        int myLastOp = this.lastOp;
        try {
            this.optional = false;
            this.closeLock = false;
            this.myPeerOpen(path, 1, 0);
            this.close();
        }
        catch (CobolIOException _ex) {
            int errNum = _ex.getErrNum();
            if (errNum == 130 || errNum == 147) {
                boolean bl = false;
                return bl;
            }
            this.setFileStatus("00");
        }
        finally {
            this.optional = opt;
            this.closeLock = cl;
            this.lastOp = myLastOp;
        }
        return true;
    }

    @Override
    public final byte[] getBufferRO() {
        return this.pickPut.toCodeSet(this.buffer.getBytes());
    }

    public final int getBufferLength() {
        return this.maxRecordLen;
    }

    @Override
    public final void updateBuffer(byte[] b) {
        this.buffer.setUsingMaxLen(this.pickPut.fromCodeSet(b));
    }

    public char[] getBufferAsChars() {
        return this.buffer.basicToString().toCharArray();
    }

    protected ICobolVar getBufferAsVar() {
        return this.buffer;
    }

    public int getMinRecordLen() {
        return this.minRecordLen;
    }

    public int getMaxRecordLen() {
        return this.maxRecordLen;
    }

    @Override
    public void setCloseLock() {
        this.closeLock = true;
    }

    @Override
    public final void finalize() {
        try {
            this.peerClose(0);
        }
        catch (CobolIOException cobolIOException) {
            // empty catch block
        }
    }

    public static BaseFile getLastUsedFile() {
        return ((MyProperties)BaseFile.get()).fd.getTdd().lastUsedFile;
    }

    @Override
    public void setLastException(CobolIOException ex) {
        this.lastException = ex;
    }

    @Override
    public CobolIOException getLastException() {
        return this.lastException;
    }

    @Override
    public CobolFile setAssignExt(boolean b) {
        this.assignExt = b;
        return this;
    }

    public int getLastOp() {
        return this.lastOp;
    }

    public int getAccessMode() {
        return this.accessMode;
    }

    public String toString() {
        return this.buffer.toString();
    }

    @Override
    public final CobolFile setCodeSet(byte[] cs) {
        this.pickPut = DataPickPut.get(cs, this.maxRecordLen);
        return this;
    }

    public static String getBasename(String n) {
        String Return2 = n.replace('\\', '/');
        if (Return2.lastIndexOf(47) >= 0) {
            Return2 = Return2.substring(Return2.lastIndexOf(47) + 1);
        }
        return Return2;
    }

    public int getNumPath() {
        return this.numPath;
    }

    public static String getFileServerUrl(String url) {
        block3: {
            String pfx;
            block2: {
                pfx = "isf://";
                if (url.startsWith("isf://")) break block2;
                pfx = "@";
                if (!url.startsWith("@") || url.startsWith("@[")) break block3;
            }
            return url.substring(pfx.length());
        }
        return null;
    }

    public void checkISF(String[] path, String name) {
        this.isfSet = BaseFile.checkISF(path, name, this.isfSet, null);
    }

    public static boolean checkISF(String[] path, boolean isfSet, String forcedFt) {
        isfSet = BaseFile.checkISF(path, null, isfSet, forcedFt);
        return isfSet;
    }

    public static boolean checkISF(String[] path, String name, boolean isfSet, String forcedFt) {
        BaseFile lastUsedFile = BaseFile.getLastUsedFile();
        if (lastUsedFile instanceof IndexFile && !(lastUsedFile instanceof SequentialDFile) && !(lastUsedFile instanceof RelativeDFile) && !(lastUsedFile instanceof LineSequentialDFile) && path[0].startsWith("@") && (FileTypeManager.getIndexIn() != null && (FileTypeManager.getIndexIn() == DynamicVision.class || FileTypeManager.getIndexIn() == DynamicVConnector.class) || ((IndexFile)lastUsedFile)._clazz != null && (((IndexFile)lastUsedFile)._clazz.toString().trim().equalsIgnoreCase("com.iscobol.io.DynamicVision") || ((IndexFile)lastUsedFile)._clazz.toString().trim().equalsIgnoreCase("com.iscobol.io.DynamicVConnector")) || name != null && IndexFile.isIdxInConfig(name) != null && (IndexFile.isIdxInConfig(name) instanceof DynamicVision || IndexFile.isIdxInConfig(name) instanceof DynamicVConnector) || Config.getProperty(".file.env_naming", false) && IndexFile.isIdxInConfig(BaseFile.getBasename(path[0])) != null && (IndexFile.isIdxInConfig(BaseFile.getBasename(path[0])) instanceof DynamicVision || IndexFile.isIdxInConfig(BaseFile.getBasename(path[0])) instanceof DynamicVConnector))) {
            return false;
        }
        if (path[0].toLowerCase().startsWith("isf://") || path[0].startsWith("@")) {
            path[0] = path[0].startsWith("@") ? path[0].substring(1) : path[0].substring(6);
            if (path[0].contains(":")) {
                String ft;
                String port;
                String host = path[0].substring(0, path[0].indexOf(":"));
                path[0] = path[0].substring(path[0].indexOf(58) + 1);
                if (path[0].contains(":")) {
                    port = path[0].substring(0, path[0].indexOf(":"));
                    path[0] = path[0].substring(path[0].indexOf(58) + 1);
                } else {
                    port = "" + Config.getProperty(".file.remote.port", 10997);
                }
                Logger log = LoggerFactory.get(8);
                String intName = BaseFile.getBasename(path[0]).toLowerCase().replace('-', '_');
                if (forcedFt != null) {
                    ft = forcedFt;
                } else {
                    lastUsedFile = BaseFile.getLastUsedFile();
                    ft = "index.";
                    if (lastUsedFile instanceof RelativeDFile) {
                        ft = "relative.";
                    } else if (lastUsedFile instanceof SequentialDFile) {
                        ft = "sequential.";
                    } else if (lastUsedFile instanceof LineSequentialDFile) {
                        ft = "linesequential.";
                    }
                }
                Config.setProperty(".file." + ft + intName, "com.iscobol.io.DynamicRemote");
                Config.setProperty(".file.remote.host." + intName, host);
                Config.setProperty(".file.remote.port." + intName, port);
                isfSet = true;
                if (log != null) {
                    StringBuffer msg = new StringBuffer("    Found isf:// or @ file type:");
                    msg.append(path[0]);
                    msg.append(", host = ");
                    msg.append(host);
                    msg.append(", port = ");
                    msg.append(port);
                    log.info(msg.toString());
                }
            }
        } else if (isfSet) {
            String ft;
            lastUsedFile = BaseFile.getLastUsedFile();
            Logger log = LoggerFactory.get(8);
            String intName = BaseFile.getBasename(path[0]).toLowerCase().replace('-', '_');
            if (forcedFt != null) {
                ft = forcedFt;
            } else {
                ft = "index.";
                if (lastUsedFile instanceof RelativeDFile) {
                    ft = "relative.";
                } else if (lastUsedFile instanceof SequentialDFile) {
                    ft = "sequential.";
                } else if (lastUsedFile instanceof LineSequentialDFile) {
                    ft = "linesequential.";
                }
            }
            Config.unsetProperty(".file." + ft + intName);
            Config.unsetProperty(".file.remote.host." + intName);
            Config.unsetProperty(".file.remote.port." + intName);
            if (log != null) {
                StringBuffer msg = new StringBuffer("    Unset ISF properties:");
                msg.append(path[0]);
                log.info(msg.toString());
            }
            isfSet = false;
        }
        return isfSet;
    }

    public static boolean isRemoveNameSpaces(String path) {
        boolean Return2 = false;
        if (!(Config.getProperty(".file.remove_name_spaces", 0) != 1 || path.trim().startsWith("-F ") || path.trim().startsWith("+F ") || path.trim().startsWith("-E ") || path.trim().startsWith("+E ") || path.trim().startsWith("-P ") || path.trim().startsWith("+P ") || path.trim().startsWith("-S ") || path.trim().startsWith("+S ") || path.trim().startsWith("-Q ") || path.trim().startsWith("+Q "))) {
            Return2 = true;
        }
        return Return2;
    }

    @Override
    public void setCompressionFactor(int cf) {
        this.compressionFactor = cf;
    }

    @Override
    public int getCompressionFactor() {
        return this.compressionFactor;
    }

    static class VarNotFoundException
    extends Exception {
        VarNotFoundException() {
        }
    }

    static class MyProperties {
        private String filePrefixDesc = "";
        private String[] filePrefixArray;
        private final FactoryData fd = Factory.getCurrent();

        MyProperties() {
        }

        FactoryData getFd() {
            return this.fd;
        }

        static /* synthetic */ String[] access$102(MyProperties x0, String[] x1) {
            x0.filePrefixArray = x1;
            return x1;
        }
    }

    static class WhileLikeApprox
    extends WhileLike {
        private final FuzzyRegexp fuzzyRE;
        private final int maxErrs;

        WhileLikeApprox(ICobolVar[] key, int flg, String rgx, int maxErrs) throws PatternSyntaxException {
            super(key, flg);
            boolean ci = (flg & 1) == 1;
            this.maxErrs = maxErrs;
            this.fuzzyRE = new FuzzyRegexp(rgx, ci);
        }

        @Override
        boolean isLike() {
            String input;
            String input0;
            if (this.key.length == 1) {
                input0 = this.key[0].toString();
            } else {
                StringBuffer sb = new StringBuffer(255);
                for (int i = 0; i < this.key.length; ++i) {
                    sb.append(this.key[i].toString());
                }
                input0 = sb.toString();
            }
            switch (this.flags & 6) {
                case 6: {
                    input = input0.trim();
                    break;
                }
                case 2: {
                    input = Factory.leftTrim(input0);
                    break;
                }
                case 4: {
                    input = Factory.rightTrim(input0);
                    break;
                }
                default: {
                    input = input0;
                }
            }
            return this.fuzzyRE.isInDistance(this.maxErrs, input);
        }
    }

    static class WhileLikeRE
    extends WhileLike {
        private final Pattern regex;
        private static final String zeroesStr = "0000000000000000000000000000000000000000000000000000000000000000";

        WhileLikeRE(ICobolVar[] key, int flg, String rgx) throws PatternSyntaxException {
            super(key, flg);
            int ci = (flg & 1) == 1 ? 66 : 0;
            this.regex = Pattern.compile(rgx, ci);
        }

        @Override
        boolean isLike() {
            String input;
            String input0;
            if (this.key.length == 1) {
                input0 = this.key[0] instanceof INumericVar && this.key[0].getLength() > this.key[0].toString().length() ? zeroesStr.substring(0, this.key[0].getLength() - this.key[0].toString().length()) + this.key[0].toString() : this.key[0].toString();
            } else {
                StringBuffer sb = new StringBuffer(255);
                for (int i = 0; i < this.key.length; ++i) {
                    if (this.key[i] instanceof INumericVar && this.key[0].getLength() > this.key[0].toString().length()) {
                        sb.append(zeroesStr.substring(0, this.key[i].getLength() - this.key[i].toString().length()) + this.key[i].toString());
                        continue;
                    }
                    sb.append(this.key[i]);
                }
                input0 = sb.toString();
            }
            switch (this.flags & 6) {
                case 6: {
                    input = input0.trim();
                    break;
                }
                case 2: {
                    input = Factory.leftTrim(input0);
                    break;
                }
                case 4: {
                    input = Factory.rightTrim(input0);
                    break;
                }
                default: {
                    input = input0;
                }
            }
            return this.regex.matcher(input).matches();
        }
    }

    static abstract class WhileLike {
        protected ICobolVar[] key;
        protected final int flags;

        WhileLike(ICobolVar[] key, int flags) {
            this.key = key;
            this.flags = flags;
        }

        abstract boolean isLike();
    }
}

