/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.DataPickPut;

final class DataPickPutConverter
extends DataPickPut {
    private final byte[] codeSet;
    private final byte[] codeSetReverse;
    private final byte[] codeSetBuffer;
    private final int maxRecordLen;

    public DataPickPutConverter(byte[] cs, int maxRecLen) {
        this.maxRecordLen = maxRecLen;
        this.codeSet = cs;
        this.codeSetReverse = new byte[256];
        for (int i = 0; i < 256; ++i) {
            this.codeSetReverse[this.codeSet[i] & 0xFF] = (byte)i;
        }
        this.codeSetBuffer = new byte[this.maxRecordLen];
    }

    @Override
    public final byte[] toCodeSet(byte[] in) {
        for (int i = 0; i < this.maxRecordLen; ++i) {
            this.codeSetBuffer[i] = this.codeSet[in[i] & 0xFF];
        }
        return this.codeSetBuffer;
    }

    @Override
    public final byte[] fromCodeSet(byte[] in) {
        for (int i = 0; i < this.maxRecordLen; ++i) {
            this.codeSetBuffer[i] = this.codeSetReverse[in[i] & 0xFF];
        }
        return this.codeSetBuffer;
    }
}

