/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.BaseFile;
import com.iscobol.io.TransactionException;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.Factory;
import com.iscobol.rts.IOUtil;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.MonitorFinalize;
import com.iscobol.rts.RuntimeErrorsNumbers;
import faircom.rtg.CtreeEnv;
import faircom.rtg.CtreeFile;
import faircom.rtg.CtreeStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DynamicCtreeJ
implements DynamicFile,
RuntimeErrorsNumbers,
Cloneable {
    private static final short zero = 0;
    private static boolean loaded;
    private CtreeFile theFile = null;
    private CtreeStatus status = new CtreeStatus();
    private static Object lock1;
    private short fnl = 1;
    private int openMode = 0;
    private KeyDescription[] keys;
    private int maxRecordSize;
    private int minRecordSize;
    private String path = "";
    private int errno;
    private String sysError;
    private String errMsg;
    private static HashMap issMap;
    String fileName = "";
    private String issName = "";
    private static byte sign;
    private static Logger log;
    private static boolean newConfig;
    private boolean bool = false;
    private boolean forcedelete = false;
    private CtreeEnv ctree = null;
    private static String lib;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicCtreeJ() {
        int position = 0;
        this.ctree = (CtreeEnv)IscobolSystem.get(CtreeEnv.class);
        if (this.ctree == null) {
            Object object = lock1;
            synchronized (object) {
                this.ctree = (CtreeEnv)IscobolSystem.get(CtreeEnv.class);
                if (this.ctree == null) {
                    boolean Return2;
                    block26: {
                        Return2 = false;
                        try {
                            this.ctree = new CtreeEnv(lib);
                        }
                        catch (Exception e) {
                            throw new IscobolRuntimeException(3, (Throwable)new IllegalArgumentException("init ERROR " + e.getMessage()));
                        }
                        try {
                            position = 1;
                            if (newConfig) {
                                String s;
                                boolean bool;
                                int maxInstance = Config.getProperty(".file.index.maxinstance", 2);
                                if (maxInstance > 99) {
                                    maxInstance = 99;
                                }
                                if (maxInstance <= 1) {
                                    maxInstance = 2;
                                }
                                long[] item = new long[maxInstance];
                                position = 2;
                                this.ctree.config(4, -1L, "", "", "", "", "", this.status);
                                if (log != null) {
                                    log.info("config adding");
                                }
                                position = 3;
                                if (Config.getProperty(".file.index.trxholdslocks", false)) {
                                    this.ctree.config(0, -1L, "trxholdslocks", Config.getProperty(".file.index.trxholdslocks", false) ? "yes" : "no", "", "", "", this.status);
                                }
                                position = 4;
                                if (Config.getProperty(".file.index.filepool", null) != null) {
                                    position = 5;
                                    bool = Config.getProperty(".file.index.filepool", false);
                                    this.ctree.config(0, -1L, "filepool", bool ? "yes" : "no", "", "", "", this.status);
                                    if (log != null) {
                                        log.info("Set filepool ctree.ctconfig(1, (long -1), \"filepool\"," + bool + ", \"\", \"\", \"\") status: errno=" + this.status.get_errno() + " int_errno=" + this.status.get_int_errno() + " int2_errno=" + this.status.get_int2_errno());
                                    }
                                    position = 6;
                                    s = Config.getProperty(".file.index.filepool.size", null);
                                    position = 7;
                                    if (s != null) {
                                        this.ctree.config(0, -1L, "filepool.size", s.trim(), "", "", "", this.status);
                                    }
                                }
                                position = 8;
                                if (Config.getProperty(".file.index.memoryfile", null) != null) {
                                    position = 9;
                                    bool = Config.getProperty(".file.index.memoryfile", true);
                                    this.ctree.config(0, -1L, "memoryfile", bool ? "yes" : "no", "", "", "", this.status);
                                    if (log != null) {
                                        log.info("Set memoryfile ctree.ctconfig(1, (long -1), \"memoryfile \"," + bool + ", \"\", \"\", \"\") status: errno=" + this.status.get_errno() + " int_errno=" + this.status.get_int_errno() + " int2_errno=" + this.status.get_int2_errno());
                                    }
                                }
                                if (Config.getProperty(".file.index.memoryfile", false) && Config.getProperty(".file.index.memoryfile.persist", null) != null) {
                                    position = 10;
                                    bool = Config.getProperty(".file.index.memoryfile.persist", true);
                                    this.ctree.config(0, -1L, "memoryfile?persist", bool ? "yes" : "no", "", "", "", this.status);
                                    if (log != null) {
                                        log.info("Set memoryfile persist ctree.ctconfig(1, (long -1), \"memoryfile?persist\"," + bool + ", \"\", \"\", \"\") status: errno=" + this.status.get_errno() + " int_errno=" + this.status.get_int_errno() + " int2_errno=" + this.status.get_int2_errno());
                                    }
                                }
                                this.SetLog();
                                this.SetInstance(item, 0);
                                for (int instance = 1; instance < maxInstance; ++instance) {
                                    s = null;
                                    s = Config.getProperty(".file.index." + instance + ".server", null);
                                    if (s == null) continue;
                                    this.SetInstance(item, instance);
                                }
                            }
                            position = 11;
                            Return2 = this.ctree.init(this.status);
                        }
                        catch (Exception e) {
                            if (position >= 11) break block26;
                            StringWriter sw = new StringWriter();
                            PrintWriter pw = new PrintWriter(sw);
                            e.printStackTrace(pw);
                            throw new IscobolRuntimeException(3, (Throwable)new IllegalArgumentException("init ERROR -" + e.toString() + " - " + sw + " -  - position:" + position));
                        }
                    }
                    if (Return2) {
                        if (this.ctree != null) {
                            IscobolSystem.set(CtreeEnv.class, this.ctree);
                            Factory.getCurrentMonitor().addObjToFinalize(new MonitorFinalize(){

                                @Override
                                public void monitorFinalize() {
                                    if (log != null) {
                                        log.info("exit cth  ctree object: " + DynamicCtreeJ.this.ctree);
                                    }
                                    loaded = false;
                                    DynamicCtreeJ.this.ctree.exit();
                                }
                            });
                        }
                        if (log != null) {
                            log.info("init cth ctree object: " + this.ctree);
                        }
                    } else {
                        throw new IscobolRuntimeException(3, new IllegalArgumentException("init ERROR " + this.status.get_errno() + ":" + this.status.get_int_errno() + ":" + this.status.get_int2_errno()).toString());
                    }
                }
            }
        }
    }

    @Override
    public String getSysErrno() {
        return this.sysError;
    }

    @Override
    public String getErrMsg() {
        return this.errMsg;
    }

    @Override
    public int getCobErrno() {
        switch (this.errno) {
            case 0: {
                return 0;
            }
            case 1: {
                return 133;
            }
            case 2: {
                return 102;
            }
            case 3: {
                return 104;
            }
            case 4: {
                return 125;
            }
            case 5: {
                BaseFile.setLockId(this.ctree.lockerId(this.status));
                return 107;
            }
            case 6: {
                return 105;
            }
            case 7: {
                return 100;
            }
            case 8: {
                return 111;
            }
            case 9: {
                return 112;
            }
            case 10: {
                return 127;
            }
            case 11: {
                BaseFile.setLockId(this.ctree.lockerId(this.status));
                return 113;
            }
            case 12: {
                return 128;
            }
            case 13: {
                return 102;
            }
            case 14: {
                return 116;
            }
            case 15: {
                return 130;
            }
            case 16: {
                return 131;
            }
            case 17: {
                return 126;
            }
            case 18: {
                return 129;
            }
            case 19: {
                return 140;
            }
            case 20: {
                return 133;
            }
            case 22: {
                return 122;
            }
            case 100: {
                return 204;
            }
            case 101: {
                return 200;
            }
        }
        return 134;
    }

    private void setLock(int lock) {
        switch (lock) {
            case -1: {
                this.fnl = (short)2;
                break;
            }
            case 0: {
                this.fnl = 1;
                break;
            }
            case 1: {
                this.fnl = 0;
                break;
            }
            case 2: {
                this.fnl = (short)-1;
                break;
            }
            case 3: {
                this.fnl = (short)-2;
            }
        }
    }

    @Override
    public long getNumRecords() {
        byte[] result = new byte[11];
        if (this.ctree == null) {
            return this.mapError(1, 5510);
        }
        this.theFile.info(-4, result, this.status);
        return Long.parseLong(new String(result, 0, 10));
    }

    @Override
    public int getNumKeys() {
        if (this.keys == null) {
            if (this.ctree == null) {
                return this.mapError(1, 5510);
            }
            byte[] result = new byte[256];
            if (!this.theFile.info(-1, result, this.status)) {
                return this.mapError();
            }
            int[] values = IOUtil.csv2Int(result);
            this.maxRecordSize = values[0];
            this.minRecordSize = values[1];
            this.keys = new KeyDescription[values[2]];
        }
        return this.keys.length;
    }

    @Override
    public int getMaxRecordSize() {
        if (this.keys == null) {
            this.getNumKeys();
        }
        return this.maxRecordSize;
    }

    @Override
    public int getMinRecordSize() {
        if (this.keys == null) {
            this.getNumKeys();
        }
        return this.minRecordSize;
    }

    @Override
    public KeyDescription getKey(int num) {
        KeyDescription Return2;
        if (num >= 0 && num < this.getNumKeys()) {
            if (this.keys[num] == null) {
                byte[] result = new byte[256];
                if (this.ctree == null) {
                    this.mapError(1, 5510);
                    return null;
                }
                if (!this.theFile.info(num, result, this.status)) {
                    this.mapError();
                    return null;
                }
                this.keys[num] = new KeyDescription(result);
            }
            Return2 = this.keys[num];
        } else {
            Return2 = null;
            this.mapError(2);
        }
        return Return2;
    }

    @Override
    public byte[] getSequence() {
        byte[] result = new byte[256];
        if (this.ctree == null) {
            this.mapError(1, 5510);
            return null;
        }
        if (!this.theFile.info(-5, result, this.status)) {
            this.mapError();
            return null;
        }
        return result;
    }

    private int findKey(KeyDescription key) {
        int Return2;
        int nKeys = this.getNumKeys();
        try {
            for (Return2 = 0; Return2 < nKeys && !key.equals(this.getKey(Return2)); ++Return2) {
            }
        }
        catch (NullPointerException e) {
            Return2 = -1;
        }
        return Return2;
    }

    private int mapError(int err, int sys) {
        this.errno = err;
        this.sysError = "" + sys;
        this.errMsg = "";
        return 0;
    }

    private int mapError(int err) {
        this.errno = err;
        this.sysError = "";
        this.errMsg = "";
        return 0;
    }

    private int mapErrorL() {
        this.errno = this.status.get_errno();
        this.sysError = "" + this.status.get_int_errno();
        this.errMsg = "" + this.status.get_errmsg();
        if (this.errno == 11 || this.errno == 5) {
            BaseFile.setLockId(this.ctree.lockerId(this.status));
        }
        return 0;
    }

    private int mapError() {
        this.errno = this.status.get_errno();
        this.sysError = "" + this.status.get_int_errno();
        this.errMsg = "" + this.status.get_errmsg();
        return 0;
    }

    int mapOpen(int mode, int lockType) {
        int Return2;
        switch (mode) {
            default: {
                Return2 = 0;
                break;
            }
            case 2: {
                Return2 = 1;
                break;
            }
            case 3: {
                Return2 = 2;
                break;
            }
            case 6: {
                Return2 = 3;
            }
        }
        switch (lockType & 0xF) {
            default: {
                break;
            }
            case 1: 
            case 6: {
                Return2 |= 0x300;
                break;
            }
            case 4: {
                Return2 |= 0x200;
                break;
            }
            case 3: 
            case 5: {
                Return2 |= 0x100;
            }
        }
        if ((lockType & 0x100) != 0) {
            Return2 |= 0x10;
        }
        if ((lockType & 0x200) != 0) {
            Return2 |= 0x600;
        }
        if ((lockType & 0x400) != 0) {
            Return2 |= 0x8000;
        }
        if ((lockType & 0x800) != 0) {
            Return2 |= 0x4000;
        }
        return Return2;
    }

    @Override
    public int build(String path, String comment, int blockingFactor, int preAllocate, int extensionFactor, int compressionFactor, int ecryptionFlag, int maxRecordSize, int minRecordSize, KeyDescription[] keys, byte[] collating, boolean assignExt) {
        String issPath;
        if (assignExt) {
            path = BaseFile.expandFileName(path);
        }
        if (this.ctree == null) {
            return this.mapError(1, 5510);
        }
        String p_params = new String(IOUtil.int2Csv(new int[]{blockingFactor, preAllocate, extensionFactor, compressionFactor, ecryptionFlag}, new int[]{1, 1, 1, 3, 1}));
        String l_params = "" + maxRecordSize + ", " + minRecordSize + ", " + keys.length;
        StringBuffer ks = new StringBuffer();
        int i = 0;
        while (true) {
            ks.append(keys[i].toString());
            if (++i >= keys.length) break;
            ks.append(',');
        }
        if (!this.ctree.make(path, comment, p_params, l_params, ks.toString(), collating, (byte)0, this.status)) {
            return this.mapError();
        }
        if (Config.getProperty(".sqlserver.iss", false) && !(issPath = Config.getProperty(".sqlserver.isspath", "").trim()).equals("")) {
            if (this.setFileName(path, issPath)) {
                File tFile = new File(issPath + File.separator + this.issName + ".iss");
                if (tFile.exists()) {
                    if (log != null) {
                        log.info("OPENING: " + issPath + File.separator + this.issName + ".iss successful");
                    }
                    this.theFile = this.ctree.open(path, 1, l_params, (byte)0, this.status);
                    if (this.theFile != null) {
                        try {
                            int len;
                            InputStreamReader r = new InputStreamReader(new FileInputStream(issPath + File.separator + this.issName + ".iss"));
                            StringWriter w = new StringWriter();
                            char[] buffer = new char[1024];
                            while ((len = r.read(buffer)) != -1) {
                                w.write(buffer, 0, len);
                            }
                            if (log != null) {
                                log.info("SQLINFO ('" + path + "', '" + issPath + File.separator + this.issName + ".iss', '" + String.valueOf((char)sign) + "')");
                            }
                            boolean Return2 = this.theFile.sqlinfo(w.toString(), sign, this.status);
                            if (log != null) {
                                if (!Return2) {
                                    log.info("SQLINFO failed: " + this.status.get_int_errno());
                                } else {
                                    log.info("SQLINFO successful");
                                }
                            }
                            this.theFile.close(this.status);
                            String database = Config.getProperty(".sqlserver.database", "ctreeSQL").trim();
                            String password = Config.getProperty(".sqlserver.password", "ADMIN").trim();
                            String owner = Config.getProperty(".sqlserver.owner", "").trim();
                            String prefix = Config.getProperty(".sqlserver.prefix", "").trim();
                            String grant = Config.getProperty(".sqlserver.grant", "0").trim();
                            if (log != null) {
                                log.info("SQLLINK ('" + path + "', '" + database + "', '" + this.fileName + "', '" + password + "', '" + owner + "', " + grant + ", '" + prefix + "')");
                            }
                            Return2 = this.ctree.sqllink(path, database, this.fileName, password, owner, (byte)Integer.parseInt(grant), prefix, this.status);
                            if (log != null) {
                                if (!Return2) {
                                    log.info("SQLLINK failed: " + this.status.get_int_errno());
                                } else {
                                    log.info("SQLLINK successful");
                                }
                            }
                            ((Reader)r).close();
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                        }
                        catch (IOException iOException) {}
                    }
                } else if (log != null) {
                    log.info("OPENING: " + issPath + File.separator + this.fileName.toLowerCase() + ".iss failed");
                }
            } else if (log != null) {
                log.info("OPENING: " + issPath + File.separator + this.fileName.toLowerCase() + ".iss failed");
            }
        }
        return 1;
    }

    private boolean setFileName(String path, String issPath) {
        String dirlevel = Config.getProperty(".sqlserver.dirlevel", "").trim();
        int repRules = Config.getProperty(".sqlserver.iss.replacement_rules", 0);
        if (repRules >= 4) {
            if (path.lastIndexOf(46) > 0) {
                path = path.substring(0, path.lastIndexOf(46));
            }
            repRules -= 4;
        }
        switch (repRules) {
            case 0: {
                path = path.replace('\\', '/').replace('.', '_').replace('-', '_');
                break;
            }
            case 1: {
                path = path.replace('\\', '/').replaceAll("\\.", "").replace('-', '_');
                break;
            }
            case 2: {
                path = path.replace('\\', '/').replace('.', '_').replaceAll("-", "");
                break;
            }
            case 3: {
                path = path.replace('\\', '/').replaceAll("\\.", "").replaceAll("-", "");
                break;
            }
            default: {
                if (log != null) {
                    log.info("OPENING: invalid .sqlserver.iss.replacement_rules property value");
                }
                return false;
            }
        }
        this.fileName = path.substring(path.lastIndexOf("/") + 1);
        if (dirlevel.length() != 0 && !dirlevel.equals("0")) {
            int j = path.lastIndexOf("/") - 1;
            int level = Integer.parseInt(dirlevel);
            for (int i = j; i >= 0; --i) {
                if (path.charAt(i) != '/') continue;
                this.fileName = path.substring(i + 1, j + 1) + this.fileName;
                j = i - 1;
                if (--level == 0) break;
            }
            if (log != null) {
                log.info("DIRLEVEL: " + path + " to " + this.fileName);
            }
        }
        for (Map.Entry entry : issMap.entrySet()) {
            if (!this.fileName.toLowerCase().matches((String)entry.getKey())) continue;
            this.issName = (String)entry.getValue();
            return true;
        }
        File tFile = new File(issPath + File.separator + this.fileName.toLowerCase() + ".iss");
        if (tFile.exists()) {
            this.issName = this.fileName.toLowerCase();
            return true;
        }
        return false;
    }

    @Override
    public int open(String path, int openType, int lockType, KeyDescription[] k, int maxRec, int minRec, int nKeys, int accesMode, boolean optional, boolean assignExt) {
        long rc = 0L;
        if (assignExt) {
            path = BaseFile.expandFileName(path);
        }
        if (this.ctree == null) {
            return this.mapError(1, 5510);
        }
        String l_params = "" + maxRec + ", " + minRec + ", " + nKeys;
        switch (openType) {
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                this.theFile = this.ctree.open(path, this.mapOpen(openType, lockType), l_params, (byte)0, this.status);
                if (this.theFile != null) break;
                return this.mapErrorL();
            }
            default: {
                throw new IscobolRuntimeException(3, new IllegalArgumentException("OPEN").toString());
            }
        }
        this.minRecordSize = minRec;
        this.maxRecordSize = maxRec;
        this.openMode = openType;
        this.path = path;
        return 1;
    }

    @Override
    public void setCurrentRecord(long nRec) {
    }

    @Override
    public long getCurrentRecord() {
        return 0L;
    }

    @Override
    public boolean isOpen() {
        return this.openMode != 0;
    }

    @Override
    public String getDescription() {
        return this.path;
    }

    @Override
    public int close() {
        if (this.isOpen()) {
            this.openMode = 0;
            if (this.ctree != null && !this.theFile.close(this.status)) {
                return this.mapError();
            }
            this.theFile = null;
            this.keys = null;
            this.path = "";
        }
        return 1;
    }

    @Override
    public long write(byte[] record, int offs, int size, boolean lock) {
        if (this.ctree == null) {
            return this.mapError(1, 5510);
        }
        if (this.maxRecordSize != 0 && this.minRecordSize == this.maxRecordSize) {
            size = this.maxRecordSize;
        }
        if (lock) {
            this.setLock(1);
        } else {
            this.setLock(0);
        }
        if (!this.theFile.write(record, offs, size, this.fnl, this.status)) {
            return this.mapError();
        }
        this.errno = this.status.get_errno();
        return 1L;
    }

    @Override
    public long rewrite(byte[] record, int offs, int size, boolean lock) {
        if (this.ctree == null) {
            return this.mapError(1, 5510);
        }
        if (this.maxRecordSize != 0 && this.minRecordSize == this.maxRecordSize) {
            size = this.maxRecordSize;
        }
        if (lock) {
            this.setLock(1);
        } else {
            this.setLock(0);
        }
        if (!this.theFile.rewrite(record, offs, size, this.fnl, this.status)) {
            return this.mapError();
        }
        this.errno = this.status.get_errno();
        return 1L;
    }

    @Override
    public long delete(byte[] record, int offs) {
        if (this.ctree == null) {
            return this.mapError(1, 5510);
        }
        if (!this.theFile.delete(record, offs, this.status)) {
            return this.mapError();
        }
        this.errno = this.status.get_errno();
        return 1L;
    }

    @Override
    public long next(byte[] record, int offs, int lock) {
        int Return2 = 0;
        if (this.ctree == null) {
            return this.mapError(1, 5510);
        }
        this.setLock(lock);
        Return2 = this.theFile.next(record, offs, this.fnl, this.status);
        if (Return2 == 0 || this.status.get_errno() != 0) {
            return this.mapErrorL();
        }
        this.errno = this.status.get_errno();
        return Return2;
    }

    @Override
    public long previous(byte[] record, int offs, int lock) {
        int Return2 = 0;
        if (this.ctree == null) {
            return this.mapError(1, 5510);
        }
        this.setLock(lock);
        Return2 = this.theFile.previous(record, offs, this.fnl, this.status);
        if (Return2 == 0 || this.status.get_errno() != 0) {
            return this.mapErrorL();
        }
        this.errno = this.status.get_errno();
        return Return2;
    }

    @Override
    public long read(byte[] record, int offs, int keyNum, int lock) {
        int Return2 = 0;
        if (this.ctree == null) {
            return this.mapError(1, 5510);
        }
        this.setLock(lock);
        Return2 = this.theFile.read(record, offs, keyNum, this.fnl, this.status);
        if (Return2 == 0 || this.status.get_errno() != 0) {
            return this.mapErrorL();
        }
        this.errno = this.status.get_errno();
        return Return2;
    }

    @Override
    public long read(byte[] record, int offs, KeyDescription key, int lock) {
        return this.read(record, offs, this.findKey(key), lock);
    }

    @Override
    public long start(byte[] record, int offs, int kNum, int kSize, int mode) {
        boolean rc;
        if (this.ctree == null) {
            return this.mapError(1, 5510);
        }
        switch (mode) {
            case 0: {
                byte[] tmpBuf = new byte[record.length];
                rc = this.theFile.start(tmpBuf, 0, kNum, kSize, 1, this.status);
                break;
            }
            case 1: {
                byte[] tmpBuf = new byte[record.length];
                for (int i = record.length - 1; i >= 0; --i) {
                    tmpBuf[i] = -1;
                }
                rc = this.theFile.start(tmpBuf, 0, kNum, kSize, 4, this.status);
                break;
            }
            case 5: {
                rc = this.theFile.start(record, offs, kNum, kSize, 0, this.status);
                break;
            }
            case 6: {
                rc = this.theFile.start(record, offs, kNum, kSize, 2, this.status);
                break;
            }
            case 7: {
                rc = this.theFile.start(record, offs, kNum, kSize, 1, this.status);
                break;
            }
            case 8: {
                rc = this.theFile.start(record, offs, kNum, kSize, 3, this.status);
                break;
            }
            case 9: {
                rc = this.theFile.start(record, offs, kNum, kSize, 4, this.status);
                break;
            }
            default: {
                throw new IscobolRuntimeException(3, new IllegalArgumentException("START").toString());
            }
        }
        if (rc) {
            this.errno = this.status.get_errno();
            return 1L;
        }
        return this.mapError();
    }

    @Override
    public long start(byte[] record, int offs, KeyDescription k, int kSize, int mode) {
        return this.start(record, offs, this.findKey(k), kSize, mode);
    }

    @Override
    public int unlock() {
        if (this.ctree == null) {
            return this.mapError(1, 5510);
        }
        if (!this.theFile.unlock(this.status)) {
            this.mapErrorL();
        } else {
            this.mapError(0);
        }
        return this.status.get_errno();
    }

    @Override
    public void sync(int allFiles) {
        if (this.ctree != null) {
            this.ctree.sync(allFiles, this.status);
        }
    }

    @Override
    public int remove(String name) {
        if (this.ctree == null) {
            return this.mapError(1, 5510);
        }
        if (!this.ctree.remove(name, this.status)) {
            return this.mapError();
        }
        this.errno = this.status.get_errno();
        return 1;
    }

    @Override
    public int rename(String src, String dst) {
        if (this.ctree == null) {
            return this.mapError(1, 5510);
        }
        if (!this.ctree.rename(src, dst, this.status)) {
            return this.mapError();
        }
        this.errno = this.status.get_errno();
        return 1;
    }

    @Override
    public int begin() {
        if (Config.getProperty(".ctree.ignore_transaction", false)) {
            return 1;
        }
        if (this.ctree == null) {
            return this.mapError(1, 5510);
        }
        if (!this.ctree.begin(this.status)) {
            this.errno = 22;
            TransactionException.get(this.getCobErrno(), "98", 13);
            return 0;
        }
        this.errno = this.status.get_errno();
        return 1;
    }

    @Override
    public int commit(int ctx) {
        if (Config.getProperty(".ctree.ignore_transaction", false)) {
            return 1;
        }
        if (this.ctree == null) {
            return this.mapError(1, 5510);
        }
        if (!this.ctree.commit(ctx, this.status)) {
            this.errno = 22;
            TransactionException.get(this.getCobErrno(), "98", 13);
            return 0;
        }
        this.errno = this.status.get_errno();
        return 1;
    }

    @Override
    public int rollback() {
        if (Config.getProperty(".ctree.ignore_transaction", false)) {
            return 1;
        }
        if (this.ctree == null) {
            return this.mapError(1, 5510);
        }
        if (!this.ctree.rollback(this.status)) {
            this.errno = 22;
            TransactionException.get(this.getCobErrno(), "98", 14);
            return 0;
        }
        this.errno = this.status.get_errno();
        return 1;
    }

    @Override
    public int recover() {
        if (this.ctree == null) {
            return this.mapError(1, 5510);
        }
        if (!this.ctree.recover(this.status)) {
            return this.mapError();
        }
        this.errno = this.status.get_errno();
        return 1;
    }

    @Override
    public String getVersion() {
        int intVersionLen;
        int fileVersionLen;
        int nameLen;
        byte[] name = new byte[255];
        byte[] fileVersion = new byte[255];
        byte[] intVersion = new byte[255];
        this.ctree.version(name, fileVersion, intVersion, 0, null, this.status);
        for (nameLen = 0; nameLen < name.length && name[nameLen] != 0; ++nameLen) {
        }
        for (fileVersionLen = 0; fileVersionLen < fileVersion.length && fileVersion[fileVersionLen] != 0; ++fileVersionLen) {
        }
        for (intVersionLen = 0; intVersionLen < intVersion.length && intVersion[intVersionLen] != 0; ++intVersionLen) {
        }
        return new String(name, 0, nameLen) + ";" + new String(fileVersion, 0, fileVersionLen) + ";" + new String(intVersion, 0, intVersionLen);
    }

    @Override
    public boolean isKeySelectedByNum() {
        return false;
    }

    private int SetInstance(long[] item, int instance) {
        String server = Config.getProperty(".file.index.server", "FAIRCOMS").trim();
        String user = Config.getProperty(".file.index.user", "").trim();
        String password = Config.getProperty(".file.index.password", "").trim();
        String connect = Config.getProperty(".file.index.connect", true) ? "yes" : "no";
        String versioncheck = Config.getProperty(".file.index.versioncheck", false) ? "yes" : "no";
        String s = null;
        boolean ssl = Config.getProperty(".file.index.ssl", false);
        String sslcert = Config.getProperty(".file.index.sslcert", "").trim();
        String endiancheck = Config.getProperty(".file.index.endiancheck", true) ? "yes" : "no";
        String ctshmemdir = Config.getProperty(".file.index.ctshmemdir", "").trim();
        if (instance > 0) {
            s = Config.getProperty(".file.index." + instance + ".server", null);
            if (s != null) {
                server = s.trim();
            }
            if ((s = Config.getProperty(".file.index." + instance + ".user", null)) != null) {
                user = s.trim();
            }
            if ((s = Config.getProperty(".file.index." + instance + ".password", null)) != null) {
                password = s.trim();
            }
            if (Config.getProperty(".file.index." + instance + ".connect", null) != null) {
                String string = connect = Config.getProperty(".file.index." + instance + ".connect", true) ? "yes" : "no";
            }
            if (Config.getProperty(".file.index." + instance + ".versioncheck", null) != null) {
                String string = versioncheck = Config.getProperty(".file.index." + instance + ".versioncheck", false) ? "yes" : "no";
            }
            if (Config.getProperty(".file.index." + instance + ".endiancheck", null) != null) {
                String string = endiancheck = Config.getProperty(".file.index." + instance + ".endiancheck", true) ? "yes" : "no";
            }
            if (Config.getProperty(".file.index." + instance + ".ctshmemdir", null) != null) {
                ctshmemdir = Config.getProperty(".file.index." + instance + ".ctshmemdir", "");
            }
        }
        String[] args = new String[]{server, user, password, connect, versioncheck, "", "", endiancheck, ssl ? "yes" : "no", sslcert, ctshmemdir};
        item[instance] = this.ctree.config(5, -1L, args, this.status);
        if (log != null) {
            String stLog = "Instance [" + instance + "] ";
            if (item[instance] < 0L) {
                stLog = stLog + "failed : ";
            }
            stLog = stLog + " server=" + server + ", user=" + user + ", password=" + password + ", connect=" + connect + ", versioncheck=" + versioncheck + ", name = \"\", author = \"\", endiancheck = " + endiancheck + ", ssl = " + ssl + ", sslcert = " + sslcert + ", ctshmemdir = " + ctshmemdir + ", status: errno=" + this.status.get_errno() + " int_errno=" + this.status.get_int_errno() + " int2_errno=" + this.status.get_int2_errno();
            log.info(stLog);
        }
        if (item[instance] < 0L) {
            return -1;
        }
        if (Config.getProperty(".file.index." + instance + ".datacompress", null) != null && Config.getProperty(".file.index." + instance + ".datacompress", false)) {
            this.ctree.config(1, item[instance], "datacompress", Config.getProperty(".file.index." + instance + ".datacompress", false) ? "yes" : "no", "", "", "", this.status);
            s = Config.getProperty(".file.index." + instance + ".datacompress.type", null);
            if (s != null) {
                this.ctree.config(1, item[instance], "datacompress.type", s.trim(), "", "", "", this.status);
            }
            if ((s = Config.getProperty(".file.index." + instance + ".datacompress.level", null)) != null) {
                this.ctree.config(1, item[instance], "datacompress.level", s.trim(), "", "", "", this.status);
            }
            if ((s = Config.getProperty(".file.index." + instance + ".datacompress.strategy", null)) != null) {
                this.ctree.config(1, item[instance], "datacompress.strategy", s.trim(), "", "", "", this.status);
            }
        } else if (Config.getProperty(".file.index.datacompress", false)) {
            this.ctree.config(1, item[instance], "datacompress", Config.getProperty(".file.index.datacompress", false) ? "yes" : "no", "", "", "", this.status);
            s = Config.getProperty(".file.index.datacompress.type", null);
            if (s != null) {
                this.ctree.config(1, item[instance], "datacompress.type", s.trim(), "", "", "", this.status);
            }
            if ((s = Config.getProperty(".file.index.datacompress.level", null)) != null) {
                this.ctree.config(1, item[instance], "datacompress.level", s.trim(), "", "", "", this.status);
            }
            if ((s = Config.getProperty(".file.index.datacompress.strategy", null)) != null) {
                this.ctree.config(1, item[instance], "datacompress.strategy", s.trim(), "", "", "", this.status);
            }
        }
        if (Config.getProperty(".file.index." + instance + ".keycompress", null) != null && Config.getProperty(".file.index." + instance + ".keycompress", false)) {
            this.ctree.config(1, item[instance], "keycompress", Config.getProperty(".file.index." + instance + ".keycompress", false) ? "yes" : "no", "", "", "", this.status);
            if (Config.getProperty(".file.index." + instance + ".keycompress.vlennod", true)) {
                this.ctree.config(1, item[instance], "keycompress.vlennod", Config.getProperty(".file.index." + instance + ".keycompress.vlennod", true) ? "yes" : "no", "", "", "", this.status);
            }
            if (Config.getProperty(".file.index." + instance + ".keycompress.rle", false)) {
                this.ctree.config(1, item[instance], "keycompress.vlennod", Config.getProperty(".file.index." + instance + ".keycompress.rle", false) ? "yes" : "no", "", "", "", this.status);
            }
            if (Config.getProperty(".file.index." + instance + ".keycompress.leading", false)) {
                this.ctree.config(1, item[instance], "keycompress.leading", Config.getProperty(".file.index." + instance + ".keycompress.leading", false) ? "yes" : "no", "", "", "", this.status);
            }
            if (Config.getProperty(".file.index." + instance + ".keycompress.padding", false)) {
                this.ctree.config(1, item[instance], "keycompress.padding", Config.getProperty(".file.index." + instance + ".keycompress.padding", false) ? "yes" : "no", "", "", "", this.status);
            }
        } else if (Config.getProperty(".file.index.keycompress", false)) {
            this.ctree.config(1, item[instance], "keycompress", Config.getProperty(".file.index.keycompress", false) ? "yes" : "no", "", "", "", this.status);
            if (Config.getProperty(".file.index.keycompress.leading", false)) {
                this.ctree.config(1, item[instance], "keycompress.leading", Config.getProperty(".file.index.keycompress.leading", false) ? "yes" : "no", "", "", "", this.status);
            }
            if (Config.getProperty(".file.index.keycompress.vlennod", true)) {
                this.ctree.config(1, item[instance], "keycompress.vlennod", Config.getProperty(".file.index.keycompress.vlennod", true) ? "yes" : "no", "", "", "", this.status);
            }
            if (Config.getProperty(".file.index.keycompress.rle", false)) {
                this.ctree.config(1, item[instance], "keycompress.rle", Config.getProperty(".file.index.keycompress.rle", false) ? "yes" : "no", "", "", "", this.status);
            }
            if (Config.getProperty(".file.index.keycompress.padding", false)) {
                this.ctree.config(1, item[instance], "keycompress.padding", Config.getProperty(".file.index.keycompress.padding", false) ? "yes" : "no", "", "", "", this.status);
            }
        }
        if (Config.getProperty(".file.index." + instance + ".encrypt", null) != null && Config.getProperty(".file.index." + instance + ".encrypt", false)) {
            this.ctree.config(1, item[instance], "encrypt", Config.getProperty(".file.index." + instance + ".encrypt", false) ? "yes" : "no", "", "", "", this.status);
        } else if (Config.getProperty(".file.index.encrypt", false)) {
            this.ctree.config(1, item[instance], "encrypt", Config.getProperty(".file.index.encrypt", false) ? "yes" : "no", "", "", "", this.status);
        }
        boolean bool = false;
        if (Config.getProperty(".file.index." + instance + ".memoryfile", null) != null && (bool = Config.getProperty(".file.index." + instance + ".memoryfile", false))) {
            this.ctree.config(1, item[instance], "memoryfile", bool ? "yes" : "no", "", "", "", this.status);
            if (log != null) {
                log.info("In instance [" + item[instance] + "]: set , \"memoryfile\"," + bool + "), \"\", \"\", \"\") status: errno=" + this.status.get_errno() + " int_errno=" + this.status.get_int_errno() + " int2_errno=" + this.status.get_int2_errno());
            }
        } else {
            bool = Config.getProperty(".file.index.memoryfile", false);
            if (bool) {
                this.ctree.config(1, item[instance], "memoryfile", bool ? "yes" : "no", "", "", "", this.status);
                if (log != null) {
                    log.info("In instance [" + item[instance] + "]: set , \"memoryfile\"," + bool + "), \"\", \"\", \"\") status: errno=" + this.status.get_errno() + " int_errno=" + this.status.get_int_errno() + " int2_errno=" + this.status.get_int2_errno());
                }
            }
        }
        if (bool && Config.getProperty(".file.index." + instance + ".memoryfile.persist", null) != null && (bool = Config.getProperty(".file.index." + instance + ".memoryfile.persist", false))) {
            this.ctree.config(1, item[instance], "memoryfile?persist", bool ? "yes" : "no", "", "", "", this.status);
            if (log != null) {
                log.info("In instance [" + item[instance] + "]: set , \"memoryfile?persist\"," + bool + "), \"\", \"\", \"\") status: errno=" + this.status.get_errno() + " int_errno=" + this.status.get_int_errno() + " int2_errno=" + this.status.get_int2_errno());
            }
        } else if (Config.getProperty(".file.index." + instance + ".memoryfile", false) && (bool = Config.getProperty(".file.index.memoryfile.persist", false))) {
            this.ctree.config(1, item[instance], "memoryfile?persist", bool ? "yes" : "no", "", "", "", this.status);
            if (log != null) {
                log.info("In instance [" + item[instance] + "]: set , \"memoryfile?persist\"," + bool + "), \"\", \"\", \"\") status: errno=" + this.status.get_errno() + " int_errno=" + this.status.get_int_errno() + " int2_errno=" + this.status.get_int2_errno());
            }
        }
        if ((s = Config.getProperty(".ctree.data_suffix", null)) != null) {
            this.ctree.config(1, item[instance], "datafilesuffix", s.trim().equals("") ? " " : s.trim(), "", "", "", this.status);
        } else {
            s = Config.getProperty(".file.index" + instance + ".data_suffix", null);
            if (s != null) {
                this.ctree.config(1, item[instance], "datafilesuffix", s.trim().equals("") ? " " : s.trim(), "", "", "", this.status);
            } else {
                s = Config.getProperty(".file.index.data_suffix", null);
                if (s != null) {
                    this.ctree.config(1, item[instance], "datafilesuffix", s.trim().equals("") ? " " : s.trim(), "", "", "", this.status);
                }
            }
        }
        s = Config.getProperty(".ctree.index_suffix", null);
        if (s != null) {
            this.ctree.config(1, item[instance], "indexfilesuffix", s.trim().equals("") ? " " : s.trim(), "", "", "", this.status);
        } else {
            s = Config.getProperty(".file.index." + instance + ".index_suffix", null);
            if (s != null) {
                this.ctree.config(1, item[instance], "indexfilesuffix", s.trim().equals("") ? " " : s.trim(), "", "", "", this.status);
            } else {
                s = Config.getProperty(".file.index.index_suffix", null);
                if (s != null) {
                    this.ctree.config(1, item[instance], "indexfilesuffix", s.trim().equals("") ? " " : s.trim(), "", "", "", this.status);
                }
            }
        }
        if (Config.getProperty(".file.index." + instance + ".fixed_length", null) != null && Config.getProperty(".file.index." + instance + ".fixed_length", false)) {
            this.ctree.config(1, item[instance], "ctfixed", Config.getProperty(".file.index." + instance + ".fixed_length", false) ? "yes" : "no", "", "", "", this.status);
        } else if (Config.getProperty(".file.index.fixed_length", false)) {
            this.ctree.config(1, item[instance], "ctfixed", Config.getProperty(".file.index.fixed_length", false) ? "yes" : "no", "", "", "", this.status);
        }
        if (Config.getProperty(".file.index." + instance + ".transaction", null) != null && Config.getProperty(".file.index." + instance + ".transaction", true)) {
            this.ctree.config(1, item[instance], "transaction", Config.getProperty(".file.index." + instance + ".transaction", true) ? "yes" : "no", "", "", "", this.status);
            if (Config.getProperty(".file.index." + instance + ".transaction.logging", false)) {
                this.ctree.config(1, item[instance], "transaction.logging", Config.getProperty(".file.index." + instance + ".transaction.logging", false) ? "yes" : "no", "", "", "", this.status);
            }
            if (Config.getProperty(".file.index." + instance + ".transaction.dependent", false)) {
                this.ctree.config(1, item[instance], "transaction.dependent", Config.getProperty(".file.index." + instance + ".transaction.dependent", false) ? "yes" : "no", "", "", "", this.status);
            } else {
                this.ctree.config(1, item[instance], "transaction.dependent", Config.getProperty(".file.index." + instance + ".transaction.dependent", false) ? "yes" : "no", "", "", "", this.status);
            }
            if (Config.getProperty(".file.index." + instance + ".transaction.deferautocommit", false)) {
                this.ctree.config(1, item[instance], "transaction.deferautocommit", Config.getProperty(".file.index." + instance + ".transaction.deferautocommit", false) ? "yes" : "no", "", "", "", this.status);
            }
        } else if (Config.getProperty(".file.index.transaction", true)) {
            this.ctree.config(1, item[instance], "transaction", Config.getProperty(".file.index.transaction", true) ? "yes" : "no", "", "", "", this.status);
            if (Config.getProperty(".file.index.transaction.logging", false)) {
                this.ctree.config(1, item[instance], "transaction.logging", Config.getProperty(".file.index.transaction.logging", false) ? "yes" : "no", "", "", "", this.status);
            }
            if (Config.getProperty(".file.index.transaction.dependent", false)) {
                this.ctree.config(1, item[instance], "transaction.dependent", Config.getProperty(".file.index.transaction.dependent", false) ? "yes" : "no", "", "", "", this.status);
            } else {
                this.ctree.config(1, item[instance], "transaction.dependent", Config.getProperty(".file.index.transaction.dependent", false) ? "yes" : "no", "", "", "", this.status);
            }
            if (Config.getProperty(".file.index.transaction.deferautocommit", false)) {
                this.ctree.config(1, item[instance], "transaction.deferautocommit", Config.getProperty(".file.index.transaction.deferautocommit", false) ? "yes" : "no", "", "", "", this.status);
            }
        } else {
            this.ctree.config(1, item[instance], "transaction", Config.getProperty(".file.index.transaction", true) ? "yes" : "no", "", "", "", this.status);
            this.ctree.config(1, item[instance], "transaction.dependent", Config.getProperty(".file.index.transaction.dependent", false) ? "yes" : "no", "", "", "", this.status);
        }
        if (Config.getProperty(".file.index." + instance + ".rpc", null) != null && Config.getProperty(".file.index." + instance + ".rpc", false)) {
            this.ctree.config(1, item[instance], "rpc", Config.getProperty(".file.index." + instance + ".rpc", false) ? "yes" : "no", "", "", "", this.status);
            if (Config.getProperty(".file.index." + instance + ".rcp.crc", false)) {
                this.ctree.config(1, item[instance], "rcp.crc", Config.getProperty(".file.index." + instance + ".rcp.crc", false) ? "yes" : "no", "", "", "", this.status);
            }
        } else if (Config.getProperty(".file.index.rpc", false)) {
            this.ctree.config(1, item[instance], "rpc", Config.getProperty(".file.index.rpc", false) ? "yes" : "no", "", "", "", this.status);
            if (Config.getProperty(".file.index.rcp.crc", false)) {
                this.ctree.config(1, item[instance], "rcp.crc", Config.getProperty(".file.index.rcp.crc", false) ? "yes" : "no", "", "", "", this.status);
            }
        }
        if (Config.getProperty(".file.index." + instance + ".lock_wait", null) != null && Config.getProperty(".file.index." + instance + ".lock_wait", false)) {
            this.ctree.config(1, item[instance], "retrylock", Config.getProperty(".file.index." + instance + ".lock_wait", false) ? "yes" : "no", "", "", "", this.status);
        } else if (Config.getProperty(".file.index.lock_wait", false)) {
            this.ctree.config(1, item[instance], "retrylock", Config.getProperty(".file.index.lock_wait", false) ? "yes" : "no", "", "", "", this.status);
        }
        if (Config.getProperty(".file.index." + instance + ".lock_read_anyhow", null) != null && Config.getProperty(".file.index." + instance + ".lock_read_anyhow", false)) {
            this.ctree.config(1, item[instance], "locktype", Config.getProperty(".file.index." + instance + ".lock_read_anyhow", false) ? "0" : "1", "", "", "", this.status);
        } else if (Config.getProperty(".file.index.lock_read_anyhow", false)) {
            this.ctree.config(1, item[instance], "locktype", Config.getProperty(".file.index.lock_read_anyhow", false) ? "0" : "1", "", "", "", this.status);
        }
        if (Config.getProperty(".file.index." + instance + ".skiplock", null) != null && Config.getProperty(".file.index." + instance + ".skiplock", false)) {
            this.ctree.config(1, item[instance], "skiplock", Config.getProperty(".file.index." + instance + ".skiplock", false) ? "yes" : "no", "", "", "", this.status);
        } else if (Config.getProperty(".file.index.skiplock", false)) {
            this.ctree.config(1, item[instance], "skiplock", Config.getProperty(".file.index.skiplock", false) ? "yes" : "no", "", "", "", this.status);
        }
        if (Config.getProperty(".file.index." + instance + ".autolock_allowed", null) != null && Config.getProperty(".file.index." + instance + ".autolock_allowed", true)) {
            this.ctree.config(1, item[instance], "runitlockdetect", "no", "", "", "", this.status);
        } else if (Config.getProperty(".file.index.autolock_allowed", null) != null && Config.getProperty(".file.index.autolock_allowed", true)) {
            this.ctree.config(1, item[instance], "runitlockdetect", "no", "", "", "", this.status);
        }
        if (Config.getProperty(".file.index." + instance + ".anyunlock", null) != null && Config.getProperty(".file.index." + instance + ".anyunlock", true)) {
            this.ctree.config(1, item[instance], "runitlockdetect?anyunlock", "yes", "", "", "", this.status);
        } else if (Config.getProperty(".file.index.anyunlock", null) != null && Config.getProperty(".file.index.anyunlock", true)) {
            this.ctree.config(1, item[instance], "runitlockdetect?anyunlock", "yes", "", "", "", this.status);
        }
        if (Config.getProperty(".file.index." + instance + ".read_lock_test", null) != null && Config.getProperty(".file.index." + instance + ".read_lock_test", false)) {
            this.ctree.config(1, item[instance], "detectlock", Config.getProperty(".file.index." + instance + ".read_lock_test", false) ? "yes" : "no", "", "", "", this.status);
        } else if (Config.getProperty(".file.index.read_lock_test", false)) {
            this.ctree.config(1, item[instance], "detectlock", Config.getProperty(".file.index.read_lock_test", false) ? "yes" : "no", "", "", "", this.status);
        }
        if (Config.getProperty(".file.index.bulkaddition", false)) {
            this.ctree.config(1, item[instance], "bulkaddition", Config.getProperty(".file.index.bulkaddition", false) ? "yes" : "no", "", "", "", this.status);
        }
        if (Config.getProperty(".file.index." + instance + ".batchaddition", null) != null) {
            bool = Config.getProperty(".file.index." + instance + ".batchaddition", false);
            this.ctree.config(1, item[instance], "batchaddition", bool ? "yes" : "no", "", "", "", this.status);
            if (log != null) {
                log.info("Set batchAddition ctree.ctconfig(1, instance =" + item[instance] + ", \"batchaddition\", batchaddition=" + bool + ", \"\", \"\", \"\") status: errno=" + this.status.get_errno() + " int_errno=" + this.status.get_int_errno() + " int2_errno=" + this.status.get_int2_errno());
            }
            if ((s = Config.getProperty(".file.index." + instance + ".batchaddition.records", null)) != null) {
                this.ctree.config(1, item[instance], "batchaddition.records", s.trim(), "", "", "", this.status);
            }
        } else if (Config.getProperty(".file.index.batchaddition", null) != null) {
            bool = Config.getProperty(".file.index.batchaddition", false);
            this.ctree.config(1, item[instance], "batchaddition", bool ? "yes" : "no", "", "", "", this.status);
            if (log != null) {
                log.info("Set batchAddition ctree.ctconfig(1, instance =" + item[instance] + ", \"batchaddition\", batchaddition=" + bool + ", \"\", \"\", \"\") status: errno=" + this.status.get_errno() + " int_errno=" + this.status.get_int_errno() + " int2_errno=" + this.status.get_int2_errno());
            }
            if ((s = Config.getProperty(".file.index.batchaddition.records", null)) != null) {
                this.ctree.config(1, item[instance], "batchaddition.records", s.trim(), "", "", "", this.status);
            }
        }
        if (Config.getProperty(".file.index." + instance + ".prefetch", null) != null && Config.getProperty(".file.index." + instance + ".prefetch", false)) {
            this.ctree.config(1, item[instance], "prefetch", Config.getProperty(".file.index." + instance + ".prefetch", false) ? "yes" : "no", "", "", "", this.status);
            s = Config.getProperty(".file.index." + instance + ".prefetch.records", null);
            if (s != null) {
                this.ctree.config(1, item[instance], "prefetch.ttl", s.trim(), "", "", "", this.status);
            }
            if ((s = Config.getProperty(".file.index." + instance + ".prefetch.ttl", null)) != null) {
                this.ctree.config(1, item[instance], "prefetch.ttl", s.trim(), "", "", "", this.status);
            }
            if (Config.getProperty(".file.index." + instance + ".prefetch.allowwriters", false)) {
                this.ctree.config(1, item[instance], "prefetch.allowwriters", Config.getProperty(".file.index." + instance + ".prefetch.allowwriters", false) ? "yes" : "no", "", "", "", this.status);
            }
        } else if (Config.getProperty(".file.index.prefetch", false)) {
            this.ctree.config(1, item[instance], "prefetch", Config.getProperty(".file.index.prefetch", false) ? "yes" : "no", "", "", "", this.status);
            s = Config.getProperty(".file.index.prefetch.records", null);
            if (s != null) {
                this.ctree.config(1, item[instance], "prefetch.records", s.trim(), "", "", "", this.status);
            }
            if ((s = Config.getProperty(".file.index.prefetch.ttl", null)) != null) {
                this.ctree.config(1, item[instance], "prefetch.ttl", s.trim(), "", "", "", this.status);
            }
            if (Config.getProperty(".file.index.prefetch.allowwriters", false)) {
                this.ctree.config(1, item[instance], "prefetch.allowwriters", Config.getProperty(".file.index.prefetch.allowwriters", false) ? "yes" : "no", "", "", "", this.status);
            }
        }
        if (Config.getProperty(".file.index." + instance + ".keycheck", null) != null && Config.getProperty(".file.index." + instance + ".keycheck", false)) {
            this.ctree.config(1, item[instance], "keycheck", Config.getProperty(".file.index." + instance + ".keycheck", false) ? "yes" : "no", "", "", "", this.status);
        } else if (Config.getProperty(".file.index.keycheck", false)) {
            this.ctree.config(1, item[instance], "keycheck", Config.getProperty(".file.index.keycheck", false) ? "yes" : "no", "", "", "", this.status);
        }
        if (Config.getProperty(".file.index." + instance + ".maxlencheck", null) != null && !Config.getProperty(".file.index." + instance + ".maxlencheck", true)) {
            this.ctree.config(1, item[instance], "maxlencheck", !Config.getProperty(".file.index." + instance + ".maxlencheck", true) ? "yes" : "no", "", "", "", this.status);
        } else if (!Config.getProperty(".file.index.maxlencheck", true)) {
            this.ctree.config(1, item[instance], "maxlencheck", !Config.getProperty(".file.index.maxlencheck", true) ? "yes" : "no", "", "", "", this.status);
        }
        if (Config.getProperty(".file.index." + instance + ".prefetch", null) != null) {
            bool = Config.getProperty(".file.index." + instance + ".prefetch", false);
            this.ctree.config(1, item[instance], "prefetch", bool ? "yes" : "no", "", "", "", this.status);
            if (bool && (s = Config.getProperty(".file.index." + instance + ".prefetch.records", null)) != null) {
                this.ctree.config(1, item[instance], "prefetch.records", s.trim(), "", "", "", this.status);
            }
            if (bool && (s = Config.getProperty(".file.index." + instance + ".prefetch.ttl", null)) != null) {
                this.ctree.config(1, item[instance], "prefetch.ttl", s.trim(), "", "", "", this.status);
            }
            if (bool) {
                this.ctree.config(1, item[instance], "prefetch.allowwriters", Config.getProperty(".file.index." + instance + ".prefetch.allowwriters", false) ? "yes" : "no", "", "", "", this.status);
            }
        } else {
            bool = Config.getProperty(".file.index.prefetch", false);
            this.ctree.config(1, item[instance], "prefetch", bool ? "yes" : "no", "", "", "", this.status);
            if (bool && (s = Config.getProperty(".file.index.prefetch.records", null)) != null) {
                this.ctree.config(1, item[instance], "prefetch.records", s.trim(), "", "", "", this.status);
            }
            if (bool && (s = Config.getProperty(".file.index.prefetch.ttl", null)) != null) {
                this.ctree.config(1, item[instance], "prefetch.ttl", s.trim(), "", "", "", this.status);
            }
            if (bool) {
                this.ctree.config(1, item[instance], "prefetch.allowwriters", Config.getProperty(".file.index.prefetch.allowwriters", false) ? "yes" : "no", "", "", "", this.status);
            }
        }
        if (Config.getProperty(".file.index." + instance + ".batchaddition", null) != null) {
            bool = Config.getProperty(".file.index." + instance + ".batchaddition", false);
            this.ctree.config(1, item[instance], "batchaddition", bool ? "yes" : "no", "", "", "", this.status);
            if (log != null) {
                log.info("Set batchAddition ctree.ctconfig(1, instance =" + item[instance] + ", \"batchaddition\", batchaddition=" + bool + ", \"\", \"\", \"\") status: errno=" + this.status.get_errno() + " int_errno=" + this.status.get_int_errno() + " int2_errno=" + this.status.get_int2_errno());
            }
            if (bool && (s = Config.getProperty(".file.index." + instance + ".batchaddition.records", null)) != null) {
                this.ctree.config(1, item[instance], "batchaddition.records", s.trim(), "", "", "", this.status);
            }
        } else if (Config.getProperty(".file.index.batchaddition", null) != null) {
            bool = Config.getProperty(".file.index.batchaddition", false);
            this.ctree.config(1, item[instance], "batchaddition", bool ? "yes" : "no", "", "", "", this.status);
            if (log != null) {
                log.info("Set batchAddition ctree.ctconfig(1, ctree=" + this.ctree + ", instance =" + item[instance] + ", \"batchaddition\", batchaddition=" + bool + ", \"\", \"\", \"\") status: errno=" + this.status.get_errno() + " int_errno=" + this.status.get_int_errno() + " int2_errno=" + this.status.get_int2_errno());
            }
            if (bool && (s = Config.getProperty(".file.index.batchaddition.records", null)) != null) {
                this.ctree.config(1, item[instance], "batchaddition.records", s.trim(), "", "", "", this.status);
            }
        }
        if (Config.getProperty(".file.index." + instance + ".inpool", null) != null) {
            bool = Config.getProperty(".file.index." + instance + ".inpool", false);
            this.ctree.config(1, item[instance], "inpool", bool ? "yes" : "no", "", "", "", this.status);
            if (log != null) {
                log.info("Set filepool and inpool ctree.ctconfig(1, instance =" + item[instance] + ", \"filepool\", filepool=" + bool + ", \"\", \"\", \"\") status: errno=" + this.status.get_errno() + " int_errno=" + this.status.get_int_errno() + " int2_errno=" + this.status.get_int2_errno());
            }
        } else if (Config.getProperty(".file.index.inpool", null) != null) {
            bool = Config.getProperty(".file.index.inpool", false);
            this.ctree.config(1, item[instance], "inpool", bool ? "yes" : "no", "", "", "", this.status);
            if (log != null) {
                log.info("Set filepool and inpool ctree.ctconfig(1, instance =" + item[instance] + ", \"filepool\", filepool=" + bool + ", \"\", \"\", \"\") status: errno=" + this.status.get_errno() + " int_errno=" + this.status.get_int_errno() + " int2_errno=" + this.status.get_int2_errno());
            }
        }
        if (Config.getProperty(".file.index." + instance + ".optimisticadd", null) != null) {
            this.ctree.config(1, item[instance], "optimisticadd", Config.getProperty(".file.index." + instance + ".optimisticadd", true) ? "yes" : "no", "", "", "", this.status);
            if (log != null) {
                log.info("config instance " + instance + " optimisticadd=" + (Config.getProperty(".file.index." + instance + ".optimisticadd", true) ? "yes" : "no") + " status: errno=" + this.status.get_errno() + " int_errno=" + this.status.get_int_errno() + " int2_errno=" + this.status.get_int2_errno());
            }
        } else {
            this.ctree.config(1, item[instance], "optimisticadd", Config.getProperty(".file.index.optimisticadd", true) ? "yes" : "no", "", "", "", this.status);
            if (log != null) {
                log.info("config instance " + instance + " optimisticadd=" + (Config.getProperty(".file.index." + instance + ".optimisticadd", true) ? "yes" : "no") + " status: errno=" + this.status.get_errno() + " int_errno=" + this.status.get_int_errno() + " int2_errno=" + this.status.get_int2_errno());
            }
        }
        if (Config.getProperty(".file.index." + instance + ".forcedelete", null) != null) {
            bool = Config.getProperty(".file.index." + instance + ".forcedelete", false);
            this.ctree.config(1, item[instance], "forcedelete", bool ? "yes" : "no", "", "", "", this.status);
            if (log != null) {
                log.info("config instance " + instance + " forcedelete=" + (Config.getProperty(".file.index." + instance + ".forcedelete", true) ? "yes" : "no") + " status: errno=" + this.status.get_errno() + " int_errno=" + this.status.get_int_errno() + " int2_errno=" + this.status.get_int2_errno());
            }
        } else if (Config.getProperty(".file.index.forcedelete", null) != null) {
            bool = Config.getProperty(".file.index.forcedelete", false);
            this.ctree.config(1, item[instance], "forcedelete", bool ? "yes" : "no", "", "", "", this.status);
            if (log != null) {
                log.info("config instance " + instance + " forcedelete=" + (Config.getProperty(".file.index." + instance + ".forcedelete", true) ? "yes" : "no") + " status: errno=" + this.status.get_errno() + " int_errno=" + this.status.get_int_errno() + " int2_errno=" + this.status.get_int2_errno());
            }
        }
        if (Config.getProperty(".file.index." + instance + ".rowid", null) != null && Config.getProperty(".file.index." + instance + ".rowid", false)) {
            this.ctree.config(1, item[instance], "rowid", Config.getProperty(".file.index." + instance + ".rowid", false) ? "yes" : "no", "", "", "", this.status);
            s = Config.getProperty(".file.index." + instance + ".rowid.size", null);
            if (s != null) {
                this.ctree.config(1, item[instance], "rowid.size", s.trim(), "", "", "", this.status);
            }
            if (log != null) {
                log.info("config instance " + instance + " rowid=" + (Config.getProperty(".file.index." + instance + ".rowid", true) ? "yes" : "no") + " status: errno=" + this.status.get_errno() + " int_errno=" + this.status.get_int_errno() + " int2_errno=" + this.status.get_int2_errno());
            }
        } else if (Config.getProperty(".file.index.rowid", false)) {
            this.ctree.config(1, item[instance], "rowid", Config.getProperty(".file.index.rowid", false) ? "yes" : "no", "", "", "", this.status);
            s = Config.getProperty(".file.index.rowid.size", null);
            if (s != null) {
                this.ctree.config(1, item[instance], "rowid.size", s.trim(), "", "", "", this.status);
            }
            if (log != null) {
                log.info("config instance " + instance + " rowid=" + (Config.getProperty(".file.index." + instance + ".rowid", true) ? "yes" : "no") + " status: errno=" + this.status.get_errno() + " int_errno=" + this.status.get_int_errno() + " int2_errno=" + this.status.get_int2_errno());
            }
        }
        if (Config.getProperty(".file.index." + instance + ".fileversion", null) != null) {
            this.ctree.config(1, item[instance], "fileversion", "" + Config.getProperty(".file.index." + instance + ".fileversion", 3), "", "", "", this.status);
            if (log != null) {
                log.info("config instance " + instance + " rowid=" + Config.getProperty(".file.index." + instance + ".fileversion", 3) + " status: errno=" + this.status.get_errno() + " int_errno=" + this.status.get_int_errno() + " int2_errno=" + this.status.get_int2_errno());
            }
        } else if (Config.getProperty(".file.index.fileversion", null) != null) {
            this.ctree.config(1, item[instance], "fileversion", "" + Config.getProperty(".file.index.fileversion", 3), "", "", "", this.status);
            if (log != null) {
                log.info("config instance " + instance + " fileversio=" + Config.getProperty(".file.index.fileversion", 3) + " status: errno=" + this.status.get_errno() + " int_errno=" + this.status.get_int_errno() + " int2_errno=" + this.status.get_int2_errno());
            }
        }
        String pathMapping = "*";
        String fileMapping = "*";
        pathMapping = Config.getProperty(".file.index." + instance + ".path_mapping", null) != null ? Config.getProperty(".file.index." + instance + ".path_mapping", "*") : Config.getProperty(".file.index.path_mapping", "*");
        fileMapping = Config.getProperty(".file.index." + instance + ".file_mapping", null) != null ? Config.getProperty(".file.index." + instance + ".file_mapping", "*") : Config.getProperty(".file.index.file_mapping", "*");
        String tmpPath = pathMapping + ",";
        String tmpFile = fileMapping + ",";
        int numPath = 1;
        long rc = 0L;
        while (tmpPath.indexOf(44) > 0) {
            s = tmpPath.substring(0, tmpPath.indexOf(44)).trim();
            tmpFile = Config.getProperty(".file.index." + instance + ".file_mapping_p" + numPath, null) != null ? Config.getProperty(".file.index." + instance + ".file_mapping_p" + numPath, "*") : (Config.getProperty(".file.index.file_mapping_p" + numPath, null) != null ? Config.getProperty(".file.index.file_mapping_p" + numPath, "*") : fileMapping);
            while (tmpFile.indexOf(44) > 0) {
                rc = this.ctree.config(7, item[instance], tmpFile.substring(0, tmpFile.indexOf(44)).trim(), s, "", "", "", this.status);
                if (log != null) {
                    log.info("config instance " + instance + " path[" + s + "] file[" + tmpFile.substring(0, tmpFile.indexOf(44)).trim() + "] rc =" + rc + " status: errno=" + this.status.get_errno() + " int_errno=" + this.status.get_int_errno() + " int2_errno=" + this.status.get_int2_errno());
                }
                tmpFile = tmpFile.substring(tmpFile.indexOf(44) + 1);
            }
            rc = this.ctree.config(7, item[instance], tmpFile.trim(), s, "", "", "", this.status);
            if (log != null) {
                log.info("config instance " + instance + " path[" + s + "] file[" + tmpFile.trim() + "] rc =" + rc + " status: errno=" + this.status.get_errno() + " int_errno=" + this.status.get_int_errno() + " int2_errno=" + this.status.get_int2_errno());
            }
            tmpPath = tmpPath.substring(tmpPath.indexOf(44) + 1);
            ++numPath;
        }
        tmpFile = Config.getProperty(".file.index." + instance + ".file_mapping_p" + numPath, null) != null ? Config.getProperty(".file.index." + instance + ".file_mapping_p" + numPath, "*") : (Config.getProperty(".file.index.file_mapping_p" + numPath, null) != null ? Config.getProperty(".file.index.file_mapping_p" + numPath, "*") : fileMapping);
        while (tmpFile.indexOf(44) > 0) {
            rc = this.ctree.config(7, item[instance], tmpFile.substring(0, tmpFile.indexOf(44)).trim(), tmpPath.trim(), "", "", "", this.status);
            if (log != null) {
                log.info("config instance " + instance + " path[" + tmpPath.trim() + "] file[" + tmpFile.substring(0, tmpFile.indexOf(44)).trim() + "] rc =" + rc + " status: errno=" + this.status.get_errno() + " int_errno=" + this.status.get_int_errno() + " int2_errno=" + this.status.get_int2_errno());
            }
            tmpFile = tmpFile.substring(tmpFile.indexOf(44) + 1);
        }
        rc = this.ctree.config(7, item[instance], tmpPath.trim(), tmpFile.trim(), "", "", "", this.status);
        if (log != null) {
            log.info("config instance " + instance + " path[" + tmpPath.trim() + "] file[" + tmpFile.trim() + "] rc =" + rc + " status: errno=" + this.status.get_errno() + " int_errno=" + this.status.get_int_errno() + " int2_errno=" + this.status.get_int2_errno());
        }
        return 0;
    }

    private void SetLog() {
        String s = Config.getProperty(".file.index.log.file", null);
        if (s != null) {
            this.ctree.config(0, -1L, "log", "yes", "", "", "", this.status);
            this.ctree.config(0, -1L, "log.file", s.trim(), "", "", "", this.status);
            if (log != null) {
                log.info("In setLog : set \"log\", log= yes (and after logFile =" + s.trim() + "), \"\", \"\", \"\") status: errno=" + this.status.get_errno() + " int_errno=" + this.status.get_int_errno() + " int2_errno=" + this.status.get_int2_errno());
            }
            if (Config.getProperty(".file.index.log.error", null) != null && Config.getProperty(".file.index.log.error", false)) {
                this.ctree.config(0, -1L, "log.error", "yes", "", "", "", this.status);
                if (Config.getProperty(".file.index.log.error.atend", false)) {
                    this.ctree.config(0, -1L, "log.error.atend", "yes", "", "", "", this.status);
                }
                if (Config.getProperty(".file.index.log.error.notfound", false)) {
                    this.ctree.config(0, -1L, "log.error.notfound", "yes", "", "", "", this.status);
                }
            }
            if (Config.getProperty(".file.index.log.info", false)) {
                this.ctree.config(0, -1L, "log.info", "yes", "", "", "", this.status);
            }
            if (Config.getProperty(".file.index.log.profile", false)) {
                this.ctree.config(0, -1L, "log.profile", "yes", "", "", "", this.status);
            }
            if (Config.getProperty(".file.index.log.debug", false)) {
                this.ctree.config(0, -1L, "log.debug", "yes", "", "", "", this.status);
                if (Config.getProperty(".file.index.log.debug.config", false)) {
                    this.ctree.config(0, -1L, "log.debug.config", "yes", "", "", "", this.status);
                }
                if (Config.getProperty(".file.index.log.debug.config.full", false)) {
                    this.ctree.config(0, -1L, "log.debug.config.full", "yes", "", "", "", this.status);
                }
                if (Config.getProperty(".file.index.log.debug.prefetch", false)) {
                    this.ctree.config(0, -1L, "log.debug.config.prefetch", "yes", "", "", "", this.status);
                }
                if (Config.getProperty(".file.index.log.debug.batchaddition", false)) {
                    this.ctree.config(0, -1L, "log.debug.config.batchaddition", "yes", "", "", "", this.status);
                }
            }
        }
    }

    public void finalize() {
        if (log != null) {
            log.info("FINALIZE:   ctree object: " + this.ctree);
        }
        this.close();
    }

    static {
        lock1 = new Object();
        issMap = new HashMap();
        sign = (byte)65;
        newConfig = false;
        if (!loaded) {
            lib = Config.getProperty(".ctree.ace", ".ctree.bound_server", false) ? Config.getProperty(".ctree.bound_library", "ctreedbs") : Config.getProperty(".ctree.library", "ctree");
            log = LoggerFactory.get(1);
            loaded = true;
        }
        newConfig = Config.getProperty(".ctree.new_config", true);
        if (Config.getProperty(".sqlserver.iss", false)) {
            String s = Config.getProperty(".sqlserver.convention", "A").trim();
            sign = s.equals("") ? (byte)65 : (byte)s.charAt(0);
            Properties props = Config.getIscobolProperties();
            Enumeration<?> num = props.propertyNames();
            while (num.hasMoreElements()) {
                String propName = num.nextElement().toString();
                if (!propName.startsWith("sqlserver.iss.mapping")) continue;
                String propValue = (String)props.get(propName);
                String[] temp = propName.split("\\.");
                if (temp.length != 4) continue;
                issMap.put(temp[3].replaceAll("\\*", ".*"), propValue);
                if (log == null) continue;
                log.info("mapping: " + temp[3] + " " + propValue);
            }
            if (log != null) {
                log.info("HashMap contains " + issMap.size() + " key value pair.");
            }
        }
    }
}

