/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.AtEndException;
import com.iscobol.io.BaseFile;
import com.iscobol.io.CobolFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.io.DynamicJIsam;
import com.iscobol.io.DynamicRelative;
import com.iscobol.io.FileTypeManager;
import com.iscobol.io.InvalidKeyException;
import com.iscobol.io.LockManagerHandler;
import com.iscobol.java.CobolVarHelper;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.DynamicMultiType;
import com.iscobol.rts.Factory;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IscobolCall;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.RuntimeErrorsNumbers;
import java.io.File;
import java.util.Vector;

public class IndexFile
extends BaseFile
implements CobolFile,
RuntimeErrorsNumbers {
    private static final boolean updBuffWithLock = Config.getProperty(".file.index.read_lock_test", false) || Config.getProperty(".file.index.lock_read_anyhow", false);
    protected DynamicFile theFile;
    private INumericVar relativeKey;
    protected Object _clazz;
    private KeyDescription[] keys = new KeyDescription[1];
    private int nKeys = 0;
    private byte[] collatingSeq;
    private static final LockManagerHandler lmh = LockManagerHandler.get();
    private static DynamicFile lastDfTrans = null;
    private static final String open_hook = Config.getProperty(".file.index.open_hook", null);
    private String pathHook;
    private IscobolCall executeHook;
    private int COMP_OPT = 0;

    private static MyProperties get() {
        MyProperties Return2 = (MyProperties)IscobolSystem.get(MyProperties.class);
        if (Return2 == null) {
            Return2 = new MyProperties();
            IscobolSystem.set(MyProperties.class, Return2);
        }
        return Return2;
    }

    public static DynamicFile getDefaultDynamicFile(Config c) {
        return IndexFile.getDynamic(Config.getProperty(c, ".file.index", "jisam"));
    }

    public static DynamicFile getDefaultDynamicFile(String name) {
        return IndexFile.getDefaultDynamicFile(name, FileTypeManager.getIndex());
    }

    public static DynamicFile getDefaultDynamicFile(String name, Class clz) {
        DynamicFile Return2;
        if (clz != null) {
            try {
                Return2 = (DynamicFile)clz.newInstance();
                MyProperties myProp = IndexFile.get();
                myProp.defIdxFileDesc = clz.getName();
                myProp.defIdxFileClass = clz;
                myProp.putClass();
            }
            catch (InstantiationException _ex) {
                throw new IscobolRuntimeException(16, clz.getName() + " (" + _ex + ")");
            }
            catch (IllegalAccessException _ex) {
                throw new IscobolRuntimeException(16, clz.getName() + " (" + _ex + ")");
            }
            catch (ClassCastException _ex) {
                throw new IscobolRuntimeException(16, clz.getName() + " (" + _ex + ")");
            }
        } else {
            Return2 = IndexFile.getDynamic(null);
        }
        return Return2;
    }

    private static DynamicFile getDynamic(String prop) {
        MyProperties myProp = IndexFile.get();
        if (prop == null || !prop.equals(myProp.defIdxFileDesc)) {
            myProp.defIdxFileDesc = prop;
            myProp.defIdxFileClass = FileTypeManager.getIndex(prop);
            myProp.putClass();
        }
        try {
            return (DynamicFile)myProp.defIdxFileClass.newInstance();
        }
        catch (IllegalAccessException _ex) {
            throw new IscobolRuntimeException(_ex);
        }
        catch (InstantiationException _ex) {
            throw new IscobolRuntimeException(_ex);
        }
    }

    public static final DynamicFile isIdxInConfig(String name) {
        if (name != null) {
            name = new File(name).getName();
            String prop = Config.getProperty(".file.index." + name.toLowerCase().replace('-', '_'), null);
            if (prop != null) {
                return IndexFile.getDynamic(prop);
            }
        }
        return null;
    }

    DynamicFile isInConfig(String name) {
        return IndexFile.isIdxInConfig(name);
    }

    public static int begin() {
        int Return2 = 1;
        MyProperties myProp = IndexFile.get();
        myProp.inTransaction = true;
        for (int i = myProp.allDynamicClasses.size() - 1; Return2 == 1 && i >= 0; --i) {
            try {
                DynamicFile df = (DynamicFile)((Class)myProp.allDynamicClasses.elementAt(i)).newInstance();
                df = lmh.get(df);
                Return2 = df.begin();
                lastDfTrans = df;
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return Return2;
    }

    public static int commit(int c) {
        int Return2 = 1;
        MyProperties myProp = IndexFile.get();
        myProp.inTransaction = false;
        for (int i = myProp.allDynamicClasses.size() - 1; Return2 == 1 && i >= 0; --i) {
            try {
                DynamicFile df = (DynamicFile)((Class)myProp.allDynamicClasses.elementAt(i)).newInstance();
                df = lmh.get(df);
                Return2 = df.commit(c);
                lastDfTrans = df;
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return Return2;
    }

    public static int rollback() {
        int Return2 = 1;
        MyProperties myProp = IndexFile.get();
        myProp.inTransaction = false;
        for (int i = myProp.allDynamicClasses.size() - 1; Return2 == 1 && i >= 0; --i) {
            try {
                DynamicFile df = (DynamicFile)((Class)myProp.allDynamicClasses.elementAt(i)).newInstance();
                df = lmh.get(df);
                Return2 = df.rollback();
                lastDfTrans = df;
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return Return2;
    }

    public static boolean isInTransaction() {
        MyProperties myProp = IndexFile.get();
        return myProp.inTransaction;
    }

    public static void sync(int c) {
        MyProperties myProp = IndexFile.get();
        for (int i = myProp.allDynamicClasses.size() - 1; i >= 0; --i) {
            try {
                DynamicFile df = (DynamicFile)((Class)myProp.allDynamicClasses.elementAt(i)).newInstance();
                df = lmh.get(df);
                df.sync(c);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
    }

    public IndexFile(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt, int am, Class cl) {
        super(nam, maxLen, memBuf, minLen, opt, am);
        this._clazz = cl;
    }

    public IndexFile(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt, int am, ICobolVar cl) {
        super(nam, maxLen, memBuf, minLen, opt, am);
        this._clazz = cl;
    }

    public IndexFile(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt, int am, String cl) {
        super(nam, maxLen, memBuf, minLen, opt, am);
        this._clazz = cl;
    }

    public IndexFile(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt, int am) {
        super(nam, maxLen, memBuf, minLen, opt, am);
        this._clazz = null;
    }

    protected Class getClazz() {
        if (this._clazz == null) {
            return FileTypeManager.getIndex();
        }
        if (this._clazz instanceof Class) {
            return (Class)this._clazz;
        }
        try {
            return Class.forName(this._clazz.toString().trim());
        }
        catch (ClassNotFoundException _ex) {
            throw new IscobolRuntimeException(5, "" + this._clazz + " (" + _ex + ")");
        }
    }

    protected int findKeyNum(ICobolVar[] key) {
        int Return2;
        KeyDescription kd = this.findKey(key);
        for (Return2 = this.nKeys - 1; Return2 >= 0; --Return2) {
            if (!this.keys[Return2].equals(kd)) continue;
            return Return2;
        }
        return Return2;
    }

    private KeyDescription findKey(ICobolVar[] key) {
        KeyDescription Return2;
        if (key != null) {
            Return2 = new KeyDescription(key.length, false);
            for (int i = 0; i < key.length; ++i) {
                Return2.setSegment(i, key[i].length(), key[i].getOffset());
            }
        } else {
            Return2 = null;
        }
        return Return2;
    }

    private void mapError(int err, String efs, int op) {
        switch (err) {
            case 0: {
                break;
            }
            case 100: {
                this.invDupl.throwMe();
                break;
            }
            case 110: {
                this.atEnd.throwMe();
                break;
            }
            case 111: {
                if (op == 6 || op == 7) {
                    this.atEnd.throwMe();
                    break;
                }
                this.invNoRec.throwMe();
                break;
            }
            default: {
                CobolIOException.get(err, efs, this, op);
            }
        }
    }

    protected KeyDescription[] getKeys() {
        return this.keys;
    }

    public KeyDescription[] getMyKeys() {
        return this.keys;
    }

    protected void setCurrentRecord(int op) {
        long nKey = this.relativeKey.tolong();
        if (nKey > 0L) {
            this.theFile.setCurrentRecord(nKey);
        } else {
            InvalidKeyException.get(111, "", this, op);
        }
    }

    private void buildFile(String path, int lockType) {
        int encr;
        int n = encr = (lockType & 0x1000) == 0 ? 0 : 1;
        if (this.theFile.build(path, "", 0, 0, 0, this.getCompressionFactor(), encr, this.getBufferLength(), this.getMinRecordLen(), this.keys, this.collatingSeq, this.assignExt) == 0) {
            this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 1);
        }
    }

    @Override
    public void peerOpen(String path, int openType, int lockType) {
        Object clazz = null;
        this.keys = this.getKeys();
        if (open_hook != null) {
            this.theFile = IndexFile.getDefaultDynamicFile(path, this.getOpenHookClass(path));
            path = this.pathHook;
        } else {
            this.theFile = this.isInConfig(path);
            if (this.theFile == null) {
                this.theFile = IndexFile.getDefaultDynamicFile(path, this.getClazz());
            }
        }
        if (this.getLogger() != null) {
            StringBuffer msg = new StringBuffer("OPENING [");
            msg.append(path);
            msg.append("] AS [");
            msg.append(this.theFile.getClass());
            msg.append("]");
            this.getLogger().info(msg.toString());
        }
        if (this.keys != null && this.keys.length > 0 && this.keys[0] != null) {
            this.theFile = lmh.get(this.theFile);
        }
        switch (openType) {
            case 2: {
                this.buildFile(path, lockType);
                if (this.theFile.open(path, openType, lockType, this.keys, this.getBufferLength(), this.getMinRecordLen(), this.nKeys, this.accessMode, this.isOptional(openType), this.assignExt) != 0) break;
                this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 1);
                break;
            }
            case 3: 
            case 6: {
                if (this.theFile.open(path, openType, lockType, this.keys, this.getBufferLength(), this.getMinRecordLen(), this.nKeys, this.accessMode, this.isOptional(openType), this.assignExt) != 0) break;
                if (this.theFile.getCobErrno() == 130) {
                    if (!this.isOptional(openType)) {
                        this.mapError(130, this.theFile.getSysErrno(), 1);
                        break;
                    }
                    CobolIOException.get(202, "", this, 1);
                    this.buildFile(path, lockType);
                    if (this.theFile.open(path, openType, lockType, this.keys, this.getBufferLength(), this.getMinRecordLen(), this.nKeys, this.accessMode, this.isOptional(openType), this.assignExt) != 0) break;
                    this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 1);
                    break;
                }
                this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 1);
                break;
            }
            case 1: {
                if (this.theFile.open(path, openType, lockType, this.keys, this.getBufferLength(), this.getMinRecordLen(), this.nKeys, this.accessMode, this.isOptional(openType), this.assignExt) != 0) break;
                if (this.theFile.getCobErrno() == 130) {
                    if (!this.isOptional(openType)) {
                        this.mapError(130, "", 1);
                        break;
                    }
                    this.mapError(203, "", 1);
                    break;
                }
                this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 1);
                break;
            }
            default: {
                throw new IscobolRuntimeException(3, new IllegalArgumentException("OPEN").toString());
            }
        }
        if (this.theFile.isOpen()) {
            int foundKeys = this.theFile.getNumKeys();
            if (this.getBufferLength() != this.theFile.getMaxRecordSize()) {
                if (this.getLogger() != null) {
                    this.getLogger().info("OPEN: [39] extFs [02] The expected record size " + this.getBufferLength() + " differ from the maximum record size " + this.theFile.getMaxRecordSize());
                }
                this.theFile.close();
                this.mapError(102, "02", 1);
            } else if (foundKeys > 0 && this.nKeys > foundKeys) {
                this.theFile.close();
                if (this.getLogger() != null) {
                    this.getLogger().info("OPEN: [39] extFs [04] The expected number of keys of the file " + this.nKeys + " is > of the number of the keys " + foundKeys);
                }
                this.mapError(102, "04", 1);
            } else if (!Config.getProperty(".file.extra_keys_ok", false) && foundKeys > 0 && this.nKeys < foundKeys) {
                this.theFile.close();
                if (this.getLogger() != null) {
                    this.getLogger().info("OPEN: [39] extFs [04] The expected number of keys of the file " + this.nKeys + " is < of the number of the keys " + foundKeys);
                }
                this.mapError(102, "04", 1);
            } else {
                this.setOpenMode(openType);
            }
            if (Config.getProperty(".file.index.check_all_keys", false)) {
                int i;
                boolean equalKeys = true;
                for (i = 0; i < this.theFile.getNumKeys() && i < this.keys.length && equalKeys; ++i) {
                    equalKeys = false;
                    for (int j = 0; j < this.theFile.getNumKeys() && j < this.keys.length && !equalKeys; ++j) {
                        equalKeys = this.theFile.getKey(j).equals(this.keys[i]);
                    }
                }
                if (!equalKeys) {
                    this.theFile.close();
                    this.setOpenMode(0);
                    if (this.getLogger() != null) {
                        this.getLogger().info("OPEN: [39] extFs [04] The description of the ordinal key " + i + " is wrong!");
                    }
                    this.mapError(102, "04", 1);
                }
            }
        } else {
            this.setOpenMode(openType);
        }
        if (this.getLogger() != null && !(this.theFile instanceof DynamicRelative)) {
            this.getLogger().info("OPENED [" + path + "] AS [" + this.theFile.getClass() + "]");
        }
    }

    @Override
    protected void peerClose(int opts) {
        if (this.theFile != null && this.theFile.isOpen() && this.theFile.close() == 0) {
            this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 2);
        }
        this.theFile = null;
        this.setOpenMode(0);
    }

    @Override
    public void keyReset() {
        this.nKeys = 0;
    }

    @Override
    public CobolFile key(ICobolVar[] key, boolean dup) {
        if (this.nKeys == this.keys.length) {
            KeyDescription[] newKeys = new KeyDescription[this.keys.length + 1];
            System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
            this.keys = newKeys;
        }
        this.keys[this.nKeys] = new KeyDescription(key.length, dup);
        for (int i = 0; i < key.length; ++i) {
            this.keys[this.nKeys].setSegment(i, key[i].length(), key[i].getOffset());
        }
        ++this.nKeys;
        return this;
    }

    @Override
    public CobolFile relativeKey(INumericVar key) {
        this.relativeKey = key;
        return this;
    }

    @Override
    public CobolFile collatingSequence(byte[] cs) {
        this.collatingSeq = cs;
        return this;
    }

    @Override
    public boolean write(boolean lock, int len) {
        super.write(lock, len);
        if (this.relativeKey != null) {
            if (this.accessMode != 1) {
                this.setCurrentRecord(3);
            }
            long rc = this.theFile.write(this.getBufferRO(), 0, len, lock);
            int err = this.theFile.getCobErrno();
            if (rc == 0L || err != 0) {
                this.mapError(err, this.theFile.getSysErrno(), 3);
            } else {
                this.relativeKey.set(this.theFile.getCurrentRecord());
            }
        } else {
            if (this.getLogger() != null && LoggerFactory.get(16) != null) {
                StringBuffer msg = new StringBuffer("key 1");
                this.writeLogKey(msg, 0);
                this.getLogger().info(msg.toString());
            }
            long rc = this.theFile.write(this.getBufferRO(), 0, len, lock);
            int err = this.theFile.getCobErrno();
            if (rc == 0L || err != 0) {
                this.mapError(err, this.theFile.getSysErrno(), 3);
            }
        }
        return false;
    }

    @Override
    public boolean writeAdvancing(int type, int lines, boolean lck, int len, int opts) {
        return this.write(lck, len);
    }

    @Override
    public void rewrite(boolean lock, int len) {
        super.rewrite(lock, len);
        if (this.relativeKey != null) {
            if (this.accessMode != 1) {
                this.setCurrentRecord(4);
            }
            long rc = this.theFile.rewrite(this.getBufferRO(), 0, len, lock);
            int err = this.theFile.getCobErrno();
            if (rc == 0L || err != 0) {
                this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 3);
            } else {
                this.relativeKey.set(this.theFile.getCurrentRecord());
            }
        } else {
            if (this.getLogger() != null && LoggerFactory.get(16) != null) {
                StringBuffer msg = new StringBuffer("key 1");
                this.writeLogKey(msg, 0);
                this.getLogger().info(msg.toString());
            }
            long rc = this.theFile.rewrite(this.getBufferRO(), 0, len, lock);
            int err = this.theFile.getCobErrno();
            if (rc == 0L || err != 0) {
                this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 4);
            }
        }
    }

    @Override
    public void delete() {
        super.delete();
        if (this.relativeKey != null) {
            long rc;
            if (this.accessMode != 1) {
                this.setCurrentRecord(5);
            }
            if ((rc = this.theFile.delete(this.getBufferRO(), 0)) == 0L) {
                this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 3);
            } else {
                this.relativeKey.set(this.theFile.getCurrentRecord());
            }
        } else if (this.theFile.delete(this.getBufferRO(), 0) == 0L) {
            this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 5);
        }
    }

    @Override
    public int readNext(int lock, ICobolVar into) {
        long Return2 = 0L;
        if (lock != -1) {
            super.readNext(lock &= this.lockMask, into);
        } else {
            super.readNext(lock &= 0xFFFFFFFF, into);
        }
        if (!this.theFile.isOpen()) {
            AtEndException.get(this, 6);
            return (int)Return2;
        }
        byte[] in = this.getBufferRO();
        do {
            Return2 = this.theFile.next(in, 0, lock);
            int err = this.theFile.getCobErrno();
            if (Return2 == 0L || err != 0) {
                if (updBuffWithLock && err == 107) {
                    this.updateBuffer(in);
                }
                this.mapError(err, this.theFile.getSysErrno(), 6);
            }
            this.updateBuffer(in);
        } while (this.whileLike != null && !this.isLike());
        if (into != null) {
            into.setUsingMaxLen(in);
        }
        if (this.relativeKey != null) {
            this.relativeKey.set(this.theFile.getCurrentRecord());
        }
        return (int)Return2;
    }

    @Override
    public int readPrev(int lock, ICobolVar into) {
        long Return2 = 0L;
        if (lock != -1) {
            super.readPrev(lock &= this.lockMask, into);
        } else {
            super.readPrev(lock &= 0xFFFFFFFF, into);
        }
        if (!this.theFile.isOpen()) {
            AtEndException.get(this, 7);
            return (int)Return2;
        }
        byte[] in = this.getBufferRO();
        do {
            Return2 = this.theFile.previous(in, 0, lock);
            int err = this.theFile.getCobErrno();
            if (Return2 == 0L || err != 0) {
                if (updBuffWithLock && err == 107) {
                    this.updateBuffer(in);
                }
                this.mapError(err, this.theFile.getSysErrno(), 7);
            }
            this.updateBuffer(in);
        } while (this.whileLike != null && !this.isLike());
        if (into != null) {
            into.setUsingMaxLen(in);
        }
        if (this.relativeKey != null) {
            this.relativeKey.set(this.theFile.getCurrentRecord());
        }
        return (int)Return2;
    }

    @Override
    public int readKey(ICobolVar[] key, int lock, ICobolVar into) {
        byte[] in;
        long Return2 = 0L;
        if (lock != -1) {
            super.readKey(key, lock &= this.lockMask, into);
        } else {
            super.readKey(key, lock &= 0xFFFFFFFF, into);
        }
        if (!this.theFile.isOpen()) {
            InvalidKeyException.get(111, "", this, 8);
            return (int)Return2;
        }
        if (this.relativeKey != null) {
            this.setCurrentRecord(8);
            in = this.getBufferRO();
            Return2 = this.theFile.read(in, 0, this.findKey(key), lock);
            int err = this.theFile.getCobErrno();
            if (Return2 == 0L || err != 0) {
                this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 3);
            } else {
                this.relativeKey.set(this.theFile.getCurrentRecord());
            }
        } else {
            if (this.getLogger() != null && LoggerFactory.get(16) != null) {
                StringBuffer msg = new StringBuffer("key ");
                msg.append(this.findKeyNum(key) + 1);
                this.writeLogKey(msg, this.findKeyNum(key));
                this.getLogger().info(msg.toString());
            }
            if (this.theFile.isKeySelectedByNum()) {
                in = this.getBufferRO();
                Return2 = this.theFile.read(in, 0, this.findKeyNum(key), lock);
            } else {
                in = this.getBufferRO();
                Return2 = this.theFile.read(in, 0, this.findKey(key), lock);
            }
            int err = this.theFile.getCobErrno();
            if (Return2 == 0L || err != 0) {
                if (updBuffWithLock && err == 107) {
                    this.updateBuffer(in);
                }
                this.mapError(err, this.theFile.getSysErrno(), 8);
            }
        }
        this.updateBuffer(in);
        if (into != null) {
            into.setUsingMaxLen(in);
        }
        return (int)Return2;
    }

    @Override
    public void start(ICobolVar[] key, int type, int keyLen) {
        super.start(key, type, keyLen);
        if (!this.theFile.isOpen()) {
            InvalidKeyException.get(111, "", this, 9);
            return;
        }
        if (this.relativeKey != null) {
            this.theFile.setCurrentRecord(this.relativeKey.tolong());
            long rc = this.theFile.start(this.getBufferRO(), 0, this.findKey(key), keyLen, type);
            if (rc == 0L) {
                this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 3);
            } else {
                this.relativeKey.set(this.theFile.getCurrentRecord());
            }
        } else {
            long rc;
            if (this.getLogger() != null && LoggerFactory.get(16) != null) {
                StringBuffer msg = new StringBuffer("key ");
                msg.append(this.findKeyNum(key) + 1);
                this.writeLogKey(msg, this.findKeyNum(key));
                this.getLogger().info(msg.toString());
            }
            if ((rc = this.theFile.isKeySelectedByNum() ? this.theFile.start(this.getBufferRO(), 0, this.findKeyNum(key), keyLen, type) : this.theFile.start(this.getBufferRO(), 0, this.findKey(key), keyLen, type)) == 0L) {
                this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 9);
            }
        }
    }

    @Override
    public void unlock() {
        int rc;
        super.unlock();
        if (this.theFile.isOpen() && (rc = this.theFile.unlock()) == 0) {
            this.mapError(this.theFile.getCobErrno(), this.theFile.getSysErrno(), 10);
        }
    }

    @Override
    public void deleteFile(ICobolVar path) {
        int rc;
        String pathAsStr;
        super.deleteFile(path);
        if (this.getLogger() != null && LoggerFactory.get(16) != null) {
            StringBuffer msg = new StringBuffer("key 0");
            this.writeLogKey(msg, 0);
            this.getLogger().info(msg.toString());
        }
        if (IndexFile.isRemoveNameSpaces(pathAsStr = path.toString().trim())) {
            pathAsStr = pathAsStr.toString().replace(" ", "");
        }
        if ((this.theFile = this.isInConfig(pathAsStr)) == null) {
            Class clazz = this.getClazz();
            this.theFile = IndexFile.getDefaultDynamicFile(pathAsStr, clazz);
        }
        if ((rc = this.theFile instanceof DynamicMultiType ? ((DynamicMultiType)this.theFile).removeEx(this.keys, this.getOsPath()) : this.theFile.remove(this.getOsPath())) == 0) {
            int cobErrno = this.theFile.getCobErrno();
            if (cobErrno == 130) {
                this.mapError(203, this.theFile.getSysErrno(), 11);
            } else {
                this.mapError(cobErrno, this.theFile.getSysErrno(), 11);
            }
        }
    }

    private void writeLogKey(StringBuffer msg, int numKey) {
        if (this.keys.length > 0) {
            KeyDescription keyd = this.keys[numKey];
            msg.append(", key-value=");
            if (keyd != null) {
                for (int i = 0; i < keyd.getNumSegments(); ++i) {
                    msg.append(this.getBufferAsVar().toString().substring(keyd.getSegment((int)i).offset, keyd.getSegment((int)i).offset + keyd.getSegment((int)i).size));
                }
            }
        }
    }

    private Class getOpenHookClass(String path) {
        this.pathHook = path;
        Class<?> clazz = null;
        CobolVarHelper p1_h = new CobolVarHelper("varPath", this.COMP_OPT).picX("varPath", 300);
        ICobolVar varPath = p1_h.get("varPath");
        CobolVarHelper p2_h = new CobolVarHelper("varClazz", this.COMP_OPT).picX("varClazz", 300);
        ICobolVar varClazz = p2_h.get("varClazz");
        varPath.set(path);
        DynamicFile theFileN = this.isInConfig(path);
        if (theFileN == null) {
            varClazz.set(this.getClazz().getName());
        } else {
            varClazz.set(theFileN.getClass().getName());
        }
        try {
            Factory.call(open_hook, null, new ICobolVar[]{varPath, varClazz});
            clazz = varClazz.toString().trim().length() != 0 ? Class.forName(varClazz.toString().trim()) : this.getClazz();
            this.pathHook = varPath.toString().trim();
        }
        catch (ClassNotFoundException _ex) {
            throw new IscobolRuntimeException(5, "" + varClazz.toString().trim() + " (" + _ex + ")");
        }
        return clazz;
    }

    public void setCOMP_OPTcp() {
        this.COMP_OPT = 16;
    }

    static class MyProperties {
        private String defIdxFileDesc = "jisam";
        private Class defIdxFileClass = DynamicJIsam.class;
        private Vector allDynamicClasses = new Vector();
        private boolean inTransaction;

        private MyProperties() {
            this.allDynamicClasses.addElement(this.defIdxFileClass);
        }

        private void putClass() {
            int i;
            int dim = this.allDynamicClasses.size();
            for (i = 0; i < dim && this.allDynamicClasses.elementAt(i) != this.defIdxFileClass; ++i) {
            }
            if (i == dim) {
                this.allDynamicClasses.addElement(this.defIdxFileClass);
            }
        }
    }
}

