/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.FileTypeManager;
import com.iscobol.io.IndexFile;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.KeyDescription;
import java.io.File;

public class LineSequentialDFile
extends IndexFile {
    public static final KeyDescription[] KEYS = new KeyDescription[0];
    boolean stripTrailingSpaces = false;

    public LineSequentialDFile(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt, int am) {
        super(nam, maxLen, memBuf, minLen, opt, am);
    }

    public LineSequentialDFile(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt, int am, Class clazz) {
        super(nam, maxLen, memBuf, minLen, opt, am, clazz);
    }

    public LineSequentialDFile(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt, int am, String clazz) {
        super(nam, maxLen, memBuf, minLen, opt, am, clazz);
    }

    @Override
    protected Class getClazz() {
        if (this._clazz != null) {
            return super.getClazz();
        }
        return FileTypeManager.getLineSequential();
    }

    @Override
    protected KeyDescription[] getKeys() {
        return KEYS;
    }

    public static final DynamicFile isLSeqInConfig(String name) {
        if (name != null) {
            name = new File(name).getName();
            String prop = Config.getProperty(".file.linesequential." + name.toLowerCase().replace('-', '_'), null);
            if (prop != null) {
                try {
                    return (DynamicFile)FileTypeManager.getLineSequential(prop).newInstance();
                }
                catch (IllegalAccessException _ex) {
                    throw new IscobolRuntimeException(_ex);
                }
                catch (InstantiationException _ex) {
                    throw new IscobolRuntimeException(_ex);
                }
            }
        }
        return null;
    }

    @Override
    protected DynamicFile isInConfig(String name) {
        return LineSequentialDFile.isLSeqInConfig(name);
    }

    public static DynamicFile getDefaultLSeqDynamicFile(String name) {
        return LineSequentialDFile.getDefaultDynamicFile(name, FileTypeManager.getLineSequential());
    }

    @Override
    public boolean write(boolean lock, int len) {
        int intLen;
        String str = "";
        if (this.stripTrailingSpaces) {
            byte[] buf = this.getBufferAsVar().getBytes();
            for (intLen = len; intLen > 0 && buf[intLen - 1] == 32; --intLen) {
            }
        }
        return super.write(lock, intLen);
    }

    public void setTrailingSpaces() {
        this.stripTrailingSpaces = true;
    }
}

