/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import IT.picosoft.isam.FLock;
import IT.picosoft.isam.IsamException;
import com.iscobol.io.AtEndException;
import com.iscobol.io.BaseRelative;
import com.iscobol.io.CobolFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.io.InvalidKeyException;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IscobolRuntimeException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;

public class RelativeFile
extends BaseRelative {
    private INumericVar relativeKey;
    private byte[] locBuffer = new byte[this.getBufferLength()];
    private byte[] delBuffer = new byte[this.getBufferLength()];
    private long currRecord;
    private boolean positioned;
    private boolean atBegin;
    private boolean atEnd;
    private Hashtable allLocks;

    public RelativeFile(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt, int am) {
        super(nam, maxLen, memBuf, minLen, opt, am);
    }

    public RelativeFile(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt, int am, INumericVar relKey) {
        this(nam, maxLen, memBuf, minLen, opt, am);
        this.relativeKey = relKey;
    }

    @Override
    public CobolFile relativeKey(INumericVar key) {
        this.relativeKey = key;
        return this;
    }

    private synchronized void allRecordUnlock() throws IsamException {
        Enumeration en = this.allLocks.elements();
        while (en.hasMoreElements()) {
            FLock lck = (FLock)en.nextElement();
            lck.l_type = (short)2;
            this.theFile.fcntl(6, lck);
        }
        this.allLocks.clear();
    }

    private synchronized void recordUnlockPos(long pos) throws IsamException {
        Long start = new Long(pos);
        FLock lck = (FLock)this.allLocks.get(start);
        if (lck != null) {
            lck.l_type = (short)2;
            this.theFile.fcntl(6, lck);
            this.allLocks.remove(start);
        }
    }

    private synchronized void recordLockNum(int lock, long recNum, int len) throws IsamException {
        if (lock > 0 && !this.exclusiveLock && this.isWritable()) {
            try {
                FLock lck = new FLock();
                lck.l_whence = 0;
                lck.l_start = (recNum - 1L) * (long)len;
                lck.l_len = len;
                lck.l_type = this.readLock || this.getOpenMode() == 1 ? (short)0 : 1;
                Long start = new Long(lck.l_start);
                FLock oldlck = (FLock)this.allLocks.get(start);
                if (oldlck != null) {
                    if (oldlck.l_type == 0 && lck.l_type == 1 || oldlck.l_len < lck.l_len) {
                        this.allLocks.remove(oldlck);
                        this.theFile.fcntl(6, lck);
                        this.allLocks.put(start, lck);
                    }
                } else {
                    if (!this.multipleLock) {
                        this.allRecordUnlock();
                    }
                    this.theFile.fcntl(6, lck);
                    this.allLocks.put(start, lck);
                }
            }
            catch (IsamException ex) {
                if (ex.getIserrno() == 113) {
                    throw new IsamException(107);
                }
                throw ex;
            }
        }
    }

    @Override
    public void peerOpen(String path, int openType, int lockType) {
        super.peerOpen(path, openType, lockType);
        this.currRecord = 1L;
        this.positioned = true;
        this.atBegin = true;
        this.atEnd = false;
        this.allLocks = new Hashtable();
    }

    private long nextRecNum() {
        if (this.atBegin) {
            return 1L;
        }
        if (this.currRecord <= 0L) {
            return 0L;
        }
        if (this.positioned) {
            return this.currRecord;
        }
        return this.currRecord + 1L;
    }

    private long prevRecNum() {
        if (this.atEnd) {
            try {
                return this.theFile.length() / (long)this.getBufferLength();
            }
            catch (IsamException _ex) {
                CobolIOException.get(RelativeFile.cobolErrno(_ex), "", this, 7);
                return 0L;
            }
        }
        if (this.currRecord <= 0L) {
            return 0L;
        }
        if (this.positioned) {
            return this.currRecord;
        }
        return this.currRecord - 1L;
    }

    private long currRecNum() {
        if (this.atBegin || this.atEnd) {
            return 0L;
        }
        return this.currRecord;
    }

    @Override
    public boolean write(boolean lock, int len) {
        super.write(lock, len);
        if (len > this.getBufferLength()) {
            len = this.getBufferLength();
        }
        try {
            long recNum;
            if (this.getOpenMode() == 6) {
                this.theFile.seek(this.theFile.length());
                this.theFile.write(this.getBufferRO(), 0, len);
                recNum = this.theFile.length() / (long)this.getBufferLength() + 1L;
                if (this.relativeKey != null) {
                    this.relativeKey.set(recNum);
                }
            } else {
                recNum = this.relativeKey != null && this.accessMode != 1 ? this.relativeKey.tolong() : this.nextRecNum();
                if (recNum < 1L) {
                    InvalidKeyException.get(139, "", this, 3);
                    return false;
                }
                long pos = (recNum - 1L) * (long)this.getBufferLength();
                this.theFile.seek(pos);
                int rc = this.theFile.read(this.locBuffer);
                if (rc < 0 || Arrays.equals(this.delBuffer, this.locBuffer)) {
                    this.theFile.seek(pos);
                    this.theFile.write(this.getBufferRO(), 0, len);
                    if (!this.exclusiveLock) {
                        this.recordUnlockPos(pos);
                    }
                } else {
                    InvalidKeyException.get(100, "", this, 3);
                    return false;
                }
            }
            this.currRecord = recNum;
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
        }
        catch (IsamException _ex) {
            CobolIOException.get(RelativeFile.cobolErrno(_ex), "", this, 2);
        }
        return false;
    }

    @Override
    public boolean writeAdvancing(int type, int lines, boolean lck, int len, int opts) {
        throw new IscobolRuntimeException(3, new IllegalArgumentException("ADVANCING ").toString());
    }

    @Override
    public void rewrite(boolean lock, int len) {
        super.rewrite(lock, len);
        try {
            long recNum;
            if (this.relativeKey != null && this.accessMode != 1) {
                recNum = this.relativeKey.tolong();
                if (recNum < 1L) {
                    InvalidKeyException.get(139, "", this, 4);
                    return;
                }
            } else {
                recNum = this.currRecNum();
                if (recNum < 1L) {
                    InvalidKeyException.get(143, "", this, 4);
                    return;
                }
            }
            long pos = (recNum - 1L) * (long)this.getBufferLength();
            this.theFile.seek(pos);
            int rc = this.theFile.read(this.locBuffer);
            if (rc >= 0 && !Arrays.equals(this.delBuffer, this.locBuffer)) {
                this.theFile.seek(pos);
                this.theFile.write(this.getBufferRO());
                if (!this.exclusiveLock) {
                    this.recordUnlockPos(pos);
                }
            } else {
                InvalidKeyException.get(111, "", this, 4);
                return;
            }
            this.currRecord = recNum;
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
        }
        catch (IsamException _ex) {
            CobolIOException.get(RelativeFile.cobolErrno(_ex), "", this, 2);
        }
    }

    @Override
    public void delete() {
        super.delete();
        try {
            long recNum;
            if (this.relativeKey != null && this.accessMode != 1) {
                recNum = this.relativeKey.tolong();
                if (recNum < 1L) {
                    InvalidKeyException.get(139, "", this, 5);
                    return;
                }
            } else {
                recNum = this.currRecNum();
                if (recNum < 1L) {
                    InvalidKeyException.get(143, "", this, 5);
                    return;
                }
            }
            long pos = (recNum - 1L) * (long)this.getBufferLength();
            this.theFile.seek(pos);
            int rc = this.theFile.read(this.locBuffer);
            if (rc < 0 || Arrays.equals(this.delBuffer, this.locBuffer)) {
                InvalidKeyException.get(111, "", this, 5);
                return;
            }
            this.theFile.seek(pos);
            this.theFile.write(this.delBuffer);
            this.currRecord = recNum;
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
        }
        catch (IsamException _ex) {
            CobolIOException.get(RelativeFile.cobolErrno(_ex), "", this, 2);
        }
    }

    private int myNext(byte[] buffer, long nRec) throws IsamException {
        int rc;
        this.currRecord = nRec < 1L ? 1L : nRec;
        long pos = (this.currRecord - 1L) * (long)buffer.length;
        this.theFile.seek(pos);
        do {
            if ((rc = this.theFile.read(buffer)) <= 0) continue;
            if (!Arrays.equals(buffer, this.delBuffer)) break;
            pos = this.currRecord * (long)buffer.length;
            ++this.currRecord;
        } while (rc > 0);
        return rc;
    }

    private int myPrev(byte[] buffer, long nRec) throws IsamException {
        int rc = 0;
        this.currRecord = nRec;
        while (this.currRecord > 0L) {
            long pos = (this.currRecord - 1L) * (long)buffer.length;
            this.theFile.seek(pos);
            rc = this.theFile.read(buffer);
            if (!Arrays.equals(buffer, this.delBuffer)) break;
            --this.currRecord;
        }
        if (this.currRecord == 0L) {
            this.currRecord = 1L;
        }
        return rc;
    }

    @Override
    public int readNext(boolean lock, ICobolVar into) {
        return this.readNext(lock ? 1 : 0, into);
    }

    @Override
    public int readNext(int lock, ICobolVar into) {
        int Return2 = 0;
        if (lock != -1) {
            super.readNext(lock &= this.lockMask, into);
        } else {
            super.readNext(lock &= 0xFFFFFFFF, into);
        }
        if (this.theFile == null) {
            AtEndException.get(this, 6);
            return Return2;
        }
        if (this.currRecord <= 0L || this.atEnd) {
            CobolIOException.get(112, "", this, 6);
            return Return2;
        }
        try {
            byte[] in = this.getBufferRO();
            Return2 = this.myNext(in, this.nextRecNum());
            if (Return2 > 0) {
                if (this.relativeKey != null) {
                    this.relativeKey.set(this.currRecord);
                }
                this.recordLockNum(lock, this.currRecord, this.getBufferLength());
                this.updateBuffer(in);
                if (into != null) {
                    into.setUsingMaxLen(in);
                }
            } else {
                this.positioned = false;
                this.atBegin = false;
                this.atEnd = true;
                AtEndException.get(this, 6);
                return Return2;
            }
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
        }
        catch (IsamException _ex) {
            this.currRecord = 0L;
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
            CobolIOException.get(RelativeFile.cobolErrno(_ex), "", this, 6);
        }
        return Return2;
    }

    @Override
    public int readPrev(boolean lock, ICobolVar into) {
        return this.readPrev(lock ? 1 : 0, into);
    }

    @Override
    public int readPrev(int lock, ICobolVar into) {
        int Return2 = 0;
        if (lock != -1) {
            super.readPrev(lock &= this.lockMask, into);
        } else {
            super.readPrev(lock &= 0xFFFFFFFF, into);
        }
        if (this.theFile == null) {
            AtEndException.get(this, 7);
            return Return2;
        }
        if (this.currRecord <= 0L || this.atBegin) {
            CobolIOException.get(112, "", this, 7);
        }
        try {
            byte[] in = this.getBufferRO();
            Return2 = this.myPrev(in, this.prevRecNum());
            if (Return2 > 0) {
                if (this.relativeKey != null) {
                    this.relativeKey.set(this.currRecord);
                }
                this.recordLockNum(lock, this.currRecord, this.getBufferLength());
                this.updateBuffer(in);
                if (into != null) {
                    into.setUsingMaxLen(in);
                }
            } else {
                this.positioned = false;
                this.atEnd = false;
                this.atBegin = true;
                AtEndException.get(this, 7);
                return Return2;
            }
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
        }
        catch (IsamException _ex) {
            this.currRecord = 0L;
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
            CobolIOException.get(RelativeFile.cobolErrno(_ex), "", this, 2);
        }
        return Return2;
    }

    @Override
    public int readKey(ICobolVar[] key, boolean lock, ICobolVar into) {
        return this.readKey(key, lock ? 1 : 0, into);
    }

    @Override
    public int readKey(ICobolVar[] key, int lock, ICobolVar into) {
        int Return2 = 0;
        if (lock != -1) {
            super.readKey(key, lock &= this.lockMask, into);
        } else {
            super.readKey(key, lock &= 0xFFFFFFFF, into);
        }
        if (this.theFile == null) {
            InvalidKeyException.get(111, "", this, 8);
            return Return2;
        }
        if (this.relativeKey == null) {
            throw new IscobolRuntimeException(4, this.getLogicName());
        }
        try {
            long recNum = this.relativeKey.tolong();
            this.currRecord = 0L;
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
            if (recNum < 1L) {
                InvalidKeyException.get(111, "", this, 8);
                return Return2;
            }
            long pos = (recNum - 1L) * (long)this.getBufferLength();
            this.theFile.seek(pos);
            Return2 = this.theFile.read(this.locBuffer);
            this.recordLockNum(lock, recNum, this.getBufferLength());
            if (Return2 < 0 || Arrays.equals(this.delBuffer, this.locBuffer)) {
                InvalidKeyException.get(111, "", this, 8);
                return Return2;
            }
            this.updateBuffer(this.locBuffer);
            if (into != null) {
                into.setUsingMaxLen(this.locBuffer);
            }
            this.currRecord = recNum;
        }
        catch (IsamException _ex) {
            CobolIOException.get(RelativeFile.cobolErrno(_ex), "", this, 2);
        }
        return Return2;
    }

    @Override
    public void start(ICobolVar[] key, int type, int keyLen) {
        super.start(key, type, keyLen);
        if (this.theFile == null) {
            InvalidKeyException.get(111, "", this, 9);
            return;
        }
        this.currRecord = 0L;
        this.positioned = false;
        this.positioned = false;
        this.atEnd = false;
        this.atBegin = false;
        try {
            long recNum;
            long lastRecord = this.theFile.length() / (long)this.getBufferLength();
            if (type == 0) {
                recNum = 1L;
            } else if (type == 1) {
                recNum = lastRecord;
            } else {
                if (this.relativeKey == null) {
                    throw new IscobolRuntimeException(4, this.getLogicName());
                }
                recNum = this.relativeKey.tolong();
            }
            switch (type) {
                case 5: {
                    if (recNum < 1L || recNum > lastRecord) {
                        InvalidKeyException.get(111, "", this, 9);
                    }
                    long pos = (recNum - 1L) * (long)this.getBufferLength();
                    this.theFile.seek(pos);
                    int rc = this.theFile.read(this.locBuffer);
                    if (rc >= 0 && !Arrays.equals(this.delBuffer, this.locBuffer)) break;
                    InvalidKeyException.get(111, "", this, 9);
                    return;
                }
                case 6: {
                    ++recNum;
                }
                case 7: {
                    if (recNum > lastRecord) {
                        InvalidKeyException.get(111, "", this, 9);
                    } else if (recNum < 1L) {
                        recNum = 1L;
                    }
                    int rc = this.myNext(this.locBuffer, recNum);
                    if (rc > 0) break;
                    InvalidKeyException.get(111, "", this, 9);
                    break;
                }
                case 8: {
                    --recNum;
                }
                case 9: {
                    if (recNum < 1L) {
                        InvalidKeyException.get(111, "", this, 9);
                    } else if (recNum > lastRecord) {
                        recNum = lastRecord;
                    }
                    int rc = this.myPrev(this.locBuffer, recNum);
                    if (rc > 0) break;
                    InvalidKeyException.get(111, "", this, 9);
                }
            }
            if (this.currRecord < 1L) {
                InvalidKeyException.get(111, "", this, 9);
            }
            this.positioned = true;
            if (this.relativeKey != null) {
                this.relativeKey.set(this.currRecord);
            }
        }
        catch (IsamException _ex) {
            CobolIOException.get(RelativeFile.cobolErrno(_ex), "", this, 2);
        }
    }

    @Override
    public void unlock() {
        super.unlock();
        try {
            this.allRecordUnlock();
        }
        catch (IsamException _ex) {
            CobolIOException.get(RelativeFile.cobolErrno(_ex), "", this, 10);
        }
    }
}

