/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.math;

import com.iscobol.math.BigCobolInt;

public class BigCobolDec
extends BigCobolInt {
    private static final long serialVersionUID = 1L;
    public static final int ROUND_DOWN = 0;
    public static final int ROUND_HALF_UP = 1;
    static final double[] dbl10Pow = new double[MAX_PRECISION + 1];
    private int scale;

    public static void main(String[] args) {
    }

    public static final BigCobolDec valueOf(long unscaled) {
        return new BigCobolDec(unscaled);
    }

    public static final BigCobolDec valueOf(long unscaled, int scale) {
        return new BigCobolDec(unscaled, scale);
    }

    public BigCobolDec() {
    }

    public BigCobolDec(byte[] unscaled, boolean signed, int ascale) {
        super(unscaled, 0, unscaled.length, signed);
        this.scale = ascale;
    }

    public BigCobolDec(byte[] unscaled, int start, int length, boolean signed, int ascale) {
        super(unscaled, start, length, signed);
        this.scale = ascale;
    }

    public BigCobolDec(int unscaled) {
        super(unscaled);
    }

    public BigCobolDec(double val) {
        if (val < 0.0) {
            this.negative = true;
            val *= -1.0;
        }
        if (val >= 1.0E36) {
            this.value[3] = 999999999;
            this.value[2] = 999999999;
            this.value[1] = 999999999;
            this.value[0] = 999999999;
            this.uvi = 3;
        } else if (val >= 1.0E-36) {
            int dgt;
            this.uvi = 0;
            while (this.uvi < this.value.length && !(val < 1.0)) {
                if (val >= 1.0E9) {
                    this.value[this.uvi] = (int)(val % 1.0E9);
                    val /= 1.0E9;
                } else {
                    this.value[this.uvi] = (int)val;
                    val -= (double)this.value[this.uvi];
                    break;
                }
                ++this.uvi;
            }
            for (int prec = this.precision(); prec < 36 && val > 0.0; val -= (double)dgt, ++prec) {
                this.shift(1);
                ++this.scale;
                dgt = (int)(val *= 10.0);
                this.value[0] = this.value[0] + dgt;
            }
        }
    }

    public BigCobolDec(long unscaled) {
        super(unscaled);
    }

    public BigCobolDec(long unscaled, int ascale) {
        super(unscaled);
        this.scale = ascale;
    }

    public BigCobolDec(String val) {
        int point = val.indexOf(46);
        if (point < 0) {
            BigCobolDec.parseInt(this, val);
        } else {
            String decPart = val.substring(point + 1, val.length());
            this.scale = decPart.length();
            BigCobolDec.parseInt(this, val.substring(0, point) + decPart);
        }
    }

    public BigCobolDec(BigCobolInt val, int val_scale) {
        super(val);
        this.scale = val_scale;
    }

    public BigCobolDec(BigCobolDec val) {
        super(val);
        this.scale = val.scale;
    }

    public int scale() {
        return this.scale;
    }

    public BigCobolDec setScale(int nScale) {
        return this.setScale(nScale, 0);
    }

    public BigCobolDec setScale(int nScale, int rounding) {
        BigCobolDec Return2 = new BigCobolDec(this);
        Return2.setMyScale(nScale, rounding);
        return Return2;
    }

    public void roundUpIfNeeded(int scaleDiff) {
        if (this.getDecDigit(scaleDiff - 1) >= 5) {
            boolean negtv = this.isNegative();
            this.shift(-scaleDiff);
            BigCobolDec.oneDigitAdd(this.value, this.uvi, 1, this.value);
            this.shift(scaleDiff);
            if (negtv != this.isNegative()) {
                this.negateMe();
            }
        }
    }

    public void setMyScale(int nScale, int rounding) {
        if (this.scale != nScale) {
            if (rounding == 0) {
                this.shift(nScale - this.scale);
            } else if (nScale < this.scale && this.getDecDigit(this.scale - nScale - 1) >= 5) {
                this.shift(nScale - this.scale);
                this.uvi = BigCobolDec.oneDigitAdd(this.value, this.uvi, 1, this.value);
            } else {
                this.shift(nScale - this.scale);
            }
            this.scale = nScale;
        }
    }

    @Override
    public int toByteArray(byte[] str, byte[] encoded_digits) {
        int Return2 = super.toByteArray(str, encoded_digits);
        if (this.scale == 0) {
            return Return2;
        }
        int strt = str[0] == encoded_digits[10] ? 1 : 0;
        int end = Return2 - strt - this.scale;
        if (end > 0) {
            end += strt;
            for (int i = Return2 - 1; i >= end; --i) {
                str[i + 1] = str[i];
            }
            str[i + 1] = encoded_digits[11];
            ++Return2;
        } else {
            int i = Return2 + 1 - end;
            for (int j = Return2; j >= strt; --j) {
                str[i] = str[j];
                --i;
            }
            while (i > strt) {
                str[i--] = encoded_digits[0];
            }
            str[strt] = encoded_digits[11];
            Return2 = this.scale + strt + 2;
        }
        return Return2;
    }

    @Override
    public String toString() {
        if (this.scale > 0) {
            int len;
            String d = super.toString();
            if (this.isNegative()) {
                d = d.substring(1);
            }
            if ((len = d.length()) > this.scale) {
                if (this.isNegative()) {
                    return "-" + d.substring(0, len - this.scale) + '.' + d.substring(len - this.scale, len);
                }
                return d.substring(0, len - this.scale) + '.' + d.substring(len - this.scale, len);
            }
            if (len == this.scale) {
                if (this.isNegative()) {
                    return "-0." + d;
                }
                return "0." + d;
            }
            StringBuffer fill = new StringBuffer(this.scale + 1);
            if (this.isNegative()) {
                fill.append("-0.");
            } else {
                fill.append("0.");
            }
            for (int i = this.scale - len; i > 0; --i) {
                fill.append("0");
            }
            fill.append(d);
            return fill.toString();
        }
        return super.toString();
    }

    private final BigCobolDec intAddSub(BigCobolDec n, boolean n_negative) {
        BigCobolDec Return2;
        int diff;
        int mp;
        if (this.scale > 0 && (mp = this.precision() - MAX_PRECISION + 1) > 0) {
            this.shift(-mp);
            this.scale -= mp;
        }
        if (n.scale > 0 && (mp = n.precision() - MAX_PRECISION + 1) > 0) {
            n.shift(-mp);
            n.scale -= mp;
        }
        if ((diff = this.scale - n.scale) == 0) {
            Return2 = new BigCobolDec(this);
            Return2.scale = this.scale;
            Return2.addSub(n, n_negative);
            Return2.normalize();
        } else {
            boolean smallerScale_negative;
            BigCobolDec smallerScale;
            boolean largerScale_negative;
            BigCobolDec largerScale;
            if (diff > 0) {
                largerScale = this;
                largerScale_negative = this.negative;
                smallerScale = n;
                smallerScale_negative = n_negative;
            } else {
                largerScale = n;
                largerScale_negative = n_negative;
                smallerScale = this;
                smallerScale_negative = this.negative;
                diff *= -1;
            }
            int excDigits = diff + smallerScale.precision() - MAX_PRECISION + 1;
            if (excDigits > 0) {
                if (diff <= excDigits) {
                    Return2 = new BigCobolDec(largerScale);
                    Return2.negative = largerScale_negative;
                    Return2.shift(-diff);
                    Return2.scale = largerScale.scale - diff;
                    Return2.addSub(smallerScale, smallerScale_negative);
                    Return2.normalize();
                } else {
                    Return2 = new BigCobolDec(largerScale);
                    Return2.negative = largerScale_negative;
                    smallerScale = new BigCobolDec(smallerScale);
                    smallerScale.negative = smallerScale_negative;
                    Return2.shift(-excDigits);
                    smallerScale.shift(diff - excDigits);
                    Return2.scale = largerScale.scale - excDigits;
                    Return2.addSub(smallerScale, smallerScale_negative);
                    Return2.normalize();
                }
            } else {
                Return2 = new BigCobolDec(smallerScale);
                Return2.negative = smallerScale_negative;
                Return2.shift(diff);
                Return2.scale = largerScale.scale;
                Return2.addSub(largerScale, largerScale_negative);
                Return2.normalize();
            }
        }
        return Return2;
    }

    @Override
    public int compareTo(BigCobolInt n) {
        if (this.scale == 0) {
            return super.compareTo(n);
        }
        return this.compareTo(new BigCobolDec(n, 0));
    }

    public int compareTo(BigCobolDec n) {
        if (this.scale == n.scale) {
            return super.compareTo(n);
        }
        BigCobolDec cf = this.subtract(n);
        if (cf.negative) {
            return -1;
        }
        if (cf.isZero()) {
            return 0;
        }
        return 1;
    }

    public BigCobolDec add(BigCobolDec n) {
        return this.intAddSub(n, n.negative);
    }

    public BigCobolDec subtract(BigCobolDec n) {
        return this.intAddSub(n, !n.negative);
    }

    public BigCobolDec multiply(BigCobolDec n) {
        BigCobolDec Return2 = new BigCobolDec();
        if (!this.isZero() && !n.isZero()) {
            int excDigits = this.precision() + n.precision() - MAX_PRECISION;
            if (excDigits <= 0) {
                Return2.uvi = BigCobolDec.absMul(this.value, this.uvi, n.value, n.uvi, Return2.value);
                Return2.negative = this.negative != n.negative;
                Return2.scale = this.scale + n.scale;
            } else {
                int[] t_value = new int[this.value.length + n.value.length];
                int t_uvi = BigCobolDec.absMul(this.value, this.uvi, n.value, n.uvi, t_value);
                int shift = Math.min(this.scale + n.scale, excDigits);
                BigCobolDec.shift(t_value, t_uvi, -shift);
                for (int i = Return2.value.length - 1; i >= 0; --i) {
                    Return2.value[i] = t_value[i];
                }
                Return2.uvi = Return2.value.length - 1;
                Return2.negative = this.negative != n.negative;
                Return2.scale = this.scale + n.scale - shift;
            }
        }
        return Return2;
    }

    public BigCobolDec divide(BigCobolDec n, int rounding) {
        return this.divide(n, this.scale, rounding);
    }

    public BigCobolDec divide(BigCobolDec n, int rscale, int rounding) {
        int qlen;
        if (n.isZero()) {
            throw new ArithmeticException("BigCobolDec divide by zero");
        }
        BigCobolDec Return2 = new BigCobolDec();
        if (this.isZero()) {
            return Return2;
        }
        int[] avalue = new int[this.value.length << 1];
        int[] q = new int[this.value.length + 1];
        int auvi = this.uvi;
        int ascale = this.scale;
        int precDiff = this.minDigits() - n.minDigits();
        for (int i = this.uvi; i >= 0; --i) {
            avalue[i] = this.value[i];
        }
        if (precDiff <= 0) {
            ascale -= precDiff;
            ++ascale;
            auvi = BigCobolDec.shift(avalue, auvi, -precDiff + 1);
        }
        BigCobolInt rmndr = null;
        int diff = ascale - n.scale;
        int sc = rscale - diff;
        if (sc > 0) {
            int mx = precDiff > 0 ? MAX_PRECISION - precDiff - sc - 1 : MAX_PRECISION - sc - 2;
            if (mx < 0) {
                sc += mx;
                rscale += mx;
            }
            auvi = BigCobolDec.shift(avalue, auvi, sc);
        }
        if (rounding != 0 && sc >= 0) {
            rmndr = new BigCobolInt();
            qlen = BigCobolDec.absDiv(avalue, auvi, n.value, n.uvi, q, rmndr.value);
            Return2.uvi = qlen & 0xFF;
            rmndr.uvi = (qlen & 0xFF00) >> 8;
            rmndr.negative = this.negative;
            rmndr.uvi = BigCobolDec.oneDigitMultiply(rmndr.value, rmndr.uvi, 2L, rmndr.value);
        } else {
            qlen = BigCobolDec.absDiv(avalue, auvi, n.value, n.uvi, q, null);
            Return2.uvi = qlen & 0xFF;
        }
        boolean bl = Return2.negative = this.negative != n.negative;
        if (sc < 0) {
            if (rounding != 0) {
                byte ch = BigCobolDec.getDecDigit(q, Return2.uvi, -sc - 1);
                Return2.uvi = BigCobolDec.shift(q, Return2.uvi, sc);
                if (ch >= 5) {
                    Return2.uvi = BigCobolDec.oneDigitAdd(q, Return2.uvi, 1, q);
                }
            } else {
                Return2.uvi = BigCobolDec.shift(q, Return2.uvi, sc);
            }
        } else if (rounding != 0 && BigCobolDec.absCompareTo(n.value, n.uvi, rmndr.value, rmndr.uvi) <= 0) {
            Return2.uvi = BigCobolDec.oneDigitAdd(q, Return2.uvi, 1, q);
        }
        for (int i = Return2.uvi; i >= 0; --i) {
            Return2.value[i] = q[i];
        }
        Return2.scale = rscale;
        return Return2;
    }

    public void narrowMe(int aprecision, int ascale) {
        this.narrowMe(aprecision, ascale, 0);
    }

    public void narrowMe(int aprecision, int ascale, int rounding) {
        if (ascale != this.scale) {
            this.setScale(ascale, rounding);
        }
        this.narrowMe(aprecision);
    }

    @Override
    public double doubleValue() {
        this.normalizeScale();
        return super.doubleValue() / dbl10Pow[this.scale];
    }

    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public long longValue() {
        if (this.scale == 0) {
            return super.longValue();
        }
        long Return2 = 0L;
        for (int i = this.precision() - 1; i >= this.scale; --i) {
            Return2 *= 10L;
            Return2 += (long)this.getDecDigit(i);
        }
        if (this.negative) {
            return -Return2;
        }
        return Return2;
    }

    public boolean hasFractionalPart() {
        if (this.scale != 0) {
            for (int i = this.scale - 1; i >= 0; --i) {
                if (this.getDecDigit(i) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public int intValue() {
        return (int)this.longValue();
    }

    public int shortValue() {
        return (short)this.longValue();
    }

    public BigCobolDec negate() {
        BigCobolDec Return2 = new BigCobolDec(this);
        Return2.negateMe();
        return Return2;
    }

    public long unscaled18Digits(int ascale) {
        long Return2;
        if (ascale == this.scale) {
            Return2 = this.value[1];
            Return2 *= 1000000000L;
            Return2 += (long)this.value[0];
        } else {
            int[] v = new int[this.value.length];
            for (int i = this.value.length - 1; i >= 0; --i) {
                v[i] = this.value[i];
            }
            BigCobolDec.shift(v, this.uvi, ascale - this.scale);
            Return2 = v[1];
            Return2 *= 1000000000L;
            Return2 += (long)v[0];
        }
        if (this.negative) {
            return -Return2;
        }
        return Return2;
    }

    private int minDigits() {
        return super.precision();
    }

    @Override
    public int precision() {
        int p = super.precision();
        return this.scale > p ? this.scale : p;
    }

    public int normalizeScale() {
        int Return2;
        if (this.scale == 0 || this.isZero()) {
            Return2 = this.scale;
            this.scale = 0;
        } else {
            int auvi;
            for (auvi = 0; auvi <= this.uvi && this.value[auvi] == 0; ++auvi) {
            }
            int sp = auvi * MAXDECDIGITS;
            if (sp >= this.scale) {
                this.shift(-this.scale);
                Return2 = this.scale;
                this.scale = 0;
            } else {
                int i;
                int end = this.scale - sp;
                if (end > MAXDECDIGITS) {
                    end = MAXDECDIGITS;
                }
                for (i = 1; i <= end && this.value[auvi] % TENPOW[i] == 0; ++i) {
                }
                --i;
                if ((i += sp) > 0) {
                    this.shift(-i);
                    Return2 = i;
                    this.scale -= i;
                } else {
                    Return2 = 0;
                }
            }
        }
        return Return2;
    }

    static {
        BigCobolDec.dbl10Pow[0] = 1.0;
        for (int i = 1; i <= MAX_PRECISION; ++i) {
            BigCobolDec.dbl10Pow[i] = Math.pow(10.0, i);
        }
    }
}

