/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.misc.javabeans;

import com.iscobol.misc.javabeans.LineNumberRuler;
import com.iscobol.misc.javabeans.StatusLine;
import com.iscobol.misc.javabeans.StyledTextPane;
import com.iscobol.rts.Factory;
import com.iscobol.rts.FindDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class CobolSourceViewer
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int UNKNOWN_FORMAT = 0;
    public static final int ANSI_FIXED = 1;
    public static final int TERMINAL_FIXED = 2;
    public static final int ANSI_FREE = 3;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int UNDERLINE = 4;
    public static final String SOURCE_STYLE_NAME = "source";
    public static final String KEYWORD_STYLE_NAME = "keyword";
    public static final String STATEMENT_STYLE_NAME = "statement";
    public static final String STRING_STYLE_NAME = "string";
    public static final String NUMBER_STYLE_NAME = "number";
    public static final String COMMENT_STYLE_NAME = "comment";
    public static final String LEVEL_NUMBER_STYLE_NAME = "levelNumber";
    public static final String FIGURATIVE_CONSTANT_NAME = "figurativeConstant";
    private int sourceFormat = 0;
    private String sourceFontName = "Monospaced";
    private int sourceFontSize = 10;
    private int sourceBackground = -1;
    private int sourceForeground = -16777216;
    private boolean sourceFormatMixed;
    private int keywordForeground = -16776961;
    private int statementForeground = -65383;
    private int stringForeground = -16744448;
    private int numberForeground = -3407872;
    private int commentForeground = -8355840;
    private int levelNumberForeground = -3407668;
    private int figurativeConstantForeground = -3381760;
    private int keywordStyle;
    private int statementStyle;
    private int stringStyle;
    private int numberStyle;
    private int commentStyle;
    private int levelNumberStyle;
    private int figurativeConstantStyle;
    private int areaDividerColor = -5196615;
    private boolean showLineNumbers = true;
    private boolean showAreaDividers;
    private boolean showAreaBackground;
    private boolean showStatusLine = true;
    private String notReservedWords = "";
    private int ansiSequenceNumberBackground = -43;
    private int ansiIndicatorAreaBackground = -1;
    private int ansiAreaABackground = -4139562;
    private int ansiAreaBBackground = -2957357;
    private int ansiIdentificationAreaBackground = -1052689;
    private int terminalIndicatorAreaBackground = -1;
    private int terminalAreaABackground = -4139562;
    private int terminalAreaBBackground = -2957357;
    private final Hashtable nrw = new Hashtable();
    private Style source;
    private Style keyword;
    private Style statement;
    private Style string;
    private Style number;
    private Style comment;
    private Style levelNumber;
    private Style figConst;
    private Style def;
    private StyledTextPane textPane;
    private JScrollPane scrollPane;
    private StatusLine statusLine;
    private LineNumberRuler verticalRuler;
    private FindDialog findDialog;
    private JPopupMenu defaultPopup;
    private Vector keyListeners = new Vector();

    public CobolSourceViewer(InputStream is) throws IOException {
        this();
        this.setContents(is);
    }

    public CobolSourceViewer() {
        this.setLayout(new BorderLayout());
        this.textPane = this.createStyledTextPane(this);
        this.textPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    CobolSourceViewer.this.getDefaultPopup().show((Component)e.getSource(), e.getX(), e.getY());
                }
            }
        });
        this.textPane.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 70 && e.isControlDown()) {
                    CobolSourceViewer.this.find();
                } else {
                    Enumeration en = CobolSourceViewer.this.keyListeners.elements();
                    while (en.hasMoreElements()) {
                        ((KeyListener)en.nextElement()).keyPressed(e);
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() != 70 || !e.isControlDown()) {
                    Enumeration en = CobolSourceViewer.this.keyListeners.elements();
                    while (en.hasMoreElements()) {
                        ((KeyListener)en.nextElement()).keyReleased(e);
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() != 70 || !e.isControlDown()) {
                    Enumeration en = CobolSourceViewer.this.keyListeners.elements();
                    while (en.hasMoreElements()) {
                        ((KeyListener)en.nextElement()).keyTyped(e);
                    }
                }
            }
        });
        this.addStylesToDocument(this.textPane.getStyledDocument());
        Font f = this.getFont(this.source);
        this.textPane.setFont(f);
        this.scrollPane = new JScrollPane(this.textPane);
        this.statusLine = this.createStatusLine();
        this.statusLine.setFont(f);
        this.verticalRuler = this.createVerticalRuler(this.textPane);
        this.verticalRuler.setFont(f);
        this.verticalRuler.setBackground(this.textPane.getBackground());
        this.verticalRuler.setForeground(this.textPane.getForeground());
        this.scrollPane.setRowHeaderView(this.verticalRuler);
        this.statusLine.setRowCol(1, 1);
        this.statusLine.setPercentage(0);
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.statusLine, "South");
        this.textPane.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                if (CobolSourceViewer.this.textPane.isDisplayable() && !CobolSourceViewer.this.textPane.getCaret().isVisible()) {
                    CobolSourceViewer.this.textPane.getCaret().setVisible(true);
                }
                int dot = e.getDot();
                int[] lineCol = CobolSourceViewer.this.computeLineCol(dot);
                CobolSourceViewer.this.statusLine.setRowCol(lineCol[0], lineCol[1]);
                double docLen = CobolSourceViewer.this.textPane.getStyledDocument().getLength();
                CobolSourceViewer.this.statusLine.setPercentage((int)((double)(dot * 100) / docLen));
            }
        });
    }

    private JPopupMenu getDefaultPopup() {
        if (this.defaultPopup == null) {
            this.defaultPopup = this.createDefaultPopup();
        }
        return this.defaultPopup;
    }

    private JPopupMenu createDefaultPopup() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem copy = new JMenuItem(Factory.getSysMsg("copy"));
        copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CobolSourceViewer.this.copy();
            }
        });
        popup.add(copy);
        JMenuItem selectall = new JMenuItem(Factory.getSysMsg("selectall"));
        selectall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CobolSourceViewer.this.selectAll();
            }
        });
        popup.add(selectall);
        return popup;
    }

    protected StyledTextPane createStyledTextPane(CobolSourceViewer viewer) {
        return new StyledTextPane(viewer);
    }

    protected StatusLine createStatusLine() {
        return new StatusLine();
    }

    protected LineNumberRuler createVerticalRuler(StyledTextPane textPane) {
        return new LineNumberRuler(textPane);
    }

    private Font getFont(Style style) {
        return new Font(StyleConstants.getFontFamily(style), 0, StyleConstants.getFontSize(style));
    }

    protected int computeFontSize(int origSize) {
        return (int)Math.round((double)(origSize * Toolkit.getDefaultToolkit().getScreenResolution()) / 72.0);
    }

    protected void addStylesToDocument(StyledDocument doc) {
        this.def = StyleContext.getDefaultStyleContext().getStyle("default");
        this.source = doc.addStyle(SOURCE_STYLE_NAME, this.def);
        StyleConstants.setFontFamily(this.def, this.sourceFontName);
        StyleConstants.setFontSize(this.def, this.computeFontSize(this.sourceFontSize));
        this.keyword = doc.addStyle(KEYWORD_STYLE_NAME, this.source);
        this.setStyleForeground(this.keyword, this.keywordForeground);
        this.statement = doc.addStyle(STATEMENT_STYLE_NAME, this.source);
        this.setStyleForeground(this.statement, this.statementForeground);
        this.string = doc.addStyle(STRING_STYLE_NAME, this.source);
        this.setStyleForeground(this.string, this.stringForeground);
        this.number = doc.addStyle(NUMBER_STYLE_NAME, this.source);
        this.setStyleForeground(this.number, this.numberForeground);
        this.comment = doc.addStyle(COMMENT_STYLE_NAME, this.source);
        this.setStyleForeground(this.comment, this.commentForeground);
        this.levelNumber = doc.addStyle(LEVEL_NUMBER_STYLE_NAME, this.source);
        this.setStyleForeground(this.levelNumber, this.levelNumberForeground);
        this.figConst = doc.addStyle(FIGURATIVE_CONSTANT_NAME, this.source);
        this.setStyleForeground(this.figConst, this.figurativeConstantForeground);
    }

    public int getSourceFormat() {
        return this.sourceFormat;
    }

    public void setSourceFormat(int format) {
        this.setSourceFormat(format, true);
    }

    public void setSourceFormat(int format, boolean refresh) {
        if (this.sourceFormat != format) {
            this.sourceFormat = format;
            if (refresh) {
                this.textPane.repaint();
            }
        }
    }

    public int getSourceBackground() {
        return this.sourceBackground;
    }

    public void setSourceBackground(int sourceBackground) {
        this.sourceBackground = sourceBackground;
        Color c = new Color(this.sourceBackground);
        this.textPane.setBackground(c);
        this.verticalRuler.setBackground(c);
    }

    public int getSourceForeground() {
        return this.sourceForeground;
    }

    public void setSourceForeground(int sourceForeground) {
        this.sourceForeground = sourceForeground;
        Color c = new Color(this.sourceForeground);
        this.textPane.setForeground(c);
        this.verticalRuler.setForeground(c);
    }

    public boolean isSourceFormatMixed() {
        return this.sourceFormatMixed;
    }

    public void setSourceFormatMixed(boolean mixedFormat) {
        if (this.sourceFormatMixed != mixedFormat) {
            this.sourceFormatMixed = mixedFormat;
            this.textPane.repaint();
        }
    }

    public String getSourceFontName() {
        return this.sourceFontName;
    }

    public void setSourceFontName(String sourceFontName) {
        this.sourceFontName = sourceFontName;
        StyleConstants.setFontFamily(this.def, sourceFontName);
        this.updateFont();
    }

    public int getSourceFontSize() {
        return this.sourceFontSize;
    }

    public void setSourceFontSize(int sourceFontSize) {
        if (sourceFontSize != this.sourceFontSize && sourceFontSize > 0) {
            this.sourceFontSize = sourceFontSize;
            StyleConstants.setFontSize(this.def, this.computeFontSize(this.sourceFontSize));
            this.updateFont();
        }
    }

    private void updateFont() {
        Font f = this.getFont(this.source);
        this.textPane.setFont(f);
        this.verticalRuler.setFont(f);
        this.statusLine.setFont(f);
        this.doLayout();
    }

    private void setStyleForeground(Style attrStyle, int rgb) {
        StyleConstants.setForeground(attrStyle, new Color(rgb));
    }

    public int getKeywordForeground() {
        return this.keywordForeground;
    }

    public void setKeywordForeground(int keywordForeground) {
        if (this.keywordForeground != keywordForeground) {
            this.keywordForeground = keywordForeground;
            this.setStyleForeground(this.keyword, this.keywordForeground);
            this.textPane.repaint();
        }
    }

    public int getStatementForeground() {
        return this.statementForeground;
    }

    public void setStatementForeground(int statementForeground) {
        if (this.statementForeground != statementForeground) {
            this.statementForeground = statementForeground;
            this.setStyleForeground(this.statement, this.statementForeground);
            this.textPane.repaint();
        }
    }

    public int getStringForeground() {
        return this.stringForeground;
    }

    public void setStringForeground(int stringForeground) {
        if (this.stringForeground != stringForeground) {
            this.stringForeground = stringForeground;
            this.setStyleForeground(this.string, this.stringForeground);
            this.textPane.repaint();
        }
    }

    public int getNumberForeground() {
        return this.numberForeground;
    }

    public void setNumberForeground(int numberForeground) {
        if (this.numberForeground != numberForeground) {
            this.numberForeground = numberForeground;
            this.setStyleForeground(this.number, this.numberForeground);
            this.textPane.repaint();
        }
    }

    public int getCommentForeground() {
        return this.commentForeground;
    }

    public void setCommentForeground(int commentForeground) {
        if (this.commentForeground != commentForeground) {
            this.commentForeground = commentForeground;
            this.setStyleForeground(this.comment, this.commentForeground);
            this.textPane.repaint();
        }
    }

    public int getLevelNumberForeground() {
        return this.levelNumberForeground;
    }

    public void setLevelNumberForeground(int levelNumberForeground) {
        if (this.levelNumberForeground != levelNumberForeground) {
            this.levelNumberForeground = levelNumberForeground;
            this.setStyleForeground(this.levelNumber, this.levelNumberForeground);
            this.textPane.repaint();
        }
    }

    public int getFigurativeConstantForeground() {
        return this.figurativeConstantForeground;
    }

    public void setFigurativeConstantForeground(int figurativeConstantForeground) {
        if (this.figurativeConstantForeground != figurativeConstantForeground) {
            this.figurativeConstantForeground = figurativeConstantForeground;
            this.setStyleForeground(this.figConst, this.figurativeConstantForeground);
            this.textPane.repaint();
        }
    }

    public boolean isShowLineNumbers() {
        return this.showLineNumbers;
    }

    public void setShowLineNumbers(boolean showLineNumbers) {
        if (this.showLineNumbers != showLineNumbers) {
            this.showLineNumbers = showLineNumbers;
            if (this.showLineNumbers) {
                this.scrollPane.setRowHeaderView(this.verticalRuler);
            } else {
                this.scrollPane.setRowHeaderView(null);
            }
            this.scrollPane.doLayout();
        }
    }

    public boolean isShowAreaDividers() {
        return this.showAreaDividers;
    }

    public void setShowAreaDividers(boolean showAreaDivider) {
        if (this.showAreaDividers != showAreaDivider) {
            this.showAreaDividers = showAreaDivider;
            if (this.getSourceFormat() == 1 || this.getSourceFormat() == 2) {
                this.textPane.repaint();
            }
        }
    }

    public boolean isShowAreaBackground() {
        return this.showAreaBackground;
    }

    public void setShowAreaBackground(boolean showAreaBackground) {
        if (this.showAreaBackground != showAreaBackground) {
            this.showAreaBackground = showAreaBackground;
            this.textPane.repaint();
        }
    }

    public boolean isShowStatusLine() {
        return this.showStatusLine;
    }

    public void setShowStatusLine(boolean showStatusLine) {
        if (this.showStatusLine != showStatusLine) {
            this.showStatusLine = showStatusLine;
            if (this.showStatusLine) {
                this.add((Component)this.statusLine, "South");
            } else {
                this.remove(this.statusLine);
            }
            this.doLayout();
        }
    }

    public String getNotReservedWords() {
        return this.notReservedWords;
    }

    public void setNotReservedWords(String notReserverdWords) {
        this.notReservedWords = notReserverdWords;
        if (this.notReservedWords == null) {
            this.notReservedWords = "";
        }
        this.nrw.clear();
        if (this.notReservedWords.length() > 0) {
            String[] tokens = this.notReservedWords.toUpperCase().split("\\,");
            for (int i = 0; i < tokens.length; ++i) {
                this.nrw.put(tokens[i], tokens[i]);
            }
        }
        this.textPane.repaint();
    }

    public Hashtable getNotReservedWordsTable() {
        return this.nrw;
    }

    public StyledTextPane getStyledTextPane() {
        return this.textPane;
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    public LineNumberRuler getVerticalRuler() {
        return this.verticalRuler;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public int getAnsiSequenceNumberBackground() {
        return this.ansiSequenceNumberBackground;
    }

    public void setAnsiSequenceNumberBackground(int ansiSequenceNumberBackground) {
        if (this.ansiSequenceNumberBackground != ansiSequenceNumberBackground) {
            this.ansiSequenceNumberBackground = ansiSequenceNumberBackground;
            if (this.isShowAreaBackground() && this.getSourceFormat() == 1) {
                this.textPane.repaint();
            }
        }
    }

    public int getAnsiIndicatorAreaBackground() {
        return this.ansiIndicatorAreaBackground;
    }

    public void setAnsiIndicatorAreaBackground(int ansiIndicatorAreaBackground) {
        if (this.ansiIndicatorAreaBackground != ansiIndicatorAreaBackground) {
            this.ansiIndicatorAreaBackground = ansiIndicatorAreaBackground;
            if (this.isShowAreaBackground() && this.getSourceFormat() == 1) {
                this.textPane.repaint();
            }
        }
    }

    public int getAnsiAreaABackground() {
        return this.ansiAreaABackground;
    }

    public void setAnsiAreaABackground(int ansiAreaABackground) {
        if (this.ansiAreaABackground != ansiAreaABackground) {
            this.ansiAreaABackground = ansiAreaABackground;
            if (this.isShowAreaBackground() && this.getSourceFormat() == 1) {
                this.textPane.repaint();
            }
        }
    }

    public int getAnsiAreaBBackground() {
        return this.ansiAreaBBackground;
    }

    public void setAnsiAreaBBackground(int ansiAreaBBackground) {
        if (this.ansiAreaBBackground != ansiAreaBBackground) {
            this.ansiAreaBBackground = ansiAreaBBackground;
            if (this.isShowAreaBackground() && this.getSourceFormat() == 1) {
                this.textPane.repaint();
            }
        }
    }

    public int getAnsiIdentificationAreaBackground() {
        return this.ansiIdentificationAreaBackground;
    }

    public void setAnsiIdentificationAreaBackground(int ansiIdentificationAreaBackground) {
        if (this.ansiIdentificationAreaBackground != ansiIdentificationAreaBackground) {
            this.ansiIdentificationAreaBackground = ansiIdentificationAreaBackground;
            if (this.isShowAreaBackground() && this.getSourceFormat() == 1) {
                this.textPane.repaint();
            }
        }
    }

    public int getTerminalIndicatorAreaBackground() {
        return this.terminalIndicatorAreaBackground;
    }

    public void setTerminalIndicatorAreaBackground(int terminalIndicatorAreaBackground) {
        if (this.terminalIndicatorAreaBackground != terminalIndicatorAreaBackground) {
            this.terminalIndicatorAreaBackground = terminalIndicatorAreaBackground;
            if (this.isShowAreaBackground() && this.getSourceFormat() == 2) {
                this.textPane.repaint();
            }
        }
    }

    public int getTerminalAreaABackground() {
        return this.terminalAreaABackground;
    }

    public void setTerminalAreaABackground(int terminalAreaABackground) {
        if (this.terminalAreaABackground != terminalAreaABackground) {
            this.terminalAreaABackground = terminalAreaABackground;
            if (this.isShowAreaBackground() && this.getSourceFormat() == 2) {
                this.textPane.repaint();
            }
        }
    }

    public int getTerminalAreaBBackground() {
        return this.terminalAreaBBackground;
    }

    public void setTerminalAreaBBackground(int terminalAreaBBackground) {
        if (this.terminalAreaBBackground != terminalAreaBBackground) {
            this.terminalAreaBBackground = terminalAreaBBackground;
            if (this.isShowAreaBackground() && this.getSourceFormat() == 2) {
                this.textPane.repaint();
            }
        }
    }

    private void setStyleEffects(Style attrStyle, int style) {
        StyleConstants.setBold(attrStyle, (style & 1) == 1);
        StyleConstants.setItalic(attrStyle, (style & 2) == 2);
        StyleConstants.setUnderline(attrStyle, (style & 4) == 4);
    }

    public int getKeywordStyle() {
        return this.keywordStyle;
    }

    public void setKeywordStyle(int keywordStyle) {
        if (this.keywordStyle != keywordStyle) {
            this.keywordStyle = keywordStyle;
            this.setStyleEffects(this.keyword, this.keywordStyle);
            this.textPane.repaint();
        }
    }

    public int getStatementStyle() {
        return this.statementStyle;
    }

    public void setStatementStyle(int statementStyle) {
        if (this.statementStyle != statementStyle) {
            this.statementStyle = statementStyle;
            this.setStyleEffects(this.statement, this.statementStyle);
            this.textPane.repaint();
        }
    }

    public int getStringStyle() {
        return this.stringStyle;
    }

    public void setStringStyle(int stringStyle) {
        if (this.stringStyle != stringStyle) {
            this.stringStyle = stringStyle;
            this.setStyleEffects(this.string, this.stringStyle);
            this.textPane.repaint();
        }
    }

    public int getNumberStyle() {
        return this.numberStyle;
    }

    public void setNumberStyle(int numberStyle) {
        if (this.numberStyle != numberStyle) {
            this.numberStyle = numberStyle;
            this.setStyleEffects(this.number, this.numberStyle);
            this.textPane.repaint();
        }
    }

    public int getCommentStyle() {
        return this.commentStyle;
    }

    public void setCommentStyle(int commentStyle) {
        if (this.commentStyle != commentStyle) {
            this.commentStyle = commentStyle;
            this.setStyleEffects(this.comment, this.commentStyle);
            this.textPane.repaint();
        }
    }

    public int getLevelNumberStyle() {
        return this.levelNumberStyle;
    }

    public void setLevelNumberStyle(int levelNumberStyle) {
        if (this.levelNumberStyle != levelNumberStyle) {
            this.levelNumberStyle = levelNumberStyle;
            this.setStyleEffects(this.levelNumber, this.levelNumberStyle);
            this.textPane.repaint();
        }
    }

    public int getFigurativeConstantStyle() {
        return this.figurativeConstantStyle;
    }

    public void setFigurativeConstantStyle(int figurativeConstantStyle) {
        if (this.figurativeConstantStyle != figurativeConstantStyle) {
            this.figurativeConstantStyle = figurativeConstantStyle;
            this.setStyleEffects(this.figConst, this.figurativeConstantStyle);
            this.textPane.repaint();
        }
    }

    public int getAreaDividerColor() {
        return this.areaDividerColor;
    }

    public void setAreaDividerColor(int areaDividerColor) {
        if (this.areaDividerColor != areaDividerColor) {
            this.areaDividerColor = areaDividerColor;
            this.textPane.repaint();
        }
    }

    @Override
    public void addMouseListener(MouseListener l) {
        this.textPane.addMouseListener(l);
    }

    @Override
    public void removeMouseListener(MouseListener l) {
        this.textPane.removeMouseListener(l);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener l) {
        this.textPane.addMouseMotionListener(l);
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener l) {
        this.textPane.removeMouseMotionListener(l);
    }

    @Override
    public void addMouseWheelListener(MouseWheelListener l) {
        this.textPane.addMouseWheelListener(l);
    }

    @Override
    public void removeMouseWheelListener(MouseWheelListener l) {
        this.textPane.removeMouseWheelListener(l);
    }

    @Override
    public void addKeyListener(KeyListener l) {
        this.keyListeners.addElement(l);
    }

    @Override
    public void removeKeyListener(KeyListener l) {
        this.keyListeners.removeElement(l);
    }

    @Override
    public void addFocusListener(FocusListener l) {
        this.textPane.addFocusListener(l);
    }

    @Override
    public void removeFocusListener(FocusListener l) {
        this.textPane.removeFocusListener(l);
    }

    @Override
    public void requestFocus() {
        this.textPane.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.textPane.requestFocusInWindow();
    }

    public void setContents(String filename) throws IOException {
        FileInputStream is = new FileInputStream(filename);
        this.setContents(is);
        ((InputStream)is).close();
    }

    public void setContents(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        this.setContents(is);
        ((InputStream)is).close();
    }

    public void setContents(InputStream is) throws IOException {
        this.setContents(new InputStreamReader(is));
    }

    public void setStringContents(String text) throws IOException {
        StringReader reader = new StringReader(text);
        this.setContents(reader);
        reader.close();
    }

    public void setContents(Reader reader) throws IOException {
        this.textPane.setContents(reader);
        this.verticalRuler.setLength(Integer.toString(this.textPane.getLineCount()).length());
    }

    public int getLineCount() {
        return this.textPane.getLineCount();
    }

    private int[] computeLineCol(int pos) {
        int x = 0;
        int y = 0;
        try {
            Rectangle caretCoords = this.textPane.modelToView(pos);
            x = caretCoords.x;
            y = caretCoords.y;
        }
        catch (Exception ex) {
            return new int[]{1, 1};
        }
        Font f = this.getFont(this.source);
        FontMetrics fm = this.textPane.getFontMetrics(f);
        int lineHeight = fm.getHeight();
        int lineWidth = fm.charWidth('X');
        return new int[]{y / lineHeight + 1, x / lineWidth + 1};
    }

    public void loadProperties(Properties in) {
        try {
            PropertyDescriptor[] pds = Introspector.getBeanInfo(this.getClass()).getPropertyDescriptors();
            for (int i = 0; i < pds.length; ++i) {
                Object value = null;
                String valueStr = in.getProperty(pds[i].getName());
                if (valueStr != null) {
                    if (pds[i].getPropertyType() == Boolean.TYPE) {
                        value = Boolean.valueOf(valueStr);
                    } else if (pds[i].getPropertyType() == Integer.TYPE) {
                        try {
                            value = Integer.valueOf(valueStr);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else {
                        value = valueStr;
                    }
                }
                if (value == null) continue;
                pds[i].getWriteMethod().invoke((Object)this, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void storeProperties(Properties out) {
        try {
            PropertyDescriptor[] pds = Introspector.getBeanInfo(this.getClass()).getPropertyDescriptors();
            Object[] params = new Object[]{};
            for (int i = 0; i < pds.length; ++i) {
                Object value = pds[i].getReadMethod().invoke((Object)this, params);
                if (value != null) {
                    out.setProperty(pds[i].getName(), value.toString());
                    continue;
                }
                out.remove(pds[i].getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void find() {
        JFrame ownerFrame = null;
        JDialog ownerDialog = null;
        for (Container cnt = this.getParent(); cnt != null; cnt = cnt.getParent()) {
            if (cnt instanceof JFrame) {
                ownerFrame = (JFrame)cnt;
                break;
            }
            if (!(cnt instanceof JDialog)) continue;
            ownerDialog = (JDialog)cnt;
            break;
        }
        if (this.findDialog == null) {
            this.findDialog = ownerFrame != null ? new FindDialog(ownerFrame, "Find", false) : (ownerDialog != null ? new FindDialog(ownerDialog, "Find", false) : new FindDialog((JFrame)null, "Find", false));
            this.findDialog.setFindListener(new FindDialog.FindListener(){

                @Override
                public void find(FindDialog.FindParam param) {
                    int idx = CobolSourceViewer.this.find(param.toSearch, param.matchCase, param.backSearch, param.matchMinusUnderscore);
                    if (idx < 0) {
                        JOptionPane.showMessageDialog(CobolSourceViewer.this, "String '" + param.toSearch + "' not found");
                    }
                }
            });
        }
        if (!this.findDialog.isVisible()) {
            this.findDialog.setLocationRelativeTo(this);
            this.findDialog.open();
            this.findDialog.toFront();
        }
    }

    private String normalizeString(String str, boolean matchCase, boolean matchMinusUnderscore) {
        if (!matchCase) {
            str = str.toUpperCase();
        }
        if (!matchMinusUnderscore) {
            str = str.replace('-', '_');
        }
        return str;
    }

    public int find(String str, boolean matchCase, boolean backward, boolean matchMinusUnderscore) {
        int idx;
        block13: {
            StyledDocument doc = this.textPane.getStyledDocument();
            if (doc.getLength() == 0) {
                return -1;
            }
            int caretPosition = this.textPane.getCaretPosition();
            if (caretPosition < 0) {
                caretPosition = 0;
            }
            Element rootElem = doc.getDefaultRootElement();
            int lineIndex = rootElem.getElementIndex(caretPosition);
            int lineCount = rootElem.getElementCount();
            if (lineIndex < 0 || lineIndex >= lineCount) {
                return -1;
            }
            str = this.normalizeString(str, matchCase, matchMinusUnderscore);
            idx = -1;
            try {
                int idx0;
                String line;
                Element elem;
                int i;
                if (backward) {
                    int idx02;
                    String line2;
                    Element elem2;
                    int i2;
                    for (i2 = lineIndex; i2 >= 0; --i2) {
                        elem2 = rootElem.getElement(i2);
                        line2 = i2 == lineIndex ? doc.getText(elem2.getStartOffset(), caretPosition - elem2.getStartOffset()) : doc.getText(elem2.getStartOffset(), elem2.getEndOffset() - elem2.getStartOffset());
                        idx02 = (line2 = this.normalizeString(line2, matchCase, matchMinusUnderscore)).lastIndexOf(str);
                        if (idx02 + elem2.getStartOffset() == this.textPane.getSelectionStart()) {
                            idx02 = idx02 > 0 ? line2.lastIndexOf(str, idx02 - 1) : -1;
                        }
                        if (idx02 < 0) continue;
                        idx = elem2.getStartOffset() + idx02;
                        break;
                    }
                    if (idx >= 0) break block13;
                    for (i2 = lineCount - 1; i2 >= lineIndex; --i2) {
                        elem2 = rootElem.getElement(i2);
                        line2 = i2 == lineIndex ? doc.getText(caretPosition, elem2.getEndOffset() - caretPosition) : doc.getText(elem2.getStartOffset(), elem2.getEndOffset() - elem2.getStartOffset());
                        idx02 = (line2 = this.normalizeString(line2, matchCase, matchMinusUnderscore)).lastIndexOf(str);
                        if (idx02 < 0) continue;
                        idx = elem2.getStartOffset() + idx02;
                        break block13;
                    }
                    break block13;
                }
                for (i = lineIndex; i < lineCount; ++i) {
                    elem = rootElem.getElement(i);
                    line = i == lineIndex ? doc.getText(caretPosition, elem.getEndOffset() - caretPosition) : doc.getText(elem.getStartOffset(), elem.getEndOffset() - elem.getStartOffset());
                    idx0 = (line = this.normalizeString(line, matchCase, matchMinusUnderscore)).indexOf(str);
                    if (idx0 < 0) continue;
                    if (i == lineIndex) {
                        idx = caretPosition + idx0;
                        break;
                    }
                    idx = elem.getStartOffset() + idx0;
                    break;
                }
                if (idx >= 0) break block13;
                for (i = 0; i <= lineIndex; ++i) {
                    elem = rootElem.getElement(i);
                    line = i == lineIndex ? doc.getText(elem.getStartOffset(), caretPosition - elem.getStartOffset()) : doc.getText(elem.getStartOffset(), elem.getEndOffset() - elem.getStartOffset());
                    idx0 = (line = this.normalizeString(line, matchCase, matchMinusUnderscore)).indexOf(str);
                    if (idx0 < 0) continue;
                    idx = elem.getStartOffset() + idx0;
                    break;
                }
            }
            catch (BadLocationException ex) {
                return -1;
            }
        }
        if (idx >= 0) {
            this.textPane.setSelectionStart(idx);
            this.textPane.setSelectionEnd(idx + str.length());
        }
        return idx;
    }

    public void copy() {
        this.textPane.copy();
    }

    public void selectAll() {
        this.textPane.selectAll();
    }
}

