/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.CallManager;
import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import com.iscobol.rts.IDumpCreator;
import com.iscobol.rts.IscobolClass;
import com.iscobol.rts.IscobolStackTraceElement;
import com.iscobol.rts.Version;
import com.iscobol.types.CobolVar;
import java.lang.reflect.Field;
import java.util.Date;

public class DumpCreator
implements IDumpCreator {
    private StringBuffer dumpInfo;

    @Override
    public void dump(IscobolStackTraceElement[] stackTrace) {
        if (!Config.getProperty(".exception.dump", false)) {
            return;
        }
        CallManager calls = Factory.getCalls();
        String eol = System.getProperty("line.separator", "\n");
        this.dumpInfo = new StringBuffer();
        this.dumpInfo.append("=== Dump created: ");
        this.dumpInfo.append(new Date());
        this.dumpInfo.append(eol);
        if (stackTrace == null || stackTrace.length <= 0) {
            this.dumpInfo.append("!!! NO INFORMATION AVAILABLE !");
            this.dumpInfo.append(eol);
            return;
        }
        Class classToDump = stackTrace[0].clazz;
        Object objectToDump = calls.get(stackTrace[0].declaringClass);
        this.dumpInfo.append("=== Program: ");
        this.dumpInfo.append(classToDump.getName());
        if (objectToDump instanceof IscobolClass) {
            this.dumpInfo.append(", compiled: ");
            this.dumpInfo.append(((IscobolClass)objectToDump).iscobolVersion());
            this.dumpInfo.append(", requires: ");
            this.dumpInfo.append(((IscobolClass)objectToDump).iscobolRequired());
        }
        this.dumpInfo.append(eol);
        this.dumpInfo.append("=== Command line arguments: ");
        String[] gArgs = Factory.get().gArgs;
        if (gArgs != null) {
            for (int i = 0; i < gArgs.length; ++i) {
                this.dumpInfo.append(gArgs[i]);
                this.dumpInfo.append(' ');
            }
        }
        this.dumpInfo.append(eol);
        this.dumpInfo.append("=== isCOBOL Version: ");
        this.dumpInfo.append(Version.getVersion());
        this.dumpInfo.append(eol);
        this.dumpInfo.append("=== Java version: ");
        this.dumpInfo.append(System.getProperty("java.version"));
        this.dumpInfo.append(" ");
        this.dumpInfo.append(System.getProperty("java.vendor"));
        this.dumpInfo.append(eol);
        this.dumpInfo.append("=== Current loaded programs ===");
        this.dumpInfo.append(eol);
        for (String k : calls.keySet()) {
            this.dumpInfo.append(" ");
            this.dumpInfo.append(k);
            this.dumpInfo.append(eol);
        }
        this.dumpInfo.append("=== Memory dump ===");
        this.dumpInfo.append(eol);
        if (objectToDump != null) {
            Field[] f = classToDump.getDeclaredFields();
            for (int i = 0; i < f.length; ++i) {
                if (!CobolVar.class.isAssignableFrom(f[i].getType())) continue;
                try {
                    f[i].setAccessible(true);
                    CobolVar obj = (CobolVar)f[i].get(objectToDump);
                    if (obj.isFinal() || obj.getParent() != null) continue;
                    try {
                        obj.dump(this.dumpInfo, eol);
                    }
                    catch (Throwable _ex) {
                        System.out.println("" + f[i].getName() + "," + _ex);
                    }
                    continue;
                }
                catch (IllegalAccessException _ex) {
                    this.dumpInfo.append(f[i].getName());
                    this.dumpInfo.append("(informations unavailable)");
                    this.dumpInfo.append(eol);
                }
            }
        }
    }

    @Override
    public String getDumpInfo() {
        return this.dumpInfo != null ? this.dumpInfo.toString() : null;
    }
}

