/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.ICobolVar;
import com.iscobol.types.CobolNum;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ExprUtil {
    public static final boolean eq(String s1, String s2) {
        if (s1 != null) {
            if (s2 != null) {
                return s1.equals(s2);
            }
            return false;
        }
        return s2 == null;
    }

    public static final boolean eq(ICobolVar s1, String s2) {
        if (s1 != null) {
            if (s2 != null) {
                return s1.toString().equals(s2);
            }
            return false;
        }
        return s2 == null;
    }

    public static final boolean eq(String s1, ICobolVar s2) {
        return ExprUtil.eq(s2, s1);
    }

    public static final boolean eq(Number n1, Number n2) {
        if (n1 != null) {
            if (n2 != null) {
                if (n1 instanceof Double || n1 instanceof Float || n2 instanceof Double || n2 instanceof Float) {
                    return n1.doubleValue() == n2.doubleValue();
                }
                return n1.longValue() == n2.longValue();
            }
            return false;
        }
        return n2 == null;
    }

    public static final boolean eq(Number n1, BigInteger n2) {
        return ExprUtil.eq(n2, n1);
    }

    public static final boolean eq(Number n1, BigDecimal n2) {
        return ExprUtil.eq(n2, n1);
    }

    public static final boolean eq(BigDecimal n1, Number n2) {
        if (n1 != null) {
            if (n2 != null) {
                return n1.equals(new BigDecimal(n2.toString()));
            }
            return false;
        }
        return n2 == null;
    }

    public static final boolean eq(BigDecimal n1, BigInteger n2) {
        if (n1 != null) {
            if (n2 != null) {
                return n1.equals(new BigDecimal(n2));
            }
            return false;
        }
        return n2 == null;
    }

    public static final boolean eq(BigDecimal n1, BigDecimal n2) {
        if (n1 != null) {
            if (n2 != null) {
                return n1.equals(n2);
            }
            return false;
        }
        return n2 == null;
    }

    public static final boolean eq(BigInteger n1, Number n2) {
        if (n1 != null) {
            if (n2 != null) {
                return new BigDecimal(n1).equals(new BigDecimal(n2.toString()));
            }
            return false;
        }
        return n2 == null;
    }

    public static final boolean eq(BigInteger n1, BigInteger n2) {
        if (n1 != null) {
            if (n2 != null) {
                return n1.equals(n2);
            }
            return false;
        }
        return n2 == null;
    }

    public static final boolean eq(BigInteger n1, BigDecimal n2) {
        return ExprUtil.eq(n2, n1);
    }

    public static final boolean eq(CobolNum n1, Number n2) {
        if (n1 != null) {
            if (n2 != null) {
                return n1.compareTo(n2 instanceof Double || n2 instanceof Float ? CobolNum.noo(n2.doubleValue()) : CobolNum.noo(n2.longValue(), 0)) == 0;
            }
            return false;
        }
        return n2 == null;
    }

    public static final boolean eq(Number n1, CobolNum n2) {
        return ExprUtil.eq(n2, n1);
    }

    public static final boolean eq(CobolNum n1, CobolNum n2) {
        if (n1 != null) {
            if (n2 != null) {
                return n1.compareTo(n2) == 0;
            }
            return false;
        }
        return n2 == null;
    }

    public static final boolean eq(CobolNum n1, BigDecimal n2) {
        if (n1 != null) {
            if (n2 != null) {
                return n1.compareTo(CobolNum.noo(n2)) == 0;
            }
            return false;
        }
        return n2 == null;
    }

    public static final boolean eq(BigDecimal n1, CobolNum n2) {
        return ExprUtil.eq(n2, n1);
    }

    public static final boolean eq(CobolNum n1, BigInteger n2) {
        if (n1 != null) {
            if (n2 != null) {
                return n1.compareTo(CobolNum.noo(n2)) == 0;
            }
            return false;
        }
        return n2 == null;
    }

    public static final boolean eq(BigInteger n1, CobolNum n2) {
        return ExprUtil.eq(n2, n1);
    }

    public static final int cmp(String s1, String s2) {
        return s1.compareTo(s2);
    }

    public static final int cmp(ICobolVar s1, String s2) {
        return s1.toString().compareTo(s2);
    }

    public static final int cmp(String s1, ICobolVar s2) {
        return -ExprUtil.cmp(s2, s1);
    }

    public static final int cmp(BigInteger n1, BigInteger n2) {
        return n1.compareTo(n2);
    }

    public static final int cmp(BigInteger n1, BigDecimal n2) {
        return CobolNum.noo(n1).compareTo(CobolNum.noo(n2));
    }

    public static final int cmp(BigInteger n1, Number n2) {
        CobolNum cn = n2 instanceof Double || n2 instanceof Float ? CobolNum.noo(n2.doubleValue()) : CobolNum.noo(n2.longValue(), 0);
        return CobolNum.noo(n1).compareTo(cn);
    }

    public static final int cmp(BigInteger n1, CobolNum n2) {
        return CobolNum.noo(n1).compareTo(n2);
    }

    public static final int cmp(BigDecimal n1, BigInteger n2) {
        return -ExprUtil.cmp(n2, n1);
    }

    public static final int cmp(BigDecimal n1, BigDecimal n2) {
        return n1.compareTo(n2);
    }

    public static final int cmp(BigDecimal n1, Number n2) {
        CobolNum cn = n2 instanceof Double || n2 instanceof Float ? CobolNum.noo(n2.doubleValue()) : CobolNum.noo(n2.longValue(), 0);
        return CobolNum.noo(n1).compareTo(cn);
    }

    public static final int cmp(BigDecimal n1, CobolNum n2) {
        return CobolNum.noo(n1).compareTo(n2);
    }

    public static final int cmp(Number n1, BigInteger n2) {
        return -ExprUtil.cmp(n2, n1);
    }

    public static final int cmp(Number n1, BigDecimal n2) {
        return -ExprUtil.cmp(n2, n1);
    }

    public static final int cmp(Number n1, Number n2) {
        if (n1 instanceof Double || n1 instanceof Float || n2 instanceof Double || n2 instanceof Float) {
            double d = n1.doubleValue() - n2.doubleValue();
            return d > 0.0 ? 1 : (d < 0.0 ? -1 : 0);
        }
        long d = n1.longValue() - n2.longValue();
        return d > 0L ? 1 : (d < 0L ? -1 : 0);
    }

    public static final int cmp(Number n1, CobolNum n2) {
        CobolNum cn = n1 instanceof Double || n1 instanceof Float ? CobolNum.noo(n1.doubleValue()) : CobolNum.noo(n1.longValue(), 0);
        return cn.compareTo(n2);
    }

    public static final int cmp(CobolNum n1, BigInteger n2) {
        return -ExprUtil.cmp(n2, n1);
    }

    public static final int cmp(CobolNum n1, BigDecimal n2) {
        return -ExprUtil.cmp(n2, n1);
    }

    public static final int cmp(CobolNum n1, Number n2) {
        return -ExprUtil.cmp(n2, n1);
    }

    public static final int cmp(CobolNum n1, CobolNum n2) {
        return n1.compareTo(n2);
    }
}

