/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.gui.ClientCall;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.io.CobolFile;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.CallHandler;
import com.iscobol.rts.CallLoader;
import com.iscobol.rts.CallType;
import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import com.iscobol.rts.Finalizable;
import com.iscobol.rts.RemoteConnections;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.ThreadDependingData;
import com.iscobol.rts.WindowCreateHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ResourceBundle;

public class FactoryData
implements RuntimeErrorsNumbers,
Serializable,
PropertyChangeListener,
Finalizable {
    public Hashtable<String, CallType> callsTypes = new Hashtable();
    private ThreadDependingData ptdd = new ThreadDependingData();
    private Hashtable htdd;
    public Hashtable externVars = new Hashtable();
    public final LinkedList monitorList = new LinkedList();
    public Hashtable sharedMem = new Hashtable();
    public final Hashtable extFiles = new Hashtable();
    private LoaderDesc loaderDesc = new LoaderDesc("", false);
    public CallLoader loader;
    public ClientCall clientCall;
    public RemoteConnections remoteConns;
    public boolean closeOnExit;
    public Hashtable recurCallList;
    public boolean decimalPointIsComma;
    public char currencyChar;
    public Hashtable automatedActionTable = new Hashtable();
    public Logger log;
    public Logger anyLog;
    public boolean traceLib;
    public ResourceBundle resource;
    public ResourceBundle systemResource;
    public Factory xArgs = new Factory();
    public String[] gArgs;
    public String envName;
    public String envValue;
    public CallHandler callHandler;
    public WindowCreateHandler windowCreateHandler;

    public FactoryData() {
        Config.addPropertyChangeListener(this);
        this.log = LoggerFactory.get(2);
        this.anyLog = LoggerFactory.get(-1);
        this.traceLib = LoggerFactory.get(1024) != null;
        LoggerFactory.addPropertyChangeListener(this);
        String pfx = Config.getPrefix();
        for (String prop : new String[]{pfx + "file.indd", pfx + "file.outdd", pfx + "resource.country", pfx + "resource.file", pfx + "resource.language", pfx + "resource.variant"}) {
            String value = Config.getProperty(prop, null);
            if (value == null) continue;
            try {
                ScreenUtility.getGuiFactory().setProperty(prop, value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void createWindowCreateHandler(String windowCreateHdlClassName, String codePrefix, boolean applyCodePath) {
        try {
            CallLoader ld = this.getCallLoader(codePrefix, applyCodePath);
            Class cls = ld != null ? ld.loadClass(windowCreateHdlClassName) : Factory.classForName(windowCreateHdlClassName);
            this.windowCreateHandler = (WindowCreateHandler)cls.newInstance();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void createCallHandler(String callHdlClassName, String codePrefix, boolean applyCodePath) {
        try {
            CallLoader ld = this.getCallLoader(codePrefix, applyCodePath);
            Class cls = ld != null ? ld.loadClass(callHdlClassName) : Factory.classForName(callHdlClassName);
            this.callHandler = (CallHandler)cls.newInstance();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public CallLoader getCallLoader(String codePrefix, boolean applyCodePath) {
        if (!this.loaderDesc.equals(codePrefix, applyCodePath)) {
            this.loaderDesc = new LoaderDesc(codePrefix, applyCodePath);
            this.loader = CallLoader.getInstance(codePrefix, applyCodePath);
        }
        return this.loader;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if (key.startsWith(Config.getPrefix() + "resource.")) {
            this.resource = null;
            this.systemResource = null;
            try {
                ScreenUtility.getGuiFactory().setProperty(key, (String)evt.getNewValue());
            }
            catch (IOException iOException) {}
        } else if (key.equals(Config.getPrefix() + "tracelevel")) {
            this.log = LoggerFactory.get(2);
            this.anyLog = LoggerFactory.get(-1);
            this.traceLib = LoggerFactory.get(1024) != null;
        } else if (key.equals(Config.getPrefix() + "remote.code_prefix")) {
            this.remoteConns.load();
        } else if (key.equals(Config.getPrefix() + "code_prefix")) {
            this.callsTypes.clear();
        }
    }

    public RemoteConnections getRemoteConnections() {
        return this.remoteConns;
    }

    public synchronized void addThreadDependingData(Thread t) {
        if (this.htdd == null) {
            this.htdd = new Hashtable();
        }
        this.htdd.put(t, new ThreadDependingData());
    }

    public synchronized void removeThreadDependingData(Thread t) {
        if (this.htdd != null && this.htdd.remove(t) != null && this.htdd.isEmpty()) {
            this.htdd = null;
        }
    }

    public ThreadDependingData getTdd() {
        ThreadDependingData Return2;
        if (this.htdd == null) {
            Return2 = this.ptdd;
        } else {
            Return2 = (ThreadDependingData)this.htdd.get(Thread.currentThread());
            if (Return2 == null) {
                Return2 = this.ptdd;
            }
        }
        return Return2;
    }

    public void closeExtFiles() {
        if (!this.extFiles.isEmpty()) {
            Enumeration en = this.extFiles.elements();
            while (en.hasMoreElements()) {
                ((CobolFile)en.nextElement()).finalize();
            }
            this.extFiles.clear();
        }
    }

    public void log(String str) {
        if (this.anyLog != null) {
            this.anyLog.info(str);
        }
    }

    @Override
    public void myFinalize() {
        Config.removePropertyChangeListener(this);
    }

    private static class LoaderDesc {
        final String codePrefix;
        final boolean applyCodePath;

        LoaderDesc(String cp, boolean acp) {
            this.codePrefix = cp;
            this.applyCodePath = acp;
        }

        boolean equals(String cp, boolean acp) {
            return this.codePrefix.equals(cp) && this.applyCodePath == acp;
        }
    }
}

