/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.gui.server.CobolAcceptStack;
import com.iscobol.gui.server.CobolRecordAccept;
import com.iscobol.gui.server.DisplayWindow;
import com.iscobol.rts.ErrorBox;
import com.iscobol.rts.Factory;
import com.iscobol.rts.Handle;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IsThread;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.MonitorFinalize;
import com.iscobol.rts.StopRunException;
import com.iscobol.rts.StoppedThreadException;
import com.iscobol.rts.ThreadException;
import com.iscobol.rts.ThreadName;
import com.iscobol.rts.UserHandles;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public abstract class Monitor
implements Runnable,
Handle {
    private Thread thread;
    private boolean[] ended = new boolean[1];
    private int id;
    private CobolAcceptStack cas;
    private CobolAcceptStack casdestroy;
    private Monitor parent;
    private Monitor lastMonitor;
    private boolean stopped;
    public Object CGEObject;
    private Vector objToFinalize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Message getMessage(int from, Monitor to) {
        LinkedList msgList;
        LinkedList linkedList = msgList = PseudoStaticData.get().messageList;
        synchronized (linkedList) {
            Message Return22;
            for (Message Return22 : msgList) {
                if (!Return22.is(from, to)) continue;
                return Return22;
            }
            Return22 = new Message(from, to);
            msgList.addLast(Return22);
            return Return22;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getAnyMessage(Monitor to, ICobolVar msg, int[] hndl) {
        LinkedList msgList;
        int Return2 = -1;
        LinkedList linkedList = msgList = PseudoStaticData.get().messageList;
        synchronized (linkedList) {
            for (Message m : msgList) {
                if (m.to != to || m.mesg.size() <= 0) continue;
                ICobolVar cv = (ICobolVar)m.mesg.removeFirst();
                cv.moveTo(msg);
                hndl[0] = m.from;
                Return2 = cv.length();
            }
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void notifyEnd(Monitor mon) {
        LinkedList msgList;
        LinkedList linkedList = msgList = PseudoStaticData.get().messageList;
        synchronized (linkedList) {
            Iterator en = msgList.iterator();
            while (en.hasNext()) {
                Message msg = (Message)en.next();
                if (msg.from == mon.id) {
                    Message message = msg;
                    synchronized (message) {
                        msg.notify();
                        continue;
                    }
                }
                if (msg.to != mon) continue;
                en.remove();
            }
        }
    }

    public Monitor(NumericVar handle, Monitor p) {
        this((INumericVar)handle, p);
    }

    public Monitor(INumericVar handle, Monitor p) {
        Thread ct = Thread.currentThread();
        int tid = ct instanceof IsThread ? ((IsThread)ct).id : 0;
        this.id = UserHandles.ssetId(this);
        if (handle != null) {
            handle.set(this.id);
        }
        this.thread = new IsThread((Runnable)this, tid);
        ThreadName.setName(this.thread, this);
        Factory.addMonitor(this, this.thread);
        IscobolSystem.duplicateEnv(this.thread);
        this.parent = p;
        this.parent.lastMonitor = this;
        this.lastMonitor = this.parent;
    }

    public Monitor() {
        this.id = UserHandles.ssetId(this);
        this.thread = Thread.currentThread();
    }

    public abstract void launch();

    public void start() {
        this.thread.start();
    }

    @Override
    public void run() {
        try {
            this.launch();
        }
        catch (StopRunException stopRunException) {
        }
        catch (ThreadDeath threadDeath) {
        }
        catch (Throwable ex) {
            this.handleError(ex);
        }
        finally {
            this.setEnded();
            Factory.removeMonitor(this, this.thread);
            UserHandles.free(this.id);
            Monitor.notifyEnd(this);
            IscobolSystem.destroyEnv(this.thread);
            this.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnded() {
        boolean[] blArray = this.ended;
        synchronized (this.ended) {
            this.ended[0] = true;
            this.ended.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor() {
        boolean[] blArray = this.ended;
        synchronized (this.ended) {
            if (!this.ended[0]) {
                try {
                    this.ended.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void handleError(Throwable t) {
        ErrorBox.show(t);
    }

    public void stopThread() {
        this.stopped = true;
        if (this.casdestroy != null) {
            this.casdestroy.push(new CobolRecordAccept(25, 91, 0, (DisplayWindow)null, 0, this.id, true, true));
        }
    }

    public void yield() {
        if (this.thread != null) {
            Thread.yield();
        }
        if (this.stopped || this.thread != null && this.thread.isInterrupted()) {
            throw new StoppedThreadException();
        }
    }

    public synchronized void finalize() {
        if (this.objToFinalize != null) {
            for (int i = this.objToFinalize.size() - 1; i >= 0; --i) {
                try {
                    ((MonitorFinalize)this.objToFinalize.elementAt(i)).monitorFinalize();
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        this.objToFinalize = null;
        if (this.casdestroy != null) {
            this.casdestroy.push(new CobolRecordAccept(25, 91, 0, (DisplayWindow)null, 0, this.id, true, true));
        }
        this.casdestroy = null;
        if (this.parent != null && this.parent.lastMonitor == this) {
            this.parent.lastMonitor = null;
        }
        this.lastMonitor = null;
    }

    public Thread getThread() {
        return this.thread;
    }

    public Monitor getMainMonitor() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getMainMonitor();
    }

    public Monitor getLastMonitor() {
        return this.lastMonitor;
    }

    public int getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCas(CobolAcceptStack c, Monitor currto) {
        this.cas = c;
        if (this.cas != null) {
            LinkedList msgList;
            Message Return2 = null;
            int n = 0;
            LinkedList linkedList = msgList = PseudoStaticData.get().messageList;
            synchronized (linkedList) {
                Iterator en = msgList.iterator();
                while (en.hasNext()) {
                    Message message = Return2 = (Message)en.next();
                    synchronized (message) {
                        if (Return2.mesg.size() > 0 && Return2.isTo(currto) && Return2.isFrom(this.id) && (n = Return2.getSendAfter()) > 0) {
                            while (n > 0) {
                                this.cas.push(new CobolRecordAccept(4, 95, 0, (DisplayWindow)null, 0, Return2.getTo().getId(), true, true));
                                --n;
                            }
                            Return2.resetsendafter();
                        }
                    }
                }
            }
        }
    }

    public void setCasdestroy(CobolAcceptStack c) {
        this.casdestroy = c;
    }

    public CobolAcceptStack getCasdestroy() {
        return this.casdestroy;
    }

    public boolean isThread(Thread t) {
        return t.equals(this.thread);
    }

    public String toString() {
        return "id=" + this.id + ",[" + this.thread.toString() + "]";
    }

    public void send(Monitor to, CobolVar msg) {
        this.send(to, (ICobolVar)msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Monitor to, ICobolVar msg) {
        Message m;
        this.lastMonitor = to;
        Message message = m = Monitor.getMessage(this.id, to);
        synchronized (message) {
            m.mesg.addLast(msg.intICopy());
            if (this.cas != null) {
                this.cas.push(new CobolRecordAccept(4, 95, 0, (DisplayWindow)null, 0, to.id, true, true));
            } else {
                m.incrsendafter();
            }
            m.notify();
        }
    }

    public int receiveAll(CobolVar msg, NumericVar handle) {
        return this.receiveAll((ICobolVar)msg, (INumericVar)handle);
    }

    public int receiveAll(ICobolVar msg, INumericVar handle) {
        int[] hndl = new int[1];
        int sz = Monitor.getAnyMessage(this, msg, hndl);
        if (sz < 0) {
            throw new ThreadException(99);
        }
        if (handle != null) {
            handle.set(hndl[0]);
        }
        return sz;
    }

    public int receive(int from, CobolVar msg, long timeoutMillis) throws ThreadException {
        return this.receive(from, (ICobolVar)msg, timeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receive(int from, ICobolVar msg, long timeoutMillis) throws ThreadException {
        Message m;
        Monitor fromMon;
        this.lastMonitor = fromMon = Factory.getMonitorById(from);
        int Return2 = 0;
        Message message = m = Monitor.getMessage(from, this);
        synchronized (message) {
            if (m.mesg.size() == 0) {
                if (fromMon == null || fromMon.ended[0]) {
                    throw new ThreadException(10);
                }
                if (timeoutMillis == 0L) {
                    throw new ThreadException(99);
                }
                try {
                    if (timeoutMillis > 0L) {
                        m.wait(timeoutMillis);
                    } else {
                        m.wait();
                    }
                }
                catch (InterruptedException _ex) {
                    throw new StoppedThreadException();
                }
            }
            if (m.mesg.size() == 0) {
                if (fromMon == null || fromMon.ended[0]) {
                    throw new ThreadException(-1);
                }
                throw new ThreadException(99);
            }
            ICobolVar cv = (ICobolVar)m.mesg.removeFirst();
            cv.moveTo(msg);
            Return2 = cv.length();
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitEnd(int from, long timeoutMillis) {
        Message m;
        Monitor fromMon = Factory.getMonitorById(from);
        int Return2 = 0;
        Message message = m = Monitor.getMessage(from, this);
        synchronized (message) {
            if (m.mesg.size() == 0) {
                if (fromMon == null || fromMon.ended[0]) {
                    throw new ThreadException(10);
                }
                if (timeoutMillis == 0L) {
                    throw new ThreadException(99);
                }
                try {
                    if (timeoutMillis > 0L) {
                        m.wait(timeoutMillis);
                        if (m.mesg.size() == 0 && !this.ended[0]) {
                            throw new ThreadException(99);
                        }
                    } else {
                        m.wait();
                    }
                }
                catch (InterruptedException _ex) {
                    throw new StoppedThreadException();
                }
            }
            if (m.mesg.size() > 0) {
                ICobolVar cv = (ICobolVar)m.mesg.getFirst();
                Return2 = cv.length();
            }
        }
        return Return2;
    }

    public void setPriority(int p) {
        this.thread.setPriority(p);
    }

    @Override
    public int type() {
        return 4;
    }

    public void addObjToFinalize(MonitorFinalize o) {
        if (this.objToFinalize == null) {
            this.objToFinalize = new Vector();
        }
        this.objToFinalize.addElement(o);
    }

    public void removeObjToFinalize(MonitorFinalize o) {
        if (this.objToFinalize != null) {
            this.objToFinalize.removeElement(o);
        }
    }

    private static class Message {
        private int from;
        private int sendafter;
        private Monitor to;
        private LinkedList mesg = new LinkedList();

        Message(int f, Monitor t) {
            this.from = f;
            this.to = t;
        }

        boolean is(int f, Monitor t) {
            return f == this.from && t == this.to;
        }

        boolean isFrom(int t) {
            return t == this.from;
        }

        int getSendAfter() {
            return this.sendafter;
        }

        void incrsendafter() {
            ++this.sendafter;
        }

        void resetsendafter() {
            this.sendafter = 0;
        }

        Monitor getTo() {
            return this.to;
        }

        int getFrom() {
            return this.from;
        }

        boolean isTo(Monitor t) {
            return t == this.to;
        }

        public String toString() {
            return "from=" + this.from + ",to=" + this.to + ",size=" + this.mesg.size() + ",hash=" + this.hashCode();
        }
    }

    private static class PseudoStaticData {
        private LinkedList messageList = new LinkedList();

        private PseudoStaticData() {
        }

        private static PseudoStaticData get() {
            PseudoStaticData Return2 = (PseudoStaticData)IscobolSystem.get(PseudoStaticData.class);
            if (Return2 == null) {
                Return2 = new PseudoStaticData();
                IscobolSystem.set(PseudoStaticData.class, Return2);
            }
            return Return2;
        }
    }
}

