/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintContext;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;

public class PrintAt
extends PrintCommand {
    private String text;
    private float left;
    private float top;
    private float width;
    private char align;
    private boolean relativePos;
    private byte yStart;
    private boolean clipping;

    public PrintAt(GuiFactory gf, String s, float x, float y, float w, boolean rpos, char algn, byte ys, boolean clp) {
        super(gf, 16);
        this.text = s.trim();
        this.left = x;
        this.top = y;
        this.width = w;
        this.relativePos = rpos;
        this.align = algn;
        this.yStart = ys;
        this.clipping = clp;
    }

    public PrintAt(GuiFactory gf, RandomAccessFile inOut) throws IOException {
        super(gf, 12);
        this.text = inOut.readUTF();
        this.left = inOut.readFloat();
        this.top = inOut.readFloat();
        this.width = inOut.readFloat();
        this.relativePos = inOut.readBoolean();
        this.align = inOut.readChar();
        this.yStart = inOut.readByte();
        this.clipping = inOut.readBoolean();
    }

    @Override
    void toFile(RandomAccessFile inOut) throws IOException {
        inOut.writeUTF(this.text);
        inOut.writeFloat(this.left);
        inOut.writeFloat(this.top);
        inOut.writeFloat(this.width);
        inOut.writeBoolean(this.relativePos);
        inOut.writeChar(this.align);
        inOut.writeByte(this.yStart);
        inOut.writeBoolean(this.clipping);
    }

    private final float getYOffs(TextLayout layout) {
        return PrintAt.getYOffs(this.yStart, layout);
    }

    @Override
    public boolean testPrint(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        return this.print(pc, null, pf);
    }

    private void myDraw(Graphics2D g2d, PrintContext pc, TextLayout layout, String str, float x, float y, float displ) {
        switch (this.align) {
            case 'R': {
                x += displ;
                break;
            }
            case 'C': {
                x += displ / 2.0f;
                break;
            }
        }
        PrintAt.drawString(g2d, pc, layout, str.trim(), x, y);
    }

    @Override
    public boolean print(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        TextLayout layout = new TextLayout(this.text, pc.font, pc.frc);
        float lineHeight = layout.getAscent() + layout.getDescent() + layout.getLeading();
        if (PrintAt.gtAtTolerance(pc.pen.y + lineHeight, pf.getImageableHeight())) {
            return false;
        }
        if (g2d != null) {
            float x = this.relativePos ? pc.pen.x + this.left : this.left;
            float y = this.relativePos ? pc.pen.y + this.top : this.top;
            float yoffs = this.getYOffs(layout);
            if (this.width > 0.0f) {
                float advance = layout.getAdvance();
                if (advance > this.width) {
                    StringTokenizer st = new StringTokenizer(this.text, " \t\n\r", true);
                    StringBuffer sb0 = new StringBuffer();
                    StringBuffer sb = new StringBuffer();
                    int i = 0;
                    while (st.hasMoreTokens()) {
                        float f;
                        String s = st.nextToken();
                        sb.append(s);
                        layout = new TextLayout(sb.toString(), pc.font, pc.frc);
                        advance = layout.getAdvance();
                        if (f > this.width) {
                            if (sb0.length() == 0) {
                                this.myDraw(g2d, pc, layout, sb.toString(), x, y + yoffs, this.width - advance);
                                sb.setLength(0);
                            } else {
                                layout = new TextLayout(sb0.toString(), pc.font, pc.frc);
                                advance = layout.getAdvance();
                                this.myDraw(g2d, pc, layout, sb0.toString(), x, y + yoffs, this.width - advance);
                                sb0.setLength(0);
                                sb.setLength(0);
                                sb0.append(s);
                                sb.append(s);
                            }
                            y += lineHeight;
                            pc.pen.y += lineHeight;
                            if (this.clipping) {
                                break;
                            }
                        } else {
                            sb0.append(s);
                        }
                        ++i;
                    }
                    if (sb0.length() > 0 && !this.clipping) {
                        layout = new TextLayout(sb0.toString(), pc.font, pc.frc);
                        advance = layout.getAdvance();
                        this.myDraw(g2d, pc, layout, sb0.toString(), x, y + yoffs, this.width - advance);
                    }
                } else {
                    this.myDraw(g2d, pc, layout, this.text, x, y + yoffs, this.width - advance);
                }
            } else {
                this.myDraw(g2d, pc, layout, this.text, x, y + this.getYOffs(layout), 0.0f);
            }
        }
        pc.pen.x = this.width > 0.0f ? (pc.pen.x += this.width) : (pc.pen.x += layout.getAdvance());
        return true;
    }
}

