/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.rts.print.GraphBrush;
import com.iscobol.rts.print.GraphPen;
import com.iscobol.rts.print.PageColumn;
import java.awt.Color;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;

public class PrintContext
implements Cloneable {
    private final float x0;
    Point2D.Float pen;
    FontRenderContext frc;
    Color color;
    Color background;
    Font font;
    GraphPen graphPen;
    GraphBrush graphBrush;
    Color boxShade;
    int[] dataCols;
    PageColumn[] pgCols;
    float advancing;
    PageFormat pf;
    int orientation;

    private PrintContext(Point2D.Float p, Font fn, FontRenderContext f, Color c, Color bg, GraphPen graphPen, GraphBrush graphBrush, int[] dataCols, PageColumn[] pgCols, PageFormat pf, int orientation) {
        this.x0 = p.x;
        this.pen = new Point2D.Float(p.x, p.y);
        this.font = fn;
        this.frc = f;
        this.color = c;
        this.background = bg;
        this.graphPen = graphPen;
        this.graphBrush = graphBrush;
        this.dataCols = dataCols;
        this.pgCols = pgCols;
        this.advancing = 0.0f;
        this.pf = pf;
        this.orientation = orientation;
    }

    PrintContext(Point2D.Float p, Font fn, FontRenderContext f, Color c, PageFormat pf, int orientation) {
        this(p, fn, f, c, null, null, null, null, null, pf, orientation);
    }

    PrintContext(PrintContext pc) {
        this(pc.pen, pc.font, pc.frc, pc.color, pc.background, pc.graphPen, pc.graphBrush, pc.dataCols, pc.pgCols, pc.pf, pc.orientation);
        this.advancing = pc.advancing;
    }

    public void resetX() {
        this.pen.x = this.x0;
    }

    public boolean isBackgroundSet() {
        return this.background != null && !this.background.equals(Color.white);
    }
}

