/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintContext;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SetCursor
extends PrintCommand {
    private static double lastX = 0.0;
    private static double lastY = 0.0;
    private static boolean lastCells = false;
    private double x;
    private double y;
    private boolean cells;
    private double prevX;
    private double prevY;
    private boolean prevCells;

    private void init(double lx, double ly, boolean lcells) {
        this.prevX = lastX;
        this.prevY = lastY;
        this.prevCells = lastCells;
        lastX = this.x = lx;
        lastY = this.y = ly;
        lastCells = this.cells = lcells;
    }

    public SetCursor(GuiFactory gf, double lx, double ly, boolean lcells) {
        super(gf, 11);
        this.init(lx, ly, lcells);
    }

    public SetCursor(GuiFactory gf, RandomAccessFile inOut) throws IOException {
        super(gf, 11);
        this.x = inOut.readDouble();
        this.y = inOut.readDouble();
        this.cells = inOut.readBoolean();
    }

    @Override
    void toFile(RandomAccessFile inOut) throws IOException {
        inOut.writeDouble(this.x);
        inOut.writeDouble(this.y);
        inOut.writeBoolean(this.cells);
    }

    @Override
    public boolean testPrint(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        return this.print(pc, null, pf);
    }

    @Override
    public boolean print(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        if (this.cells) {
            TextLayout layout = new TextLayout("0", pc.font, pc.frc);
            float fh = SetCursor.getCellHeight(pc, layout);
            float fw = layout.getAdvance();
            pc.pen.x = (float)(this.x * (double)fw);
            pc.pen.y = (float)(this.y * (double)fh);
        } else {
            pc.pen.x = (float)this.x;
            pc.pen.y = (float)this.y;
        }
        return true;
    }

    public double getPrevX() {
        return this.prevX;
    }

    public double getPrevY() {
        return this.prevY;
    }

    public boolean getPrevCells() {
        return this.prevCells;
    }

    public static double getLastX() {
        return lastX;
    }

    public static double getLastY() {
        return lastY;
    }

    public static boolean getLastCells() {
        return lastCells;
    }
}

