/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.Events;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.print.LocalSpoolPrinter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class SpoolPrinterList {
    private int prog;
    private Map<Integer, LocalSpoolPrinter> spoolPrinters = new HashMap<Integer, LocalSpoolPrinter>();
    private Stack<LocalSpoolPrinter> spoolPrinterStack = new Stack();
    private Stack<LocalSpoolPrinter> ssSpoolPrinterStack = new Stack();
    private boolean serverSide;

    public static SpoolPrinterList get() {
        SpoolPrinterList Return2 = (SpoolPrinterList)IscobolSystem.get(SpoolPrinterList.class);
        if (Return2 == null) {
            Return2 = new SpoolPrinterList();
            IscobolSystem.set(SpoolPrinterList.class, Return2);
        }
        return Return2;
    }

    public boolean isServerSide() {
        return this.serverSide;
    }

    public void setServerSide(boolean serverSide) {
        this.serverSide = serverSide;
    }

    public void setCurrentSpoolPrinter(LocalSpoolPrinter sp) throws IOException {
        if (sp != null) {
            if (sp.isServerSide()) {
                if (this.ssSpoolPrinterStack.contains(sp)) {
                    this.ssSpoolPrinterStack.remove(sp);
                }
                this.ssSpoolPrinterStack.push(sp);
            } else {
                if (this.spoolPrinterStack.contains(sp)) {
                    this.spoolPrinterStack.remove(sp);
                }
                this.spoolPrinterStack.push(sp);
            }
        } else {
            this.spoolPrinterStack.clear();
            this.ssSpoolPrinterStack.clear();
        }
    }

    public LocalSpoolPrinter getCurrentSpoolPrinter() throws IOException {
        if (this.serverSide) {
            if (this.ssSpoolPrinterStack.isEmpty()) {
                this.newSpoolPrinter(0);
            }
            return this.ssSpoolPrinterStack.peek();
        }
        if (this.spoolPrinterStack.isEmpty()) {
            this.newSpoolPrinter(0);
        }
        return this.spoolPrinterStack.peek();
    }

    public LocalSpoolPrinter newSpoolPrinter() throws IOException {
        return this.newSpoolPrinter(++this.prog);
    }

    private LocalSpoolPrinter newSpoolPrinter(int id) throws IOException {
        LocalSpoolPrinter csp = null;
        if (this.serverSide) {
            if (!this.ssSpoolPrinterStack.isEmpty()) {
                csp = this.ssSpoolPrinterStack.peek();
            }
        } else if (!this.spoolPrinterStack.isEmpty()) {
            csp = this.spoolPrinterStack.peek();
        }
        LocalSpoolPrinter Return2 = new LocalSpoolPrinter(id, this.serverSide, csp);
        this.spoolPrinters.put(id, Return2);
        if (this.serverSide) {
            this.ssSpoolPrinterStack.push(Return2);
        } else {
            this.spoolPrinterStack.push(Return2);
        }
        return Return2;
    }

    public LocalSpoolPrinter newSpoolPrinter(boolean preview, boolean direct, boolean pdf, String fileName, boolean binary) throws IOException {
        return this.newSpoolPrinter(preview, direct, pdf, fileName, binary, null);
    }

    public LocalSpoolPrinter newSpoolPrinter(boolean preview, boolean direct, boolean pdf, String fileName, boolean binary, Events events) throws IOException {
        String defFont;
        LocalSpoolPrinter csp = null;
        if (this.serverSide) {
            if (!this.ssSpoolPrinterStack.isEmpty()) {
                csp = this.ssSpoolPrinterStack.peek();
            }
        } else if (!this.spoolPrinterStack.isEmpty()) {
            csp = this.spoolPrinterStack.peek();
        }
        if ((defFont = Config.getProperty("iscobol.print.default_font", null)) != null) {
            ScreenUtility.getGuiFactory().setProperty("iscobol.print.default_font", defFont);
        }
        LocalSpoolPrinter Return2 = new LocalSpoolPrinter(++this.prog, preview, direct, pdf, fileName, binary, events, this.serverSide, csp);
        this.spoolPrinters.put(this.prog, Return2);
        if (this.serverSide) {
            this.ssSpoolPrinterStack.push(Return2);
        } else {
            this.spoolPrinterStack.push(Return2);
        }
        return Return2;
    }

    public LocalSpoolPrinter getSpoolPrinter(int id) {
        return this.spoolPrinters.get(id);
    }

    public LocalSpoolPrinter removeSpoolPrinter(int id) throws IOException {
        LocalSpoolPrinter Return2 = this.spoolPrinters.remove(id);
        if (Return2 != null) {
            if (Return2.isServerSide()) {
                this.ssSpoolPrinterStack.remove(Return2);
            } else {
                this.spoolPrinterStack.remove(Return2);
            }
        }
        return Return2;
    }
}

