/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.son;

import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolCall;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.Memory;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.NumericVar;
import com.iscobol.types_n.Pic9Comp_5;
import java.io.File;
import java.util.StringTokenizer;

public class DynamicCall
implements RuntimeErrorsNumbers,
IscobolCall {
    public static final int STDC_CALL_CONV = 0;
    public static final int PASCAL_CALL_CONV = 1;
    public static final int MAX_ARGS = 256;
    private static boolean loaded;
    private final int callConv;
    private final String name;
    private Pic9Comp_5 ret = new Pic9Comp_5(Memory.getMemory(8), 0, 8, true, 0, 0, null, null, null, false, true);

    private static native void init();

    private static native boolean peerOpen(String var0);

    private static native long peerCall(String var0, int var1, long[] var2);

    private static native String peerClose(String var0);

    public DynamicCall(String name, int callConv) {
        this.name = name;
        this.callConv = callConv;
    }

    @Override
    public Object call(Object[] arg) {
        long rc;
        if (!loaded) {
            throw new IscobolRuntimeException(2, this.name);
        }
        try {
            rc = DynamicCall.call(this.name, this.callConv, arg);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            if ((arg == null || arg.length == 0) && DynamicCall.open(this.name)) {
                rc = 0L;
            }
            throw new IscobolRuntimeException(2, this.name);
        }
        this.ret.set(rc);
        return this.ret;
    }

    @Override
    public void finalize() {
    }

    public static final boolean open(String name) {
        return DynamicCall.open(name, false);
    }

    private static boolean open(String name, boolean preload) {
        Logger l;
        boolean Return2;
        boolean bl = Return2 = loaded && DynamicCall.peerOpen(name);
        if (name != null && (l = LoggerFactory.get(-1)) != null) {
            String msg = "";
            if (preload) {
                msg = msg + "PRE";
            }
            msg = msg + "LOADING library '";
            msg = msg + name;
            msg = msg + "' ";
            msg = Return2 ? msg + "SUCCEEDED" : msg + "FAILED";
            l.info(msg);
        }
        return Return2;
    }

    public final Object openAndLoad(Object[] argv) {
        String lib = System.mapLibraryName(this.name);
        if (!DynamicCall.open(lib)) {
            throw new IscobolRuntimeException(2, this.name);
        }
        this.ret.set(DynamicCall.call(this.name, this.callConv, argv));
        return this.ret;
    }

    public static final long call(String name, int callConv, Object[] argv) {
        long[] argl;
        boolean argvMax = false;
        if (loaded) {
            if (argv == null) {
                argl = null;
            } else {
                if (argv.length > 256) {
                    argl = new long[256];
                    argvMax = true;
                } else {
                    argl = new long[argv.length];
                }
                for (int i = 0; i < argl.length; ++i) {
                    try {
                        CobolVar var = (CobolVar)argv[i];
                        if (var.isByVal()) {
                            if (var instanceof NumericVar) {
                                argl[i] = var.tolong();
                                continue;
                            }
                            argl[i] = var.intCopy().getAddressAsLong();
                            continue;
                        }
                        argl[i] = var.getAddressAsLong();
                        continue;
                    }
                    catch (Exception _ex) {
                        argl[i] = 0L;
                    }
                }
            }
        } else {
            throw new RuntimeException("Native call not found");
        }
        long Return2 = DynamicCall.peerCall(name, callConv, argl);
        if (argvMax) {
            throw new IllegalArgumentException("Too many arguments:" + argv.length + " (max allowed: " + 256 + ")");
        }
        return Return2;
    }

    public static final String unload(String name) {
        if (loaded) {
            return DynamicCall.peerClose(name);
        }
        return "";
    }

    @Override
    public void perform(int begin, int end) {
    }

    static {
        String sll;
        block5: {
            try {
                System.loadLibrary("dyncall_n");
                loaded = true;
                DynamicCall.init();
            }
            catch (UnsatisfiedLinkError e) {
                if (Config.getProperty("iscobol.runtime.native.ignore_errors", "iscobol.runtime.native.dynamic.ignore_errors", true)) break block5;
                throw new IscobolRuntimeException(32, (Throwable)e);
            }
        }
        if (Config.getProperty("iscobol.shared_dlopen_null", true)) {
            DynamicCall.open(null);
        }
        if ((sll = Config.getProperty("iscobol.shared_library_list", null)) != null) {
            StringTokenizer st = new StringTokenizer(sll, "\n" + File.pathSeparatorChar);
            while (st.hasMoreTokens()) {
                DynamicCall.open(st.nextToken(), true);
            }
        }
    }
}

