/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.math.BigCobolDec;
import com.iscobol.rts.DivideByZeroException;
import com.iscobol.rts.Factory;
import com.iscobol.rts.Memory;
import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVar;
import com.iscobol.types.EncBytes;
import com.iscobol.types.NumericVar;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;

public class CobolDouble
extends CobolNum {
    private double dbValue;
    private static boolean[] dummy = new boolean[1];

    CobolDouble(double val) {
        super((byte)2);
        this.dbValue = val;
    }

    @Override
    public float floatValue() {
        return (float)this.dbValue;
    }

    @Override
    public double doubleValue() {
        return this.dbValue;
    }

    @Override
    public BigDecimal bigDecimalValue() {
        if (Double.isInfinite(this.dbValue) || Double.isNaN(this.dbValue)) {
            return new BigDecimal("10000000000000000000000000000000");
        }
        return new BigDecimal(this.dbValue);
    }

    @Override
    public BigCobolDec bigCobDecValue() {
        if (Double.isInfinite(this.dbValue) || Double.isNaN(this.dbValue)) {
            return OVERFLOW_BD;
        }
        return new BigCobolDec(this.dbValue);
    }

    @Override
    public CobolNum set(long nLong, int nScale, boolean rounding) {
        this.dbValue = (double)nLong / factDouble[nScale];
        return this;
    }

    @Override
    public CobolNum set(BigCobolDec bd) {
        this.dbValue = bd.doubleValue();
        return this;
    }

    @Override
    public CobolNum set(double db) {
        return this.set(db, false);
    }

    public CobolNum set(double db, boolean rounded) {
        this.dbValue = db;
        return this;
    }

    @Override
    public CobolNum set(float fl) {
        this.dbValue = fl;
        return this;
    }

    @Override
    public CobolNum set(CobolNum val, boolean rounded, boolean lenInBytes) {
        return this.set(val.doubleValue());
    }

    @Override
    public CobolNum add(CobolNum val) {
        return new CobolDouble(this.dbValue + val.doubleValue());
    }

    @Override
    public void addToMe(short i) {
        this.dbValue += (double)i;
    }

    @Override
    public void subFromMe(short i) {
        this.dbValue -= (double)i;
    }

    @Override
    public void multiplyByMe(short i) {
        this.dbValue *= (double)i;
    }

    @Override
    public void divideIntoMe(boolean checkdivbyzero, short i) {
        this.dbValue /= (double)i;
    }

    @Override
    public void divideIntoMeByZero(boolean checkdivbyzero) throws DivideByZeroException {
        int v = checkdivbyzero ? CHECKDIV_PROPERTY : 0;
        switch (v) {
            default: {
                if (this.dbValue < 0.0) {
                    this.dbValue = Double.NEGATIVE_INFINITY;
                    break;
                }
                this.dbValue = Double.POSITIVE_INFINITY;
                break;
            }
            case 1: {
                throw new DivideByZeroException();
            }
            case 2: {
                this.dbValue = 0.0;
            }
            case 3: {
                break;
            }
            case -1: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumend undefined result");
                if (this.dbValue < 0.0) {
                    this.dbValue = Double.NEGATIVE_INFINITY;
                    break;
                }
                this.dbValue = Double.POSITIVE_INFINITY;
                break;
            }
            case -2: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumed result is 0");
                this.dbValue = 0.0;
                break;
            }
            case -3: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumed divide by 1");
            }
        }
    }

    @Override
    public void addToMe(int i) {
        this.dbValue += (double)i;
    }

    @Override
    public void subFromMe(int i) {
        this.dbValue -= (double)i;
    }

    @Override
    public void multiplyByMe(int i) {
        this.dbValue *= (double)i;
    }

    @Override
    public void divideIntoMe(boolean checkdivbyzero, int i) {
        this.dbValue /= (double)i;
    }

    @Override
    public void addToMe(long i) {
        this.dbValue += (double)i;
    }

    @Override
    public void subFromMe(long i) {
        this.dbValue -= (double)i;
    }

    @Override
    public void multiplyByMe(long i) {
        this.dbValue *= (double)i;
    }

    @Override
    public void divideIntoMe(boolean checkdivbyzero, long i) {
        this.dbValue /= (double)i;
    }

    @Override
    public CobolNum add1() {
        return new CobolDouble(this.dbValue + 1.0);
    }

    @Override
    public CobolNum subtract(CobolNum val) {
        return new CobolDouble(this.dbValue - val.doubleValue());
    }

    @Override
    public CobolNum subtract1() {
        return new CobolDouble(this.dbValue - 1.0);
    }

    @Override
    public CobolNum multiply(CobolNum val) {
        return new CobolDouble(this.dbValue * val.doubleValue());
    }

    @Override
    public CobolNum multiply36(CobolNum val) {
        return this.multiply(val);
    }

    @Override
    public CobolNum divide(boolean checkdivbyzero, CobolNum val, int scale, boolean rounding) {
        return CobolDouble.divideDouble(checkdivbyzero, this.dbValue, val.doubleValue(), scale, rounding);
    }

    @Override
    public void toCobolByteArray(byte[] Return2, int len, byte[] encoded_digits) {
        byte[] st;
        String str = Double.toString(this.dbValue);
        try {
            st = str.getBytes(CobolVar.encoding);
        }
        catch (UnsupportedEncodingException e) {
            st = str.getBytes();
        }
        if (st.length >= len) {
            System.arraycopy(st, 0, Return2, 0, len);
        } else {
            System.arraycopy(st, 0, Return2, 0, st.length);
            for (int i = st.length; i < len; ++i) {
                Return2[i] = EncBytes.C_SPACE;
            }
        }
    }

    @Override
    public int toByteArray(byte[] Return2) {
        return this.bigCobDecValue().toByteArray(Return2, NumericVar.encoded_digits);
    }

    @Override
    public boolean isOverflow(CobolNum dest, int destIntPart) {
        switch (dest.type) {
            case 0: {
                if (Double.isInfinite(this.dbValue) || Double.isNaN(this.dbValue)) {
                    return true;
                }
                if (this.dbValue < 0.0) {
                    return this.dbValue < (double)factMin[destIntPart];
                }
                return this.dbValue > (double)factMax[destIntPart];
            }
            case 1: {
                if (Double.isInfinite(this.dbValue) || Double.isNaN(this.dbValue)) {
                    return true;
                }
                if (this.dbValue < 0.0) {
                    return this.dbValue < -factDouble[destIntPart];
                }
                return this.dbValue > factDouble[destIntPart];
            }
            case 3: {
                return this.dbValue > 3.4028234663852886E38 || this.dbValue < (double)1.4E-45f || Double.isNaN(this.dbValue);
            }
            case 2: {
                return Double.isInfinite(this.dbValue) || Double.isNaN(this.dbValue);
            }
        }
        return false;
    }

    @Override
    public boolean isOverflowByte(CobolNum dest, int nBytes, boolean signed) {
        return Double.isInfinite(this.dbValue) || Double.isNaN(this.dbValue);
    }

    @Override
    public int compareTo(CobolNum val) {
        return CobolDouble.evalCompare(this.dbValue - val.doubleValue());
    }

    @Override
    public int compareTo(long val, int scale) {
        return CobolDouble.evalCompare(this.dbValue - CobolDouble.doubleValue(val, scale));
    }

    @Override
    public long getUnscaledLong(boolean[] overflow) {
        long Return2 = this.bigCobDecValue().setScale(0).unscaled18Digits(0);
        boolean bl = overflow[0] = this.bigCobDecValue().precision() > 18;
        if (!overflow[0]) {
            int sc = this.bigCobDecValue().scale();
            Return2 = this.bigCobDecValue().unscaled18Digits(sc);
            if (sc < 0) {
                Return2 *= fact[-sc];
            }
        }
        return Return2;
    }

    @Override
    public long getUnscaledLong() {
        return this.getUnscaledLong(dummy);
    }

    @Override
    public void toBinaryByteArray(Memory Return2, int start, int len) {
        long n = Double.doubleToLongBits(this.dbValue);
        for (int i = len - 1; i > 0; --i) {
            Return2.put(start++, (byte)(n >>> (i << 3)));
        }
        Return2.put(start, (byte)(n & 0xFFL));
    }

    @Override
    public void toBinaryByteArray(byte[] Return2, int start, int len) {
        long n = Double.doubleToLongBits(this.dbValue);
        for (int i = len - 1; i > 0; --i) {
            Return2[start++] = (byte)(n >>> (i << 3));
        }
        Return2[start] = (byte)(n & 0xFFL);
    }

    @Override
    public void setSizeDigit(int intPart, int decPart) {
    }

    @Override
    public void setSizeByteUnsigned(int nBytes) {
    }

    @Override
    public void setSizeByteSigned(int nBytes) {
    }

    @Override
    public void setScale(int scale, boolean rounding, boolean lenInBytes) {
    }

    @Override
    public final void roundUpIfNeeded(int scaleDiff) {
    }

    @Override
    public int scale() {
        return -1;
    }

    @Override
    public int precision() {
        return -1;
    }

    @Override
    public int signum() {
        return (int)Math.signum(this.dbValue);
    }

    @Override
    public void negateMe() {
        this.dbValue = -this.dbValue;
    }

    @Override
    public CobolNum negate() {
        return new CobolDouble(-this.dbValue);
    }

    @Override
    public void shift(int tenExp) {
        this.dbValue = tenExp < 0 ? (this.dbValue /= (double)fact[-tenExp]) : (this.dbValue *= (double)fact[tenExp]);
    }

    @Override
    public String toString() {
        return Double.toString(this.dbValue);
    }

    @Override
    public int shortValue() {
        return (short)this.dbValue;
    }

    @Override
    public int intValue() {
        return (int)this.dbValue;
    }

    @Override
    public long longValue() {
        return (long)this.dbValue;
    }

    @Override
    public int shortValue(boolean rounding) {
        if (rounding) {
            return (short)Math.round(this.dbValue);
        }
        return (short)this.dbValue;
    }

    @Override
    public int intValue(boolean rounding) {
        if (rounding) {
            return (int)Math.round(this.dbValue);
        }
        return (int)this.dbValue;
    }

    @Override
    public long longValue(boolean rounding) {
        if (rounding) {
            return Math.round(this.dbValue);
        }
        return (long)this.dbValue;
    }

    @Override
    public CobolNum integerFunc() {
        return new CobolDouble(Math.floor(this.dbValue));
    }

    @Override
    public CobolNum integerPart() {
        if (this.dbValue < 0.0) {
            return new CobolDouble(Math.ceil(this.dbValue));
        }
        return new CobolDouble(Math.floor(this.dbValue));
    }
}

