/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.math.BigCobolDec;
import com.iscobol.rts.DivideByZeroException;
import com.iscobol.rts.Factory;
import com.iscobol.rts.Memory;
import com.iscobol.types.CobolDouble;
import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVar;
import com.iscobol.types.EncBytes;
import com.iscobol.types.NumericVar;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;

public class CobolFloat
extends CobolNum {
    private float flValue;
    private static boolean[] dummy = new boolean[1];

    CobolFloat(float val) {
        super((byte)3);
        this.flValue = val;
    }

    @Override
    public float floatValue() {
        return this.flValue;
    }

    @Override
    public double doubleValue() {
        return this.flValue;
    }

    @Override
    public BigDecimal bigDecimalValue() {
        if (Float.isInfinite(this.flValue) || Float.isNaN(this.flValue)) {
            return new BigDecimal("10000000000000000000000000000000");
        }
        return new BigDecimal(this.flValue);
    }

    @Override
    public BigCobolDec bigCobDecValue() {
        if (Float.isInfinite(this.flValue) || Float.isNaN(this.flValue)) {
            return OVERFLOW_BD;
        }
        return new BigCobolDec(this.flValue);
    }

    @Override
    public CobolNum set(long nLong, int nScale, boolean rounding) {
        this.flValue = (float)((double)nLong / factDouble[nScale]);
        return this;
    }

    @Override
    public CobolNum set(BigCobolDec bd) {
        this.flValue = (float)bd.doubleValue();
        return this;
    }

    @Override
    public CobolNum set(double db) {
        this.flValue = (float)db;
        return this;
    }

    @Override
    public CobolNum set(float fl) {
        this.flValue = fl;
        return this;
    }

    @Override
    public CobolNum set(CobolNum val, boolean rounded, boolean lenInBytes) {
        return this.set(val.floatValue());
    }

    @Override
    public CobolNum add(CobolNum val) {
        switch (val.type) {
            case 3: {
                return new CobolFloat(this.flValue + val.floatValue());
            }
            case 0: 
            case 1: 
            case 2: {
                return new CobolDouble((double)this.flValue + val.doubleValue());
            }
        }
        return null;
    }

    @Override
    public void addToMe(short i) {
        this.flValue += (float)i;
    }

    @Override
    public void subFromMe(short i) {
        this.flValue -= (float)i;
    }

    @Override
    public void multiplyByMe(short i) {
        this.flValue *= (float)i;
    }

    @Override
    public void divideIntoMe(boolean checkdivbyzero, short i) {
        this.flValue /= (float)i;
    }

    @Override
    public void divideIntoMeByZero(boolean checkdivbyzero) throws DivideByZeroException {
        int v = checkdivbyzero ? CHECKDIV_PROPERTY : 0;
        switch (v) {
            default: {
                if (this.flValue < 0.0f) {
                    this.flValue = Float.NEGATIVE_INFINITY;
                    break;
                }
                this.flValue = Float.POSITIVE_INFINITY;
                break;
            }
            case 1: {
                throw new DivideByZeroException();
            }
            case 2: {
                this.flValue = 0.0f;
            }
            case 3: {
                break;
            }
            case -1: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumend undefined result");
                if (this.flValue < 0.0f) {
                    this.flValue = Float.NEGATIVE_INFINITY;
                    break;
                }
                this.flValue = Float.POSITIVE_INFINITY;
                break;
            }
            case -2: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumed result is 0");
                this.flValue = 0.0f;
                break;
            }
            case -3: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumed divide by 1");
            }
        }
    }

    @Override
    public void addToMe(int i) {
        this.flValue += (float)i;
    }

    @Override
    public void subFromMe(int i) {
        this.flValue -= (float)i;
    }

    @Override
    public void multiplyByMe(int i) {
        this.flValue *= (float)i;
    }

    @Override
    public void divideIntoMe(boolean checkdivbyzero, int i) {
        this.flValue /= (float)i;
    }

    @Override
    public void addToMe(long i) {
        this.flValue += (float)i;
    }

    @Override
    public void subFromMe(long i) {
        this.flValue -= (float)i;
    }

    @Override
    public void multiplyByMe(long i) {
        this.flValue *= (float)i;
    }

    @Override
    public void divideIntoMe(boolean checkdivbyzero, long i) {
        this.flValue /= (float)i;
    }

    @Override
    public CobolNum add1() {
        return new CobolFloat(this.flValue + 1.0f);
    }

    @Override
    public CobolNum subtract(CobolNum val) {
        switch (val.type) {
            case 3: {
                return new CobolFloat(this.flValue - val.floatValue());
            }
            case 0: 
            case 1: 
            case 2: {
                return new CobolDouble((double)this.flValue - val.doubleValue());
            }
        }
        return null;
    }

    @Override
    public CobolNum subtract1() {
        return new CobolFloat(this.flValue - 1.0f);
    }

    @Override
    public CobolNum multiply(CobolNum val) {
        switch (val.type) {
            case 3: {
                return new CobolFloat(this.flValue * val.floatValue());
            }
            case 0: 
            case 1: 
            case 2: {
                return new CobolDouble((double)this.flValue * val.doubleValue());
            }
        }
        return null;
    }

    @Override
    public CobolNum multiply36(CobolNum val) {
        return this.multiply(val);
    }

    @Override
    public CobolNum divide(boolean checkdivbyzero, CobolNum val, int scale, boolean rounding) {
        switch (val.type) {
            case 0: 
            case 3: {
                return CobolFloat.divideFloat(checkdivbyzero, this.flValue, val.floatValue(), scale, rounding);
            }
            case 1: 
            case 2: {
                return CobolFloat.divideDouble(checkdivbyzero, this.flValue, val.doubleValue(), scale, rounding);
            }
        }
        return null;
    }

    @Override
    public void toCobolByteArray(byte[] Return2, int len, byte[] encoded_digits) {
        byte[] st;
        String str = Float.toString(this.flValue);
        try {
            st = str.getBytes(CobolVar.encoding);
        }
        catch (UnsupportedEncodingException e) {
            st = str.getBytes();
        }
        if (st.length >= len) {
            System.arraycopy(st, 0, Return2, 0, len);
        } else {
            System.arraycopy(st, 0, Return2, 0, st.length);
            for (int i = st.length; i < len; ++i) {
                Return2[i] = EncBytes.C_SPACE;
            }
        }
    }

    @Override
    public int toByteArray(byte[] Return2) {
        return this.bigCobDecValue().toByteArray(Return2, NumericVar.encoded_digits);
    }

    @Override
    public boolean isOverflow(CobolNum dest, int destIntPart) {
        switch (dest.type) {
            case 0: {
                if (Float.isInfinite(this.flValue) || Float.isNaN(this.flValue)) {
                    return true;
                }
                if (this.flValue < 0.0f) {
                    return this.flValue < (float)factMin[destIntPart];
                }
                return this.flValue > (float)factMax[destIntPart];
            }
            case 1: {
                if (Float.isInfinite(this.flValue) || Float.isNaN(this.flValue)) {
                    return true;
                }
                if (this.flValue < 0.0f) {
                    return (double)this.flValue < -factDouble[destIntPart];
                }
                return (double)this.flValue > factDouble[destIntPart];
            }
            case 2: 
            case 3: {
                return Float.isInfinite(this.flValue) || Float.isNaN(this.flValue);
            }
        }
        return false;
    }

    @Override
    public boolean isOverflowByte(CobolNum dest, int nBytes, boolean signed) {
        return Float.isInfinite(this.flValue) || Float.isNaN(this.flValue);
    }

    @Override
    public int compareTo(CobolNum val) {
        switch (val.type) {
            case 3: {
                return CobolFloat.evalCompare(this.flValue - val.floatValue());
            }
            case 0: 
            case 1: 
            case 2: {
                return CobolFloat.evalCompare(this.doubleValue() - val.doubleValue());
            }
        }
        return 0;
    }

    @Override
    public int compareTo(long val, int scale) {
        return CobolFloat.evalCompare(this.flValue - CobolFloat.floatValue(val, scale));
    }

    @Override
    public long getUnscaledLong(boolean[] overflow) {
        long Return2 = this.bigCobDecValue().setScale(0).unscaled18Digits(0);
        boolean bl = overflow[0] = this.bigCobDecValue().precision() > 18;
        if (!overflow[0]) {
            int sc = this.bigCobDecValue().scale();
            Return2 = this.bigCobDecValue().unscaled18Digits(sc);
            if (sc < 0) {
                Return2 *= fact[-sc];
            }
        }
        return Return2;
    }

    @Override
    public long getUnscaledLong() {
        return this.getUnscaledLong(dummy);
    }

    @Override
    public void toBinaryByteArray(Memory Return2, int start, int len) {
        int n = Float.floatToIntBits(this.flValue);
        for (int i = len - 1; i > 0; --i) {
            Return2.put(start++, (byte)(n >>> (i << 3)));
        }
        Return2.put(start, (byte)(n & 0xFF));
    }

    @Override
    public void toBinaryByteArray(byte[] Return2, int start, int len) {
        int n = Float.floatToIntBits(this.flValue);
        for (int i = len - 1; i > 0; --i) {
            Return2[start++] = (byte)(n >>> (i << 3));
        }
        Return2[start] = (byte)(n & 0xFF);
    }

    @Override
    public void setSizeDigit(int intPart, int decPart) {
    }

    @Override
    public void setSizeByteUnsigned(int nBytes) {
    }

    @Override
    public void setSizeByteSigned(int nBytes) {
    }

    @Override
    public void setScale(int scale, boolean rounding, boolean lenInBytes) {
    }

    @Override
    public final void roundUpIfNeeded(int scaleDiff) {
    }

    @Override
    public int scale() {
        return -1;
    }

    @Override
    public int precision() {
        return -1;
    }

    @Override
    public int signum() {
        return (int)Math.signum(this.flValue);
    }

    @Override
    public void negateMe() {
        this.flValue = -this.flValue;
    }

    @Override
    public CobolNum negate() {
        return new CobolFloat(-this.flValue);
    }

    @Override
    public void shift(int tenExp) {
        this.flValue = tenExp < 0 ? (this.flValue /= (float)fact[-tenExp]) : (this.flValue *= (float)fact[tenExp]);
    }

    @Override
    public String toString() {
        return Float.toString(this.flValue);
    }

    @Override
    public int shortValue() {
        return (short)this.flValue;
    }

    @Override
    public int intValue() {
        return (int)this.flValue;
    }

    @Override
    public long longValue() {
        return (long)this.flValue;
    }

    @Override
    public int shortValue(boolean rounding) {
        if (rounding) {
            return (short)Math.round(this.flValue);
        }
        return (short)this.flValue;
    }

    @Override
    public int intValue(boolean rounding) {
        if (rounding) {
            return Math.round(this.flValue);
        }
        return (int)this.flValue;
    }

    @Override
    public long longValue(boolean rounding) {
        if (rounding) {
            return Math.round(this.flValue);
        }
        return (long)this.flValue;
    }

    @Override
    public CobolNum integerFunc() {
        return new CobolFloat((float)Math.floor(this.flValue));
    }

    @Override
    public CobolNum integerPart() {
        if (this.flValue < 0.0f) {
            return new CobolFloat((float)Math.ceil(this.flValue));
        }
        return new CobolFloat((float)Math.floor(this.flValue));
    }
}

