/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.math.BigCobolDec;
import com.iscobol.rts.Factory;
import com.iscobol.rts.SignEncOpt;
import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;

public final class Pic9Comp_3
extends NumericVar
implements SignEncOpt {
    private static final long serialVersionUID = 123L;
    private final byte positive;
    private final byte unsigned;
    private static final byte[] UNSIGNED = new byte[]{15, 12};
    private static final byte[] POSITIVES = new byte[]{15, 12, 12, 11, 12};
    private static final byte NEGATIVE = 13;

    private static byte getPositive(int opt) {
        switch (opt) {
            case 0: {
                return POSITIVES[0];
            }
            case 1: {
                return POSITIVES[1];
            }
            case 3: {
                return POSITIVES[3];
            }
            case 4: {
                return POSITIVES[4];
            }
        }
        return POSITIVES[2];
    }

    private static byte getUnsigned(int opt) {
        switch (opt) {
            case 5: {
                return UNSIGNED[1];
            }
        }
        return UNSIGNED[0];
    }

    public Pic9Comp_3(byte[] m, int i, int il, int dl, boolean s, int[] dimSize, int[] dim, String name, int opt, boolean pComma) {
        super(m, i, il, dl, s, (il + dl) / 2 + 1, dimSize, dim, name, pComma);
        this.positive = Pic9Comp_3.getPositive(opt);
        this.unsigned = Pic9Comp_3.getUnsigned(opt);
        if (m != null) {
            this.updateCache(m, this.theValue);
        }
    }

    public Pic9Comp_3(CobolVar par, int i, int il, int dl, boolean s, int[] dimSize, int[] dim, String name, int opt, boolean pComma) {
        super(par, i, il, dl, s, (il + dl) / 2 + 1, dimSize, dim, name, pComma);
        this.positive = Pic9Comp_3.getPositive(opt);
        this.unsigned = Pic9Comp_3.getUnsigned(opt);
    }

    @Override
    int getAlphaBuffSize() {
        return super.getAlphaBuffSize() + 1;
    }

    private void putBDToMem(byte[] mem, BigCobolDec _bcd) {
        int i = this.end - 1;
        BigCobolDec val = new BigCobolDec(_bcd);
        int b = val.isNegative() ? 13 : (this.signed ? (int)this.positive : (int)this.unsigned);
        byte nibble = val.getDecDigit(0);
        val.shift(-1);
        b = (byte)(b | (byte)(nibble << 4));
        mem[i--] = b;
        while (i >= this.curOffset) {
            nibble = val.getDecDigit(0);
            val.shift(-1);
            b = nibble;
            nibble = val.getDecDigit(0);
            val.shift(-1);
            b = (byte)(b | (byte)(nibble << 4));
            mem[i--] = b;
        }
    }

    private void putLongToMem(byte[] mem, long val) {
        int b;
        int i = this.end - 1;
        if (val < 0L) {
            val = -val;
            b = 13;
        } else {
            b = this.signed ? (int)this.positive : (int)this.unsigned;
        }
        byte nibble = (byte)(val % 10L);
        val /= 10L;
        b = (byte)(b | (byte)(nibble << 4));
        mem[i--] = b;
        while (i >= this.curOffset) {
            nibble = (byte)(val % 10L);
            b = nibble;
            nibble = (byte)((val /= 10L) % 10L);
            val /= 10L;
            b = (byte)(b | (byte)(nibble << 4));
            mem[i--] = b;
        }
    }

    @Override
    void updateMemory(byte[] mem, CobolNum cn) {
        if (this.intLen + this.decLen <= 18) {
            this.putLongToMem(mem, cn.getUnscaledLong());
        } else {
            this.putBDToMem(mem, cn.bigCobDecValue());
        }
    }

    @Override
    void updateMemory(byte[] mem) {
        if (this.intLen + this.decLen <= 18) {
            this.putLongToMem(mem, this.num().getUnscaledLong());
        } else {
            this.putBDToMem(mem, this.num().bigCobDecValue());
        }
    }

    @Override
    public void defaultInitialize() {
        this.theValue.lnUnscValue = 0L;
        byte[] mem = this.getMemory();
        Factory.myFill(mem, this.curOffset, this.end, (byte)0);
        mem[this.end - 1] = this.signed ? this.positive : this.unsigned;
    }

    @Override
    void updateCache(byte[] mem, CobolNum cn) {
        if (this.intLen + this.decLen <= 18) {
            cn.set(this.getLongFromMem(mem), this.decLen);
        } else {
            cn.set(this.getBDFromMem(mem));
        }
    }

    private long getLongFromMem(byte[] mem) {
        int i = this.end;
        long Return2 = 0L;
        long decFact = 1L;
        boolean negative = this.myIsNegative();
        Return2 = mem[--i] >> 4 & 0xF;
        decFact = 10L;
        --i;
        while (i >= this.curOffset) {
            Return2 += (long)(mem[i] & 0xF) * decFact;
            Return2 += (long)(mem[i] >> 4 & 0xF) * (decFact *= 10L);
            decFact *= 10L;
            --i;
        }
        if (negative) {
            return -Return2;
        }
        return Return2;
    }

    private BigCobolDec getBDFromMem(byte[] mem) {
        int i = this.end;
        boolean negative = this.myIsNegative();
        char[] cNum = new char[this.intLen + this.decLen + 2];
        int cnIdx = cNum.length;
        cNum[--cnIdx] = (char)(mem[--i] >> 4 & 0xF);
        --i;
        while (i >= this.curOffset) {
            cNum[--cnIdx] = (char)(mem[i] & 0xF);
            cNum[--cnIdx] = (char)(mem[i] >> 4 & 0xF);
            --i;
        }
        return Pic9Comp_3.getBD(cNum, cnIdx, negative, this.decLen);
    }

    @Override
    public boolean isNumeric() {
        byte[] mem = this.getMemory();
        int l = this.intLen + this.decLen;
        int k = this.curOffset;
        for (int i = 0; k < this.end && i < l; ++k, ++i) {
            byte c = (byte)(mem[k] >> 4 & 0xF);
            if (c < 0 || c > 9) {
                return false;
            }
            if (++i >= l || (c = (byte)(mem[k] & 0xF)) >= 0 && c <= 9) continue;
            return false;
        }
        byte c = (byte)(mem[this.end - 1] & 0xF);
        return c == this.positive || c == 13 || c == this.unsigned;
    }

    @Override
    public boolean isNegative() {
        return this.isNumeric() && this.myIsNegative();
    }

    private boolean myIsNegative() {
        return (this.getMemory()[this.end - 1] & 0xF) == 13;
    }
}

