/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.rts.Config;
import com.iscobol.rts.Native;
import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVar;
import com.iscobol.types.PicBinary;

public abstract class PicNativeBinary
extends PicBinary
implements Native {
    private boolean bigEndian = false;
    private static final long serialVersionUID = 123L;

    public PicNativeBinary(byte[] mem, int offs, int pl, boolean s, int il, int dl, int[] dimSize, int[] dim, String name, boolean pComma) {
        super(mem, offs, pl, s, il, dl, dimSize, dim, name, pComma);
        this.bigEndian = !Config.getProperty("iscobol.little_endian", Config.LITTLE_ENDIAN);
    }

    public PicNativeBinary(CobolVar par, int offs, int pl, boolean s, int il, int dl, int[] dimSize, int[] dim, String name, boolean pComma) {
        super(par, offs, pl, s, il, dl, dimSize, dim, name, pComma);
        this.bigEndian = !Config.getProperty("iscobol.little_endian", Config.LITTLE_ENDIAN);
    }

    public PicNativeBinary(long initValue, int pl, boolean s, int il, int dl, boolean pComma) {
        super(initValue, pl, s, il, dl, pComma);
    }

    @Override
    void updateMemory(byte[] mem, CobolNum cn) {
        this.internalSet(mem, cn.getUnscaledLong());
    }

    @Override
    void updateMemory(byte[] mem) {
        this.internalSet(mem, this.num().getUnscaledLong());
    }

    protected void internalSet(byte[] buf, long unscaled) {
        if (!this.signed && unscaled < 0L) {
            unscaled = -unscaled;
        }
        if (buf != null) {
            int i = 8 - this.len + 1;
            if (this.bigEndian) {
                int start = this.curOffset;
                while (start < this.end - 1) {
                    int r_shift = 64 - 8 * i;
                    buf[start] = (byte)(unscaled >>> r_shift);
                    ++start;
                    ++i;
                }
                buf[start] = (byte)unscaled;
            } else {
                int start = this.end - 1;
                while (start > this.curOffset) {
                    int r_shift = 64 - 8 * i;
                    buf[start] = (byte)(unscaled >>> r_shift);
                    --start;
                    ++i;
                }
                buf[start] = (byte)unscaled;
            }
        }
    }

    @Override
    void updateCache(byte[] mem, CobolNum cn) {
        cn.set(this.getLongFromMem(mem), this.decLen);
    }

    @Override
    protected long getLongFromMem(byte[] buf) {
        long unscaled;
        if (buf != null) {
            int i = 8 - this.len + 1;
            unscaled = 0L;
            if (this.bigEndian) {
                int start = this.curOffset;
                while (start < this.end - 1) {
                    int l_shift = 64 - 8 * i;
                    unscaled |= (long)(buf[start] & 0xFF) << l_shift;
                    ++start;
                    ++i;
                }
                unscaled |= (long)(buf[start] & 0xFF);
                if (this.len < 8 && this.signed) {
                    boolean negative;
                    boolean bl = negative = (buf[this.curOffset] >>> 7 & 1) == 1;
                    if (negative) {
                        unscaled -= this.u_max;
                    }
                }
            } else {
                int start = this.end - 1;
                while (start > this.curOffset) {
                    int l_shift = 64 - 8 * i;
                    unscaled |= (long)(buf[start] & 0xFF) << l_shift;
                    --start;
                    ++i;
                }
                unscaled |= (long)(buf[start] & 0xFF);
                if (this.len < 8 && this.signed) {
                    boolean negative;
                    boolean bl = negative = (buf[this.end - 1] >>> 7 & 1) == 1;
                    if (negative) {
                        unscaled -= this.u_max;
                    }
                }
            }
        } else {
            unscaled = this.value.getUnscaledLong();
        }
        if (!this.signed && unscaled < 0L) {
            unscaled = -unscaled;
        }
        return unscaled;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }
}

