/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVar;
import com.iscobol.types.FloatingPointConverter;
import com.iscobol.types.PicNativeBinary;

public final class PicNativeFloat
extends PicNativeBinary {
    private static final long serialVersionUID = 123L;

    public PicNativeFloat(byte[] mem, int offs, int phisicLen, int[] dimSize, int[] dim, String name, boolean pComma) {
        super(mem, offs, phisicLen, true, -1, -3, dimSize, dim, name, pComma);
    }

    public PicNativeFloat(CobolVar par, int offs, int phisicLen, int[] dimSize, int[] dim, String name, boolean pComma) {
        super(par, offs, phisicLen, true, -1, -3, dimSize, dim, name, pComma);
    }

    @Override
    int getAlphaBuffSize() {
        return 48;
    }

    @Override
    void updateMemory(byte[] mem, CobolNum cn) {
        this.internalSet(mem, FloatingPointConverter.floatToIntBits(cn.floatValue()));
    }

    @Override
    void updateMemory(byte[] mem) {
        this.internalSet(mem, FloatingPointConverter.floatToIntBits(this.num().floatValue()));
    }

    @Override
    void updateCache(byte[] mem, CobolNum cn) {
        cn.set(FloatingPointConverter.intBitsToFloat((int)this.getLongFromMem(mem)));
    }

    @Override
    public boolean set(long unscaled, int scale, boolean rounded, boolean checkOverflow) {
        if (this.isFinal) {
            return true;
        }
        this.theValue.set(unscaled, scale);
        this.memory.setUnsync(this);
        return false;
    }

    @Override
    public boolean set(CobolNum d, boolean rounded, boolean checkOverflow) {
        if (this.isFinal) {
            return true;
        }
        if (checkOverflow && d == CobolNum.INFINITY) {
            return true;
        }
        this.theValue.set(d, rounded, this.lenInBytes);
        this.memory.setUnsync(this);
        return false;
    }
}

