/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.rts.Factory;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVar;
import com.iscobol.types.EncBytes;
import com.iscobol.types.MemMan;
import com.iscobol.types.NumericVar;
import com.iscobol.types.Pic1;
import com.iscobol.types.PicDisplay;
import com.iscobol.types.PicN;
import com.iscobol.types.PicNumEdit;
import java.io.UnsupportedEncodingException;

public class PicX
extends CobolVar {
    private static final long serialVersionUID = 123L;
    private static final NumberFormatException myNumException = new NumberFormatException();

    public static PicX literal(String str) {
        return new PicX(str);
    }

    public PicX(byte[] m, int i, int l, int[] dimSize, int[] dim, String n, boolean pComma, boolean isJust) {
        super(m, i, l, dimSize, dim, n, pComma, isJust);
    }

    public PicX(CobolVar par, int i, int l, int[] dimSize, int[] dim, String n, boolean pComma, boolean isJust) {
        super(par, i, l, dimSize, dim, n, pComma, isJust);
    }

    public PicX(String value) {
        super(value);
        this.isFinal = true;
    }

    public PicX(byte[] value) {
        this(value, true);
    }

    public PicX(byte[] value, boolean fnl) {
        super(value);
        this.isFinal = fnl;
    }

    public PicX(int ch) {
        super(ch);
        this.isFinal = true;
    }

    PicX(MemMan m, int start, int offset, String name, boolean dComma) {
        super(m, start, offset, name, dComma);
        this.isFinal = false;
    }

    public PicX at(int[] idxs) {
        return (PicX)this.intAt(idxs);
    }

    public PicX at(int ix) {
        return (PicX)this.intAt(ix);
    }

    public PicX atNC(int[] idxs) {
        return (PicX)this.intAtNC(idxs);
    }

    public PicX atNC(int ix) {
        return (PicX)this.intAtNC(ix);
    }

    public PicX setDepending(CobolVar depOn) {
        return (PicX)this.intSetDepending(depOn);
    }

    public PicX byVal() {
        this.byValue = true;
        return this;
    }

    public PicX byRef() {
        this.byValue = false;
        return this;
    }

    public PicX copy() {
        return (PicX)this.intCopy();
    }

    public boolean set(CobolNum d, boolean rounded, boolean checkOverflow) {
        throw new IscobolRuntimeException(4, " set(CobolNum, boolean, boolean)");
    }

    public PicX set(CobolVar value) {
        value.moveTo(this);
        return this;
    }

    @Override
    public boolean set(Object value) {
        if (value != null) {
            return this.set(value.toString(), true);
        }
        throw new NullPointerException();
    }

    @Override
    public boolean set(String value) {
        return this.set(value, true);
    }

    @Override
    public boolean set(boolean value) {
        return this.set(value ? "1" : "0", true);
    }

    @Override
    public boolean set(byte value) {
        return this.set("" + (char)value, true);
    }

    @Override
    public boolean set(char value) {
        return this.set("" + value, true);
    }

    @Override
    public boolean set(short value) {
        return this.set("" + value, true);
    }

    @Override
    public boolean set(int value) {
        return this.set("" + value, true);
    }

    @Override
    public boolean set(long value) {
        return this.set("" + value, true);
    }

    @Override
    public boolean set(float value) {
        return this.set("" + value, true);
    }

    @Override
    public boolean set(double value) {
        return this.set("" + value, true);
    }

    @Override
    public boolean toboolean() {
        String me = this.toString();
        return "1".equals(me) || "true".equalsIgnoreCase(me);
    }

    @Override
    public byte tobyte() {
        byte Return2 = this.getMemory()[this.getOffset()];
        return Return2;
    }

    @Override
    public char tochar() {
        String s = this.toString();
        char Return2 = s.length() > 0 ? s.charAt(0) : (char)'\u0000';
        return Return2;
    }

    @Override
    public short toshort() {
        short Return2;
        try {
            Return2 = Short.parseShort(this.toString().trim());
        }
        catch (NumberFormatException e) {
            Return2 = 0;
        }
        return Return2;
    }

    @Override
    public int toint() {
        int Return2;
        try {
            Return2 = Integer.parseInt(this.toString().trim());
        }
        catch (NumberFormatException e) {
            Return2 = 0;
        }
        return Return2;
    }

    public long tolongChecked() throws NumberFormatException {
        long Return2 = 0L;
        byte[] src = this.getMemory();
        int end = this.getEnd();
        for (int idx = this.getOffset(); idx < end; ++idx) {
            int digit = src[idx] & 0xF;
            if (digit > 9) {
                throw myNumException;
            }
            Return2 = Return2 * 10L + (long)digit;
        }
        return Return2;
    }

    @Override
    public long tolong() {
        try {
            return this.tolongChecked();
        }
        catch (NumberFormatException _ex) {
            return 0L;
        }
    }

    @Override
    public float tofloat() {
        float Return2;
        try {
            Return2 = Float.parseFloat(this.toString().trim());
        }
        catch (NumberFormatException e) {
            Return2 = 0.0f;
        }
        return Return2;
    }

    @Override
    public double todouble() {
        double Return2;
        try {
            Return2 = Double.parseDouble(this.toString().trim());
        }
        catch (NumberFormatException e) {
            Return2 = 0.0;
        }
        return Return2;
    }

    @Override
    public boolean isAlphabetic() {
        char[] mem = this.toString().toCharArray();
        for (int i = 0; i < mem.length; ++i) {
            if (mem[i] == ' ' || Character.isLetter(mem[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAlphabeticUpper() {
        char[] mem = this.toString().toCharArray();
        for (int i = 0; i < mem.length; ++i) {
            if (mem[i] == ' ' || Character.isUpperCase(mem[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAlphabeticLower() {
        char[] mem = this.toString().toCharArray();
        for (int i = 0; i < mem.length; ++i) {
            if (mem[i] == ' ' || Character.isLowerCase(mem[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNumeric() {
        char[] mem = this.toString().toCharArray();
        if (mem.length == 0) {
            return false;
        }
        for (int i = 0; i < mem.length; ++i) {
            if (Character.isDigit(mem[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean moveConv(NumericVar dest) {
        boolean[] error = new boolean[1];
        dest.set(CobolNum.valueOf(this.toString(), this.isDecPointComma, error), false, false);
        return error[0];
    }

    public boolean moveConv(PicNumEdit dest) {
        boolean[] error = new boolean[1];
        dest.set(CobolNum.valueOf(this.toString(), this.isDecPointComma, error), false, false);
        return error[0];
    }

    @Override
    public CobolVar moveTo(CobolVar dest) {
        int len = this.getLen();
        dest.allocMemory(len);
        dest.set(this.getMemory(), this.getOffset(), len, dest.getLen(), true);
        dest.dynSet(this);
        return this;
    }

    @Override
    public CobolVar moveTo(PicX dest) {
        dest.set(this);
        return this;
    }

    @Override
    public CobolVar moveTo(PicN dest) {
        dest.set(this);
        return this;
    }

    public CobolVar moveTo(Pic1 dest) {
        dest.set(this.toString());
        return this;
    }

    @Override
    void internalSet(CobolVar cv) {
        cv.moveTo(this);
    }

    protected void set(NumericVar nv) {
        int nvLen = nv.intLength() + nv.scale();
        int len = Math.max(this.getLength(), nvLen);
        if (nvLen < 0) {
            nvLen = len;
        }
        byte[] src = new byte[len];
        nv.num().toCobolByteArray(src, len);
        int d = len - nvLen;
        if (d > 0) {
            if (this.isJustified) {
                Factory.myFill(src, 0, d, fill);
                this.set(src, 0, len, true);
            } else {
                this.set(src, d, nvLen, true);
            }
        } else {
            this.set(src, 0, len, true);
        }
    }

    protected void set(PicX px) {
        this.set(px.getMemory(), px.getOffset(), px.getLen(), true);
    }

    protected void set(PicNumEdit pne) {
        this.set(pne.getMemory(), pne.getOffset(), pne.getLen(), true);
    }

    @Override
    public CobolVar moveTo(NumericVar dest) {
        if (this.getLength() > 18) {
            CobolNum num = CobolNum.noo(this.toString());
            dest.set(num);
        } else {
            try {
                dest.set(this.tolongChecked());
            }
            catch (NumberFormatException _ex) {
                try {
                    dest.set(this.tofloat());
                }
                catch (NumberFormatException _ex1) {
                    super.moveTo((CobolVar)dest);
                }
            }
        }
        return this;
    }

    @Override
    public CobolVar moveTo(PicNumEdit dest) {
        if (this.getLength() > 18) {
            CobolNum num = CobolNum.noo(this.toString());
            dest.set(num);
        } else {
            try {
                dest.set(this.tolongChecked());
            }
            catch (NumberFormatException _ex) {
                dest.set(this);
            }
        }
        return this;
    }

    @Override
    public CobolVar moveToX2UD(PicNumEdit dest) {
        dest.setBytes(this.getMemory(), this.getOffset(), this.getLen());
        return this;
    }

    @Override
    public CobolVar moveToX2UD(NumericVar dest) {
        PicX.moveToX2UD(this.getMemory(), this.getOffset(), this.getLen(), dest);
        return this;
    }

    private static void moveToX2UD(String source, NumericVar dest) {
        try {
            byte[] mem = source.getBytes(encoding);
            PicX.moveToX2UD(mem, 0, mem.length, dest);
        }
        catch (UnsupportedEncodingException e) {
            throw new IscobolRuntimeException(e);
        }
    }

    private static void moveToX2UD(byte[] mem1, int offs1, int len1, NumericVar dest) {
        int mlen;
        int i;
        byte[] memory = dest.getMemory();
        int offset = dest.getOffset();
        short intLen = dest.intLen;
        short decLen = dest.decLen;
        if (intLen > len1) {
            for (i = intLen - len1; i > 0; --i) {
                memory[offset++] = EncBytes.C_0;
            }
            mlen = len1;
        } else {
            offs1 += len1 - intLen;
            mlen = intLen;
        }
        for (i = 0; i < mlen; ++i) {
            memory[offset++] = mem1[offs1++];
        }
        if (decLen > 0) {
            for (i = (int)decLen; i > 0; --i) {
                memory[offset++] = EncBytes.C_0;
            }
        }
    }

    public boolean unstring(CobolVar[] delims, boolean[] isAll, CobolVar[] dest, CobolVar[] delimDest, NumericVar[] countDest, NumericVar ptr_var, NumericVar tally_var) {
        return this.unstring(delims, isAll, dest, delimDest, countDest, ptr_var, tally_var, false);
    }

    public boolean unstring(CobolVar[] delims, boolean[] isAll, CobolVar[] dest, CobolVar[] delimDest, NumericVar[] countDest, NumericVar ptr_var, NumericVar tally_var, boolean cudc) {
        String source = this.toString();
        int ptr = 0;
        if (ptr_var != null) {
            ptr = ptr_var.toint();
            if (ptr < 1 || ptr > source.length()) {
                return true;
            }
            source = source.substring(ptr - 1);
        }
        String[] delimsStr = new String[delims.length];
        for (int i = 0; i < delims.length; ++i) {
            delimsStr[i] = this.myToString(delims[i]);
        }
        int tally = 0;
        while (source.length() > 0) {
            if (tally == dest.length) {
                if (tally_var != null) {
                    tally_var.set(tally + tally_var.toint());
                }
                if (ptr_var != null) {
                    ptr_var.set(ptr);
                }
                return true;
            }
            int[] delimIdx = new int[1];
            int idx = PicX.indexOf(source, delimsStr, delimIdx);
            if (idx != -1) {
                if (!cudc || !(dest[tally] instanceof PicDisplay)) {
                    dest[tally].set(source.substring(0, idx));
                } else {
                    PicX.moveToX2UD(source.substring(0, idx), (NumericVar)dest[tally]);
                }
                if (delimDest[tally] != null) {
                    if (!cudc || !(delimDest[tally] instanceof PicDisplay)) {
                        delimDest[tally].set(delimsStr[delimIdx[0]]);
                    } else {
                        PicX.moveToX2UD(delimsStr[delimIdx[0]], (NumericVar)delimDest[tally]);
                    }
                }
                if (countDest[tally] != null) {
                    countDest[tally].set(idx, 0, false, false);
                }
                ++tally;
                int l = delimsStr[delimIdx[0]].length();
                source = source.substring(idx + l);
                ptr += idx + l;
                if (!isAll[delimIdx[0]]) continue;
                while (source.startsWith(delimsStr[delimIdx[0]])) {
                    source = source.substring(l);
                    ptr += l;
                }
                continue;
            }
            if (delimDest[tally] != null) {
                if (!cudc || !(delimDest[tally] instanceof PicDisplay)) {
                    delimDest[tally].setSpace();
                } else {
                    delimDest[tally].setZero();
                }
            }
            int src_len = source.length();
            if (!cudc || !(dest[tally] instanceof PicDisplay)) {
                dest[tally].set(source);
            } else {
                PicX.moveToX2UD(source, (NumericVar)dest[tally]);
            }
            if (countDest[tally] != null) {
                countDest[tally].set(src_len);
            }
            for (int j = tally + 1; j < countDest.length; ++j) {
                if (countDest[j] == null) continue;
                countDest[j].set(0);
            }
            ptr += src_len;
            ++tally;
            break;
        }
        if (tally_var != null) {
            tally_var.set(tally + tally_var.toint());
        }
        if (ptr_var != null) {
            ptr_var.set(ptr);
        }
        return false;
    }

    public boolean unstringByte(CobolVar[] delims, boolean[] isAll, CobolVar[] dest, CobolVar[] delimDest, NumericVar[] countDest, NumericVar ptr_var, NumericVar tally_var) {
        return this.unstringByte(delims, isAll, dest, delimDest, countDest, ptr_var, tally_var, false);
    }

    public boolean unstringByte(CobolVar[] delims, boolean[] isAll, CobolVar[] dest, CobolVar[] delimDest, NumericVar[] countDest, NumericVar ptr_var, NumericVar tally_var, boolean cudc) {
        int ptr;
        CobolVar.ByteBuffer mem = new CobolVar.ByteBuffer(this.getMemory(), this.getOffset(), this.getEnd());
        if (ptr_var != null) {
            ptr = ptr_var.toint();
            if (ptr < 1 || ptr > mem.len) {
                return true;
            }
            ptr += mem.offs;
        } else {
            ptr = mem.offs + 1;
        }
        CobolVar.ByteBuffer[] delimsStr = new CobolVar.ByteBuffer[delims.length];
        for (int i = 0; i < delims.length; ++i) {
            delimsStr[i] = new CobolVar.ByteBuffer(delims[i].getMemory(), delims[i].getOffset(), delims[i].getEnd());
        }
        int tally = 0;
        while (ptr <= mem.end) {
            int l;
            if (tally == dest.length) {
                if (tally_var != null) {
                    tally_var.set(tally + tally_var.toint());
                }
                if (ptr_var != null) {
                    ptr_var.set(ptr - mem.offs);
                }
                return true;
            }
            int[] delimIdx = new int[1];
            int idx = PicX.indexOf(mem, ptr - 1, delimsStr, delimIdx);
            if (idx != -1) {
                l = idx - ptr + 1;
                if (!cudc || !(dest[tally] instanceof PicDisplay)) {
                    dest[tally].setBytes(mem.buf, ptr - 1, l);
                } else {
                    PicX.moveToX2UD(mem.buf, ptr - 1, l, (NumericVar)dest[tally]);
                }
                if (delimDest[tally] != null) {
                    if (!cudc || !(delimDest[tally] instanceof PicDisplay)) {
                        delimDest[tally].setBytes(mem.buf, idx, delimsStr[delimIdx[0]].len);
                    } else {
                        PicX.moveToX2UD(mem.buf, idx, delimsStr[delimIdx[0]].len, (NumericVar)delimDest[tally]);
                    }
                }
                if (countDest[tally] != null) {
                    countDest[tally].set(l);
                }
                ++tally;
                ptr = idx + delimsStr[delimIdx[0]].len + 1;
                if (!isAll[delimIdx[0]]) continue;
                while (PicX.startsWith(mem, ptr - 1, delimsStr[delimIdx[0]])) {
                    ptr += delimsStr[delimIdx[0]].len;
                }
                continue;
            }
            if (delimDest[tally] != null) {
                if (!cudc || !(delimDest[tally] instanceof PicDisplay)) {
                    delimDest[tally].setSpace();
                } else {
                    delimDest[tally].setZero();
                }
            }
            l = mem.end - ptr + 1;
            if (!cudc || !(dest[tally] instanceof PicDisplay)) {
                dest[tally].setBytes(mem.buf, ptr - 1, l);
            } else {
                PicX.moveToX2UD(mem.buf, ptr - 1, l, (NumericVar)dest[tally]);
            }
            if (countDest[tally] != null) {
                countDest[tally].set(l);
            }
            for (int j = tally + 1; j < countDest.length; ++j) {
                if (countDest[j] == null) continue;
                countDest[j].set(0);
            }
            ptr = mem.end + 1;
            ++tally;
            break;
        }
        if (tally_var != null) {
            tally_var.set(tally + tally_var.toint());
        }
        if (ptr_var != null) {
            ptr_var.set(ptr - mem.offs);
        }
        return false;
    }

    public boolean unstring(CobolVar[] dest, NumericVar ptr_var, NumericVar tally_var) {
        return this.unstring(dest, ptr_var, tally_var, false);
    }

    public boolean unstring(CobolVar[] dest, NumericVar ptr_var, NumericVar tally_var, boolean cudc) {
        int tally;
        String source = this.toString();
        int ptr = 0;
        int srcLen = source.length();
        if (ptr_var != null && ((ptr = ptr_var.toint() - 1) < 0 || ptr >= srcLen)) {
            return true;
        }
        for (tally = 0; tally < dest.length && ptr < srcLen; ++tally) {
            int destLen = dest[tally].getLength();
            if (ptr + destLen < srcLen) {
                if (!cudc || !(dest[tally] instanceof PicDisplay)) {
                    dest[tally].set(source.substring(ptr, ptr + destLen));
                } else {
                    PicX.moveToX2UD(source.substring(ptr, ptr + destLen), (NumericVar)dest[tally]);
                }
                ptr += destLen;
                continue;
            }
            if (!cudc || !(dest[tally] instanceof PicDisplay)) {
                dest[tally].set(source.substring(ptr));
            } else {
                PicX.moveToX2UD(source.substring(ptr), (NumericVar)dest[tally]);
            }
            ptr = srcLen;
        }
        if (ptr_var != null) {
            ptr_var.set(ptr + 1);
        }
        if (tally_var != null) {
            tally_var.set(tally + tally_var.toint());
        }
        return ptr < srcLen;
    }

    public boolean unstringByte(CobolVar[] dest, NumericVar ptr_var, NumericVar tally_var) {
        return this.unstringByte(dest, ptr_var, tally_var, false);
    }

    public boolean unstringByte(CobolVar[] dest, NumericVar ptr_var, NumericVar tally_var, boolean cudc) {
        int ptr;
        CobolVar.ByteBuffer mem = new CobolVar.ByteBuffer(this.getMemory(), this.getOffset(), this.getEnd());
        int tally = 0;
        if (ptr_var != null) {
            ptr = ptr_var.toint();
            if (ptr < 1 || ptr > mem.len) {
                return true;
            }
            ptr += mem.offs;
        } else {
            ptr = mem.offs + 1;
        }
        while (tally < dest.length && ptr <= mem.end) {
            int destLen = dest[tally].getLen();
            if (ptr + destLen <= mem.end) {
                if (!cudc || !(dest[tally] instanceof PicDisplay)) {
                    dest[tally].setBytes(mem.buf, ptr - 1, destLen);
                } else {
                    PicX.moveToX2UD(mem.buf, ptr - 1, destLen, (NumericVar)dest[tally]);
                }
                ptr += destLen;
            } else {
                if (!cudc || !(dest[tally] instanceof PicDisplay)) {
                    dest[tally].setBytes(mem.buf, ptr - 1, mem.end - ptr + 1);
                } else {
                    PicX.moveToX2UD(mem.buf, ptr - 1, mem.end - ptr + 1, (NumericVar)dest[tally]);
                }
                ptr = mem.end + 1;
            }
            ++tally;
        }
        if (ptr_var != null) {
            ptr_var.set(ptr - mem.offs);
        }
        if (tally_var != null) {
            tally_var.set(tally + tally_var.toint());
        }
        return ptr <= mem.end;
    }

    @Override
    public void defaultInitialize() {
        this.setSpace();
    }

    @Override
    protected int getCategory() {
        return 2;
    }

    @Override
    public int compareTo(NumericVar nv) {
        int nvLen = nv.intLen + nv.decLen;
        byte[] buf = new byte[48];
        if (nvLen < 0) {
            nvLen = buf.length;
        }
        nv.num().toCobolByteArray(buf, nvLen);
        return this.compareTo(buf, 0, nvLen);
    }

    @Override
    public int compareTo(NumericVar nv, int[] collSeq) {
        int nvLen = nv.intLen + nv.decLen;
        byte[] buf = new byte[48];
        if (nvLen < 0) {
            nvLen = buf.length;
        }
        nv.num().toCobolByteArray(buf, nvLen);
        return this.compareTo(buf, 0, nvLen, collSeq);
    }

    @Override
    void updateMemory(byte[] mem) {
    }

    public int hashCode() {
        return this.toString().trim().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof PicX) {
            return this.compareTo((PicX)o) == 0;
        }
        if (o instanceof String) {
            return this.toString().trim().equals(o);
        }
        return false;
    }

    @Override
    int internalCompare(ICobolVar value) {
        return -((CobolVar)value).compareTo(this);
    }

    public PicX offs(int offs) {
        return (PicX)this.intOffs(offs);
    }

    public PicX offsNC(int offs) {
        return (PicX)this.intOffsNC(offs);
    }
}

