/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.rts.Config;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.types_n.CobolVar;
import java.io.Serializable;

public class ArrayCache
implements RuntimeErrorsNumbers,
Serializable {
    private static final int SIZE = Config.getProperty("iscobol.array_cache", 101);
    private static final long serialVersionUID = 123L;
    private static final int[] empty = new int[SIZE];
    final CobolVar[] cache;
    final int[] indexes;
    final int size;

    public ArrayCache(int dim) {
        this.size = dim < SIZE ? dim : SIZE;
        this.cache = new CobolVar[this.size];
        this.indexes = new int[this.size];
        System.arraycopy(empty, 0, this.indexes, 0, this.size);
    }

    public final void clear() {
        System.arraycopy(empty, 0, this.indexes, 0, this.size);
    }

    public final CobolVar get(int idx) {
        int hash = idx;
        hash &= Integer.MAX_VALUE;
        if (this.indexes[hash %= this.size] == idx) {
            return this.cache[hash];
        }
        return null;
    }

    public final void put(CobolVar c, int idx) {
        int hash = idx;
        hash &= Integer.MAX_VALUE;
        this.indexes[hash %= this.size] = idx;
        this.cache[hash] = c;
    }

    static {
        for (int i = SIZE - 1; i >= 0; --i) {
            ArrayCache.empty[i] = -1;
        }
    }
}

