/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.rts.Factory;
import com.iscobol.rts.Memory;
import com.iscobol.types_n.MemoryUnsafe;

public class MemoryFast
extends Memory {
    private static final long serialVersionUID = 123L;
    private byte[] memory;
    private MemoryUnsafe unsafe;

    public MemoryFast(int sz) {
        this.length = sz;
        this.memory = new byte[this.length];
    }

    public MemoryFast(byte[] m) {
        this.memory = m;
        this.length = m.length;
    }

    @Override
    public void init(long addr, int sz, boolean optmzd) {
        throw new UnsupportedOperationException("MemoryFast.init 1");
    }

    @Override
    public void init(int sz, boolean optmzd) {
        throw new UnsupportedOperationException("MemoryFast.init 2");
    }

    @Override
    public void init(byte[] val, boolean optimized) {
        throw new UnsupportedOperationException("MemoryFast.init 3");
    }

    @Override
    public long getBaseAddress() {
        if (this.unsafe == null) {
            this.unsafe = new MemoryUnsafe();
            this.unsafe.init(this.memory, false);
        } else {
            for (int i = 0; i < this.memory.length; ++i) {
                this.unsafe.put(i, this.memory[i]);
            }
        }
        return this.unsafe.getBaseAddress();
    }

    @Override
    public boolean isOptimized() {
        return true;
    }

    @Override
    public byte get(int offset) {
        return this.memory[offset];
    }

    @Override
    public void put(int offset, byte val) {
        this.memory[offset] = val;
    }

    @Override
    public void fill(byte value) {
        for (int i = this.length - 1; i >= 0; --i) {
            this.memory[i] = value;
        }
    }

    @Override
    public void fill(int offset, int end, byte value) {
        for (int i = offset; i < end; ++i) {
            this.memory[i] = value;
        }
    }

    @Override
    public void fill(int offset, int len, byte[] value) {
        Factory.myFill(this.memory, offset, len, value);
    }

    @Override
    public void set(int dstOffset, byte[] src, int srcOffset, int len) {
        int l = dstOffset;
        int i = 0;
        while (i < len) {
            this.memory[l] = src[srcOffset];
            ++l;
            ++i;
            ++srcOffset;
        }
    }

    @Override
    public void copy(int srcOffset, Memory dst, int dstOffset, int len) {
        dst.set(dstOffset, this.memory, srcOffset, len);
    }

    @Override
    public void finalize() {
        if (this.unsafe != null) {
            this.unsafe.finalize();
        }
    }

    @Override
    public String toString() {
        return new String(this.toByteArray(0, this.length));
    }

    @Override
    public byte[] toByteArray(int offs, int len) {
        if (offs == 0 && len == this.memory.length) {
            return this.memory;
        }
        byte[] b = new byte[len];
        Factory.myArraycopy(this.memory, offs, b, 0, len);
        return b;
    }
}

