/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.web;

import com.iscobol.io.BaseFile;
import com.iscobol.java.internal.IsCobol;
import com.iscobol.logger.ServletLogger;
import com.iscobol.rts.CallOverflowException;
import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import com.iscobol.rts.HTTPHandler;
import com.iscobol.rts.HTTPSessionInfo;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.RuntimeEnvironmentType;
import com.iscobol.rts.RuntimeInfo;
import com.iscobol.rts.SOAPEnvelopeParser;
import com.iscobol.rts.StopRunException;
import com.iscobol.web.MultipartRequest;
import com.iscobol.web.ServletSessionInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.SessionTrackingMode;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class IscobolServletCall
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.run(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.run(request, response);
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.run(request, response);
    }

    public void doDelete(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.run(request, response);
    }

    public void doPatch(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.run(request, response);
    }

    public void doOptions(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.run(request, response);
    }

    public void doTrace(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.run(request, response);
    }

    public void doHead(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.run(request, response);
    }

    private void run(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Object attr;
        HttpSession session = request.getSession();
        String sessionId = session.getId();
        ServletContext ctx = session.getServletContext();
        Set tmds = ctx.getEffectiveSessionTrackingModes();
        if (tmds.size() == 1 && tmds.iterator().next() == SessionTrackingMode.URL && (attr = session.getAttribute("iscobolServlet.sessionId")) == null) {
            session.setAttribute("iscobolServlet.sessionId", (Object)sessionId);
            String newurl = request.getRequestURL().append(";jsessionid=").append(sessionId).toString();
            response.sendRedirect(newurl);
            return;
        }
        IscobolSystem.set(HTTPSessionInfo.class, new ServletSessionInfo(sessionId, response));
        String contentType = request.getHeader("Content-Type");
        String soapAction = request.getHeader("SOAPAction");
        if (contentType != null && (contentType.startsWith("application/soap+xml") || contentType.startsWith("text/xml") && soapAction != null)) {
            this.runSoap(request, response);
        } else {
            Charset cs;
            String ce = request.getCharacterEncoding();
            if (ce == null) {
                ce = Config.getProperty(".http.form.encoding", null);
            }
            if (ce != null) {
                try {
                    cs = Charset.forName(ce);
                    request.setCharacterEncoding(ce);
                    response.setCharacterEncoding(ce);
                }
                catch (UnsupportedEncodingException e) {
                    cs = null;
                }
            } else {
                cs = null;
            }
            this.runDefault(request, response, cs);
        }
    }

    private String getFaultEnvelope(String value, String reason) {
        StringBuffer Return2 = new StringBuffer();
        Return2.append("<?xml version='1.0' encoding='utf-8'?>");
        Return2.append("<Envelope xmlns=\"http://www.w3.org/2003/05/soap-envelope\">");
        Return2.append("<Header>");
        Return2.append("<Action xmlns=\"http://www.w3.org/2005/08/addressing\">");
        Return2.append("http://www.w3.org/2005/08/addressing/soap/fault");
        Return2.append("</Action>");
        Return2.append("</Header>");
        Return2.append("<Body>");
        Return2.append("<Fault>");
        Return2.append("<Code>");
        Return2.append("<Value>");
        Return2.append(value);
        Return2.append("</Value>");
        Return2.append("</Code>");
        Return2.append("<Reason>");
        Return2.append("<Text>");
        Return2.append(reason);
        Return2.append("</Text>");
        Return2.append("</Reason>");
        Return2.append("<Detail/>");
        Return2.append("</Fault>");
        Return2.append("</Body>");
        Return2.append("</Envelope>");
        return Return2.toString();
    }

    private byte[] getInput(HttpServletRequest request) throws IOException {
        ServletInputStream inputStream = request.getInputStream();
        int inpLen = request.getContentLength();
        byte[] input = null;
        if (inpLen > 0) {
            int rc0;
            input = new byte[inpLen];
            int rc = 0;
            while ((rc0 = inputStream.read(input, rc, input.length - rc)) > 0 && (rc += rc0) < inpLen) {
            }
        } else {
            int rc;
            byte[] buffer = new byte[1024];
            while ((rc = inputStream.read(buffer, 0, buffer.length)) > 0) {
                if (input == null) {
                    if (rc == buffer.length) {
                        input = buffer;
                        buffer = new byte[buffer.length];
                        continue;
                    }
                    input = new byte[rc];
                    System.arraycopy(buffer, 0, input, 0, rc);
                    continue;
                }
                byte[] newb = new byte[input.length + rc];
                System.arraycopy(input, 0, newb, 0, input.length);
                System.arraycopy(buffer, 0, newb, input.length, rc);
                input = newb;
            }
        }
        return input;
    }

    private static void logRequest(ServletLogger logger, byte[] input, HttpServletRequest request) {
        logger.reportLog("===============================");
        logger.reportLog("Request received at " + ServletLogger.reportTimestamp());
        logger.reportLog("Begin request id: " + request.getSession().getId());
        logger.reportLog("Request headers:");
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = request.getHeader(key);
            logger.reportLog(key + "=" + value);
        }
        Map params = request.getParameterMap();
        if (params.isEmpty()) {
            logger.reportLog("Request parameters: no parameters");
        } else {
            logger.reportLog("Request parameters:");
            for (String key : params.keySet()) {
                String[] value = (String[])params.get(key);
                StringBuilder sb = new StringBuilder();
                sb.append(key);
                sb.append("=");
                if (value.length > 0) {
                    if (value.length > 1) {
                        sb.append("{");
                        sb.append(value[0]);
                        for (int i = 1; i < value.length; ++i) {
                            sb.append(",");
                            sb.append(value[i]);
                        }
                        sb.append("}");
                    } else {
                        sb.append(value[0]);
                    }
                }
                logger.reportLog(sb.toString());
            }
        }
        String contentType = request.getContentType();
        logger.reportLog("Request body: content-type " + contentType);
        if (input != null) {
            String inputStr = new String(input);
            if (IscobolServletCall.isXmlContentType(contentType)) {
                inputStr = ServletLogger.prettyPrint(inputStr);
            }
            logger.reportLog(inputStr);
        }
        logger.reportLog("");
    }

    private static boolean isXmlContentType(String contentType) {
        String[] ss;
        return contentType != null && (ss = contentType.split("\\/")).length > 1 && ss[1].startsWith("xml");
    }

    private static void logResponse(ServletLogger logger, String responseText, boolean isXml) {
        logger.reportLog("Output Response generated at " + ServletLogger.reportTimestamp());
        if (isXml) {
            responseText = ServletLogger.prettyPrint(responseText);
        }
        logger.reportLog(responseText);
        logger.reportLog("");
    }

    private void runSoap(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String cobolProgram;
        byte[] input = this.getInput(request);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(input);
        try {
            SOAPEnvelopeParser sep = new SOAPEnvelopeParser(inputStream);
            ((InputStream)inputStream).reset();
            cobolProgram = sep.getMethodName();
        }
        catch (Exception _ex) {
            ServletLogger logger = ServletLogger.getInstance("iscobol.soap.log", "iscobol.soap.log.folder", null, request.getSession().getId());
            if (logger != null) {
                logger.reportLog("======================================");
                logger.reportLog(ServletLogger.reportTimestamp() + ": isCOBOL SOAP Exception: the SOAP envelope seems incorrect: " + _ex.toString());
                String inputXML = new String(input);
                logger.reportLog("Input Request");
                logger.reportLog("Request headers:");
                Enumeration headerNames = request.getHeaderNames();
                while (headerNames.hasMoreElements()) {
                    String key = (String)headerNames.nextElement();
                    String value = request.getHeader(key);
                    logger.reportLog(key + "=" + value);
                }
                logger.reportLog("Request body:");
                logger.reportLog(ServletLogger.prettyPrint(inputXML));
                logger.reportLog("======================================");
            }
            _ex.printStackTrace();
            response.sendError(500, this.getFaultEnvelope("The SOAP envelope seems incorrect", _ex.toString()));
            return;
        }
        ServletLogger logger = ServletLogger.getInstance("iscobol.soap.log", "iscobol.soap.log.folder", cobolProgram, request.getSession().getId());
        if (logger != null) {
            IscobolServletCall.logRequest(logger, input, request);
        }
        String responseText = null;
        if (cobolProgram != null && cobolProgram.length() > 0) {
            try {
                responseText = this.go(cobolProgram, inputStream, request, response, null);
            }
            catch (Throwable _ex) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                _ex.printStackTrace(pw);
                pw.close();
                response.setStatus(500);
                responseText = this.getFaultEnvelope(_ex.getMessage(), sw.toString());
                response.getWriter().println(responseText);
            }
        } else {
            response.setStatus(500);
            responseText = this.getFaultEnvelope("Missing method to call", "The server wasn't able to find any method name in the SOAP envelope");
            response.getWriter().println(responseText);
        }
        if (logger != null && responseText != null) {
            IscobolServletCall.logResponse(logger, responseText, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDefault(HttpServletRequest request, HttpServletResponse response, Charset cs) throws IOException, ServletException {
        int extension;
        int uriLastChar;
        int parStart;
        String cobolProgram;
        String uri;
        int lastSlash;
        String origUri = request.getRequestURI();
        int idx = origUri.toLowerCase().indexOf(";jsessionid");
        if (idx >= 0) {
            origUri = origUri.substring(0, idx);
        }
        if ((lastSlash = (uri = origUri).lastIndexOf(47)) >= 0) {
            uri = uri.substring(lastSlash + 1);
        }
        if ((cobolProgram = (parStart = uri.indexOf(40) + 1) > 0 && uri.charAt(uriLastChar = uri.length() - 1) == ')' ? uri.substring(parStart, uriLastChar) : ((extension = uri.indexOf(46)) > 0 ? uri.substring(0, extension) : uri)).length() > 0) {
            if (request.getParameter("wsdl") != null) {
                String wsdlLocation = Config.getProperty("iscobol.soap.wsdl.location", null);
                if (wsdlLocation != null) {
                    if (new File(wsdlLocation, cobolProgram + ".wsdl").exists()) {
                        FileInputStream inputStream = new FileInputStream(wsdlLocation + File.separator + cobolProgram + ".wsdl");
                        response.setHeader("Content-Disposition", "attachment; filename=" + cobolProgram + ".wsdl");
                        try {
                            int c;
                            while ((c = inputStream.read()) != -1) {
                                response.getWriter().write(c);
                            }
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            response.getWriter().close();
                        }
                    } else {
                        response.sendError(404, cobolProgram + ".wsdl not found");
                    }
                }
            } else {
                String responseText;
                ServletLogger logger;
                block19: {
                    logger = ServletLogger.getInstance("iscobol.rest.log", "iscobol.rest.log.folder", cobolProgram, request.getSession().getId());
                    ByteArrayInputStream inputStream = null;
                    if (logger != null) {
                        byte[] input = this.getInput(request);
                        IscobolServletCall.logRequest(logger, input, request);
                        if (input != null) {
                            inputStream = new ByteArrayInputStream(input);
                        }
                    }
                    responseText = null;
                    try {
                        responseText = this.go(cobolProgram, inputStream, request, response, cs);
                    }
                    catch (Throwable _ex) {
                        responseText = this.getError(_ex);
                        if (response.isCommitted()) break block19;
                        response.sendError(404, responseText);
                    }
                }
                if (logger != null && responseText != null) {
                    IscobolServletCall.logResponse(logger, responseText, false);
                }
            }
        } else {
            throw new IscobolRuntimeException(102, origUri);
        }
    }

    private File getDir(String dir) {
        int[] fileType = new int[1];
        File Return2 = null;
        if (!(dir == null || (Return2 = new File(dir = BaseFile.getFullPaths(dir, fileType)[0])).isDirectory() && Return2.exists())) {
            Return2 = null;
        }
        if (!(Return2 != null || (dir = System.getProperty("java.io.tmpdir")) == null || (Return2 = new File(dir)).isDirectory() && Return2.exists())) {
            Return2 = null;
        }
        if (Return2 == null) {
            Return2 = new File(".");
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String go(String cobolProgram, InputStream inpStream, HttpServletRequest request, HttpServletResponse response, Charset cs) throws IOException, CallOverflowException, IscobolRuntimeException {
        Map params;
        String responseText = null;
        HashMap<String, String> header = new HashMap<String, String>();
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = request.getHeader(key);
            header.put(key.toLowerCase(), value);
        }
        if (request.getMethod().equals("POST") || request.getMethod().equals("PUT")) {
            String cType = request.getContentType();
            if (cType.startsWith("multipart/form-data")) {
                int max_size = Config.getProperty(".http.upload.max_size", 0x100000);
                File directory = this.getDir(Config.getProperty(".http.upload.directory", null));
                String prefix = Config.getProperty(".http.upload.prefix", null);
                MultipartRequest multi = new MultipartRequest(request, max_size, directory, prefix);
                params = multi.getParameterMap();
            } else {
                params = cType.startsWith("application/x-www-form-urlencoded") ? request.getParameterMap() : request.getParameterMap();
            }
        } else {
            Cookie[] cks;
            params = new HashMap(request.getParameterMap());
            if (Config.getProperty(".http.cookies_as_fields", false) && (cks = request.getCookies()) != null) {
                for (int i = 0; i < cks.length; ++i) {
                    params.put(cks[i].getName(), cks[i].getValue());
                }
            }
        }
        boolean stateless = Config.getProperty(".http.stateless", false);
        if (inpStream == null) {
            inpStream = request.getInputStream();
        }
        HTTPHandler commArea = new HTTPHandler(params, inpStream, header, cs);
        commArea.setMethod(request.getMethod());
        commArea.setContentType(request.getContentType());
        commArea.setRequest(request);
        commArea.setResponse(response);
        commArea.setSession(request.getSession());
        String cobolProgramPrefix = Config.getProperty(".http.servlet.prefix", null);
        String wcobolProgram = cobolProgramPrefix == null ? new String(cobolProgram) : cobolProgramPrefix.concat(cobolProgram);
        boolean stopRun = false;
        try {
            RuntimeInfo.set(RuntimeEnvironmentType.J2EE);
            try {
                IsCobol._call(wcobolProgram, new Object[]{commArea}, false, null, null);
            }
            catch (StopRunException ex) {
                stopRun = true;
            }
            String mimeType = commArea.getOutputMimeType();
            int errnum = commArea.getError();
            boolean isRedirect = commArea.isRedirect();
            if (isRedirect) {
                response.sendRedirect(commArea.getOutputMessage());
            } else if (errnum != 0) {
                response.sendError(errnum, commArea.getOutputMessage());
            } else {
                InputStream is;
                response.setContentType(mimeType);
                Map outHeader = commArea.getOutHeader();
                if (outHeader != null) {
                    Set entries = outHeader.entrySet();
                    for (Map.Entry e2 : entries) {
                        response.addHeader(e2.getKey().toString(), e2.getValue().toString());
                    }
                }
                if ((is = commArea.getOutputBinaryFile()) != null) {
                    int len;
                    ServletOutputStream os = response.getOutputStream();
                    byte[] buff = new byte[1024];
                    while ((len = is.read(buff)) > 0) {
                        os.write(buff, 0, len);
                    }
                    is.close();
                } else {
                    PrintWriter pw = response.getWriter();
                    Reader rdr = commArea.getOutputTextFile();
                    if (rdr != null) {
                        int len;
                        char[] buff = new char[512];
                        while ((len = rdr.read(buff)) > 0) {
                            pw.write(buff, 0, len);
                        }
                        rdr.close();
                    } else {
                        responseText = commArea.getOutputMessage();
                        pw.println(responseText);
                    }
                }
            }
        }
        finally {
            HTTPHandler.remove();
            if (stateless) {
                if (!stopRun) {
                    com.iscobol.java.IsCobol.cancelAll();
                    Factory.stopRun(0, false);
                }
                IscobolSystem.destroyAndFinalizeEnv(Thread.currentThread());
            }
        }
        if (commArea.isSessionInvalidated()) {
            HttpSession s = request.getSession();
            s.invalidate();
        }
        return responseText;
    }

    private String getError(Throwable ex) {
        if (ex.getCause() != null) {
            ex = ex.getCause();
        }
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        String msg = ex.getLocalizedMessage();
        if (msg == null || msg.length() == 0) {
            msg = ex.getClass().getName() + " caught!";
        }
        return msg + "\n" + sw.toString();
    }
}

