/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.web;

import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Factory;
import com.iscobol.rts.HTTPSessionInfo;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.web.IscobolFilter;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class IscobolSessionListener
implements HttpSessionListener {
    private final Logger log;

    public IscobolSessionListener() {
        IscobolSystem.set(HTTPSessionInfo.class, new HTTPSessionInfo("IscobolSessionListener"));
        try {
            this.log = LoggerFactory.get(128);
        }
        finally {
            IscobolSystem.remove(HTTPSessionInfo.class);
        }
    }

    public void sessionCreated(HttpSessionEvent se) {
        if (this.log != null) {
            HttpSession session = se.getSession();
            this.log.info("Session created: " + session);
        }
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        Object ctx = session.getAttribute(IscobolFilter.attrName);
        IscobolSystem.setContext((IscobolSystem.Context)ctx);
        Factory.stopRun(0, false);
        if (this.log != null) {
            this.log.info("Session invalidated: " + session);
        }
        IscobolSystem.unsetContext();
    }
}

