/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.web;

import com.iscobol.web.MultipartRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Part {
    private MultipartRequest inp;
    private final String boundary;
    private String name;
    private String fileName;
    private String fullPathName;
    private String contentType;
    private String value;
    private String prefix;
    private File directory;
    private File tmpFile;
    private boolean inRam;
    private InputStream file;
    private byte[] fileBuffer;

    public Part(MultipartRequest mpr, String n, String v) throws IOException {
        this.inp = mpr;
        this.boundary = null;
        this.name = n;
        this.fileName = null;
        this.fullPathName = null;
        this.contentType = "text/plain";
        this.value = v;
        this.directory = null;
        this.tmpFile = null;
        this.inRam = true;
        this.fileBuffer = this.value.getBytes();
        this.file = new ByteArrayInputStream(this.fileBuffer);
    }

    public Part(MultipartRequest mpr, String n, String f, String c, String b, boolean ram, File dir, String pref) throws IOException {
        this.inp = mpr;
        this.name = n;
        this.fullPathName = f;
        this.contentType = c;
        this.boundary = b;
        this.inRam = ram;
        this.directory = dir;
        String string = this.prefix = pref == null ? "" : pref;
        if (this.fullPathName == null || this.fullPathName.length() == 0) {
            this.readValue();
        } else {
            int lastSep = f.lastIndexOf(92);
            if (lastSep < 0) {
                lastSep = f.lastIndexOf(47);
            }
            this.fileName = lastSep == f.length() - 1 ? "" : (lastSep >= 0 ? f.substring(lastSep + 1) : f);
            this.readFile();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getFullPathName() {
        return this.fullPathName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getValue() {
        return this.value;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isFile() {
        return this.fullPathName != null;
    }

    public File getFile() {
        return this.tmpFile;
    }

    public byte[] getBytes() {
        return this.fileBuffer;
    }

    public InputStream getInputStream() {
        return this.file;
    }

    private File createTmpFile() throws IOException {
        File Return2 = null;
        long ts = System.currentTimeMillis();
        while (!(Return2 = new File(this.directory, this.prefix + Long.toHexString(ts++) + "_" + this.fileName)).createNewFile()) {
        }
        this.fullPathName = Return2.getCanonicalPath();
        return Return2;
    }

    private void readFile() throws IOException {
        int rc;
        OutputStream os;
        int boundLenMin = this.boundary.length();
        int boundLenMax = boundLenMin + 4;
        byte[] buffer = new byte[8192];
        int eolc = 0;
        if (this.inRam) {
            os = new ByteArrayOutputStream();
        } else {
            try {
                this.tmpFile = this.createTmpFile();
                os = new FileOutputStream(this.tmpFile);
            }
            catch (IOException e) {
                throw new IOException(e.getMessage() + ": directory=" + this.directory.getPath());
            }
        }
        while (!((rc = this.inp.readLine(buffer, eolc, buffer.length - eolc)) <= 0 || rc >= boundLenMin && rc <= boundLenMax && new String(buffer, eolc, rc).startsWith(this.boundary))) {
            if (eolc == 0) {
                eolc = this.inp.getEolToSkip() + 1;
                rc -= eolc;
            }
            os.write(buffer, 0, rc);
            for (int i = 0; i < eolc; ++i) {
                buffer[i] = buffer[rc + i];
            }
        }
        os.close();
        if (this.inRam) {
            this.fileBuffer = ((ByteArrayOutputStream)os).toByteArray();
            this.file = new ByteArrayInputStream(this.fileBuffer);
        } else {
            this.file = new FileInputStream(this.tmpFile);
        }
    }

    private void readValue() throws IOException {
        int rc;
        byte[] buffer = new byte[8192];
        int boundLenMin = this.boundary.length();
        int boundLenMax = boundLenMin + 4;
        int eolc = 0;
        StringBuffer iBuf = new StringBuffer();
        while (!((rc = this.inp.readLine(buffer, eolc, buffer.length - eolc)) <= 0 || rc >= boundLenMin && rc <= boundLenMax && new String(buffer, eolc, rc).startsWith(this.boundary))) {
            if (eolc == 0) {
                eolc = this.inp.getEolToSkip() + 1;
                rc -= eolc;
            }
            String charset = this.inp.getCharset();
            iBuf.append(new String(buffer, 0, rc, charset));
            for (int i = 0; i < eolc; ++i) {
                buffer[i] = buffer[rc + i];
            }
        }
        this.value = iBuf.toString();
        this.fileBuffer = this.value.getBytes();
        this.file = new ByteArrayInputStream(this.fileBuffer);
    }

    public String toString() {
        return "name=" + this.name + ",file=" + this.fileName + ",type=" + this.contentType + ",value=" + this.value;
    }

    protected void finalize() throws Throwable {
        try {
            this.file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

