/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler;

import com.veryant.cobol.compiler.CompilerMessage;
import com.veryant.cobol.compiler.CompilerMessageSeverity;
import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.directives.CHANGEMESSAGE;
import com.veryant.cobol.compiler.directives.STDOUT;
import com.veryant.cobol.exceptions.COBOLCompilerException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;

public class Console
implements Closeable {
    private final PrintStream printer;
    private final HashMap<String, CompilerMessageSeverity> messageMap;
    private int warningsCount;
    private int errorsCount;

    private Console(File file, Directives directives) {
        try {
            this.printer = ((STDOUT)directives.getDirective(293)).createStream(file, directives);
        }
        catch (IOException iOException) {
            throw new COBOLCompilerException("Abort, cannot create Console instance");
        }
        CHANGEMESSAGE cHANGEMESSAGE = (CHANGEMESSAGE)directives.getDirective(38);
        this.messageMap = cHANGEMESSAGE.getMessageMap();
    }

    public void write(CompilerMessageSeverity compilerMessageSeverity, String string) {
        switch (compilerMessageSeverity) {
            case W: {
                ++this.warningsCount;
                break;
            }
            case E: 
            case C: {
                ++this.errorsCount;
            }
        }
        this.printer.println(string);
    }

    public void write(String string) {
        this.write(CompilerMessageSeverity.I, string);
    }

    public void write(CompilerMessage compilerMessage) {
        CompilerMessageSeverity compilerMessageSeverity;
        if (!this.messageMap.isEmpty() && (compilerMessageSeverity = this.messageMap.get(compilerMessage.getFormattedCode())) != null) {
            if (compilerMessageSeverity != CompilerMessageSeverity.N) {
                this.write(compilerMessageSeverity, compilerMessage.getFormattedMessage(compilerMessageSeverity));
            }
            return;
        }
        this.write(compilerMessage.getType(), compilerMessage.getFormattedMessage());
    }

    @Override
    public void close() {
        if (this.printer != null && this.printer != System.out && this.printer != System.err) {
            this.printer.flush();
            this.printer.close();
        }
    }

    public static Console get(File file, Directives directives) {
        return new Console(file, directives);
    }

    public int getWarningsCount() {
        return this.warningsCount;
    }

    public int getErrorsCount() {
        return this.errorsCount;
    }
}

