/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler;

import com.veryant.cobol.compiler.Codepage;
import com.veryant.cobol.compiler.Console;
import com.veryant.cobol.compiler.EntryPoint;
import com.veryant.cobol.compiler.directives.AllDirectives;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.compiler.directives.MEMORYMODEL;
import com.veryant.cobol.compiler.memory.LiteralsTable;
import java.util.concurrent.ConcurrentHashMap;

public class Context
extends AllDirectives {
    private Codepage codepage;
    private final LiteralsTable literals = new LiteralsTable();
    private final Console console;
    private boolean decimalPointIsComma = false;
    private char currencySign = '\u0000';
    private boolean nativeMemory;
    private static final ConcurrentHashMap<String, EntryPoint> globalEntrypointList = new ConcurrentHashMap();

    public byte getCurrencySymbol() {
        if (this.currencySign > '\u0000') {
            return (byte)this.currencySign;
        }
        return this.isAscii() ? (byte)36 : 91;
    }

    public byte getDecimalSymbol() {
        return this.isDecimalPointIsComma() ? (this.isAscii() ? (byte)44 : 107) : (this.isAscii() ? (byte)46 : 75);
    }

    public byte getThousandsSymbol() {
        return this.isDecimalPointIsComma() ? (this.isAscii() ? (byte)46 : 75) : (this.isAscii() ? (byte)44 : 107);
    }

    public byte getSpaceSymbol() {
        return this.isAscii() ? (byte)32 : 64;
    }

    public boolean isAscii() {
        return this.codepage.isAscii();
    }

    public static boolean registerEntryPoint(EntryPoint entryPoint) {
        String string = entryPoint.getName().toLowerCase();
        if (globalEntrypointList.containsKey(string)) {
            return false;
        }
        globalEntrypointList.put(string, entryPoint);
        return true;
    }

    public static EntryPoint retrieveEntryPoint(String string) {
        return globalEntrypointList.get(string.toLowerCase());
    }

    public Context(Console console) {
        this.console = console;
    }

    @Override
    public void onDirectiveChanged(BaseDirective baseDirective) {
        super.onDirectiveChanged(baseDirective);
        switch (baseDirective.getIndex()) {
            case 37: {
                this.codepage = this.getCCSID().getCodepage();
                break;
            }
            case 70: {
                this.currencySign = this.getCURRENCYSIGN().getCurrency();
                break;
            }
            case 194: {
                this.nativeMemory = this.getMEMORYMODEL().getModel() == MEMORYMODEL.Model.Native;
            }
        }
    }

    public Codepage getCodepage() {
        return this.codepage;
    }

    public LiteralsTable getLiterals() {
        return this.literals;
    }

    public Console getConsole() {
        return this.console;
    }

    public boolean isDecimalPointIsComma() {
        return this.decimalPointIsComma;
    }

    public void setDecimalPointIsComma(boolean bl) {
        this.decimalPointIsComma = bl;
    }

    public char getCurrencySign() {
        return this.currencySign;
    }

    public void setCurrencySign(char c) {
        this.currencySign = c;
    }

    public boolean isNativeMemory() {
        return this.nativeMemory;
    }
}

