/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler;

import com.veryant.cobol.compiler.ASTPrinter;
import com.veryant.cobol.compiler.ArithmeticType;
import com.veryant.cobol.compiler.CompilerMessageSeverity;
import com.veryant.cobol.compiler.Console;
import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.SourceFormat;
import com.veryant.cobol.compiler.Utils;
import com.veryant.cobol.compiler.ast.AbstractSyntaxTree;
import com.veryant.cobol.compiler.ast.AstCobolProgram;
import com.veryant.cobol.compiler.directives.ALIGN;
import com.veryant.cobol.compiler.directives.ARITH;
import com.veryant.cobol.compiler.directives.ASSIGN;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.compiler.directives.COMP1;
import com.veryant.cobol.compiler.directives.COMP2;
import com.veryant.cobol.compiler.directives.COMPILERTARGET;
import com.veryant.cobol.compiler.directives.DIALECT;
import com.veryant.cobol.compiler.directives.FOLDCOPYNAME;
import com.veryant.cobol.compiler.directives.JOBS;
import com.veryant.cobol.compiler.directives.MEMORYMODEL;
import com.veryant.cobol.compiler.directives.PERFORMTYPE;
import com.veryant.cobol.compiler.directives.RECMODE;
import com.veryant.cobol.compiler.directives.SEQUENTIAL;
import com.veryant.cobol.compiler.directives.SIGN;
import com.veryant.cobol.compiler.directives.SYNTAXTREE;
import com.veryant.cobol.compiler.directives.TRUNC;
import com.veryant.cobol.compiler.emitters.ITargetCompiler;
import com.veryant.cobol.compiler.emitters.Target;
import com.veryant.cobol.compiler.emitters.jvm.JvmCompiler;
import com.veryant.cobol.compiler.frontend.CobolParser;
import com.veryant.cobol.compiler.scope.FileDeclaration;
import com.veryant.cobol.exceptions.COBOLCompilerException;
import com.veryant.cobol.exceptions.InvalidDirectiveException;
import com.veryant.cobol.preproc.CodeStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class Unit
implements Thread.UncaughtExceptionHandler {
    private static final PrintStream stdOut = System.out;
    private final List<File> sourceFiles = new LinkedList<File>();
    private final Directives cmdLineDirectives;
    private final List<AbstractSyntaxTree> compilationUnit = new Vector<AbstractSyntaxTree>();
    private final ITargetCompiler targetCompiler;
    private final int jobs;
    private int globalErrorsCount;
    private int globalWarningsCount;
    public static final String PCC_OPTION = "-zmf";
    private static final String ISCOBOL_COMPILER_PROPERTY_PREFIX = "iscobol.compiler.";
    private static final String ISCOBOL_COMPILER_CONST = "const";
    private static final String ISCOBOL_COMPILER_MESSAGELEVEL = "messagelevel";
    private static final String[] PropertyPrefixArray = new String[]{"const."};

    public int getSourceFilesCount() {
        return this.sourceFiles.size();
    }

    public File getSourceFile(int n) {
        return this.sourceFiles.get(n);
    }

    public int getExitStatus() {
        return this.globalErrorsCount;
    }

    public Unit(String[] stringArray) {
        try {
            this.cmdLineDirectives = new Directives();
            this.parseArgs(stringArray);
            this.jobs = ((JOBS)this.cmdLineDirectives.getDirective(171)).getMaxJobs();
            Target target = ((COMPILERTARGET)this.cmdLineDirectives.getDirective(58)).getTarget();
            switch (target) {
                case JVM: {
                    this.targetCompiler = new JvmCompiler();
                    break;
                }
                default: {
                    throw new COBOLCompilerException("Unsupported target platform");
                }
            }
        }
        catch (InvalidDirectiveException invalidDirectiveException) {
            throw new COBOLCompilerException(invalidDirectiveException.getMessage());
        }
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    private void parseArgs(String[] stringArray) throws InvalidDirectiveException {
        if (stringArray != null && stringArray.length > 0) {
            for (String string : stringArray) {
                if (!string.trim().equalsIgnoreCase(PCC_OPTION)) continue;
                this.parsePccArgs(stringArray);
                return;
            }
            this.parseStandardArgs(stringArray);
        }
    }

    private void parseStandardArgs(String[] stringArray) throws InvalidDirectiveException {
        for (String string : stringArray) {
            if ((string = string.trim()).length() > 1 && string.startsWith("-")) {
                this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, string.substring(1));
                continue;
            }
            this.tryAddSourceFile(string);
        }
    }

    private StringPair GetPrefixedProperty(String string) {
        for (String string2 : PropertyPrefixArray) {
            if (!string.startsWith(string2)) continue;
            return new StringPair(string.substring(0, string2.length() - 1), string.substring(string2.length()));
        }
        return null;
    }

    private String[] splitOptions(String string) {
        string = string.trim();
        ArrayList<String> arrayList = new ArrayList<String>();
        Boolean bl = false;
        Object object = "";
        block7: for (int i = 0; i < string.length(); ++i) {
            Character c = Character.valueOf(string.charAt(i));
            if (!bl.booleanValue()) {
                switch (c.charValue()) {
                    case ' ': {
                        if (((String)object).length() <= 0) continue block7;
                        this.addNewOption(arrayList, (String)object);
                        object = "";
                        break;
                    }
                    case '\"': {
                        bl = true;
                        object = (String)object + c;
                        break;
                    }
                    default: {
                        object = (String)object + c;
                        break;
                    }
                }
                continue;
            }
            switch (c.charValue()) {
                case '\"': {
                    bl = false;
                    object = (String)object + c;
                    continue block7;
                }
                default: {
                    object = (String)object + c;
                }
            }
        }
        this.addNewOption(arrayList, (String)object);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void addNewOption(List<String> list, String string) {
        if (string == null) {
            return;
        }
        if ((string = string.trim()).startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1).trim();
        }
        if (string.length() > 0) {
            list.add(string);
        }
    }

    private void updatePropertiesFromConfigFile(Properties properties, String string) {
        try {
            String string2;
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!string2.startsWith(ISCOBOL_COMPILER_PROPERTY_PREFIX)) continue;
                int n = string2.indexOf(61);
                Object var7_9 = null;
                if (n >= 0) {
                    properties.put(string2.substring(n + 1), string2.substring(0, n));
                    continue;
                }
                properties.put(string2.substring(n + 1), "");
            }
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new COBOLCompilerException(String.format("Cannot access file: %s", string));
        }
        catch (IOException iOException) {
            throw new COBOLCompilerException(String.format("Cannot access file: %s", string));
        }
    }

    private void ensureArgArg(String string, String string2) {
        if (string == null) {
            throw new COBOLCompilerException(String.format("Invalid command line option: '%s'", string2));
        }
    }

    private List<StringPair> GetReservedWordPairs(String string, String string2) {
        this.ensureArgArg(string, string2);
        string = string.trim();
        if (string.length() == 0) {
            throw new COBOLCompilerException(String.format("Invalid command line option: '%s'", string2));
        }
        ArrayList<StringPair> arrayList = new ArrayList<StringPair>();
        String[] stringArray = string.split(",");
        if (stringArray.length % 2 != 0) {
            throw new COBOLCompilerException(String.format("Invalid command line option: '%s'", string2));
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            String string3 = stringArray[i].trim();
            String string4 = stringArray[i + 1].trim();
            if (string3.length() == 0 || string4.length() == 0) {
                throw new COBOLCompilerException(String.format("Invalid command line option: '%s'", string2));
            }
            arrayList.add(new StringPair(string3, string4));
        }
        return arrayList;
    }

    private List<String> GetReservedWords(String string, String string2) {
        this.ensureArgArg(string, string2);
        string = string.trim();
        if (string.length() == 0) {
            throw new COBOLCompilerException(String.format("Invalid command line option: '%s'", string2));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = string.split(",");
        if (stringArray.length % 2 != 0) {
            throw new COBOLCompilerException(String.format("Invalid command line option: '%s'", string2));
        }
        for (String string3 : stringArray) {
            if ((string3 = string3.trim()).length() == 0) {
                throw new COBOLCompilerException(String.format("Invalid command line option: '%s'", string2));
            }
            arrayList.add(string3);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private void parsePccArgs(String[] object) throws InvalidDirectiveException {
        Object object2;
        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"DIALECT", DIALECT.Dialects.ISCOBOL}));
        String stringArray = null;
        String stringArray2 = null;
        block329: for (Object object4 : object) {
            String string = ((String)object4).trim();
            if (string.length() == 0 || !string.startsWith("-")) continue;
            int n = string.indexOf(61);
            Object var10_26 = null;
            if (n >= 0) {
                String string2 = string.substring(n + 1);
                string = string.substring(0, n);
            }
            string = string.toLowerCase();
            switch (string) {
                case "-c": {
                    void var10_25;
                    this.ensureArgArg((String)var10_25, (String)object4);
                    stringArray = var10_25;
                    continue block329;
                }
                case "-conly": {
                    void var10_25;
                    this.ensureArgArg((String)var10_25, (String)object4);
                    stringArray2 = var10_25;
                }
            }
        }
        Object object5 = null;
        if (stringArray2 != null) {
            object5 = new Properties();
            this.updatePropertiesFromConfigFile((Properties)object5, stringArray2);
        } else if (stringArray != null) {
            object5 = System.getProperties();
            this.updatePropertiesFromConfigFile((Properties)object5, stringArray);
        } else {
            object5 = System.getProperties();
        }
        block330: for (String string : ((Properties)object5).stringPropertyNames()) {
            if (!string.startsWith(ISCOBOL_COMPILER_PROPERTY_PREFIX)) continue;
            string = string.substring(ISCOBOL_COMPILER_PROPERTY_PREFIX.length());
            String string3 = ((Properties)object5).getProperty(string);
            switch (string) {
                case "command_line_linkage": {
                    continue block330;
                }
                case "javac": {
                    continue block330;
                }
                case "javac.options": {
                    continue block330;
                }
                case "options": {
                    String[] stringArray3 = this.splitOptions(string3);
                    if (stringArray3.length <= 0) continue block330;
                    object2 = new String[stringArray3.length + ((Object)object).length];
                    System.arraycopy(stringArray3, 0, object2, 0, stringArray3.length);
                    System.arraycopy(object, 0, object2, stringArray3.length, ((Object)object).length);
                    object = object2;
                    continue block330;
                }
                case "easylinkage": {
                    switch (string3.trim()) {
                        case "0": {
                            this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, "NOILSMARTLINKAGE");
                            break;
                        }
                        case "1": {
                            this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, "ILSMARTLINKAGE");
                            break;
                        }
                        case "2": {
                            break;
                        }
                        case "3": {
                            this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, "ILSMARTLINKAGE");
                        }
                    }
                    continue block330;
                }
                case "easylinkage.decoration": {
                    continue block330;
                }
                case "easylinkage.package": {
                    this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", "ILSMARTLINKAGE", string3));
                    continue block330;
                }
                case "easylinkage.prefix": {
                    continue block330;
                }
            }
            object2 = this.GetPrefixedProperty(string);
            if (object2 == null) continue;
            switch (((StringPair)object2).getKey()) {
                case "const": {
                    this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s=%s", "CONSTANT", string3));
                    break;
                }
                case "messagelevel": {
                    void var7_19;
                    switch (string3.trim()) {
                        case "0": {
                            String string4 = "N";
                            break;
                        }
                        case "1": {
                            String string5 = "I";
                            break;
                        }
                        case "2": {
                            String string6 = "W";
                            break;
                        }
                        case "3": {
                            String string7 = "E";
                            break;
                        }
                        case "4": {
                            String string8 = "S";
                            break;
                        }
                        default: {
                            Object var7_18 = null;
                        }
                    }
                    if (var7_19 == null) break;
                    this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s %s)", "CHANGEMESSAGE", ((StringPair)object2).getValue(), string));
                }
            }
        }
        Object object6 = false;
        String string = null;
        block331: for (Object object3 : object) {
            object2 = ((String)object3).trim();
            if (((String)object2).length() == 0) continue;
            if (((String)object2).startsWith("--")) {
                this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, ((String)object2).substring(2));
                continue;
            }
            if (((String)object2).startsWith("-")) {
                int n = ((String)object2).indexOf(61);
                String string9 = null;
                if (n >= 0) {
                    string9 = ((String)object2).substring(n + 1);
                    object2 = ((String)object2).substring(0, n);
                }
                switch (object2 = ((String)object2).toLowerCase()) {
                    case "-zmf": {
                        continue block331;
                    }
                    case "-b": {
                        continue block331;
                    }
                    case "-c": {
                        continue block331;
                    }
                    case "-conly": {
                        continue block331;
                    }
                    case "-d": {
                        break;
                    }
                    case "-dx": {
                        break;
                    }
                    case "-edc": {
                        continue block331;
                    }
                    case "-ef": {
                        if (string == null) {
                            this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, "STDOUT");
                        } else {
                            this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", "STDOUT", string));
                        }
                        object6 = true;
                        continue block331;
                    }
                    case "-eo": {
                        this.ensureArgArg(string9, (String)object3);
                        string = string9;
                        if (!((Boolean)object6).booleanValue()) continue block331;
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", "STDOUT", string));
                        continue block331;
                    }
                    case "-es": {
                        continue block331;
                    }
                    case "-esme": {
                        this.ensureArgArg(string9, (String)object3);
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", "MAXERROR", string9));
                        continue block331;
                    }
                    case "-help": {
                        break;
                    }
                    case "-helpx": {
                        break;
                    }
                    case "-noarcc": {
                        break;
                    }
                    case "-oe": {
                        continue block331;
                    }
                    case "-v": {
                        break;
                    }
                    case "-verbose": {
                        break;
                    }
                    case "-sysc": {
                        break;
                    }
                    case "-ca": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, "ACU");
                        continue block331;
                    }
                    case "-caec": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, "MOVECONVERT");
                        continue block331;
                    }
                    case "-cax": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"ASSIGN", ASSIGN.AssignType.External}));
                        continue block331;
                    }
                    case "-ccbas": {
                        continue block331;
                    }
                    case "-cdlz": {
                        break;
                    }
                    case "-cfl": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"SEQUENTIAL", SEQUENTIAL.SequentialType.Record}));
                        continue block331;
                    }
                    case "-cfp36": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"ARITH", ARITH.ArithOptions.Extend}));
                        continue block331;
                    }
                    case "-cko": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, "SORTINDEXEDKEYS");
                        continue block331;
                    }
                    case "-ci": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, "ICOBOL");
                        continue block331;
                    }
                    case "-cm": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, "MF");
                        continue block331;
                    }
                    case "-cndbcs": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, "DBCS");
                        continue block331;
                    }
                    case "-cnlz": {
                        break;
                    }
                    case "-cod1": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, "ODOOSVS");
                        continue block331;
                    }
                    case "-coe": {
                        break;
                    }
                    case "-cp": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"MEMORYMODEL", MEMORYMODEL.Model.Native}));
                        continue block331;
                    }
                    case "-cpanv": {
                        break;
                    }
                    case "-cr": {
                        break;
                    }
                    case "-crlk": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, "RETRYLOCK");
                        continue block331;
                    }
                    case "-crko": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, "SORTINDEXEDKEYS");
                        continue block331;
                    }
                    case "-crv": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"RECMODE", RECMODE.Formats.RMCOBOL}));
                        continue block331;
                    }
                    case "-csl": {
                        break;
                    }
                    case "-csqn": {
                        break;
                    }
                    case "-csqq": {
                        break;
                    }
                    case "-cudc": {
                        break;
                    }
                    case "-cv": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"DIALECT", DIALECT.Dialects.OSVS}));
                        continue block331;
                    }
                    case "-cva": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"ARITHMETIC", ArithmeticType.OSVS}));
                        continue block331;
                    }
                    case "-align": {
                        this.ensureArgArg(string9, (String)object3);
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s %s)", new Object[]{"ALIGN", string9, ALIGN.AlignOptions.Fixed}));
                        continue block331;
                    }
                    case "-d1": {
                        break;
                    }
                    case "-d5": {
                        break;
                    }
                    case "-d64": {
                        break;
                    }
                    case "-dca": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"COMP1", COMP1.Comp1Type.Binary}));
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"COMP2", COMP2.Comp2Type.Decimal}));
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(1)", "COMP5"));
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(3)", "COMP6"));
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(8)", "MFSYNC"));
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"SIGN", SIGN.StorageConventions.Acu}));
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"TRUNC", TRUNC.Dialects.Acu}));
                        continue block331;
                    }
                    case "-dcb": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"SIGN", SIGN.StorageConventions.MBP}));
                        continue block331;
                    }
                    case "-dcd": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, "DG");
                        continue block331;
                    }
                    case "-dcdm": {
                        break;
                    }
                    case "-dci": 
                    case "-dcii": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"SIGN", SIGN.StorageConventions.IBM}));
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, "IBMCOMP");
                        continue block331;
                    }
                    case "-dcm": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"SIGN", SIGN.StorageConventions.MF}));
                        continue block331;
                    }
                    case "-dcmi": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, "IBMCOMP");
                        continue block331;
                    }
                    case "-dcn": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"SIGN", SIGN.StorageConventions.NCR}));
                        continue block331;
                    }
                    case "-dcr": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"SIGN", SIGN.StorageConventions.Realia}));
                        continue block331;
                    }
                    case "-dcv": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"SIGN", SIGN.StorageConventions.Vax}));
                        continue block331;
                    }
                    case "-di": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, "INITBYTYPE");
                        continue block331;
                    }
                    case "-ds": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"SIGN", SIGN.SignModes.TrailingSeparate}));
                        continue block331;
                    }
                    case "-dv": {
                        this.ensureArgArg(string9, (String)object3);
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", "DEFAULTBYTE", string9));
                        continue block331;
                    }
                    case "-dvext": {
                        break;
                    }
                    case "-dvexta": {
                        break;
                    }
                    case "-dz": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"TRUNC", TRUNC.Dialects.Acu}));
                        continue block331;
                    }
                    case "-dznt": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("NO%s", "TRUNC"));
                        continue block331;
                    }
                    case "-dxta": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"TRUNC", TRUNC.Dialects.ANSI}));
                        continue block331;
                    }
                    case "-efa": {
                        break;
                    }
                    case "-efc": {
                        break;
                    }
                    case "-efd": {
                        break;
                    }
                    case "-efo": {
                        break;
                    }
                    case "-fl": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, "SINGLERECORDLOCKING");
                        break;
                    }
                    case "-flsu": {
                        break;
                    }
                    case "-fm": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"LOCKMODE", FileDeclaration.LockMode.Manual}));
                        continue block331;
                    }
                    case "-fsv": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"RECORDSEQUENTIALRECORDINGMODE", RECMODE.Formats.V}));
                        continue block331;
                    }
                    case "-jc": {
                        break;
                    }
                    case "-jj": {
                        break;
                    }
                    case "-jo": {
                        break;
                    }
                    case "-la": {
                        break;
                    }
                    case "-ld": {
                        break;
                    }
                    case "-lf": {
                        break;
                    }
                    case "-lfo": {
                        break;
                    }
                    case "-lo": {
                        break;
                    }
                    case "-m1": {
                        break;
                    }
                    case "-od": {
                        this.ensureArgArg(string9, (String)object3);
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", "ILOUTPUT", string9));
                        continue block331;
                    }
                    case "-ostrip": {
                        break;
                    }
                    case "-pt0": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"PERFORMTYPE", PERFORMTYPE.Dialect.RM}));
                        continue block331;
                    }
                    case "-pt1": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"PERFORMTYPE", PERFORMTYPE.Dialect.MF}));
                        continue block331;
                    }
                    case "-pt2": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"PERFORMTYPE", PERFORMTYPE.Dialect.OSVS}));
                        continue block331;
                    }
                    case "-rc": {
                        for (StringPair stringPair : this.GetReservedWordPairs(string9, (String)object2)) {
                            this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s \"%s\" = \"%s\")", "MAKESYN", stringPair.getKey(), stringPair.getValue()));
                        }
                        continue block331;
                    }
                    case "-rm": {
                        for (StringPair stringPair : this.GetReservedWordPairs(string9, (String)object2)) {
                            this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s \"%s\" = \"%s\")", "OVERRIDE", stringPair.getKey(), stringPair.getValue()));
                        }
                        continue block331;
                    }
                    case "-rw": {
                        for (String string10 : this.GetReservedWords(string9, (String)object2)) {
                            this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s\"%s\")", "REMOVE", string10));
                        }
                        continue block331;
                    }
                    case "-apost": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, "APOST");
                        continue block331;
                    }
                    case "-big": {
                        break;
                    }
                    case "-ce": {
                        this.ensureArgArg(string9, (String)object3);
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", "COPYEXT", string9.replace(';', ',').replace(':', ',')));
                        continue block331;
                    }
                    case "-exec": {
                        break;
                    }
                    case "-noexec": {
                        break;
                    }
                    case "-s78c": {
                        break;
                    }
                    case "-sa": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"SOURCEFORMAT", SourceFormat.FIXED}));
                        continue block331;
                    }
                    case "-sc": {
                        break;
                    }
                    case "-scnl": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"FOLDCOPYNAME", FOLDCOPYNAME.FileCase.Lower}));
                        continue block331;
                    }
                    case "-scnu": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"FOLDCOPYNAME", FOLDCOPYNAME.FileCase.Upper}));
                        continue block331;
                    }
                    case "-sdcs": {
                        break;
                    }
                    case "-sddp": {
                        break;
                    }
                    case "-sevc": {
                        break;
                    }
                    case "-sf": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"SOURCEFORMAT", SourceFormat.FREE}));
                        continue block331;
                    }
                    case "-sl": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"SOURCEFORMAT", SourceFormat.VARIABLE}));
                        continue block331;
                    }
                    case "-smat": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, "LOCALSOURCEFORMAT");
                        continue block331;
                    }
                    case "-sp": {
                        this.ensureArgArg(string9, (String)object3);
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", "COPYPATH", string9));
                        continue block331;
                    }
                    case "-ssnl": {
                        break;
                    }
                    case "-ssnu": {
                        break;
                    }
                    case "-st": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"SOURCEFORMAT", SourceFormat.TERMINAL}));
                        continue block331;
                    }
                    case "-stl": {
                        this.ensureArgArg(string9, (String)object3);
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", "SOURCETABSTOP", string9));
                        continue block331;
                    }
                    case "-sv": {
                        this.cmdLineDirectives.set(BaseDirective.Phase.CommandLine, String.format("%s(%s)", new Object[]{"SOURCEFORMAT", SourceFormat.VARIABLE}));
                        continue block331;
                    }
                    case "-va": {
                        break;
                    }
                    case "-vansi": {
                        break;
                    }
                    case "-vh": {
                        break;
                    }
                    case "-vu": {
                        break;
                    }
                    case "-vx": {
                        break;
                    }
                    case "-watn": {
                        break;
                    }
                    case "-wd2": {
                        break;
                    }
                    case "-wdbz": {
                        break;
                    }
                    case "-whttp": {
                        break;
                    }
                    case "-wlu": {
                        break;
                    }
                    case "-wmwc": {
                        break;
                    }
                    case "-wr": {
                        break;
                    }
                    case "-wref": {
                        break;
                    }
                    case "-wu": {
                        break;
                    }
                    case "-tasks": {
                        break;
                    }
                    case "-ze": {
                        break;
                    }
                    case "-zi": {
                        break;
                    }
                    case "-zy": {
                        break;
                    }
                    default: {
                        throw new COBOLCompilerException(String.format("Invalid command line option: '%s'", ((String)object3).trim()));
                    }
                }
            } else {
                this.tryAddSourceFile((String)object2);
                continue;
            }
            stdOut.println(String.format("Option '%s' not yet supported", object2));
        }
    }

    private void tryAddSourceFile(String string) {
        try {
            File file = new File(string).getCanonicalFile();
            if (!Utils.isValidFile(file)) {
                throw new COBOLCompilerException(String.format("Cannot open source file: %s", string));
            }
            this.sourceFiles.add(file);
        }
        catch (IOException iOException) {
            throw new COBOLCompilerException(String.format("Cannot open source file: %s", string));
        }
    }

    public void createAst() {
        ExecutorService executorService = Executors.newFixedThreadPool(this.jobs);
        for (File file : this.sourceFiles) {
            String string = Utils.pathMerge(file.getParent(), "compiler.options");
            try {
                Directives directives = new Directives();
                directives.parseOptionsFile(string);
                directives.importAll(BaseDirective.Phase.Clone, this.cmdLineDirectives);
                executorService.execute(() -> this.createAst(file, directives));
            }
            catch (InvalidDirectiveException invalidDirectiveException) {
                throw new COBOLCompilerException(string + ": " + invalidDirectiveException.getMessage());
            }
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
        }
        catch (InterruptedException interruptedException) {
            throw new COBOLCompilerException(interruptedException.getMessage());
        }
    }

    private void createAst(File file, Directives directives) {
        Console console = Console.get(file, directives);
        console.write(String.format("Compiling %s...", file.getPath()));
        try (CodeStream codeStream = new CodeStream(file, console, directives);){
            String string = Utils.basename(file);
            CobolParser cobolParser = new CobolParser(string, codeStream);
            AbstractSyntaxTree abstractSyntaxTree = cobolParser.parse();
            SYNTAXTREE sYNTAXTREE = (SYNTAXTREE)directives.getDirective(299);
            if (sYNTAXTREE.isSet()) {
                String string2 = sYNTAXTREE.getOutput(file);
                try (ASTPrinter aSTPrinter = new ASTPrinter(string2);){
                    aSTPrinter.print(abstractSyntaxTree, sYNTAXTREE.getFormat());
                }
            }
            if (console.getErrorsCount() == 0) {
                this.compilationUnit.add(abstractSyntaxTree);
            } else {
                this.globalErrorsCount += console.getErrorsCount();
                this.globalWarningsCount += console.getWarningsCount();
            }
        }
        catch (COBOLCompilerException cOBOLCompilerException) {
            ++this.globalErrorsCount;
            console.write(CompilerMessageSeverity.C, cOBOLCompilerException.getMessage());
        }
        catch (IOException iOException) {
            throw new COBOLCompilerException(iOException);
        }
    }

    public void transplant() {
        ExecutorService executorService = Executors.newFixedThreadPool(this.jobs);
        for (AbstractSyntaxTree abstractSyntaxTree : this.compilationUnit) {
            executorService.execute(() -> {
                Console console = abstractSyntaxTree.getConsole();
                AstCobolProgram[] astCobolProgramArray = abstractSyntaxTree.getModules();
                try {
                    for (AstCobolProgram astCobolProgram : astCobolProgramArray) {
                        astCobolProgram.walk();
                    }
                    if (console.getErrorsCount() == 0) {
                        for (AstCobolProgram astCobolProgram : astCobolProgramArray) {
                            this.targetCompiler.emit(astCobolProgram.getCompilationResult());
                        }
                    }
                    this.globalErrorsCount += console.getErrorsCount();
                    this.globalWarningsCount += console.getWarningsCount();
                }
                catch (COBOLCompilerException cOBOLCompilerException) {
                    ++this.globalErrorsCount;
                    console.write(CompilerMessageSeverity.C, cOBOLCompilerException.getMessage());
                }
            });
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
        }
        catch (InterruptedException interruptedException) {
            throw new COBOLCompilerException(interruptedException.getMessage());
        }
        this.compilationUnit.clear();
    }

    public void compile() {
        stdOut.println(String.format("Errors: %d, Warnings: %d", this.globalErrorsCount, this.globalWarningsCount));
        if (this.globalErrorsCount == 0) {
            stdOut.println("Compiling to target...");
            this.targetCompiler.compile();
            stdOut.println("Done");
        }
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        throwable.printStackTrace();
        System.exit(-1);
    }

    class StringPair {
        private String key;
        private String value;

        StringPair(String string, String string2) {
            this.key = string;
            this.value = this.value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

