/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast;

import com.veryant.cobol.compiler.BuiltIn;
import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.ISourceReference;
import com.veryant.cobol.compiler.LinkageParam;
import com.veryant.cobol.compiler.Magnitude;
import com.veryant.cobol.compiler.Operators;
import com.veryant.cobol.compiler.ast.AstDataDescriptionEntry;
import com.veryant.cobol.compiler.ast.AstDataRedefines;
import com.veryant.cobol.compiler.ast.AstDataRenames;
import com.veryant.cobol.compiler.ast.AstFileDescription;
import com.veryant.cobol.compiler.ast.AstLinkageSection;
import com.veryant.cobol.compiler.ast.AstLocalStorage;
import com.veryant.cobol.compiler.ast.AstNode;
import com.veryant.cobol.compiler.ast.AstWorkingStorage;
import com.veryant.cobol.compiler.memory.CobolData;
import com.veryant.cobol.compiler.memory.DataItem;
import com.veryant.cobol.compiler.memory.DynamicChunk;
import com.veryant.cobol.compiler.memory.RecordItem;
import com.veryant.cobol.compiler.memory.Region;
import com.veryant.cobol.compiler.scope.DataItemDeclaration;
import com.veryant.cobol.compiler.scope.LiteralsRange;
import com.veryant.cobol.compiler.scope.NamedConditionDeclaration;
import com.veryant.cobol.compiler.types.IntermediateCondition;
import com.veryant.cobol.exceptions.COBOLCompilerException;
import java.util.ArrayList;
import java.util.List;

public class AstDataDescriptionBlock
extends AstNode {
    private int stackIndex = -1;
    private int recordIndex = 0;
    private int[] stack = new int[50];
    private final List<DataItem> topLevelDataItems = new ArrayList<DataItem>();
    private CobolData memoryHandler;
    private DataItemDeclaration lastDeclaration;
    private final List<DataItemDeclaration> records = new ArrayList<DataItemDeclaration>();
    private final List<DataItemDeclaration> syntItems = new ArrayList<DataItemDeclaration>();

    public DataItemDeclaration[] getRecords() {
        return this.records.toArray(new DataItemDeclaration[this.records.size()]);
    }

    public AstDataDescriptionBlock(Collector collector) {
        super(collector);
    }

    @Override
    public boolean isUniqueNode() {
        return true;
    }

    protected Region getAstRegion() {
        AstNode astNode = this.getParent();
        if (astNode instanceof AstFileDescription) {
            return Region.WORKING_STORAGE;
        }
        if (astNode instanceof AstWorkingStorage) {
            return Region.WORKING_STORAGE;
        }
        if (astNode instanceof AstLocalStorage) {
            return Region.LOCAL_STORAGE;
        }
        if (astNode instanceof AstLinkageSection) {
            return Region.LINKAGE;
        }
        throw new COBOLCompilerException("Internal error, invalid AST structure");
    }

    protected void wrongLevelHierarchy(AstDataDescriptionEntry astDataDescriptionEntry) {
        this.consoleWrite(22, astDataDescriptionEntry.getToken(), new Object[0]);
    }

    @Override
    public void validate() {
        switch (this.getAstRegion()) {
            case WORKING_STORAGE: {
                this.memoryHandler = this.getCollector().getWorkingStorage();
                break;
            }
            case LOCAL_STORAGE: {
                this.memoryHandler = this.getCollector().getLocalStorage();
                break;
            }
            case LINKAGE: {
                break;
            }
            default: {
                throw new COBOLCompilerException("Internal error, invalid AST structure");
            }
        }
        int n = this.getChildrenCount();
        for (int i = 0; i < n; ++i) {
            this.process((AstDataDescriptionEntry)this.getChild(i));
        }
        this.complete();
        for (DataItemDeclaration dataItemDeclaration : this.syntItems) {
            this.getCollector().getWorkingStorage().add(dataItemDeclaration.getDataItem());
        }
    }

    private void complete() {
        while (this.stackIndex >= 0) {
            this.back();
        }
    }

    private void complete(int n) {
        while (this.stackIndex >= 0 && this.stack[this.stackIndex] >= n) {
            this.back();
        }
    }

    protected void processRenames(AstDataDescriptionEntry astDataDescriptionEntry) {
        AstDataRenames astDataRenames = astDataDescriptionEntry.getRenames();
        DataItem dataItem = astDataRenames.getRenamedDataItem();
        if (dataItem != null) {
            System.out.println(dataItem.getName() + ", " + ((DynamicChunk)dataItem.getChunk()).getRegion() + " " + ((DynamicChunk)dataItem.getChunk()).getIndex());
            DataItem dataItem2 = astDataRenames.getRenamedThrough();
            if (dataItem2 != null) {
                System.out.println(dataItem2.getName() + ", " + ((DynamicChunk)dataItem2.getChunk()).getRegion() + " " + ((DynamicChunk)dataItem2.getChunk()).getIndex());
            }
        }
    }

    protected void processCondition(AstDataDescriptionEntry astDataDescriptionEntry) {
        if (this.lastDeclaration == null) {
            this.wrongLevelHierarchy(astDataDescriptionEntry);
            return;
        }
        NamedConditionDeclaration namedConditionDeclaration = astDataDescriptionEntry.toNamedConditionDeclaration();
        namedConditionDeclaration.setParent(this.lastDeclaration);
        LiteralsRange[] literalsRangeArray = namedConditionDeclaration.getValues();
        IntermediateCondition[] intermediateConditionArray = new IntermediateCondition[literalsRangeArray.length];
        for (int i = 0; i < literalsRangeArray.length; ++i) {
            intermediateConditionArray[i] = literalsRangeArray[i].getTo() == null ? this.createCondition(Operators.EQ, namedConditionDeclaration.getSyntheticReference(), literalsRangeArray[i].getFrom()) : this.createCondition(Operators.AND, this.createCondition(Operators.GE, namedConditionDeclaration.getSyntheticReference(), literalsRangeArray[i].getFrom()), this.createCondition(Operators.LE, namedConditionDeclaration.getSyntheticReference(), literalsRangeArray[i].getTo()));
        }
        IntermediateCondition intermediateCondition = intermediateConditionArray[0];
        for (int i = 1; i < literalsRangeArray.length; ++i) {
            intermediateCondition = this.createCondition(Operators.OR, intermediateCondition, intermediateConditionArray[i]);
        }
        namedConditionDeclaration.setSyntheticCondition(intermediateCondition);
        if (!this.getScope().add(namedConditionDeclaration)) {
            this.consoleWrite(62, namedConditionDeclaration, namedConditionDeclaration.getName());
        }
    }

    protected void process(AstDataDescriptionEntry astDataDescriptionEntry) {
        DataItem dataItem;
        int n = astDataDescriptionEntry.getLevel();
        if (n == 78) {
            return;
        }
        switch (n) {
            case 1: 
            case 77: {
                ++this.recordIndex;
            }
            case 66: {
                this.complete();
                break;
            }
            default: {
                this.complete(n);
            }
        }
        if (n == 66) {
            this.processRenames(astDataDescriptionEntry);
            return;
        }
        if (n == 88) {
            this.processCondition(astDataDescriptionEntry);
            return;
        }
        this.stack[++this.stackIndex] = n;
        DataItemDeclaration dataItemDeclaration = astDataDescriptionEntry.toDataItemDeclaration();
        dataItemDeclaration.setRecordIndex(this.recordIndex);
        if (this.getAstRegion() == Region.LINKAGE && (n == 1 || n == 77)) {
            this.memoryHandler = new CobolData(Region.LINKAGE);
            this.getCollector().getLinkage().add(new LinkageParam(dataItemDeclaration, this.memoryHandler));
        }
        DataItem dataItem2 = this.memoryHandler.open(dataItemDeclaration.getDataItem());
        if (astDataDescriptionEntry.denyPromotionByDefault()) {
            dataItemDeclaration.getDataItem().denyPromotion();
        }
        for (String object : dataItemDeclaration.getIndexes()) {
            DataItemDeclaration dataItemDeclaration2 = new DataItemDeclaration((ISourceReference)dataItemDeclaration, new DataItem(object, BuiltIn.UNSIGNED, new Magnitude(false, 5, 0), 5));
            this.syntItems.add(dataItemDeclaration2);
            if (this.getScope().add(dataItemDeclaration2)) continue;
            this.consoleWrite(62, dataItemDeclaration, dataItemDeclaration2.getName());
        }
        AstDataRedefines astDataRedefines = astDataDescriptionEntry.getRedefines();
        if (astDataRedefines != null && (dataItem = astDataRedefines.getDataItem()) != null) {
            int n2 = 1;
            DataItem dataItem3 = dataItemDeclaration.getDataItem();
            dataItem3.denyPromotion();
            if (dataItem.getParent() == null) {
                if (!DataItem.isValidRedefines(dataItem, this.topLevelDataItems, this.topLevelDataItems.size() - 1)) {
                    n2 = 0;
                }
            } else if (!dataItem3.isValidRedefines(dataItem)) {
                n2 = 0;
            }
            if (n2 != 0) {
                ((DynamicChunk)dataItemDeclaration.getDataItem().getChunk()).setUnion((DynamicChunk)dataItem.getChunk());
            } else {
                this.consoleWrite(78, astDataDescriptionEntry.getRedefines().getRedefinedDataItemToken(), dataItem.getName());
            }
        }
        if (n == 1 || n == 77) {
            this.topLevelDataItems.add(dataItemDeclaration.getDataItem());
            if (dataItemDeclaration.getDataItem() instanceof RecordItem) {
                this.records.add(dataItemDeclaration);
            }
        } else if (dataItem2 == null) {
            this.wrongLevelHierarchy(astDataDescriptionEntry);
        } else if (dataItem2.getDeclaredSize() > 0) {
            this.wrongLevelHierarchy(astDataDescriptionEntry);
        }
        if (dataItemDeclaration.getValue() != null) {
            this.getCollector().addInitialization(dataItemDeclaration);
        }
        if (!dataItemDeclaration.getDataItem().isFiller() && !this.getScope().add(dataItemDeclaration)) {
            this.consoleWrite(62, dataItemDeclaration, dataItemDeclaration.getName());
        }
        this.lastDeclaration = dataItemDeclaration;
    }

    private void back() {
        DynamicChunk dynamicChunk = this.memoryHandler.close();
        if (!dynamicChunk.isSized()) {
            this.consoleWrite(23, this.lastDeclaration, new Object[0]);
        }
        --this.stackIndex;
    }

    @Override
    public String toString() {
        return "data-description-block";
    }
}

