/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast;

import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.Utils;
import com.veryant.cobol.compiler.ast.AstOperand;
import com.veryant.cobol.compiler.frontend.Token;
import com.veryant.cobol.compiler.types.StringLiteral;

public class AstStringLiteral
extends AstOperand {
    private StringLiteral stringLiteral;

    protected AstStringLiteral(Collector collector, Token token, byte[] byArray) {
        super(collector, token);
        this.stringLiteral = new StringLiteral(this.getToken(), this.createLiteral(byArray));
        this.getContext().getLiterals().add(this.stringLiteral.getValue());
    }

    @Override
    public StringLiteral getOperand() {
        return this.stringLiteral;
    }

    @Override
    public String toString() {
        return Utils.quoteString(this.stringLiteral.toString());
    }

    public static AstStringLiteral fromSTR(Collector collector, Token token) {
        if (token.kind != 856) {
            throw AstStringLiteral.unexpectedTokenException(token);
        }
        return new AstStringLiteral(collector, token, Utils.getBytes(Utils.unquoteString(token.image), collector.getContext().getCodepage()));
    }

    public static AstStringLiteral fromHEX(Collector collector, Token token) {
        if (token.kind != 855) {
            throw AstStringLiteral.unexpectedTokenException(token);
        }
        return new AstStringLiteral(collector, token, Utils.hexToByteArray(Utils.unquoteString(token.image.substring(1))));
    }

    public static AstStringLiteral fromPIC(Collector collector, Token token) {
        if (token.kind != 856) {
            throw AstStringLiteral.unexpectedTokenException(token);
        }
        return new AstStringLiteral(collector, token, Utils.getBytes(token.image, collector.getContext().getCodepage()));
    }

    public static AstStringLiteral fromIDENTIFIER(Collector collector, Token token) {
        if (token.kind == 856) {
            throw AstStringLiteral.unexpectedTokenException(token);
        }
        return new AstStringLiteral(collector, token, Utils.getBytes(token.image, collector.getContext().getCodepage()));
    }
}

