/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast.common;

import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.ast.AstFileDescription;
import com.veryant.cobol.compiler.ast.AstNode;
import com.veryant.cobol.compiler.ast.statements.AstAbstractFileIOStatement;
import com.veryant.cobol.compiler.ast.statements.AstSelectStatement;
import com.veryant.cobol.compiler.frontend.Token;
import com.veryant.cobol.compiler.memory.RecordItem;
import com.veryant.cobol.compiler.scope.DataItemDeclaration;
import com.veryant.cobol.compiler.scope.FileDeclaration;
import java.util.ArrayList;
import java.util.List;

public class AstFileReference
extends AstNode {
    private FileDeclaration file = null;
    private final List<DataItemDeclaration> topLevels = new ArrayList<DataItemDeclaration>();

    public AstFileReference(Collector collector, Token token) {
        super(collector, token);
    }

    public void addTopLevel(DataItemDeclaration dataItemDeclaration) {
        this.topLevels.add(dataItemDeclaration);
        this.file.addRecord((RecordItem)dataItemDeclaration.getDataItem());
    }

    @Override
    public String toString() {
        if (this.file == null) {
            return this.getToken().image + " (validate method non invoked, yet)";
        }
        if (!this.file.hasSelectAndFD()) {
            return super.toString() + " (undefined)";
        }
        if (this.file.getIsSelectMissing()) {
            return super.toString() + " (select is missing)";
        }
        if (this.file.getIsFDMissing()) {
            return super.toString() + " (fd is missing)";
        }
        if (this.file.getIsSelectDuplicate()) {
            return super.toString() + " (select is duplicate)";
        }
        return super.toString();
    }

    @Override
    public void validate() {
        super.validate();
        if (this.findParent(AstSelectStatement.class) != null) {
            this.file = this.getCollector().declareFileSelect(this.getToken(), this.getToken().image);
        } else if (this.findParent(AstFileDescription.class) != null) {
            this.file = this.getCollector().declareFileDescription(this.getToken(), this.getToken().image);
            if (this.file.getIsSelectMissing()) {
                this.consoleWrite(41, this.getToken(), this.getToken().image);
            }
        } else {
            this.file = this.getCollector().getExistingFile(this.getToken(), this.getToken().image);
            if (this.file.getIsSelectMissing() || this.file.getIsFDMissing()) {
                this.consoleWrite(41, this.getToken(), this.getToken().image);
            } else if (this.findParentSubclass(AstAbstractFileIOStatement.class) != null) {
                this.getFile().setDeclaredOnly(false);
            }
        }
    }

    public FileDeclaration getFile() {
        return this.file;
    }
}

