/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.directives;

import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.exceptions.InvalidDirectiveException;
import java.util.EnumSet;

public final class FLAGSTD
extends BaseDirective {
    public static final String NAME = "FLAGSTD";
    private Subsets subset;
    private EnumSet<Modules> modules;
    private Boolean obsoleteElements;

    @Override
    public void setValues() throws InvalidDirectiveException {
        String[] stringArray;
        if (this.isNo()) {
            this.subset = null;
            this.modules = null;
            this.obsoleteElements = null;
            return;
        }
        this.checkParameterCount(1);
        this.subset = null;
        this.modules = EnumSet.noneOf(Modules.class);
        this.obsoleteElements = false;
        String[] stringArray2 = stringArray = this.getTokenValue(0).toUpperCase().split(" +");
        int n = stringArray2.length;
        block34: for (int i = 0; i < n; ++i) {
            String string;
            switch (string = stringArray2[i]) {
                case "M": 
                case "I": 
                case "H": {
                    if (this.subset == null) break;
                    throw Directives.invalidDirectiveException("Directive %s: Value '%s' can only appear once.", NAME, string);
                }
            }
            switch (string) {
                case "M": {
                    this.subset = Subsets.Minimum;
                    continue block34;
                }
                case "I": {
                    this.subset = Subsets.Intermediate;
                    continue block34;
                }
                case "H": {
                    this.subset = Subsets.High;
                    continue block34;
                }
                case "C1": {
                    this.modules.add(Modules.Communications1);
                    continue block34;
                }
                case "C2": {
                    this.modules.add(Modules.Communications2);
                    continue block34;
                }
                case "D1": {
                    this.modules.add(Modules.Debug1);
                    continue block34;
                }
                case "D2": {
                    this.modules.add(Modules.Debug2);
                    continue block34;
                }
                case "S1": {
                    this.modules.add(Modules.Segmentation1);
                    continue block34;
                }
                case "S2": {
                    this.modules.add(Modules.Segmentation2);
                    continue block34;
                }
                case "R": {
                    this.modules.add(Modules.ReportWriter);
                    continue block34;
                }
                case "O": {
                    this.obsoleteElements = true;
                }
            }
        }
        if (this.subset == null) {
            throw Directives.invalidDirectiveException("Directive %s: You must choose one of the following: '%s'.", NAME, String.join((CharSequence)"', '", "M", "I", "H"));
        }
    }

    @Override
    public boolean hasParameters() {
        return true;
    }

    @Override
    public boolean isNoAllowed() {
        return true;
    }

    @Override
    public BaseDirective.Set getSet() {
        return BaseDirective.Set.Init;
    }

    public static void setDefault(Directives directives) throws InvalidDirectiveException {
        directives.setDefault("NOFLAGSTD");
    }

    public Subsets getSubset() {
        return this.subset;
    }

    public EnumSet<Modules> getModules() {
        return this.modules;
    }

    public Boolean getObsoleteElements() {
        return this.obsoleteElements;
    }

    public FLAGSTD(boolean bl) {
        super(bl, null, null);
    }

    @Override
    public int getIndex() {
        return 126;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static enum Modules {
        Communications1,
        Communications2,
        Debug1,
        Debug2,
        Segmentation1,
        Segmentation2,
        ReportWriter;

    }

    public static enum Subsets {
        Minimum,
        Intermediate,
        High;

    }
}

