/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.directives;

import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.exceptions.InvalidDirectiveException;

public final class JOBS
extends BaseDirective {
    private static final int MAX_VCORE = Runtime.getRuntime().availableProcessors();
    public static final String NAME = "JOBS";
    private Integer maxJobs;

    @Override
    public void setValues() throws InvalidDirectiveException {
        this.checkParameterCount(1);
        this.maxJobs = this.getTokenIntegerValue(0, 0, MAX_VCORE);
        if (this.maxJobs == 0) {
            this.maxJobs = (int)Math.ceil((double)MAX_VCORE / 2.0);
        }
    }

    @Override
    public boolean hasParameters() {
        return true;
    }

    @Override
    public boolean isNoAllowed() {
        return false;
    }

    @Override
    public BaseDirective.Set getSet() {
        return BaseDirective.Set.No;
    }

    public static void setDefault(Directives directives) throws InvalidDirectiveException {
        directives.setDefault("JOBS\"0\"");
    }

    public Integer getMaxJobs() {
        return this.maxJobs;
    }

    public JOBS(boolean bl) {
        super(bl, null, null);
    }

    @Override
    public int getIndex() {
        return 171;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

