/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.directives;

import com.veryant.cobol.compiler.CompilerMessageSeverity;
import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.exceptions.InvalidDirectiveException;

public final class MAXERROR
extends BaseDirective {
    public static final String NAME = "MAXERROR";
    private Integer count;
    private CompilerMessageSeverity severity;

    @Override
    public void setValues() throws InvalidDirectiveException {
        if (this.isNo()) {
            this.count = Integer.MAX_VALUE;
            return;
        }
        this.checkParameterCount(1);
        String[] stringArray = this.getTokenValue(0).split(" +");
        if (stringArray.length > 2) {
            throw Directives.invalidDirectiveException("Directive %s: %s", NAME, "'count [severity]' expected.");
        }
        this.count = this.getTokenIntegerValue(stringArray[0]);
        if (stringArray.length == 1) {
            this.severity = CompilerMessageSeverity.F;
        } else {
            this.checkTokenValues(stringArray[1], true, "F", "I", "W", "E", "S");
            switch (stringArray[1].toUpperCase()) {
                case "F": {
                    this.severity = CompilerMessageSeverity.F;
                    break;
                }
                case "I": {
                    this.severity = CompilerMessageSeverity.I;
                    break;
                }
                case "W": {
                    this.severity = CompilerMessageSeverity.W;
                    break;
                }
                case "E": {
                    this.severity = CompilerMessageSeverity.E;
                    break;
                }
                case "S": {
                    this.severity = CompilerMessageSeverity.C;
                }
            }
        }
    }

    @Override
    public boolean hasParameters() {
        return true;
    }

    @Override
    public boolean isNoAllowed() {
        return true;
    }

    @Override
    public BaseDirective.Set getSet() {
        return BaseDirective.Set.Init;
    }

    public static void setDefault(Directives directives) throws InvalidDirectiveException {
        directives.setDefault("NOMAX-ERROR");
    }

    public Integer getCount() {
        return this.count;
    }

    public CompilerMessageSeverity getSeverity() {
        return this.severity;
    }

    public MAXERROR(boolean bl) {
        super(bl, null, null);
    }

    @Override
    public int getIndex() {
        return 192;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

