/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.directives;

import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.exceptions.InvalidDirectiveException;

public final class REPOSITORY
extends BaseDirective {
    public static final String NAME = "REPOSITORY";
    private boolean update;
    private boolean checking;

    @Override
    public void setValues() throws InvalidDirectiveException {
        this.checkParameterCount(1);
        String[] stringArray = this.getTokenValue(0).split(" +");
        if (stringArray.length % 2 != 0) {
            throw Directives.invalidDirectiveException("Directive %s: %s", NAME, "'[ {update|checking} {on|off} ]...' expected.");
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            this.checkTokenValues(stringArray[i], true, "UPDATE", "CHECKING");
            this.checkTokenValues(stringArray[i + 1], true, "ON", "OFF");
            if (stringArray[i].equalsIgnoreCase("UPDATE")) {
                this.update = stringArray[i + 1].equalsIgnoreCase("ON");
                continue;
            }
            this.checking = stringArray[i + 1].equalsIgnoreCase("ON");
        }
    }

    @Override
    public boolean hasParameters() {
        return true;
    }

    @Override
    public boolean isNoAllowed() {
        return false;
    }

    @Override
    public BaseDirective.Set getSet() {
        return BaseDirective.Set.Init;
    }

    public static void setDefault(Directives directives) throws InvalidDirectiveException {
        directives.setDefault("REPOSITORY\"UPDATE OFF CHECKING OFF\"");
    }

    public boolean getUpdate() {
        return this.update;
    }

    public boolean getChecking() {
        return this.checking;
    }

    public REPOSITORY(boolean bl) {
        super(bl, null, null);
    }

    @Override
    public int getIndex() {
        return 262;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

