/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters.jvm;

import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.CompilerMessage;
import com.veryant.cobol.compiler.emitters.ITargetCompiler;
import com.veryant.cobol.compiler.emitters.jvm.CobolProgramEmitter;
import com.veryant.cobol.compiler.emitters.jvm.JavaSourceFile;
import com.veryant.cobol.exceptions.COBOLCompilerException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;

public class JvmCompiler
implements ITargetCompiler {
    private PrintStream out = System.out;
    private final JavaCompiler javaCompiler;
    private final List<JavaSourceFile> javaSourceFiles = new Vector<JavaSourceFile>();

    public JvmCompiler() {
        this.javaCompiler = ToolProvider.getSystemJavaCompiler();
        if (this.javaCompiler == null) {
            throw new COBOLCompilerException("No JDK installed, or no tools.jar found in CLASSPATH");
        }
    }

    @Override
    public void emit(Collector collector) {
        this.javaSourceFiles.addAll(JvmCompiler.transplant(collector));
    }

    @Override
    public void compile() {
        this.runJavaTask(this.javaSourceFiles);
    }

    protected static List<JavaSourceFile> transplant(Collector collector) {
        return CobolProgramEmitter.emit(collector);
    }

    private boolean checkOutputFolder(String string) {
        File file = new File(string);
        if (file.exists()) {
            return file.isDirectory() && file.canWrite();
        }
        return file.mkdirs();
    }

    protected void runJavaTask(List<JavaSourceFile> list) {
        if (list.size() == 0) {
            return;
        }
        try {
            for (JavaSourceFile list22 : list) {
                list22.save();
            }
        }
        catch (IOException iOException) {
            throw new COBOLCompilerException(iOException.getMessage());
        }
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        List<String> list2 = Arrays.asList("-d", list.get(list.size() - 1).getOutputFolder());
        JavaCompiler.CompilationTask compilationTask = this.javaCompiler.getTask(null, null, diagnosticCollector, list2, null, list);
        if (!compilationTask.call().booleanValue()) {
            boolean bl = false;
            for (Diagnostic diagnostic : diagnosticCollector.getDiagnostics()) {
                if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
                bl = true;
                this.out.println(new CompilerMessage(4, (int)diagnostic.getLineNumber(), (int)diagnostic.getColumnNumber(), "Java Source", diagnostic.getMessage(null)));
            }
            if (bl) {
                this.out.println();
                this.out.println("CONTACT TECHNICAL SUPPORT:");
                this.out.println("Your program contains an error which the COBOL system has failed to recognize.");
                this.out.println("Send to the Technical Support a copy of the above reported errors and a copy of your source code.");
                this.out.println();
            }
        }
    }
}

