/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters.jvm.builtin;

import com.veryant.cobol.compiler.BuiltIn;
import com.veryant.cobol.compiler.DataUsage;
import com.veryant.cobol.compiler.Magnitude;
import com.veryant.cobol.compiler.TruncConvention;
import com.veryant.cobol.compiler.emitters.jvm.BuiltInEmitter;
import com.veryant.cobol.compiler.emitters.jvm.Local;
import com.veryant.cobol.compiler.emitters.jvm.VMType;
import com.veryant.cobol.compiler.emitters.jvm.core.Errors;
import com.veryant.cobol.compiler.emitters.jvm.core.Opcodes;
import com.veryant.cobol.compiler.emitters.jvm.core.Templates;
import com.veryant.cobol.compiler.memory.DataItem;
import com.veryant.cobol.compiler.memory.DynamicChunk;
import com.veryant.cobol.compiler.types.DataItemReference;
import com.veryant.cobol.converters.CMP2UDEC;
import com.veryant.cobol.converters.CMP3U;
import com.veryant.cobol.converters.CMP3UVAX;
import com.veryant.cobol.converters.CMP5U;
import com.veryant.cobol.converters.CMP6;
import com.veryant.cobol.converters.CMPXU;

public abstract class Promoted {
    private static final int[] INT_MASK = new int[]{0, 255, 65535, 0xFFFFFF, -1};
    private static final long[] LONG_MASK = new long[]{0L, 255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, -1L};
    static final BuiltInEmitter LOAD = (jvmCode, abstractOperand) -> {
        Magnitude magnitude = abstractOperand.getMagnitude();
        VMType vMType = VMType.from(magnitude);
        DataItem dataItem = ((DataItemReference)abstractOperand).getDataItem();
        if (!dataItem.isPromoted()) {
            throw Errors.e_types_system_fail();
        }
        jvmCode.push(abstractOperand, vMType, dataItem.getPromotedName(), magnitude);
    };
    static final BuiltInEmitter STORE = (jvmCode, abstractOperand) -> {
        Magnitude magnitude = abstractOperand.getMagnitude();
        DataItem dataItem = ((DataItemReference)abstractOperand).getDataItem();
        String string = dataItem.getPromotedName();
        BuiltIn builtIn = abstractOperand.getBuiltIn();
        TruncConvention truncConvention = builtIn.getTruncConvention();
        int n = 0;
        switch (truncConvention) {
            case YES: {
                n = magnitude.getDigits();
                break;
            }
            case CONFIGURABLE: {
                switch (jvmCode.getTruncation()) {
                    case ENFORCED: 
                    case ANSI: {
                        n = magnitude.getDigits();
                    }
                }
            }
        }
        if (n > 0) {
            Opcodes.TRUNC(jvmCode, magnitude.getDigits(), magnitude.getScale());
        } else {
            Opcodes.SCALE(jvmCode, magnitude.getScale());
        }
        if (builtIn.getUsage() != DataUsage.DISPLAY) {
            int n2 = ((DynamicChunk)((DataItemReference)abstractOperand).getDataItem().getChunk()).getSize();
            VMType vMType = VMType.from(magnitude);
            if (!magnitude.isSigned()) {
                Class<?> clazz = builtIn.getStoreConvention();
                if (clazz.equals(CMP2UDEC.class) || clazz.equals(CMP3U.class) || clazz.equals(CMP3UVAX.class) || clazz.equals(CMPXU.class) || clazz.equals(CMP5U.class) || clazz.equals(CMP6.class)) {
                    Local local = Opcodes.STORE_LOCAL(jvmCode);
                    Opcodes.LOAD_LOCAL(jvmCode, local);
                    Opcodes.LOAD_CONST(jvmCode, 0);
                    Opcodes.LT(jvmCode);
                    Opcodes.IF(jvmCode);
                    Opcodes.LOAD_LOCAL(jvmCode, local);
                    Opcodes.NEG(jvmCode);
                    Opcodes.STORE_LOCAL(jvmCode, local);
                    Opcodes.FI(jvmCode);
                    Opcodes.LOAD_LOCAL(jvmCode, local);
                }
                if (n2 < 4) {
                    Opcodes.LOAD_CONST(jvmCode, INT_MASK[n2]);
                    Opcodes.BITWISE_AND(jvmCode);
                } else if (n2 > 4 && n2 < 8) {
                    Opcodes.LOAD_CONST(jvmCode, LONG_MASK[n2]);
                    Opcodes.BITWISE_AND(jvmCode);
                }
            } else {
                int n3 = (n2 + 3) / 4 * 32 - n2 * 8;
                if (n3 > 0) {
                    Opcodes.LOAD_CONST(jvmCode, n3);
                    Opcodes.INJECT(jvmCode, vMType, Templates.T_SHIFT_LEFT);
                    Opcodes.LOAD_CONST(jvmCode, n3);
                    Opcodes.INJECT(jvmCode, vMType, Templates.T_SHIFT_RIGHT, magnitude);
                }
            }
        }
        Opcodes.CAST(jvmCode, VMType.from(magnitude));
        jvmCode.push(abstractOperand, VMType.VOID, string + "=" + jvmCode.pop() + ";");
        if (builtIn.getUsage() == DataUsage.DISPLAY && !magnitude.isSigned()) {
            jvmCode.push(abstractOperand, VMType.VOID, string + "=" + string + "<0?-" + string + ":" + string + ";");
        }
    };
}

