/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters.jvm.statements;

import com.veryant.cobol.compiler.EntryPoint;
import com.veryant.cobol.compiler.IOperand;
import com.veryant.cobol.compiler.IStatement;
import com.veryant.cobol.compiler.StringFormat;
import com.veryant.cobol.compiler.UsingParameterMode;
import com.veryant.cobol.compiler.emitters.jvm.JvmCode;
import com.veryant.cobol.compiler.emitters.jvm.Local;
import com.veryant.cobol.compiler.emitters.jvm.VMType;
import com.veryant.cobol.compiler.emitters.jvm.core.Opcodes;
import com.veryant.cobol.compiler.emitters.jvm.statements.BaseEmitter;
import com.veryant.cobol.compiler.stmts.Call;
import com.veryant.cobol.compiler.types.AbstractLiteral;
import com.veryant.cobol.compiler.types.AbstractOperand;
import com.veryant.cobol.data.CobolDataReference;
import com.veryant.cobol.rununit.ICallable;

public abstract class CallEmitter
extends BaseEmitter {
    protected static final VMType CDR_ARR = VMType.from(CobolDataReference[].class);
    protected static final VMType CLASS = VMType.from(Class.class);
    protected static final VMType ICALL = VMType.from(ICallable.class);
    private static final StringFormat LOAD_INSTANCE = new StringFormat("Environment.load($RUT$,{?})");
    private static final StringFormat STATIC_CALL = new StringFormat("(({?}){?}).$ENTRY${?}()");
    private static final StringFormat STATIC_CALL_ARGS = new StringFormat("(({?}){?}).$ENTRY${?}({?})");
    private static final StringFormat DYN_CALL = new StringFormat("Environment.call($RUT$,{?},0)");
    private static final StringFormat DYN_CALL_ARGS = new StringFormat("Environment.call($RUT$,{?},0,{?})");
    private static final StringFormat BY_REF = new StringFormat("new CobolDataReference({?})");
    private static final StringFormat BY_VAL = new StringFormat("new CobolDataValue({?})");
    private static final StringFormat IGNORE_RET = new StringFormat("{?};");
    private static final StringFormat TEST_ADDR = new StringFormat("{?}.getAddress({?})");

    public static void emit(JvmCode jvmCode, IStatement iStatement) {
        Call call = (Call)iStatement;
        EntryPoint entryPoint = call.getEntryPoint();
        Local local = null;
        if (call.hasExceptionBlocks()) {
            Opcodes.LOAD_CONST(jvmCode, false);
            local = Opcodes.STORE_LOCAL(jvmCode);
            Opcodes.INJECT(jvmCode, "try{");
        }
        if (entryPoint != null) {
            String string = entryPoint.getModuleName();
            Opcodes.INJECT(jvmCode, CLASS, string + ".class");
            Opcodes.INJECT(jvmCode, ICALL, LOAD_INSTANCE);
            Local local2 = Opcodes.STORE_LOCAL(jvmCode);
            Opcodes.INJECT(jvmCode, CLASS, string);
            Opcodes.LOAD_LOCAL(jvmCode, local2);
            Opcodes.LOAD_CONST(jvmCode, entryPoint.getIndex());
            CallEmitter.emitCall(jvmCode, true, call.getModes(), call.getParameters());
        } else {
            AbstractOperand abstractOperand = call.getModule();
            if (abstractOperand instanceof AbstractLiteral) {
                com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.LOAD(jvmCode, abstractOperand);
            } else {
                com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.LOAD_ADDR(jvmCode, abstractOperand);
                Opcodes.CAST(jvmCode, VMType.STRING);
            }
            CallEmitter.emitCall(jvmCode, false, call.getModes(), call.getParameters());
        }
        if (call.getReturnValue() != null) {
            com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.STORE(jvmCode, call.getReturnValue());
        } else {
            Opcodes.INJECT(jvmCode, IGNORE_RET);
        }
        if (local != null) {
            Opcodes.INJECT(jvmCode, "}catch(Exception ignored){");
            Opcodes.LOAD_CONST(jvmCode, true);
            Opcodes.STORE_LOCAL(jvmCode, local);
            Opcodes.INJECT(jvmCode, "}");
            Opcodes.LOAD_LOCAL(jvmCode, local);
            if (call.getExceptionBlock() != null) {
                Opcodes.IF(jvmCode);
                CallEmitter.emitBlock(jvmCode, call.getExceptionBlock(), false);
                if (call.getNotExceptionBlock() != null) {
                    Opcodes.ELSE(jvmCode);
                    CallEmitter.emitBlock(jvmCode, call.getNotExceptionBlock(), false);
                }
                Opcodes.FI(jvmCode);
            } else {
                Opcodes.NOT(jvmCode);
                Opcodes.IF(jvmCode);
                CallEmitter.emitBlock(jvmCode, call.getNotExceptionBlock(), false);
                Opcodes.FI(jvmCode);
            }
        }
    }

    private static void emitCall(JvmCode jvmCode, boolean bl, UsingParameterMode[] usingParameterModeArray, AbstractOperand[] abstractOperandArray) {
        boolean bl2;
        boolean bl3 = bl2 = abstractOperandArray != null && abstractOperandArray.length > 0;
        if (bl2) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < abstractOperandArray.length; ++i) {
                AbstractOperand abstractOperand = abstractOperandArray[i];
                if (usingParameterModeArray[i] == UsingParameterMode.Value || usingParameterModeArray[i] == UsingParameterMode.Content) {
                    if (IOperand.isNumeric(abstractOperand)) {
                        com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.LOAD(jvmCode, abstractOperand);
                    } else {
                        com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.LOAD_ADDR(jvmCode, abstractOperand);
                        Opcodes.INJECT(jvmCode, VMType.OBJECT, BY_VAL);
                    }
                } else {
                    com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.LOAD_ADDR(jvmCode, abstractOperand, true);
                    jvmCode.pop();
                    Opcodes.INJECT(jvmCode, VMType.INT64, TEST_ADDR);
                }
                if (i != 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(jvmCode.pop());
            }
            Opcodes.INJECT(jvmCode, CDR_ARR, stringBuilder.toString());
        }
        if (bl) {
            if (bl2) {
                Opcodes.INJECT(jvmCode, VMType.INT64, STATIC_CALL_ARGS);
            } else {
                Opcodes.INJECT(jvmCode, VMType.INT64, STATIC_CALL);
            }
        } else if (bl2) {
            Opcodes.INJECT(jvmCode, VMType.INT64, DYN_CALL_ARGS);
        } else {
            Opcodes.INJECT(jvmCode, VMType.INT64, DYN_CALL);
        }
    }
}

