/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.memory;

import com.veryant.cobol.compiler.BuiltIn;
import com.veryant.cobol.compiler.ClassField;
import com.veryant.cobol.compiler.ClassFieldSet;
import com.veryant.cobol.compiler.Magnitude;
import com.veryant.cobol.compiler.NameGenerator;
import com.veryant.cobol.compiler.memory.DynamicChunk;
import com.veryant.cobol.compiler.memory.HasChunk;
import com.veryant.cobol.compiler.memory.IPromotable;
import com.veryant.cobol.compiler.memory.RecordItem;
import com.veryant.cobol.exceptions.COBOLCompilerException;
import java.util.ArrayList;
import java.util.List;

public class DataItem
extends HasChunk<DynamicChunk>
implements IPromotable {
    private static final DataItem[] NO_CHILDREN = new DataItem[0];
    private List<DataItem> children;
    private DataItem parent;
    private final String name;
    private final BuiltIn builtIn;
    private final Magnitude magnitude;
    private final int declaredSize;
    private final int declaredTimes;
    private boolean used;
    private ClassField promotionField;
    private ClassFieldSet promotionDestination;
    private NameGenerator promotionPool;

    public RecordItem getRecordItem() {
        if (this instanceof RecordItem) {
            return (RecordItem)this;
        }
        if (this.parent != null) {
            return this.parent.getRecordItem();
        }
        return null;
    }

    public DataItem[] getChildren() {
        if (this.children != null) {
            return this.children.toArray(new DataItem[this.children.size()]);
        }
        return NO_CHILDREN;
    }

    public int getChildrenCount() {
        return this.children != null ? this.children.size() : 0;
    }

    public boolean isFiller() {
        return this.getName() == null;
    }

    public boolean isOccurs() {
        return this.declaredTimes > 0;
    }

    public DataItem getParentOccurs() {
        for (DataItem dataItem = this.getParent(); dataItem != null; dataItem = dataItem.getParent()) {
            if (!dataItem.isOccurs()) continue;
            return dataItem;
        }
        return null;
    }

    public int getOccursRank() {
        int n = 0;
        if (this.isOccurs()) {
            ++n;
        }
        for (DataItem dataItem = this.getParentOccurs(); dataItem != null; dataItem = dataItem.getParentOccurs()) {
            ++n;
        }
        return n;
    }

    public void addChild(DataItem dataItem) {
        if (this.children == null) {
            this.children = new ArrayList<DataItem>();
        }
        this.children.add(dataItem);
        dataItem.parent = this;
    }

    public static boolean isValidRedefines(DataItem dataItem, List<DataItem> list, int n) {
        for (int i = n; i >= 0; --i) {
            if (list.get(i) == dataItem) {
                return true;
            }
            if (((DynamicChunk)list.get(i).getChunk()).hasUnion()) continue;
            return false;
        }
        return false;
    }

    public boolean isValidRedefines(DataItem dataItem) {
        if (this.parent != null) {
            for (int i = 0; i < this.parent.children.size(); ++i) {
                if (this.parent.children.get(i) != this) continue;
                return DataItem.isValidRedefines(dataItem, this.parent.children, i - 1);
            }
        }
        return false;
    }

    public DataItem(String string, BuiltIn builtIn, Magnitude magnitude, int n) {
        this(string, builtIn, magnitude, n, 0);
    }

    public DataItem(String string, BuiltIn builtIn, Magnitude magnitude, int n, int n2) {
        this.name = string;
        this.builtIn = builtIn;
        this.magnitude = magnitude;
        this.declaredSize = n;
        this.declaredTimes = n2;
    }

    protected void setChunk(DynamicChunk dynamicChunk, ClassFieldSet classFieldSet, NameGenerator nameGenerator) {
        super.setChunk(dynamicChunk);
        if (this.magnitude == null) {
            return;
        }
        this.promotionDestination = classFieldSet;
        this.promotionPool = nameGenerator;
        dynamicChunk.setUsed(false);
    }

    @Override
    protected void setChunk(DynamicChunk dynamicChunk) {
        super.setChunk(dynamicChunk);
        dynamicChunk.setUsed(true);
    }

    @Override
    public boolean isPromoted() {
        boolean bl;
        boolean bl2 = bl = this.promotionDestination != null && this.promotionPool != null;
        if (bl) {
            return !this.isChunkReferenced();
        }
        return false;
    }

    public boolean isChunkReferenced() {
        for (DataItem dataItem = this.getParent(); dataItem != null; dataItem = dataItem.getParent()) {
            if (!((DynamicChunk)dataItem.getChunk()).isUsed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void denyPromotion() {
        this.promotionDestination = null;
        this.promotionPool = null;
        ((DynamicChunk)this.getChunk()).setUsed(true);
    }

    @Override
    public String getPromotedName() {
        return this.createField().getName();
    }

    private ClassField createField() {
        if (!this.isPromoted()) {
            throw new COBOLCompilerException("Internal error, types system fail");
        }
        if (this.promotionField == null) {
            this.promotionField = new ClassField(this.promotionPool.next(), this.magnitude);
            this.promotionDestination.put(this.promotionField);
        }
        return this.promotionField;
    }

    public DataItem getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public BuiltIn getBuiltIn() {
        return this.builtIn;
    }

    public Magnitude getMagnitude() {
        return this.magnitude;
    }

    public int getDeclaredSize() {
        return this.declaredSize;
    }

    public int getDeclaredTimes() {
        return this.declaredTimes;
    }

    public boolean isUsed() {
        return this.used;
    }

    public void setUsed(boolean bl) {
        this.used = bl;
    }
}

