/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.stmts;

import com.veryant.cobol.compiler.IOperand;
import com.veryant.cobol.compiler.ISourceReference;
import com.veryant.cobol.compiler.Statements;
import com.veryant.cobol.compiler.emitters.jvm.MathPrecision;
import com.veryant.cobol.compiler.stmts.AbstractArithmeticStatement;
import com.veryant.cobol.compiler.types.AbstractOperand;

public class Multiply
extends AbstractArithmeticStatement {
    private final AbstractOperand operand;
    private final AbstractOperand[] byOperands;
    private final AbstractOperand[] givingOperands;

    @Override
    public Statements getStatement() {
        return Statements.MULTIPLY;
    }

    @Override
    public MathPrecision getPrecision() {
        if (IOperand.isFloatingPoint(this.operand)) {
            return MathPrecision.FLOATING_POINT_PRECISION;
        }
        for (AbstractOperand abstractOperand : this.byOperands) {
            if (!IOperand.isFloatingPoint(abstractOperand)) continue;
            return MathPrecision.FLOATING_POINT_PRECISION;
        }
        return MathPrecision.FIXED_POINT_PRECISION;
    }

    public Multiply(ISourceReference iSourceReference, AbstractOperand abstractOperand, AbstractOperand[] abstractOperandArray, AbstractOperand[] abstractOperandArray2) {
        super(iSourceReference);
        this.operand = abstractOperand;
        this.byOperands = abstractOperandArray;
        this.givingOperands = abstractOperandArray2;
    }

    public Multiply(ISourceReference iSourceReference, AbstractOperand abstractOperand, AbstractOperand[] abstractOperandArray) {
        this(iSourceReference, abstractOperand, abstractOperandArray, null);
    }

    public AbstractOperand getOperand() {
        return this.operand;
    }

    public AbstractOperand[] getByOperands() {
        return this.byOperands;
    }

    public AbstractOperand[] getGivingOperands() {
        return this.givingOperands;
    }
}

