/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.converters;

import com.veryant.cobol.converters.CharsetConstants;
import com.veryant.cobol.data.IMemory;
import com.veryant.cobol.exceptions.COBOLRuntimeException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;

public class Raw
extends CharsetConstants {
    private static final int PREALLOCATED_SIZE = 1024;
    private static final byte[] NULLS = new byte[1024];
    private static final byte[] ASCII_SPACES = Raw.allocMemory(1024, (byte)32);
    private static final byte[] EBCDIC_SPACES = Raw.allocMemory(1024, (byte)64);

    public static byte[] allocMemory(int n, byte by) {
        byte[] byArray = new byte[n];
        Arrays.fill(byArray, by);
        return byArray;
    }

    public static void copyMemory(IMemory iMemory, int n, IMemory iMemory2, int n2, int n3) {
        iMemory2.copy(iMemory, n, n2, n3);
    }

    public static void copyMemory(IMemory iMemory, int n, int n2, IMemory iMemory2, int n3, int n4) {
        iMemory2.copy(iMemory, n, n3, n4);
    }

    public static void initMemory(IMemory iMemory, int n, int n2, byte by) {
        byte[] byArray;
        switch (by) {
            case 32: {
                byArray = ASCII_SPACES;
                break;
            }
            case 64: {
                byArray = EBCDIC_SPACES;
                break;
            }
            case 0: {
                byArray = NULLS;
                break;
            }
            default: {
                while (n < n2) {
                    iMemory.put(n++, by);
                }
                return;
            }
        }
        while (n2 > 0) {
            int n3 = n2;
            if (n3 > 1024) {
                n3 = 1024;
            }
            iMemory.copy(byArray, 0, n, n3);
            n += n3;
            n2 -= n3;
        }
    }

    public static void initMemory(Class<?> clazz, IMemory iMemory, String string) {
        Object object = clazz.getName();
        int n = ((String)object).lastIndexOf(46);
        if (n > 0) {
            object = ((String)object).substring(n + 1);
        }
        object = (String)object + "." + string;
        try {
            URL uRL = clazz.getResource((String)object);
            if (uRL == null) {
                throw new COBOLRuntimeException(String.format("Can't read resource file: %s", object));
            }
            byte[] byArray = Files.readAllBytes(Paths.get(uRL.toURI()));
            if (byArray.length != iMemory.getSize()) {
                throw new COBOLRuntimeException(String.format("Resource file size mismatch: %s", object));
            }
            iMemory.copy(byArray, 0, 0, byArray.length);
        }
        catch (IOException | URISyntaxException exception) {
            throw new COBOLRuntimeException(String.format("Can't read resource file: %s", exception.getMessage()));
        }
    }
}

