/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.rununit;

import com.veryant.cobol.data.CobolString;
import java.util.Scanner;

public class Console {
    private static final Scanner scanner = new Scanner(System.in);

    public static void write(CobolString cobolString) {
        System.out.print(cobolString.toString());
    }

    public static void write(String string) {
        System.out.print(string);
    }

    public static void writeLine(CobolString cobolString) {
        Console.writeLine(cobolString.toString());
    }

    public static void writeLine(String string) {
        Console.write(string);
        Console.newLine();
    }

    public static void writeLine(Exception exception) {
        Console.writeLine("---------------- EXCEPTION CAUGHT ----------------");
        Console.writeLine("Message: " + exception.getLocalizedMessage());
        Console.writeLine("StackTrace:");
        for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
            Console.writeLine("    " + stackTraceElement.toString());
        }
    }

    public static void newLine() {
        System.out.println();
        System.out.flush();
    }

    public static String readLine() {
        return scanner.nextLine();
    }
}

