/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file;

import com.veryant.vision4j.file.FileSystemCache;
import com.veryant.vision4j.file.IndexFile;
import com.veryant.vision4j.file.SegmentedFile;
import com.veryant.vision4j.file.internals.Block;
import com.veryant.vision4j.file.internals.FileAddress;
import com.veryant.vision4j.file.internals.FileDescriptor;
import com.veryant.vision4j.file.internals.Lock;
import com.veryant.vision4j.file.internals.LogicalAttributes;
import com.veryant.vision4j.file.internals.PhysicalAttributes;
import com.veryant.vision4j.file.internals.PointerState;

class File
extends SegmentedFile {
    private int id;
    private final String name;
    private final int openMode;
    private boolean pendingTransaction;
    private final FileSystemCache fileSystemCache;
    private final int version;
    private final PhysicalAttributes physicalAttributes;
    private final LogicalAttributes logicalAttributes;
    private final short recordOverhead;
    private final long maxSegmentSize;
    private final boolean rollbackable;
    private final int blockSize;
    private boolean headerLocked;
    private boolean unlockedHeaderRead;
    private final Block headerCache;
    private PointerState pointerState = PointerState.NO_CUR_REC;
    private boolean currentIsNext;
    private int currentKeyNum;
    private long currentUniqueId;
    private final Block currentKey = new Block(252);
    private final Block currentPrimaryKey = new Block(250);
    private final FileAddress currentRecord = new FileAddress();
    private final FileAddress currentNode = new FileAddress();
    private final FileAddress lastReadBlock = new FileAddress();
    private long lastReadTreeVersion;
    private final FileAddress[] readNextAddressesCache = new FileAddress[10];
    private final byte[] temporaryRecord;
    private final Block compressedRecord;
    private final Block rewrittenRecord;
    private final Block record;
    private final Block loadedNode;
    private long totalRecords;
    private long deletedRecords;
    private long abandonedRecords;
    private int freeFailures;
    private int openCounter;
    private long treeVersion;
    private long keyRootVersion;
    private long nextUniqueId;
    private int findKeyNum;
    private final Block foundKey = new Block(252);
    private boolean foundExactMatch;
    private int keyEntryOffset;
    private int keyEntryOverhead;
    private final FileAddress[] nodeAddresses = new FileAddress[30];
    private final FileAddress nextRec = new FileAddress();
    private final FileAddress firstRec = new FileAddress();
    private final FileAddress freeRec = new FileAddress();
    private final FileAddress abandonedRec = new FileAddress();
    private final FileAddress firstNode = new FileAddress();
    private final FileAddress freeNode = new FileAddress();
    private final Lock[] locks;
    private final IndexFile indexFile;
    private long usedNodes;
    private long freeNodes;
    private long nodeUsage;
    private final Block collate;

    public long incCurrentUniqueId() {
        return ++this.currentUniqueId;
    }

    public long incTotalRecords() {
        return ++this.totalRecords;
    }

    public long decTotalRecords() {
        return --this.totalRecords;
    }

    public long incDeletedRecords() {
        return ++this.deletedRecords;
    }

    public long decDeletedRecords() {
        return --this.deletedRecords;
    }

    public long incAbandonedRecords() {
        return ++this.abandonedRecords;
    }

    public int incFreeFailures() {
        return ++this.freeFailures;
    }

    public long incOpenCounter() {
        return ++this.openCounter;
    }

    public long decOpenCounter() {
        return --this.openCounter;
    }

    public long incTreeVersion() {
        return ++this.treeVersion;
    }

    public long incKeyRootVersion() {
        return ++this.keyRootVersion;
    }

    public long incNextUniqueId() {
        return ++this.nextUniqueId;
    }

    public long incUsedNodes() {
        return ++this.usedNodes;
    }

    public long decUsedNodes() {
        return --this.usedNodes;
    }

    public long incFreeNodes() {
        return ++this.freeNodes;
    }

    public long decFreeNodes() {
        return --this.freeNodes;
    }

    public long incNodeUsage(long amount) {
        return this.nodeUsage += amount;
    }

    public long decNodeUsage(long amount) {
        return this.nodeUsage -= amount;
    }

    public byte[] copyOfCollate() {
        return this.collate.copy().getBytes();
    }

    public boolean hasCollate() {
        return this.collate != null;
    }

    public byte collate(int index) {
        return this.collate.get8(index);
    }

    File(String name, int openMode, int version, Block headerCache, PhysicalAttributes physicalAttributes, LogicalAttributes logicalAttributes, FileDescriptor segment0, FileDescriptor indexSegment0, Block collate, short recordOverhead, long maxSegmentSize, int locksTableSize, boolean rollbackable, FileSystemCache fileSystemCache) {
        this.name = name;
        this.openMode = openMode;
        this.version = version;
        this.headerCache = headerCache;
        this.physicalAttributes = physicalAttributes;
        this.logicalAttributes = logicalAttributes;
        this.blockSize = physicalAttributes.getBlockingFactor() * 512;
        this.addSegment(segment0);
        if (indexSegment0 != null) {
            this.indexFile = new IndexFile();
            this.indexFile.addSegment(indexSegment0);
        } else {
            this.indexFile = null;
        }
        this.collate = collate;
        this.recordOverhead = recordOverhead;
        this.maxSegmentSize = maxSegmentSize;
        this.locks = new Lock[locksTableSize];
        this.rollbackable = rollbackable;
        this.fileSystemCache = fileSystemCache;
        this.record = new Block(logicalAttributes.getMaxRecordSize() + recordOverhead);
        this.rewrittenRecord = new Block(logicalAttributes.getMaxRecordSize() + recordOverhead);
        this.compressedRecord = new Block(logicalAttributes.getMaxRecordSize() + recordOverhead + 16);
        this.temporaryRecord = new byte[logicalAttributes.getMaxRecordSize()];
        this.loadedNode = new Block(this.blockSize);
    }

    public String toString() {
        return "name: '" + this.name + '\'' + ", version: " + this.version + ", record overhead: " + this.recordOverhead + ", max segment size: " + this.maxSegmentSize + ", total records: " + this.totalRecords + ", deleted records: " + this.deletedRecords + ", abandoned records: " + this.abandonedRecords + ", free failures: " + this.freeFailures + ", open counter: " + this.openCounter + ", internal version: " + this.treeVersion + ", keys root version: " + this.keyRootVersion + ", next unique id: " + this.nextUniqueId + ", size: " + this.getFileSize() + ", used nodes: " + this.usedNodes + ", free nodes: " + this.freeNodes + ", node usage: " + this.nodeUsage + " bytes";
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public int getOpenMode() {
        return this.openMode;
    }

    public boolean isPendingTransaction() {
        return this.pendingTransaction;
    }

    public void setPendingTransaction(boolean pendingTransaction) {
        this.pendingTransaction = pendingTransaction;
    }

    public FileSystemCache getFileSystemCache() {
        return this.fileSystemCache;
    }

    public int getVersion() {
        return this.version;
    }

    public PhysicalAttributes getPhysicalAttributes() {
        return this.physicalAttributes;
    }

    public LogicalAttributes getLogicalAttributes() {
        return this.logicalAttributes;
    }

    public short getRecordOverhead() {
        return this.recordOverhead;
    }

    public long getMaxSegmentSize() {
        return this.maxSegmentSize;
    }

    public boolean isRollbackable() {
        return this.rollbackable;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public boolean isHeaderLocked() {
        return this.headerLocked;
    }

    public void setHeaderLocked(boolean headerLocked) {
        this.headerLocked = headerLocked;
    }

    public boolean isUnlockedHeaderRead() {
        return this.unlockedHeaderRead;
    }

    public void setUnlockedHeaderRead(boolean unlockedHeaderRead) {
        this.unlockedHeaderRead = unlockedHeaderRead;
    }

    public Block getHeaderCache() {
        return this.headerCache;
    }

    public PointerState getPointerState() {
        return this.pointerState;
    }

    public void setPointerState(PointerState pointerState) {
        this.pointerState = pointerState;
    }

    public boolean isCurrentIsNext() {
        return this.currentIsNext;
    }

    public void setCurrentIsNext(boolean currentIsNext) {
        this.currentIsNext = currentIsNext;
    }

    public int getCurrentKeyNum() {
        return this.currentKeyNum;
    }

    public void setCurrentKeyNum(int currentKeyNum) {
        this.currentKeyNum = currentKeyNum;
    }

    public long getCurrentUniqueId() {
        return this.currentUniqueId;
    }

    public void setCurrentUniqueId(long currentUniqueId) {
        this.currentUniqueId = currentUniqueId;
    }

    public Block getCurrentKey() {
        return this.currentKey;
    }

    public Block getCurrentPrimaryKey() {
        return this.currentPrimaryKey;
    }

    public FileAddress getCurrentRecord() {
        return this.currentRecord;
    }

    public FileAddress getCurrentNode() {
        return this.currentNode;
    }

    public FileAddress getLastReadBlock() {
        return this.lastReadBlock;
    }

    public long getLastReadTreeVersion() {
        return this.lastReadTreeVersion;
    }

    public void setLastReadTreeVersion(long lastReadTreeVersion) {
        this.lastReadTreeVersion = lastReadTreeVersion;
    }

    public FileAddress[] getReadNextAddressesCache() {
        return this.readNextAddressesCache;
    }

    public byte[] getTemporaryRecord() {
        return this.temporaryRecord;
    }

    public Block getCompressedRecord() {
        return this.compressedRecord;
    }

    public Block getRewrittenRecord() {
        return this.rewrittenRecord;
    }

    public Block getRecord() {
        return this.record;
    }

    public Block getLoadedNode() {
        return this.loadedNode;
    }

    public long getTotalRecords() {
        return this.totalRecords;
    }

    public void setTotalRecords(long totalRecords) {
        this.totalRecords = totalRecords;
    }

    public long getDeletedRecords() {
        return this.deletedRecords;
    }

    public void setDeletedRecords(long deletedRecords) {
        this.deletedRecords = deletedRecords;
    }

    public long getAbandonedRecords() {
        return this.abandonedRecords;
    }

    public void setAbandonedRecords(long abandonedRecords) {
        this.abandonedRecords = abandonedRecords;
    }

    public int getFreeFailures() {
        return this.freeFailures;
    }

    public void setFreeFailures(int freeFailures) {
        this.freeFailures = freeFailures;
    }

    public int getOpenCounter() {
        return this.openCounter;
    }

    public void setOpenCounter(int openCounter) {
        this.openCounter = openCounter;
    }

    public long getTreeVersion() {
        return this.treeVersion;
    }

    public void setTreeVersion(long treeVersion) {
        this.treeVersion = treeVersion;
    }

    public long getKeyRootVersion() {
        return this.keyRootVersion;
    }

    public void setKeyRootVersion(long keyRootVersion) {
        this.keyRootVersion = keyRootVersion;
    }

    public long getNextUniqueId() {
        return this.nextUniqueId;
    }

    public void setNextUniqueId(long nextUniqueId) {
        this.nextUniqueId = nextUniqueId;
    }

    public int getFindKeyNum() {
        return this.findKeyNum;
    }

    public void setFindKeyNum(int findKeyNum) {
        this.findKeyNum = findKeyNum;
    }

    public Block getFoundKey() {
        return this.foundKey;
    }

    public boolean isFoundExactMatch() {
        return this.foundExactMatch;
    }

    public void setFoundExactMatch(boolean foundExactMatch) {
        this.foundExactMatch = foundExactMatch;
    }

    public int getKeyEntryOffset() {
        return this.keyEntryOffset;
    }

    public void setKeyEntryOffset(int keyEntryOffset) {
        this.keyEntryOffset = keyEntryOffset;
    }

    public int getKeyEntryOverhead() {
        return this.keyEntryOverhead;
    }

    public void setKeyEntryOverhead(int keyEntryOverhead) {
        this.keyEntryOverhead = keyEntryOverhead;
    }

    public FileAddress[] getNodeAddresses() {
        return this.nodeAddresses;
    }

    public FileAddress getNextRec() {
        return this.nextRec;
    }

    public FileAddress getFirstRec() {
        return this.firstRec;
    }

    public FileAddress getFreeRec() {
        return this.freeRec;
    }

    public FileAddress getAbandonedRec() {
        return this.abandonedRec;
    }

    public FileAddress getFirstNode() {
        return this.firstNode;
    }

    public FileAddress getFreeNode() {
        return this.freeNode;
    }

    public Lock[] getLocks() {
        return this.locks;
    }

    public IndexFile getIndexFile() {
        return this.indexFile;
    }

    public long getUsedNodes() {
        return this.usedNodes;
    }

    public void setUsedNodes(long usedNodes) {
        this.usedNodes = usedNodes;
    }

    public long getFreeNodes() {
        return this.freeNodes;
    }

    public void setFreeNodes(long freeNodes) {
        this.freeNodes = freeNodes;
    }

    public long getNodeUsage() {
        return this.nodeUsage;
    }

    public void setNodeUsage(long nodeUsage) {
        this.nodeUsage = nodeUsage;
    }
}

