/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file.internals;

public class FileAddress {
    private int segment;
    private long offset;

    public boolean isZero() {
        return this.offset == 0L && this.segment == 0;
    }

    public boolean isValid() {
        return this.offset != -1L && this.segment != 65535;
    }

    public boolean eq(FileAddress addr) {
        return this.offset == addr.getOffset() && this.segment == addr.getSegment();
    }

    public boolean gt(FileAddress addr) {
        return this.segment > addr.getSegment() || this.segment == addr.getSegment() && this.offset > addr.getOffset();
    }

    public boolean gtZero() {
        return this.offset > 0L || this.offset == 0L && this.segment > 0;
    }

    public boolean lt(FileAddress addr) {
        return this.segment < addr.getSegment() || this.segment == addr.getSegment() && this.offset < addr.getOffset();
    }

    public boolean ltZero() {
        return this.offset < 0L;
    }

    public boolean ge(FileAddress addr) {
        return !this.lt(addr);
    }

    public boolean le(FileAddress addr) {
        return !this.gt(addr);
    }

    public void invalidate() {
        this.offset = -1L;
        this.segment = 65535;
    }

    public void initialize() {
        this.offset = 0L;
        this.segment = 0;
    }

    public void incSegment() {
        ++this.segment;
    }

    public void incOffset(long val) {
        this.offset += val;
    }

    public void flipOffset() {
        this.offset = -this.offset;
    }

    public FileAddress copy() {
        return new FileAddress(this.segment, this.offset);
    }

    public void copyFrom(FileAddress address) {
        this.segment = address.getSegment();
        this.offset = address.getOffset();
    }

    public FileAddress() {
        this(0, 0L);
    }

    public FileAddress(int segment, long offset) {
        this.segment = segment;
        this.offset = offset;
    }

    public String toString() {
        return "offset: " + this.offset + ", segment: " + this.segment;
    }

    public int getSegment() {
        return this.segment;
    }

    public void setSegment(int segment) {
        this.segment = segment;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }
}

