      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
       program-id. FBCONNECT.
       configuration section.
       repository.
           class web-area as "com.iscobol.rts.HTTPHandler"
           class http-client as "com.iscobol.rts.HTTPClient"
           class http-params as "com.iscobol.rts.HTTPData.Params"
           class j-bigint as "java.math.BigInteger"
           class j-securernd as "java.security.SecureRandom"
           .
       working-storage section.
       77  client-id pic x any length.
       77  clsc  pic x any length. 
       77  redir pic x any length.

       01  params object reference http-params.
       01  http object reference http-client.
       01  state pic x any length.
       01  data-dir  pic x any length.
       77  response-code pic S9(3).
       77  prg-to-run pic x any length.
       77  err-msg pic x any length.

       01  http-response identified by "_".
           03 identified by "state".
              05 http-state  pic x any length.
           03 identified by "code".
              05 http-code  pic x any length.
       01  fb-token  identified by ''.
           03 access_token identified by 'access_token'.
             05 access_token-data pic x any length.
           03 token_type identified by 'token_type'.
             05 token_type-data pic x any length.
           03 expires_in identified by 'expires_in'.
             05 expires_in-data pic x any length.

       01  user-info identified by "".
           03 identified by "name".
              05 user-name  pic x any length.
           03 identified by "email".
              05 user-email  pic x any length.
           03 identified by "id".
              05 user-id  pic x any length.

       77  authorization pic x any length.
       01  redirect-page identified by "html".
           03 identified by "script".
              05 identified by "type" is attribute
                     pic x any length value "text/javascript".
              05 pic x any length value
                   'location.href ="http://localhost/isCobol(DOSYNC)?'-
                   'auth_token='.
              05 tok-value pic x any length.
              05 pic x any length value '";'.

       linkage section.
       01  comm-area object reference web-area.
       procedure division using comm-area.
       main.

           accept client-id from environment "app_id_by_fb"
           accept clsc  from environment "app_secret_by_fb".

           accept redir from environment "realdir_fb".

           if user-email = ""
              perform do-auth
           else
              perform run-first-program
           end-if.
           goback.
              
       do-auth.
           initialize http-response.
           comm-area:>accept(http-response).
           if http-state = space
              perform phase-1-redirection
           else
              if http-state = state
                 perform phase-2-get-auth-token
                 perform phase-3-get-info
                 perform set-first-program
                 perform run-first-program
              else
                 string  "Forged state! (" http-state ")(" state ")"
                         into err-msg
                 comm-area:>displayError(403 err-msg)
              end-if
           end-if.

       phase-1-redirection..
           set state=j-bigint:>new(130 j-securernd:>new):>toString(32).
           set params = http-params:>new
                      :>add ("client_id" client-id)
                      :>add ("display" "popup")
                      :>add ("response_type" "code")
                      :>add ("scope" "email")
                      :>add ("redirect_uri" redir)
                      :>add ("state" state)
           ;;
           comm-area:>redirect (
               "https://www.facebook.com/dialog/oauth" params).
       phase-2-get-auth-token..
           set http = http-client:>new
           set params = http-params:>new
                :>add ("code" http-code)
                :>add ("client_id" client-id)
                :>add ("client_secret" clsc)
                :>add ("redirect_uri" redir)
                :>add ("grant_type" "authorization_code")
           try
              http:>doPost (
               "https://graph.facebook.com/oauth/access_token" params)
              http:>getResponseCode (response-code)
              if response-code = 200
                 http:>getResponseJSON(fb-token)
              else
                 comm-area:>displayError(response-code "")
                 goback
              end-if
           catch exception
              comm-area:>displayError(500 exception-object:>toString)
              goback
           end-try.

       phase-3-get-info.
           string "https://graph.facebook.com/me?"
                  "fields=name,email&"
                  "access_token=" access_token-data
                  into authorization
           set http = http-client:>new
           try 
              http:>doGet (authorization)
              http:>getResponseCode (response-code)
              if response-code = 200
                 http:>getResponseJSON (user-info)
              else
                 comm-area:>displayError(response-code "")
                 goback
              end-if
           catch exception
              comm-area:>displayError(500 exception-object:>toString)
              goback
           end-try.

       set-first-program.
           set environment "openid.email" to user-email
           accept data-dir from environment "myprefix"
           string data-dir "/" user-email into data-dir

           call "c$makedir" using data-dir
           set environment "file.prefix" to data-dir.

       run-first-program.
           comm-area:>redirect ("mainapp.html").
           